@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Ecommerce Setting</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{ url('/admin_dashboard') }}"><i class="fa fa-home"></i></a></li>
        <li class="active">Coupons</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>

    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">

        <div class="row">
            <div class="col-lg-4">
                
                <div class="panel">

                    @if(Session::has('message')) 
                    <div class="alert alert-{{ Session::get('type') }} alert-dismissible  show" role="alert">
                        <h4 class="alert-heading">{{ Session::get("message") }}</h4>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    @endif
                    
                    <div class="panel-heading">
                        <div class="panel-control">
                            <button class="btn btn-default" data-panel="minmax"><i class="demo-psi-chevron-up"></i></button>
                        </div>
                        <h3 class="panel-title">Edit Coupons</h3>
                    </div>
                    
                    <div class="collapse in">
                        @if(!empty( $singlenews))
                        <form id="update_wl_news_detail" action="{{ url('/update_wl_news_detail/'.$singlenews[0]->NewsId) }}" enctype="multipart/form-data" method="post" accept-charset="utf-8">      
                            {{ csrf_field() }}
                            <div class="panel-body">
                                
                                <div class="row">
                                    
                                    <div class="form-group">
                                        <label class="control-label">Name</label>
                                        <input type="text" name="" class="form-control empty" id="" placeholder="Enter Coupon Name" value="{{ $singlenews[0]->CouponName }}">
                                    </div>
									<div class="form-group">
                                        <label class="control-label">Coupon Code</label>
                                        <input type="text" name="txt_news" class="form-control empty" id="txt_news" placeholder="Enter Coupon Code" value="{{ $singlenews[0]->CouponCode }}">
                                    </div>
                                    <div class="form-group">
                                        <label class="control-label">Coupon Quantity</label>
                                        <input type="text" name="txt_news" class="form-control empty" id="txt_news" placeholder="Enter Coupon Quantity" value="{{ $singlenews[0]->CouponQuantity }}">
                                    </div>
                                    <div class="form-group">
                                        <label class="control-label">Coupon Price</label>
                                        <input type="text" name="txt_news" class="form-control empty" id="txt_news" placeholder="Enter Coupon Price" value="{{ $singlenews[0]->CouponPrice}}">
                                    </div>
                                    <div class="form-group">
                                        <label class="control-label">Coupon Status</label>  
                                        <select id="dd_status" name="dd_status"  class="form-control empty">
                                            <option value="1" {{($singlenews[0]->NewsStatus == 'ACTIVE')?'selected':''}}>Active</option>
                                            <option value="0" {{($singlenews[0]->NewsStatus == 'INACTIVE')?'selected':''}}>Deactive</option>
                                        </select>
                                    </div>

                                </div>


                                
                            </div>
                            <div class="panel-footer text-center">
                                <button class="btn btn-success" type="button" onclick="conwv('update_wl_news_detail')">UPDATE</button>
                                <button type="reset" class="btn btn-primary">RESET</button> 
                            </div>
                        </form>
                        @else
                        <form id="add_wl_news" action="{{ url('add_wl_news') }}" enctype="multipart/form-data" method="post" accept-charset="utf-8">      
                            {{ csrf_field() }}
                            <div class="panel-body">
                                
                                <div class="row">
                                    <div class="form-group">
                                        <label class="control-label">Name</label>
                                        <input type="text" name="txt_news" class="form-control empty" id="txt_news" value=""  placeholder="Enter Coupon Title">
                                    </div>
									<div class="form-group">
                                        <label class="control-label">Coupon Code</label>
                                        <input type="text" name="txt_news" class="form-control empty" id="txt_news" value=""  placeholder="Enter Coupon Code">
                                    </div>
									<div class="form-group">
                                        <label class="control-label">Coupon Quantity</label>
                                        <input type="text" name="txt_news" class="form-control empty" id="txt_news" value=""  placeholder="Enter Coupon Quantity">
                                    </div>
									<div class="form-group">
                                        <label class="control-label">Coupon Price</label>
                                        <input type="text" name="txt_news" class="form-control empty" id="txt_news" value=""  placeholder="Enter Coupon Price">
                                    </div>
                                    <div class="form-group">
                                        <label class="control-label">Coupon Status</label>  
                                        <select id="dd_status" name="dd_status"  class="form-control empty">
                                            <option value="1">Active</option>
                                            <option value="0">Deactive</option>
                                        </select>
                                    </div>

                                </div>


                            </div>
                            <div class="panel-footer text-center">
                                <button class="btn btn-success" type="button" onclick="conwv('add_wl_news')">UPDATE</button>
                                <button type="reset" class="btn btn-primary">RESET</button> 
                            </div>
                        </form>
                        @endif
                    </div>
                    
                </div>
                
            </div>
        

            <div class="col-lg-8">
                <div class="panel">
                
                    <div class="panel-body">
                        <table id="demo-dt-addrow" class="table table-striped table-bordered" cellspacing="0" width="100%">
                            <thead>
                                <tr>
                                    <th >#</th>
                                    <th>Coupon Name</th>
                                    <th>Coupon Code</th>
                                    <th>Coupon Quantity</th>
                                    <th>Coupon Price</th>
                                    <th>Coupon Used/Unused</th>
                                    <th>Coupon Status</th>
									<th>Create Date</th>
									<th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                               <tr>
									<td>1</td>
									<td>1</td>
									<td>1</td>
									<td>1</td>
									<td>1</td>
									<td>1</td>
									<td>1</td>
									<td>1</td>
									<td>1</td>
									

								</tr>
                            </tbody>
                        </table>
                    </div>
                
                </div>
            </div>

        </div>

        <div class="modal fade" id="demo-default-modal" role="dialog" tabindex="-1" aria-labelledby="demo-default-modal" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">

                <form action="{{url('wl_news_status')}}" method="POST"> 
                    {{ csrf_field() }}

                    <!--Modal header-->
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal"><i class="pci-cross pci-circle"></i></button>
                        <h4 class="modal-title">CHANGE NEWS STATUS</h4>
                    </div>

                    <!--Modal body-->
                    <div class="modal-body">
                        <div class="form-group">
                            <label class="control-label">NEWS TITLE :-  <span id="newsname"></span></label>
                            <input id="txt_statusregid" name="txt_statusregid" type="hidden" class="form-control" required="required">
                        </div>
                        <br>
                        <p class="text-semibold text-main">Would you like to change the status of news ?</p>

                    </div>

                    <!--Modal footer-->
                    <div class="modal-footer">
                        <button data-dismiss="modal" class="btn btn-default" type="button">NO</button>
                        <button class="btn btn-primary" type="submit">Yes</button>
                    </div>

                </form>
                </div>
            </div>
        </div>
            
    </div>
    <!--===================================================-->
    <!--End page content-->

</div>


<!--===================================================-->
<!--END CONTENT CONTAINER-->

<script src="http://ajax.googleapis.com/ajax/libs/jquery/2.0.0/jquery.min.js"></script>
<script type="text/javascript">
$(document).ready(function(){
    function get_status_details(obj,id)
    {
        alert(id);
        $('#txt_statusregid').val(id);
        $('#newsname').html($(obj).data('name'));
    } 
});
</script>
@endsection