@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Master Panel</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{ url('/admin_dashboard') }}"><i class="demo-pli-home"></i></a></li>
        <li><a href="{{ url('/admin_dashboard') }}">Dashboard</a></li>
        <li class="active">Country Master</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>

    

    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">

        <div class="row">

            <div class="col-md-4">
            
                <div class="panel">

                    @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                    @endif

                    @if(Session::has('country_msg')) 
                    <div class="alert alert-{{ Session::get('type') }} alert-dismissible  show" role="alert">
                        <h4 class="alert-heading">{{ Session::get("country_msg") }}</h4>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    @endif

                    <div class="panel-heading">
                        <div class="panel-control">
                            <button class="btn btn-default" data-panel="minmax"><i class="demo-psi-chevron-up"></i></button>
                        </div>
                        <h3 class="panel-title">Country Master</h3>
                    </div>

                    <div class="collapse in">
                        @if(isset($singlecountry[0]->LOC_ID))
                        <form id="edit-country" action="{{ url('update_country/'.$singlecountry[0]->LOC_ID) }}" method="POST">
                            {{ csrf_field() }}
                            <div class="panel-body">
                                <div class="row">
                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txtcountryname">Country Name</label>
                                            <input type="text" name="txtcountryname" id="txtcountryname" class="form-control" value="{{$singlecountry[0]->LOC_NAME}}" required>
                                        </div>
                                    </div>

                                    <div class="col-sm-12">   
                                        <div class="form-group text-center">
                                            <label class="control-label" style="display:block;">&nbsp;</label>
                                            <button class="btn btn-success" type="button" onclick="conwv('edit-country')">Save</button>
                                            <button class="btn btn-default" type="button">Close</button>
                                        </div>
                                    </div>
                                </div>    
                            </div>
                        </form>
                        @elseif(!isset($singlecountry[0]->LOC_ID))
                        <form id="add-country" action="{{ url('add_country') }}" method="POST">
                            {{ csrf_field() }}
                            <div class="panel-body">
                                <div class="row">
                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txtcountryname">Country Name</label>
                                            <input type="text" name="txtcountryname" id="txtcountryname" class="form-control" placeholder="Enter Country Name." required>
                                        </div>
                                    </div>

                                    <div class="col-sm-12 text-center">   
                                        <div class="form-group">
                                            <label class="control-label" style="display:block;">&nbsp;</label>
                                            <button class="btn btn-success" type="button" onclick="conwv('add-country')">Save</button>
                                            <button class="btn btn-default" type="button">Close</button>
                                        </div>
                                    </div>
                                </div>    
                            </div>
                        </form>
                        @endif

                    </div>
        
                </div>

            </div>
            

            <div class="col-md-8">
                <div class="panel">
                    
                    <div class="panel-body">
                        <table id="demo-dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
                            <thead>
                                <tr>
                                    <th>S.NO</th>
                                    <th>COUNTRY NAME</th>
                                    <th class="min-tablet">EDIT</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $i=1;?>
                                @if(isset($country[0]->LOC_NAME))
                                @foreach ($country as $value)
                                <tr>
                                    <td>{{$i++}}</td>
                                    <td>{{ $value->LOC_NAME }}</td>
                                    <td>
                                        <a href="{{ url('country/'.$value->LOC_ID) }}" class="btn btn-success btn-xs" type="submit">EDIT</a>
                                        <button data-id="{{$value->LOC_ID}}" data-name="{{$value->LOC_NAME}}" data-target="#demo-default-modal" data-toggle="modal" class="btn btn-primary btn-xs val">{{$value->LOC_STATUS == 'ACTIVE' ? 'Active' : 'InActive'}}</button>
                                    </td>
                                </tr>
                                @endforeach
                                @endif
                            </tbody>
                        </table>
                    </div>
            
                </div>
            </div>

            <div class="modal fade" id="demo-default-modal" role="dialog" tabindex="-1" aria-labelledby="demo-default-modal" aria-hidden="true">
                <div class="modal-dialog">
                    <div class="modal-content">

                    <form action="{{url('country_status')}}" method="POST"> 
                        {{ csrf_field() }}

                        <!--Modal header-->
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal"><i class="pci-cross pci-circle"></i></button>
                            <h4 class="modal-title">CHANGE COUNTRY STATUS</h4>
                        </div>

                        <!--Modal body-->
                        <div class="modal-body">
                            <div class="form-group">
                                <input id="txt_country_id" name="txt_country_id" type="hidden" class="form-control" required="required">
                            </div>
                            <p class="text-semibold text-main">COUNTRY NAME :-<span id="country"></span></p>
                            <br>
                            <p class="text-semibold text-main">Would you like to change the status of country ?</p>

                        </div>

                        <!--Modal footer-->
                        <div class="modal-footer">
                            <button data-dismiss="modal" class="btn btn-default" type="button">NO</button>
                            <button class="btn btn-primary" type="submit">Yes</button>
                        </div>

                    </form>
                    </div>
                </div>
            </div>
        </div>
            
    </div>
    <!--===================================================-->
    <!--End page content-->

</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->
<script src="http://ajax.googleapis.com/ajax/libs/jquery/2.0.0/jquery.min.js"></script>
<script type="text/javascript">
$(document).ready(function(){
    $(".val").on("click", function(e) {
        var id = $(this).data('id');
        var country = $(this).data('name');
        $('#txt_country_id').val(id);
        $('#country').text(country);
    });
});
</script>
@endsection
