@extends('mainlayout')
@section('content')

<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Ecommerce Setting</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{ url('/admin_dashboard') }}"><i class="demo-pli-home"></i></a></li>
        <li class="active">Ecommerece Banner Management</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>

    
    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">

        <div class="row">

            <div class="col-md-12">
            
                <div class="panel">

                    @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                    @endif



                    @if(Session::has('banner_msg')) 
                    <div class="alert alert-{{ Session::get('type') }} alert-dismissible  show" role="alert">
                        <h4 class="alert-heading">{{ Session::get("banner_msg") }}
                    
                        </h4>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    @endif

                       @if(session()->has('error'))
                            <div class="alert alert-danger">
                                {{ session()->get('error') }}
                            </div>
                        @endif

                    <div class="panel-heading">
                        <div class="panel-control">
                            <button class="btn btn-default" data-panel="minmax"><i class="demo-psi-chevron-up"></i></button>
                        </div>
                        <h3 class="panel-title">Ecommerce Banner Management</h3>
                    </div>

                    <div class="collapse in">
                        @if(!isset($single_banner[0]->BANNER_ID))
                        <form id="add-banner" action="{{url('/add_banners')}}" method="post" enctype="multipart/form-data">
                            {{ csrf_field() }}
                            <div class="panel-body">
                                <div class="row">
								

                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_banner_name">Banner Name</label>
                                            <input type="text" name="txt_banner_name" id="txt_banner_name" class="form-control" placeholder="Enter Banner Name">
                                        </div>
                                    </div>

                                    
                                      <div class="col-sm-3"  style="display: none;">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_banner_name">Banner Var</label>
                                            <input type="text" name="txt_banner_var" id="txt_banner_var" class="form-control" placeholder="Enter Banner Variable" value="1">
                                        </div>
                                    </div>


									<div class="col-sm-3">
                                        <div class="form-group">
                                            <label class="control-label" for="dd_banner_type">Banner Type</label>
                                            <select class="form-control" id="dd_banner_type" name="dd_banner_type">
                                                <option value="-1">Select Banner Type</option>
                                                <option value="2">Slider Banner</option>
                                                <option value="8">Offer Banner</option>
                                                <option value="1">Front Banner</option>
                                                <option value="6">Front Popup</option>
                                                <option value="7">Category Banner</option>
                                                <option value="11">Category Bottom Banner</option>
                                                <option value="4">App Slider Banner</option>
                                                <option value="3">App Front Banner</option>
                                                <option value="10">App Offer Banner</option>
                                                <option value="9">App Category</option>
                                                <option value="5">App Popup</option>
                                            </select>
                                        </div>
                                    </div>

									<div class="col-sm-3">
                                        <div class="form-group">
                                            <label class="control-label" for="dd_banner_category">Banner Category</label>
                                            <select class="form-control" id="dd_banner_category" name="dd_banner_category">
                                            <option value="0">Select Category</option>
                                            @foreach($categories as $catval)
                                                <option value="{{$catval->CAT_ID}}" >{{$catval->CAT_NAME}}</option>
                                            @endforeach
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-sm-3" style="display: none;">
                                        <div class="form-group">
                                            <label class="control-label" for="dd_banner_for">Banner For</label>
                                            <select class="form-control" id="dd_banner_for" name="dd_banner_for">
                                                <option value="WEB" >WEB</option>
                                                <option value="APP" >APP</option>
                                                <option value="BOTH" >BOTH</option>
                                            </select>
                                        </div>
                                    </div>
                                      <div class="col-sm-3">
                                        <div class="form-group">
                                            <label class="control-label" for="dd_banner_size">Banner Size (in Pixel)</label>
                                            <select class="form-control" id="dd_banner_size" name="dd_banner_size">
                                                <option value="">SELECT</option>
                                                 @foreach($imagesize as $imgsize)
                                                <option value="{{$imgsize->m76_image_id}}">{{$imgsize->m76_name}} (  {{$imgsize->m76_width}}  X  {{$imgsize->m76_height}}  )</option>
                                               @endforeach
                                         
                                            </select>
                                        </div>
                                    </div>
                                

   
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label class="control-label" for="file_banner_img">Banner Image</label>
                                            <input class="form-control" type="file" name="file_banner_img" id="file_banner_img">
                                        </div>
                                    </div>



                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label class="control-label" for="dd_banner_status">Banner Status</label>
                                            <select class="form-control" id="dd_banner_status" name="dd_banner_status">
                                                <option value="1">Active</option>
                                                <option value="2">InActive</option>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_banner_meta">Banner Meta</label>
                                            <input class="form-control" type="text" name="txt_banner_meta" id="txt_banner_meta">
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_banner_desc">Banner Description</label>
                                            <textarea class="form-control" name="txt_banner_desc" id="txt_banner_desc"></textarea>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="panel-footer text-center">
                                <button class="btn btn-success" type="button" onclick="conwv('add-banner')">Save</button>
                                <button class="btn btn-default" type="button">Close</button>
                            </div>

                        </form>

                        @elseif(isset($single_banner[0]->BANNER_ID))
                        <form id="edit-banner" action="{{url('/update_banners/'.$single_banner[0]->BANNER_ID)}}" method="post" enctype="multipart/form-data">
                            {{ csrf_field() }}
                            <div class="panel-body">
                                <div class="row">

                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_banner_name">Banner Name</label>
                                            <input type="text" name="txt_banner_name" id="txt_banner_name" class="form-control" value="{{$single_banner[0]->BANNER_NAME}}">
                                        </div>
                                    </div>
									<div class="col-sm-3">
                                        <div class="form-group">
                                            <label class="control-label" for="dd_banner_type">Banner Type</label>
                                            <select class="form-control" id="dd_banner_type" name="dd_banner_type">
                                                <option value="-1">Select Banner Type</option>
                                                <option value="2" {{$single_banner[0]->BANNER_TYPE == 'SLIDER' ? 'selected' : ''}}>Slider Banner</option>
                                                <option value="8" {{$single_banner[0]->BANNER_TYPE == 'OFFER' ? 'selected' : ''}}>Offer Banner</option>
                                                <option value="1" {{$single_banner[0]->BANNER_TYPE == 'FRONT' ? 'selected' : ''}}>Front Banner</option>
                                                <option value="7" {{$single_banner[0]->BANNER_TYPE == 'CATEGORY' ? 'selected' : ''}}>Category Banner</option>
                                                <option value="11" {{$single_banner[0]->BANNER_TYPE == 'CATEGORY_BOTTOM_BANNER' ? 'selected' : ''}}>Category Bottom Banner</option>
                                                <option value="6" {{$single_banner[0]->BANNER_TYPE == 'FRONT_POPUP' ? 'selected' : ''}}>Front Popup</option>
                                                <option value="4" {{$single_banner[0]->BANNER_TYPE == 'APP_SLIDER' ? 'selected' : ''}}>App Slider Banner</option>
                                                <option value="10" {{$single_banner[0]->BANNER_TYPE == 'OFFER_APP' ? 'selected' : ''}}>App Offer Banner</option>
                                                <option value="3" {{$single_banner[0]->BANNER_TYPE == 'APP_FRONT' ? 'selected' : ''}}>App Front Banner</option>
                                                <option value="5" {{$single_banner[0]->BANNER_TYPE == 'APP_POPUP' ? 'selected' : ''}}>App Popup</option>
                                                <option value="9" {{$single_banner[0]->BANNER_TYPE == 'CATEGORY_APP' ? 'selected' : ''}}>App Category</option>

                                            </select>
                                        </div>
                                    </div>

									<div class="col-sm-3">
                                        <div class="form-group">
                                            <label class="control-label" for="dd_banner_category">Banner Category</label>
                                            <select class="form-control" id="dd_banner_category" name="dd_banner_category">
                                                <option value="0">Select Category</option>
                                            @foreach($categories as $catval)
                                                <option value="{{$catval->CAT_ID}}" {{$single_banner[0]->CATEGORY == $catval->CAT_ID ? 'selected' : ''}}>{{$catval->CAT_NAME}}</option>
                                            @endforeach
                                            </select>
                                        </div>
                                    </div>

                                     <div class="col-sm-3"  style="display: none;">
                                        <div class="form-group">
                                            <label class="control-label" for="dd_banner_for">Banner For</label>
                                            <select class="form-control" id="dd_banner_for" name="dd_banner_for">
                                                <option value="WEB" {{$single_banner[0]-> BANNER_FOR == 'WEB'? 'selected' : ''}}>WEB</option>
                                                <option value="APP" {{$single_banner[0]-> BANNER_FOR == 'APP'? 'selected' : ''}}>APP</option>
                                                <option value="BOTH" {{$single_banner[0]-> BANNER_FOR == 'BOTH'? 'selected' : ''}}>BOTH</option>
                                            </select>
                                        </div>
                                    </div>
                                      <div class="col-sm-3">
                                        <div class="form-group">
                                            <label class="control-label" for="dd_banner_size">Banner Size (in Pixel)</label>
                                            <select class="form-control" id="dd_banner_size" name="dd_banner_size">
                                                <option value=""> SELECT </option>
                                                @foreach($imagesize as $imgsize)
                                                <option value="{{$imgsize->m76_image_id}}">{{$imgsize->m76_name}} (  {{$imgsize->m76_width}}  X  {{$imgsize->m76_height}}  )</option>
                                               @endforeach
                                         
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_banner_meta">Banner Meta</label>
                                            <input class="form-control" type="text" name="txt_banner_meta" id="txt_banner_meta" value="{{$single_banner[0]->BANNER_META}}">
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label class="control-label" for="file_banner_img">Banner Image</label>
                                            <input class="form-control" type="file" name="file_banner_img" id="file_banner_img">
                                            <input class="form-control" type="hidden" name="txt_old_banner" id="txt_old_banner" value="{{$single_banner[0]->BANNER_IMG}}">
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label class="control-label" for="dd_banner_status">Banner Status</label>
                                            <select class="form-control" id="dd_banner_status" name="dd_banner_status">
                                                <option value="1" {{$single_banner[0]->BANNER_STATUS == 'ACTIVE' ? 'selected' : ''}}>Active</option>
                                                <option value="2" {{$single_banner[0]->BANNER_STATUS == 'INACTIVE' ? 'selected' : ''}}>InActive</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label class="control-label" for="dd_banner_status">Old Image</label>
                                            <img src="{{asset('/images/front/'.$single_banner[0]->BANNER_IMG)}}" height="50" width="50">
                                        </div>
                                    </div>

                                </div>
                               
                                <div class="row"> 
                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_banner_desc">Banner Description</label>
                                            <textarea class="form-control" name="txt_banner_desc" id="txt_banner_desc">{{$single_banner[0]->BANNER_DESC}}</textarea>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="panel-footer text-center">
                                <button class="btn btn-warning" type="button" onclick="conwv('edit-banner')">Update</button>
                                <button class="btn btn-default" type="button">Close</button>
                            </div>
                        </form>
                        @endif
                    </div>
                </div>
            </div>
            <div class="col-md-12">
                <div class="panel">
                    <div class="panel-body">
                        <table id="demo-dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
                            <thead>
                                <tr>
                                    <th>S.No</th>
                                    <th>Banner Name</th>
                                    <th class="min-tablet">Banner Description</th>
                                    <th class="min-tablet">Banner Image</th>
									<th class="min-tablet">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($banners as $key => $b)
                                <tr>
                                    <td>{{$key+1}}</td>
                                    <td>{{$b->BANNER_NAME}}</td>
                                    <td>{{$b->BANNER_DESC}}</td>
                                    <td><img src="{{asset('/images/front/'.$b->BANNER_IMG)}}" height="50" width="50"></td>
                                    <td>
                                        <a class="btn btn-success btn-xs" href="{{url('edit_banner/'.$b->BANNER_ID)}}">EDIT</a>
                                        <a href="{{url('status_change/'.$b->BANNER_ID)}}">
                                        <button data-id="{{$b->BANNER_ID}}" data-name="{{$b->BANNER_NAME}}" data-target="#demo-default-modal" data-toggle="modal" class="btn btn-primary btn-xs val">{{$b->BANNER_STATUS == 'ACTIVE' ? 'ACTIVE' : 'INACTIVE'}}</button>
                                        </a>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                
                </div>
            </div>

        </div>
            
    </div>
    <!--===================================================-->
    <!--End page content-->

</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->
@endsection