@extends('mainlayout')
@section('content')

<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Balance Deduction Types </h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{ url('/admin_dashboard') }}"><i class="fa fa-home"></i></a></li>
        <li><a href="{{ url('/admin_dashboard') }}">Master</a></li>
        <li class="active">Balance Deduction Types</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">
        <div class="row">
            <div class="col-md-4">
                <div class="panel">
                    @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                    @endif
                    @if(Session::has('message')) 
                    <div class="alert alert-{{ Session::get('type') }} alert-dismissible  show" role="alert">
                        <h4 class="alert-heading">{{ Session::get("message") }}</h4>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    @endif

                    <div class="panel-heading">
                        <div class="panel-control">
                            <button class="btn btn-default" data-panel="minmax"><i class="demo-psi-chevron-up"></i></button>
                        </div>
                        <h3 class="panel-title">Balance Deduction Types</h3>
                    </div>

                    <div class="collapse in">
                        @if($data['single'] != '')
                        <form id="edit_service" action="{{url('update-balance-deduction-types/'.$data['single'][0]->m70_bdt_id)}}" method="post" enctype="multipart/form-data">
                            {{ csrf_field() }}
                            <div class="panel-body">
                                <div class="row">

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_name">Name</label>
                                            <input type="text" name="txt_name" id="txt_name" class="form-control" value="{{$data['single'][0]->m70_bdt_name}}">
                                        </div>
                                    </div>
                                    <div class="col-sm-12">
									<div class="form-group">
                                            <label class="control-label" for="dd_deduction_type">Deduction Types</label>
                                            <select class="form-control" id="dd_deduction_type" name="dd_deduction_type">
                                                <option value="2">Select Deduction Types</option>
												<option value="1" {{$data['single'][0]->m70_deduction_types == 'CREDIT' ? 'selected':''}}>CREDIT</option>
												<option value="2" {{$data['single'][0]->m70_deduction_types == 'DEBIT' ? 'selected':''}}>DEBIT</option>
                                            </select>
                                    </div>
									</div>
                                    <div class="col-sm-12">
									<div class="form-group">
                                            <label class="control-label" for="dd_ledger_type">Ledger Type</label>
                                            <select class="form-control" id="dd_ledger_type" name="dd_ledger_type">
                                                <option value="2">Select Ledger Type</option>
												<option value="1"  {{$data['single'][0]->m70_manage_ledger_types == 'DEDUCTIBLE' ? 'selected':''}}>DEDUCTIBLE</option>
												<option value="2"  {{$data['single'][0]->m70_manage_ledger_types == 'NON DEDUCTIBLE' ? 'selected':''}}>NON DEDUCTIBLE</option>
                                            </select>
                                    </div>
									</div>
                                    <div class="col-sm-12"   style="display:none">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_ledger_type">Ledger Type Order Number</label>
                                            <input type="hidden" name="txt_ledger_type" id="txt_ledger_type" class="form-control" value="{{$data['single'][0]->tr03_m_ledger_type}}">
                                        </div>
                                    </div>
                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_desc">Description</label>
                                            <input type="text" name="txt_desc" id="txt_desc" class="form-control" value="{{$data['single'][0]->m70_bdt_desc}}">
                                        </div>
                                    </div>

                                </div>
                            </div>
                            <div class="panel-footer text-center">
                                <button class="btn btn-success" type="button" onclick="conwv('edit_service')">Save</button>
                                <button class="btn btn-default" type="button">Close</button>
                            </div>
                        </form>
                        @else
                        <form id="add_service" action="{{url('/create-balance-deduction-types')}}" method="post" enctype="multipart/form-data">
                            {{ csrf_field() }}
                            <div class="panel-body">
                                <div class="row">
                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_name">Name</label>
                                            <input type="text" name="txt_name" id="txt_name" class="form-control" value="">
                                        </div>
                                    </div>
                                    <div class="col-sm-12">
									<div class="form-group">
                                            <label class="control-label" for="dd_deduction_type">Deduction Types</label>
                                            <select class="form-control" id="dd_deduction_type" name="dd_deduction_type">
                                                <option value="2">Select Deduction Types</option>
												<option value="1">CREDIT</option>
												<option value="2">DEBIT</option>
                                            </select>
                                    </div>
									</div>
                                    <div class="col-sm-12">
									<div class="form-group">
                                            <label class="control-label" for="dd_ledger_type">Ledger Type</label>
                                            <select class="form-control" id="dd_ledger_type" name="dd_ledger_type">
                                                <option value="1">Select Ledger Type</option>
												<option value="1">DEDUCTIBLE</option>
												<option value="2">NON DEDUCTIBLE</option>
                                            </select>
                                    </div>
									</div>
                                    <div class="col-sm-12"  style="display:none">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_ledger_type">Ledger Type Order Number</label>
                                            <input type="hidden" name="txt_ledger_type" id="txt_ledger_type" value="16" class="form-control" value="">
                                        </div>
                                    </div>
                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_desc">Description</label>
                                            <input type="text" name="txt_desc" id="txt_desc" class="form-control" placeholder="Enter Description">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="panel-footer text-center">
                                <button class="btn btn-success" type="button" onclick="conwv('add_service')">Save</button>
                                <button class="btn btn-default" type="button">Close</button>
                            </div>
                        </form>
                        @endif
                        
                    </div>
        
                </div>

            </div>
            
        

            <div class="col-md-8">
                <div class="panel">
                
                    <div class="panel-body">
                        <table id="demo-dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
                            <thead>
                                <tr>
                                    <th class="min-tablet">S.No</th>
                                    <th class="min-tablet">Name</th>
									<th class="min-tablet">Deduction Type</th>
									<th class="min-tablet">Ledger Type</th>
                                    <th class="min-tablet">Description</th>
                                    <th class="min-tablet">Action</th>
                                </tr>
                            </thead>	
							@foreach($data['all'] as $key => $value)
								<tr>
                                    <th class="min-tablet">{{$key+1}}</th>
                                    <th class="min-tablet">{{$value->m70_bdt_name}}</th>
                                    <th class="min-tablet">{{$value->m70_deduction_types}}</th>
                                    <th class="min-tablet">{{$value->m70_manage_ledger_types}}</th>
                                    <th class="min-tablet">{{$value->m70_bdt_desc}}</th>
                                    <th class="min-tablet"><a class="btn btn-xs btn-success" href="{{url('edit-balance-deduction-types/'.$value->m70_bdt_id)}}"> Edit</a></th>
                                </tr>
							@endforeach
                            <tbody>
                
                            </tbody>
                        </table>
                    </div>
                
                </div>
            </div>

        </div>
            
    </div>
    <!--===================================================-->
    <!--End page content-->

</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->
@endsection