@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Assign User Menu</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{ url('/admin_dashboard') }}"><i class="fa fa-home"></i></a></li>
        <li><a href="{{ url('/admin_dashboard') }}">Master</a></li>
        <li class="active">Assign User Menu</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>

    
    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">
        
        <div class="row">
            <div class="col-sm-6 col-md-4">
                <div class="panel">



                    <div class="panel-heading">
                        <div class="panel-control">
                            <button class="btn btn-default" data-panel="minmax"><i class="demo-psi-chevron-up"></i></button>
                        </div>
                        <h3 class="panel-title">Assign User Menu Management</h3>
                    </div>

                    <div class="collapse in">
                        @if(!isset($single_usermenu[0]->USRMN_ID))
                        <form id="assign-user-menu" action="{{url('/add_usermenu')}}" method="post" enctype="multipart/form-data">
                            {{ csrf_field() }}
                            <div class="panel-body">
                                <div class="row">

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="dd_assigned_for">Menu Asigned For</label>
                                            <select class="form-control" id="dd_assigned_for" name="dd_assigned_for">
                                                <option value="-1">Select Menu Asigned For</option>
                                                <option value="1">User</option>
                                                <option value="2">Employee</option>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-sm-12" id="select_user">
                                        <div class="form-group">
                                            <label class="control-label" for="dd_user">Select User</label>
                                            <select class="form-control" id="dd_user" name="dd_user">
                                                <option value="-1">Select User</option>
                                                @foreach($users as $us)
                                                <option value="{{$us->RegId}}">{{$us->MemberName}} [{{$us->RegCode}}]</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div> 

                                    <div class="col-sm-12" id="select_emp">
                                        <div class="form-group">
                                            <label class="control-label" for="dd_emp">Select Employee</label>
                                            <select class="form-control" id="dd_emp" name="dd_emp">
                                                <option value="-1">Select Employee</option>
                                                @foreach($employees as $emp)
                                                <option value="{{$emp->RegId}}">{{$emp->MemberName}} [{{$emp->RegCode}}]</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>  

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="dd_menu">Select Menu</label>
                                            <select class="form-control" id="dd_menu" name="dd_menu">
                                                <option value="-1">Select Menu</option>
                                                @foreach($menus as $mn)
                                                @if($mn->ASMENU_PARENTID == -1)
                                                <option value="{{$mn->ASMENU_ID}}">{{$mn->ASMENU_NAME}} [{{$mn->ASMENU_ROLE}}]</option>
                                                    @foreach($menus as $mn1)
                                                    @if($mn1->ASMENU_PARENTID == $mn->ASMENU_ID)
                                                    <option value="{{$mn1->ASMENU_ID}}">-{{$mn1->ASMENU_NAME}} [{{$mn1->ASMENU_ROLE}}]</option>
                                                        @foreach($menus as $mn2)
                                                        @if($mn2->ASMENU_PARENTID == $mn2->ASMENU_ID)
                                                        <option value="{{$mn2->ASMENU_ID}}">--{{$mn2->ASMENU_NAME}} [{{$mn2->ASMENU_ROLE}}]</option>
                                                        @endif
                                                        @endforeach
                                                    @endif
                                                    @endforeach
                                                @endif
                                                @endforeach
                                            </select>
                                        </div>
                                    </div> 

                                    

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="dd_assigned_by">Menu Asigned By</label>
                                            <select class="form-control" id="dd_assigned_by" name="dd_assigned_by">
                                                <option value="-1">Select Menu Asigned By</option>
                                                <option value="1">Admin</option>
                                                <option value="2">User</option>
                                                <option value="3">Employee</option>
                                            </select>
                                        </div>
                                    </div> 

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="dd_status">Menu Status</label>
                                            <select class="form-control" id="dd_status" name="dd_status">
                                                <option value="-1">Select Menu Status</option>
                                                <option value="1">Active</option>
                                                <option value="2">InActive</option>
                                            </select>
                                        </div>
                                    </div> 

                                </div>

                            </div>
                            <div class="panel-footer text-center">
                                <button class="btn btn-success" type="button" onclick="conwv('assign-user-menu')">Save</button>
                                <button class="btn btn-default" type="button">Close</button>
                            </div>
                        </form>
                        @elseif(isset($single_usermenu[0]->USRMN_ID))
                        <form id="assign-user-menu" action="{{url('/update_usermenu/'.$single_usermenu[0]->USRMN_ID)}}" method="post" enctype="multipart/form-data">
                            {{ csrf_field() }}
                            <div class="panel-body">
                                <div class="row">

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="dd_assigned_for">Menu Asigned For</label>
                                            <select class="form-control" id="dd_assigned_for" name="dd_assigned_for">
                                                <option value="-1">Select Menu Asigned For</option>
                                                <option value="1" {{$single_usermenu[0]->USRMN_USERTYPE == 'USER' ? 'selected' : ''}}>User</option>
                                                <option value="2" {{$single_usermenu[0]->USRMN_USERTYPE == 'EMPLOYEE' ? 'selected' : ''}}>Employee</option>
                                            </select>
                                        </div>
                                    </div> 

                                    <div class="col-sm-12" id="select_user">
                                        <div class="form-group">
                                            <label class="control-label" for="dd_user">Select User</label>
                                            <select class="form-control" id="dd_user" name="dd_user">
                                                <option value="-1">Select User</option>
                                                @foreach($users as $us)
                                                <option value="{{$us->RegId}}" {{$us->RegId == $single_usermenu[0]->USRMN_USERID ? 'selected' : ''}}>{{$us->MemberName}} [{{$us->RegCode}}]</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>   

                                    <div class="col-sm-12" id="select_emp">
                                        <div class="form-group">
                                            <label class="control-label" for="dd_emp">Select Employee</label>
                                            <select class="form-control" id="dd_emp" name="dd_emp">
                                                <option value="-1">Select Employee</option>
                                                @foreach($employees as $emp)
                                                <option value="{{$emp->RegId}}" {{$emp->RegId == $single_usermenu[0]->USRMN_EMPID ? 'selected' : ''}}>{{$emp->MemberName}} [{{$emp->RegCode}}]</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>  

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="dd_menu">Select Menu</label>
                                            <select class="form-control" id="dd_menu" name="dd_menu">
                                                <option value="-1">Select Menu</option>
                                                @foreach($menus as $mn)
                                                @if($mn->ASMENU_PARENTID == -1)
                                                <option value="{{$mn->ASMENU_ID}}" {{$mn->ASMENU_ID == $single_usermenu[0]->USRMN_MENUID ? 'selected' : ''}}>{{$mn->ASMENU_NAME}} [{{$mn->ASMENU_ROLE}}]</option>
                                                    @foreach($menus as $mn1)
                                                    @if($mn1->ASMENU_PARENTID == $mn->ASMENU_ID)
                                                    <option value="{{$mn1->ASMENU_ID}}" {{$mn1->ASMENU_ID == $single_usermenu[0]->USRMN_MENUID ? 'selected' : ''}}>-{{$mn1->ASMENU_NAME}} [{{$mn1->ASMENU_ROLE}}]</option>
                                                        @foreach($menus as $mn2)
                                                        @if($mn2->ASMENU_PARENTID == $mn2->ASMENU_ID)
                                                        <option value="{{$mn2->ASMENU_ID}}" {{$mn2->ASMENU_ID == $single_usermenu[0]->USRMN_MENUID ? 'selected' : ''}}>--{{$mn2->ASMENU_NAME}} [{{$mn2->ASMENU_ROLE}}]</option>
                                                        @endif
                                                        @endforeach
                                                    @endif
                                                    @endforeach
                                                @endif
                                                @endforeach
                                            </select>
                                        </div>
                                    </div> 

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="dd_assigned_by">Menu Asigned By</label>
                                            <select class="form-control" id="dd_assigned_by" name="dd_assigned_by">
                                                <option value="-1">Select Menu Asigned By</option>
                                                <option value="1" {{$single_usermenu[0]->USRMN_ASSIGN_BY == 'ADMIN' ? 'selected' : ''}}>Admin</option>
                                                <option value="2" {{$single_usermenu[0]->USRMN_ASSIGN_BY == 'USER' ? 'selected' : ''}}>User</option>
                                                <option value="3" {{$single_usermenu[0]->USRMN_ASSIGN_BY == 'EMPLOYEE' ? 'selected' : ''}}>Employee</option>
                                            </select>
                                        </div>
                                    </div> 

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="dd_status">Menu Status</label>
                                            <select class="form-control" id="dd_status" name="dd_status">
                                                <option value="-1">Select Menu Status</option>
                                                <option value="1" {{$single_usermenu[0]->USRMN_ASSIGN_BYID == 'ACTIVE' ? 'selected' : ''}}>Active</option>
                                                <option value="2" {{$single_usermenu[0]->USRMN_ASSIGN_BYID == 'INACTIVE' ? 'selected' : ''}}>InActive</option>
                                            </select>
                                        </div>
                                    </div> 

                                </div>

                            </div>
                            <div class="panel-footer text-center">
                                <button class="btn btn-success" type="button" onclick="conwv('assign-user-menu')">Save</button>
                                <button class="btn btn-default" type="button">Close</button>
                            </div>
                        </form>
                        @endif
                        
                    </div>
        
                </div>

                <div class="modal fade" id="demo-default-modal" role="dialog" tabindex="-1" aria-labelledby="demo-default-modal" aria-hidden="true">
                    <div class="modal-dialog">
                        <div class="modal-content">

                        <form action="{{url('usermenu_status')}}" method="POST"> 
                            {{ csrf_field() }}

                            <!--Modal header-->
                            <div class="modal-header">
                                <button type="button" class="close" data-dismiss="modal"><i class="pci-cross pci-circle"></i></button>
                                <h4 class="modal-title">CHANGE USER MENU STATUS</h4>
                            </div>

                            <!--Modal body-->
                            <div class="modal-body">
                                <div class="form-group">
                                    <input id="txt_menuid" name="txt_menuid" type="hidden" class="form-control" required="required">
                                </div>
                                <p class="text-semibold text-main">MENU NAME :-<span id="menuname"></span></p>
                                <br>
                                <p class="text-semibold text-main">Would you like to change the status of menu ?</p>

                            </div>

                            <!--Modal footer-->
                            <div class="modal-footer">
                                <button data-dismiss="modal" class="btn btn-default" type="button">NO</button>
                                <button class="btn btn-primary" type="submit">Yes</button>
                            </div>

                        </form>
                        </div>
                    </div>
                </div>
    
            </div>
            <div class="col-sm-6 col-md-8">
    
    
            </div>
        </div>

        <div class="row">
            <div class="panel">
                
                <div class="panel-body">
                    <table id="demo-dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
                        <thead>
                            <tr>
                                <th>S.No</th>
                                <th>User Name</th>
                                <th>Menu Name</th>
                                <th class="min-tablet">User Role</th>
                                <th class="min-tablet">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $i = 1; ?>
                            @foreach($user_menu as $um)
                            <tr>
                                <td>{{$i++}}</td>
                                <td>
                                    @if($um->USRMN_USERNAME)
                                    {{$um->USRMN_USERNAME}} [{{$um->USRMN_USERCODE}}]
                                    @else
                                    {{$um->USRMN_EMPNAME}} [{{$um->USRMN_EMPCODE}}]
                                    @endif
                                </td>
                                <td>{{$um->USRMN_MENUNAME}}</td>
                                <td>{{$um->USRMN_USERTYPE}}</td>
                                <td>
                                    <a class="btn btn-success btn-xs" href="{{url('view_usermenu/'.$um->USRMN_ID)}}">EDIT</a>
                                    <button data-id="{{$um->USRMN_ID}}" data-menuname="{{$um->USRMN_MENUNAME}}" data-target="#demo-default-modal" data-toggle="modal" class="btn btn-primary btn-xs val">{{$um->USRMN_STATUS == 'ACTIVE' ? 'ACTIVE' : 'INACTIVE'}}</button>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            
            </div>
        </div>
        
        
    </div>
    <!--===================================================-->
    <!--End page content-->

</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->
<script src="{{asset('js/jquery.min.js')}}" ></script>
<script src="{{asset('plugins/jstree/jstree.min.js')}}"></script>

<script type="text/javascript">
 $(document).ready(function()
    {
       $("#select_user").hide();
       $("#select_emp").hide();
       $("#dd_assigned_for").change(function(){
            var val = $("#dd_assigned_for").val();
            if(val == 1){
                $("#select_user").show();
                $("#select_emp").hide();
            }
            else if(val == 2){
                $("#select_emp").show();
                $("#select_user").hide();
            }
            else if(val == -1){
                $("#select_emp").hide();
                $("#select_user").hide();
            }
       });

        var val1 = $("#dd_assigned_for :selected").val();
        if(val1 == 1){
            $("#select_user").show();
            $("#select_emp").hide();
        }
        else if(val1 == 2){
            $("#select_emp").show();
            $("#select_user").hide();
        }
        else if(val1 == -1){
            $("#select_emp").hide();
            $("#select_user").hide();
        }
    });
</script>
<!--Custom script [ DEMONSTRATION ]-->
    <!--===================================================-->
    <script>
        $(document).on('nifty.ready', function () {
            
            // Custom Icon - Premium Solid Icons
            // =================================================================
            // Require JSTree & Premium Icons
            // =================================================================
            $('#demo-jstree-1').jstree({
                'core' : {
                    'check_callback' : true
                },
                'plugins' : [ 'types', 'dnd' ],
                'types' : {
                    'default' : {
                        'icon' : 'demo-pli-folder'
                    },
                    'html' : {
                        'icon' : 'demo-pli-file-html'
                    },
                    'file' : {
                        'icon' : 'demo-pli-file'
                    },
                    'jpg' : {
                        'icon' : 'demo-pli-file-jpg'
                    },
                    'zip' : {
                        'icon' : 'demo-pli-file-zip'
                    }
            
                }
            });

            $('#demo-jstree-2').jstree({
                'core' : {
                    'check_callback' : true
                },
                'plugins' : [ 'types', 'dnd' ],
                'types' : {
                    'default' : {
                        'icon' : 'demo-pli-folder'
                    },
                    'html' : {
                        'icon' : 'demo-pli-file-html'
                    },
                    'file' : {
                        'icon' : 'demo-pli-file'
                    },
                    'jpg' : {
                        'icon' : 'demo-pli-file-jpg'
                    },
                    'zip' : {
                        'icon' : 'demo-pli-file-zip'
                    }
            
                }
            });

            $('#demo-jstree-3').jstree({
                'core' : {
                    'check_callback' : true
                },
                'plugins' : [ 'types', 'dnd' ],
                'types' : {
                    'default' : {
                        'icon' : 'demo-pli-folder'
                    },
                    'html' : {
                        'icon' : 'demo-pli-file-html'
                    },
                    'file' : {
                        'icon' : 'demo-pli-file'
                    },
                    'jpg' : {
                        'icon' : 'demo-pli-file-jpg'
                    },
                    'zip' : {
                        'icon' : 'demo-pli-file-zip'
                    }
            
                }
            });
           
        });
    </script>
<script type="text/javascript">
$(document).ready(function(){
    $(".val").on("click", function(e) {
        var id = $(this).data('id');
        var menuname = $(this).data('menuname');
        $('#txt_menuid').val(id);
        $('#menuname').text(menuname);
    });
});
</script>
@endsection