@extends('mainlayout')
@section('content')
<style >
.select2-container {
    box-sizing: border-box;
    display: inline-block;
    margin: 0;
    position: relative;
    vertical-align: middle;
    width: 100%!important;
}
</style>
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Master Panel</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{ url('/admin_dashboard') }}"><i class="demo-pli-home"></i></a></li>
        <li><a href="{{ url('/admin_dashboard') }}">Dashboard</a></li>
        <li class="active">Assign Menu</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>

    
    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">
        
        <div class="row">
            <div class="col-sm-6 col-md-4">
                <div class="panel">
					

					 @if(Session::has('menu_msg')) 
                        <div class="alert alert-{{ Session::get('type') }} alert-dismissible show" role="alert">
                            <h4 class="alert-heading">{{ Session::get('menu_msg') }}</h4>
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                    @endif


                    <div class="panel-heading">
                        <div class="panel-control">
                            <button class="btn btn-default" data-panel="minmax"><i class="demo-psi-chevron-up"></i></button>
                        </div>
                        <h3 class="panel-title">Assign Menu Management</h3>
                    </div>

                    <div class="collapse in">
                        @if(!isset($single_menu[0]->ASMENU_ID))
                        <form id="assign-menu" action="{{url('/add_menu')}}" method="post" enctype="multipart/form-data">
                            {{ csrf_field() }}
                            <div class="panel-body">
                                <div class="row">

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_menu_name">Menu Name</label>
                                            <input type="text" name="txt_menu_name" id="txt_menu_name" class="form-control" placeholder="Enter Menu Name">
                                        </div>
                                    </div>

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_menu_var">Menu Variable</label>
                                            <input type="text" name="txt_menu_var" id="txt_menu_var" class="form-control" placeholder="Enter Menu Variable">
                                        </div>
                                    </div>

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_menu_url">Menu Url</label>
                                            <input type="text" name="txt_menu_url" id="txt_menu_url" class="form-control" placeholder="Enter Menu Url">
                                        </div>
                                    </div>

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_menu_icon">Menu Icon</label>
                                            <input type="text" name="txt_menu_icon" id="txt_menu_icon" class="form-control" placeholder="Enter Menu Icon">
                                        </div>
                                    </div>

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_menu_order">Menu Order</label>
                                            <input type="number" name="txt_menu_order" id="txt_menu_order" class="form-control" placeholder="Enter Menu Order">
                                        </div>
                                    </div>


                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="dd_role">Role Type</label>
                                            <select class="form-control" id="dd_role" name="dd_role" required>
                                                <option value="">Select Role</option>
                                                @foreach($role as $value)
                                                <option value="{{$value->ROLE_ID}}">{{$value->ROLE_NAME}}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                                    @error('dd_role')
                                                    <span class="help-block text-danger">{{ $message }}</span>
                                                    @enderror
                                    </div>

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="demo-select2-multiple-selects">Role</label>
                                            <select class="form-control" name="dd_role_id[]"  id="demo-select2-multiple-selects" multiple="multiple" required>
                                                <option value="" disabled selected>Select Role</option>
                                            </select>
                                        </div>
                                        <input type="hidden" name="txt_user_role_id" id="txt_user_role_id" value="" required>
                                                    @error('dd_role_id')
                                                    <span class="help-block text-danger">{{ $message }}</span>
                                                    @enderror
                                    </div>

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="dd_menu">Menu</label>
                                            <select class="form-control" id="dd_menu" name="dd_menu">
                                                <option value="-1">Select Parent Menu</option>
                                                @foreach($parent_menus as $pm)
                                                <option value="{{$pm->ASMENU_ID}}">{{$pm->ASMENU_NAME}} [ @if($pm->ROLE_TYPE == '18') BOTH @endif @if($pm->ROLE_TYPE == '1') USER  @endif @if($pm->ROLE_TYPE == '10') EMPLOYEE  @endif  ]</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="dd_islink">Is Link</label>
                                            <select class="form-control" id="dd_islink" name="dd_islink">
                                                <option value="-1">Select Menu Is Link</option>
                                                <option value="1">Yes</option>
                                                <option value="2">No</option>
                                            </select>
                                        </div>
                                    </div>

                                </div>

                            </div>
                            <div class="panel-footer text-center">
                                <button class="btn btn-success" type="button" onclick="conwv('assign-menu')">Save</button>
                                <button class="btn btn-default" type="button">Close</button>
                            </div>
                        </form>
                        @elseif(isset($single_menu[0]->ASMENU_ID))
                        <form id="assign-menu" action="{{url('/update_menu/'.$single_menu[0]->ASMENU_ID)}}" method="post" enctype="multipart/form-data">
                            {{ csrf_field() }}
                            <div class="panel-body">
                                <div class="row">

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_menu_name">Menu Name</label>
                                            <input type="text" name="txt_menu_name" id="txt_menu_name" class="form-control" value="{{$single_menu[0]->ASMENU_NAME}}">
                                        </div>
                                    </div>

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_menu_var">Menu Variable</label>
                                            <input type="text" name="txt_menu_var" id="txt_menu_var" class="form-control" value="{{$single_menu[0]->ASMENU_VAR}}">
                                        </div>
                                    </div>

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_menu_url">Menu Url</label>
                                            <input type="text" name="txt_menu_url" id="txt_menu_url" class="form-control" value="{{$single_menu[0]->ASMENU_URL}}">
                                        </div>
                                    </div>

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_menu_icon">Menu Icon</label>
                                            <input type="text" name="txt_menu_icon" id="txt_menu_icon" class="form-control" value="{{$single_menu[0]->ASMENU_ICON}}">
                                        </div>
                                    </div>

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_menu_order">Menu Order</label>
                                            <input type="number" name="txt_menu_order" id="txt_menu_order" class="form-control" value="{{$single_menu[0]->ASMENU_ORDER}}">
                                        </div>
                                    </div>


                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="dd_role">Role Type</label>
                                            <select class="form-control" id="dd_role" name="dd_role" required>
                                                <option value="">Select Role</option>
                                                @foreach($role as $value)
                                                <option value="{{$value->ROLE_ID}}"  {{$single_menu[0]->ROLE_TYPE == $value->ROLE_ID ? 'selected' : ''}}>{{$value->ROLE_NAME}}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                                    @error('dd_role')
                                                    <span class="help-block text-danger">{{ $message }}</span>
                                                    @enderror
                                    </div>

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="dd_role_id">Role</label>
                                            <select class="form-control"  name="dd_role_id[]"  id="demo-select2-multiple-selects"  multiple="multiple" required>
                                                <option value="">Select Role</option>
                                                @foreach($ProleID as $value)
												@php  $menu_user_roles = explode(',', $single_menu[0]->ROLE_ID); @endphp
                                                <option value="{{$value->ROLE_ID}}" @if(in_array($value->ROLE_ID,$menu_user_roles)) selected @endif >{{$value->ROLE_NAME}}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                                    @error('dd_role_id')
                                                    <span class="help-block text-danger">{{ $message }}</span>
                                                    @enderror
                                    </div>

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="dd_islink">Is Link</label>
                                            <select class="form-control" id="dd_islink" name="dd_islink">
                                                <option value="-1">Select Menu Is Link</option>
                                                <option value="1" {{$single_menu[0]->ASMENU_ISLINK == 'YES' ? 'selected' : ''}}>Yes</option>
                                                <option value="2" {{$single_menu[0]->ASMENU_ISLINK == 'NO' ? 'selected' : ''}}>No</option>
                                            </select>
                                        </div>
                                    </div>

                                </div>

                            </div>
                            <div class="panel-footer text-center">
                                <button class="btn btn-success" type="button" onclick="conwv('assign-menu')">Save</button>
                                <button class="btn btn-default" type="button">Close</button>
                            </div>
                        </form>
                        @endif
                    </div>
        
                </div>

                <div class="modal fade" id="demo-default-modal" role="dialog" tabindex="-1" aria-labelledby="demo-default-modal" aria-hidden="true">
                    <div class="modal-dialog">
                        <div class="modal-content">

                        <form action="{{url('menu_status')}}" method="POST"> 
                            {{ csrf_field() }}

                            <!--Modal header-->
                            <div class="modal-header">
                                <button type="button" class="close" data-dismiss="modal"><i class="pci-cross pci-circle"></i></button>
                                <h4 class="modal-title">CHANGE MENU STATUS</h4>
                            </div>

                            <!--Modal body-->
                            <div class="modal-body">
                                <div class="form-group">
                                    <input id="txt_menuid" name="txt_menuid" type="hidden" class="form-control" required="required">
                                </div>
                                <p class="text-semibold text-main">MENU NAME :-<span id="menuname"></span></p>
                                <br>
                                <p class="text-semibold text-main">Would you like to change the status of menu ?</p>

                            </div>

                            <!--Modal footer-->
                            <div class="modal-footer">
                                <button data-dismiss="modal" class="btn btn-default" type="button">NO</button>
                                <button class="btn btn-primary" type="submit">Yes</button>
                            </div>

                        </form>
                        </div>
                    </div>
                </div>
    
            </div>
            <div class="col-sm-6 col-md-8">
    
                <!-- Custom Icon - Premium Line Icons -->
                <!---------------------------------->
                <div class="panel">
                     <div class="panel-heading">
                         <h3 class="panel-title">Menu Structure</h3>
                     </div>
                     <div class="panel-body">
                        <div class="row">
                        <div class="col-md-6">
                            <div id="demo-jstree-1">
                                <ul>
                                    <li class="jstree-close">Employee
                                        <ul>
										
                                            @foreach($parent_menus as $mn)
                                            @if($mn->ASMENU_PARENTID == -1 && $mn->ROLE_TYPE == '10' || $mn->ROLE_TYPE == '18')
                                            <li class="jstree-close">{{$mn->ASMENU_NAME}} - {{$mn->ASMENU_URL}}
                                                <ul>
                                                    @foreach($menus as $sm)
                                                    @if($mn->ASMENU_ID == $sm->ASMENU_PARENTID && $mn->ROLE_TYPE == '10' || $mn->ROLE_TYPE == '18')
                                                    <li class="jstree-close">{{$sm->ASMENU_NAME}} - {{$sm->ASMENU_URL}}
                                                    </li>
                                                    @endif
                                                    @endforeach
                                                </ul>
                                            </li>
                                              @endif
                                            @endforeach
                                        </ul>
                                    </li>
                                </ul>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div id="demo-jstree-2">
                                <ul>
                                    <li class="jstree-close">User
                                        <ul>
                                            @foreach($parent_menus as $mn)
                                            @if($mn->ASMENU_PARENTID == -1 && $mn->ROLE_TYPE == '1' || $mn->ROLE_TYPE == '18')
                                            <li class="jstree-close">{{$mn->ASMENU_NAME}} - {{$mn->ASMENU_URL}}
                                                <ul>
                                                    @foreach($menus as $sm)
                                                    @if($mn->ASMENU_ID == $sm->ASMENU_PARENTID && $mn->ROLE_TYPE == '1' || $mn->ROLE_TYPE == '18')
                                                    <li class="jstree-close">{{$sm->ASMENU_NAME}} - {{$sm->ASMENU_URL}}
                                                    </li>
                                                    @endif
                                                    @endforeach
                                                </ul>
                                            </li>
                                              @endif
                                            @endforeach
                                        </ul>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
    
                     </div>
                 </div>
                <!---------------------------------->
    
            </div>
        </div>

        <div class="row">
            <div class="panel">
                
                <div class="panel-body">
                    <table id="demo-dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
                        <thead>
                            <tr>
                                <th>S.No</th>
                                <th>Menu Parent</th>
                                <th>Menu Name</th>
                                <th class="min-tablet">Menu Url</th>
								<th  class="min-tablet">Assign Role</th>
                                <th  class="min-tablet">Menu Assign To</th>
                                <th class="min-tablet">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $i = 1; ?>
                            @foreach($menus as $mn)
                            <tr>
                                <td>{{$i++}}</td>
                                <td>{{$mn->ASMENU_PARENTNAME}}</td>
                                <td>{{$mn->ASMENU_NAME}}</td>
                                <td>{{$mn->ASMENU_URL}}</td>
                                <td>{{$mn->ASMENU_ROLE_NAME }}</td>
								<td>{{$mn->ASMENU_ROLE }}</td>
								<!-- td> //@php $data1 = ''; $data1 = explode(',', $mn->ROLE_ID); @endphp @foreach($data1 as $values)   @endforeach @foreach($AllRole as $value)   @endforeach</td -->
                                <td>
                                    <a class="btn btn-success btn-xs" href="{{url('view_menu/'.$mn->ASMENU_ID)}}">EDIT</a>
                                    <button data-id="{{$mn->ASMENU_ID}}" data-menuname="{{$mn->ASMENU_NAME}}" data-target="#demo-default-modal" data-toggle="modal" class="btn btn-primary btn-xs val">{{$mn->ASMENU_STATUS == 'ACTIVE' ? 'ACTIVE' : 'INACTIVE'}}</button>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            
            </div>
        </div>
        
        
    </div>
    <!--===================================================-->
    <!--End page content-->

</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->

<script src="{{asset('js/jquery.min.js')}}" ></script>
<script src="{{asset('plugins/jstree/jstree.min.js')}}"></script>
<!--Custom script [ DEMONSTRATION ]-->
    <!--===================================================-->
    <script>
        $(document).on('nifty.ready', function () {
            
            // Custom Icon - Premium Solid Icons
            // =================================================================
            // Require JSTree & Premium Icons
            // =================================================================
            $('#demo-jstree-1').jstree({
                'core' : {
                    'check_callback' : true
                },
                'plugins' : [ 'types', 'dnd' ],
                'types' : {
                    'default' : {
                        'icon' : 'demo-pli-folder'
                    },
                    'html' : {
                        'icon' : 'demo-pli-file-html'
                    },
                    'file' : {
                        'icon' : 'demo-pli-file'
                    },
                    'jpg' : {
                        'icon' : 'demo-pli-file-jpg'
                    },
                    'zip' : {
                        'icon' : 'demo-pli-file-zip'
                    }
            
                }
            });

            $('#demo-jstree-2').jstree({
                'core' : {
                    'check_callback' : true
                },
                'plugins' : [ 'types', 'dnd' ],
                'types' : {
                    'default' : {
                        'icon' : 'demo-pli-folder'
                    },
                    'html' : {
                        'icon' : 'demo-pli-file-html'
                    },
                    'file' : {
                        'icon' : 'demo-pli-file'
                    },
                    'jpg' : {
                        'icon' : 'demo-pli-file-jpg'
                    },
                    'zip' : {
                        'icon' : 'demo-pli-file-zip'
                    }
            
                }
            });

            $('#demo-jstree-3').jstree({
                'core' : {
                    'check_callback' : true
                },
                'plugins' : [ 'types', 'dnd' ],
                'types' : {
                    'default' : {
                        'icon' : 'demo-pli-folder'
                    },
                    'html' : {
                        'icon' : 'demo-pli-file-html'
                    },
                    'file' : {
                        'icon' : 'demo-pli-file'
                    },
                    'jpg' : {
                        'icon' : 'demo-pli-file-jpg'
                    },
                    'zip' : {
                        'icon' : 'demo-pli-file-zip'
                    }
            
                }
            });
           
        });
    </script>
<script type="text/javascript">
$(document).ready(function(){
    $(".val").on("click", function(e) {
        var id = $(this).data('id');
        var menuname = $(this).data('menuname');
        $('#txt_menuid').val(id);
        $('#menuname').text(menuname);
    });
$("#demo-select2-multiple-selects").select2();
});

        $("#dd_role").change(function () {
        var id = this.value;
        if(this.value > 0)
        {
            $.ajax({
               type:"POST",
               url:"{{ url('/get-role-type')}}",
               data:{"_token": "{{ csrf_token() }}", "id":id },
               success:function(result)
               {   
                    if(result == '')
                    {   $('#demo-select2-multiple-selects').empty();
                        alert('Data Not Found');
                    }
                    else
                    {
                        $('#demo-select2-multiple-selects').empty();
                        $("#demo-select2-multiple-selects").append('<option value="">Select Role</option>');
                        $.each(result,function(key,value){
                            $("#demo-select2-multiple-selects").append('<option value="'+result[key].ROLE_ID+'" data="'+result[key].USER_ROLE_ID+'">'+result[key].ROLE_NAME+'</option>');
                        });
						$("#demo-select2-multiple-selects").select2();
                    }    

               }

            });
        }
        }); 




</script>
@endsection