@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Login Log Panel</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{ url('/admin_dashboard') }}"><i class="fa fa-home"></i></a></li>
        <li><a href="{{ url('/admin_dashboard') }}">Activity</a></li>
        <li class="active">Login Log Details</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>

    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">

        <div class="row">

            <div class="col-md-4 col-sm-12 col-xs-12">
            
                <div class="panel">

                    @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                    @endif

                    @if(Session::has('admin_msg')) 
                    <div class="alert alert-{{ Session::get('type') }} alert-dismissible  show" role="alert">
                        <h4 class="alert-heading">{{ Session::get("admin_msg") }}</h4>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    @endif

                    <div class="panel-heading">
                        <div class="panel-control">
                            <button class="btn btn-default" data-panel="minmax"><i class="fa fa-arrow-circle-up"></i></button>
                        </div>
                        <h3 class="panel-title">Login Log Details</h3>
                    </div>

                    <div class="collapse in">

                    
                    
                        <form id="edit-admin-login" action="{{url('/update_soft_login/'. $admin_detail[0]->m00_login_id)}}" method="POST">
							{{ csrf_field() }}
                            <div class="panel-body">
                                <div class="row">


                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_loginid">OTP Enable</label>
                                            <div class="radio">
                                                <input id="rb_otpenable_mail" class="magic-radio" type="radio" name="rb_otpenable" value="2" 
                                                       {{ $admin_detail[0]->m00_otpenable == 'MAIL' ? 'checked' : '' }}>
                                                <label for="rb_otpenable_mail">MAIL</label>

                                                <input id="rb_otpenable_sms" class="magic-radio" type="radio" name="rb_otpenable" value="3" 
                                                       {{ $admin_detail[0]->m00_otpenable == 'SMS' ? 'checked' : '' }}>
                                                <label for="rb_otpenable_sms">SMS</label>

                                                <input id="rb_otpenable_both" class="magic-radio" type="radio" name="rb_otpenable" value="4"
                                                       {{ $admin_detail[0]->m00_otpenable == 'BOTH' ? 'checked' : '' }}>
                                                <label for="rb_otpenable_both">BOTH</label>

                                                <input id="rb_otpenable_none" class="magic-radio" type="radio" name="rb_otpenable" value="1"
                                                       {{ $admin_detail[0]->m00_otpenable == 'NONE' ? 'checked' : '' }}>
                                                <label for="rb_otpenable_none">NONE</label>
                                            </div>
                                        </div>
                                    </div>

                                </div>

                            </div>
                            <div class="panel-footer text-center">
                                <button class="btn btn-success val" type="button" onclick="conwv('edit-admin-login')">Search</button>
                                <button class="btn btn-default" type="button">Close</button>
                            </div>
                        </form>
                        
                    </div>
        
                </div>

            </div>

            <div class="col-md-8 col-sm-12 col-xs-12">

                <div class="panel">

                    <div class="panel-heading">
                        <div class="panel-control">
                            <button class="btn btn-default" data-panel="minmax"><i class="fa fa-arrow-circle-up"></i></button>
                        </div>
                        <h3 class="panel-title">Login Log Details</h3>
                    </div>
                    <div class="collapse in">
                    <div class="panel-body">
                        <table id="demo-dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
                            <thead>
                                <tr>
                                    <th>S.NO.</th>
                                    <th>REMOTE IP</th>
                                    <th class="min-tablet">USER AGENT</th>
                                    <th class="min-tablet">LOGIN OTP</th>
                                    <th class="min-tablet">LOGIN AT</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $i=1;?>
                                @foreach( $admin_loginlog as $con)
                                <tr>
                                    <td>{{$i++}}</td>
                                    <td> {{$con->REMOTE_IP}} </td>
                                    <td>{{$con->AGENT_DETAILS}}</td>
                                    <td>{{$con->LOGIN_OTP}}</td>
                                    <td>{{$con->LOGIN_AT}}</td>
                                </tr>

                                @endforeach
							
						    </tbody>    
                        </table>
                    </div>
</div>
            
                </div>
            
                
            </div>

            
        </div>
            
    </div>
    <!--===================================================-->
    <!--End page content-->

</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->
@endsection