@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Payout Ledger</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{ url('/admin_dashboard') }}"><i class="fa fa-home"></i></a></li>
        <li><a href="{{ url('/admin_dashboard') }}">Funds</a></li>
        <li class="active">Payout Ledger</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>

    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">

        <div class="row">
            
            <div class="panel">
                <div class="panel-heading">
                    <div class="panel-control">
                        <button class="btn btn-default" data-panel="minmax"><i class="fa fa-arrow-circle-up"></i></button>
                    </div>
                    <h3 class="panel-title">Payout Ledger</h3>
                </div>

                <div class="collapse in">
    
                      <form action="{{url('/payout_ledger')}}" enctype="multipart/form-data" id="payout_ledger" method="post" accept-charset="utf-8">
                        {{ csrf_field() }} 
                            <div class="panel-body">
                                <div class="row">    

                                    <div class="col-sm-2">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_from">From Date</label>
                                            <div id="demo-dp-txtinput">
                                                <input type="text" name="txt_from" id="txt_from" class="form-control input-inline input-medium" placeholder="dd/mm/yyyy" autocomplete="off" >
                                            </div>
                                        </div>
                                    </div>    

                                    <div class="col-sm-2">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_to">To Date</label>
                                            <div id="demo-dp-txtinput">
                                                <input type="text" name="txt_to" id="txt_to" class="form-control input-inline input-medium" placeholder="dd/mm/yyyy" autocomplete="off" >
                                            </div>    
                                        </div>
                                    </div>                             
                                 <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="txt_memberid">Member Id</label>
                                        <input type="text" id="txt_memberid" name="txt_memberid" class="form-control" placeholder="Enter Member Id." >
                                    </div>
                                </div>
                                    <div class="col-sm-2">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_transid">Transaction Id</label>
                                            <input type="text" name="txt_transid" id="txt_transid" class="form-control" placeholder="Enter Transaction Id.">
                                        </div>
                                    </div>

                                    <div class="col-sm-2">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_records">No. Of Records</label>
                                            <input type="text" name="txt_records" id="txt_records" class="form-control" placeholder="Enter No. Of Records">
                                        </div>
                                    </div>

                                    <div class="col-sm-2">
                                        <div class="form-group">
                                            <label class="control-label">LEDGER TYPE</label>
                                            <select name="dd_ledgertype" class="form-control selectpicker" data-live-search="true" data-width="100%">
                                                <option value="-1">SELECT LEDGER</option>
                                                <option value="11">TOPUP</option>
												<option value="12">REFERRAL POINT</option>
												<option value="13">TEAM BONUS POINT</option>
												<option value="14">REDEEM REFERRALPOINT</option>
												<option value="15">REDEEM TEAM BONUS POINT</option>
                                            </select>
                                        </div>
                                    </div>

                                </div>
                            </div>
                            <div class="panel-footer text-center">
                                <input type="submit" id="btnsubmit" class="btn btn-success" >
                                <input type="reset" id="btnsreset" class="btn btn-primary" >                            
                            </div>
                        </form>
                    
                </div>
    
            </div>
            
        </div>

        <div class="row">
            <div class="panel">
            
                <div class="panel-body">
                    <div class="text-right">
                        <div class="form-group">
                            <button class="btn btn-success" id="excel" onclick="EXPORTTOEXCEL('payout_ledger');">Export To Excel</button>
                        </div>
                    </div>
                    <table id="demo-dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
                        <thead>
                            <tr>
                                <th>SNO.</th>
                                <th>MEMBERID/NAME</th>
                                <th class="min-tablet">TRANSACTION ID</th>
                                <th class="min-tablet">TRANSACTION DATE</th>
                                <th class="min-tablet">DESCRIPTION</th>
                                <th class="min-tablet">CR. AMOUNT</th>
                                <th class="min-tablet">DR. AMOUNT</th>
                                <th class="min-tablet">BALANCE FOR</th>
                                <th class="min-tablet">MAINBAL</th>
                                <th class="min-tablet">PAYOUTBAL</th>
                                <th class="min-tablet">REWARDBAL</th>
                            </tr>
                        </thead>
                       <tbody>
							@foreach( $ledger_report as $con)
							 <tr>
							 <td >{{'#'}}</td >
            <td>{{$con->MemberID}}<span style="color:red;">/</span>{{$con->MemberFirstName}} {{$con->MemberLastName}}</td>
			<td>{{$con->Transactionid}}</td>
			<td>{{$con->TransactionDate}}</td>
			<td>{{$con->Description}}</td>
			<td>{{$con->AmountCredited}}</td>
			<td>{{$con->AmountDedited}}</td>
			<td>{{$con->BalanceType}}</td>
			<td>{{$con->CurrentBalance}}</td>
			<td>{{$con->UtilityBalance}}</td>
			<td>{{$con->RemittanceBalance}}</td>
			</tr>
			 @endforeach
						</tbody>
                    </table>
                </div>
            
            </div>
        </div>
            
    </div>
    <!--===================================================-->
    <!--End page content-->

</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->
@endsection