@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Fund Recieve</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{ url('/admin_dashboard') }}"><i class="fa fa-home"></i></a></li>
        <li><a href="{{ url('/admin_dashboard') }}">Funds</a></li>
        <li class="active">Fund Recieve</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>

    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">

        <div class="row">
            
            <div class="panel">
                <div class="panel-heading">
                    <div class="panel-control">
                        <button class="btn btn-default" data-panel="minmax"><i class="fa fa-arrow-circle-up"></i></button>
                    </div>
                    <h3 class="panel-title">Fund Recieve</h3>
                </div>

                <div class="collapse in">
                    <form action="{{url('/payment_summary')}}" enctype="multipart/form-data" id="fund_ledger" method="post" accept-charset="utf-8">
                        {{ csrf_field() }} 
                            <div class="panel-body">
                                <div class="row">     

                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_from">From Date</label>
                                            <div id="demo-dp-txtinput">
                                                <input type="text" name="txt_from" id="txt_from" class="form-control input-inline input-medium" placeholder="dd/mm/yyyy" autocomplete="off" >
                                            </div>
                                        </div>
                                    </div>    

                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_to">To Date</label>
                                            <div id="demo-dp-txtinput">
                                                <input type="text" name="txt_to" id="txt_to" class="form-control input-inline input-medium" placeholder="dd/mm/yyyy" autocomplete="off" >
                                            </div>    
                                        </div>
                                    </div>                            
                                
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_transid">Transaction Id</label>
                                            <input type="text" name="txt_transid" id="txt_transid" class="form-control" placeholder="Enter Transaction Id." >
                                        </div>
                                    </div>

                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_records">No. Of Records</label>
                                            <input type="text" name="txt_records" id="txt_records" class="form-control" placeholder="Enter No. Of Records" >
                                        </div>
                                    </div>
								</div>
                            </div>
                            <div class="panel-footer text-center">
                                <input type="submit" id="btnsubmit" class="btn btn-success" >
                                <input type="reset" id="btnsreset" class="btn btn-primary" >                            
                            </div>
                        </form>
                    
                </div>
    
            </div>
            
        </div>

        <div class="row">
            <div class="panel">
            
                <div class="panel-body">
                    <div class="text-right">
                        <div class="form-group">
                            <button class="btn btn-success" id="excel" onclick="EXPORTTOEXCEL('FUND_RECEIVE');">Export To Excel</button>
                        </div>
                    </div>
                    <table id="demo-dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
                        <thead>
                            <tr>
                                <th>SNO.</th>
								<th >TXN DATE</th>	
                                <th>MEMBERID/NAME</th>
                                <th >DESCRIPTION</th>
                                <th >CR. AMOUNT</th>
                                <th >DR. AMOUNT</th>
                                <th >BALANCE FOR</th>
                                <th >MAINBAL</th>
                                <th >DMRBAL</th>
                                <th >AEPSBAL</th>
                            </tr>
                        </thead>
                        <tbody>
							@foreach( $ledger_report as $con)
							 <tr>
							 <td >{{'#'}}</td >
            <td>{{$con->MemberID}}<span style="color:red;"></br></span>{{$con->MemberFirstName}} {{$con->MemberLastName}}</td>
			
			<td>{{$con->TransactionDate}}</td>
			<td>{{$con->Description}}</td>
			<td>{{$con->AmountCredited}}</td>
			<td>{{$con->AmountDedited}}</td>
			<td>{{$con->BalanceType}}</td>
			<td>{{$con->CurrentBalance}}</td>
			<td>{{$con->UtilityBalance}}</td>
			<td>{{$con->RemittanceBalance}}</td>
			</tr>
			 @endforeach
						</tbody>
                    </table>
                </div>
            
            </div>
        </div>
        
            
    </div>
    <!--===================================================-->
    <!--End page content-->

</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->
@endsection