@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Fund Transfer To Store</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{ url('/admin_dashboard') }}"><i class="fa fa-home"></i></a></li>
        <li><a href="{{ url('/admin_dashboard') }}">Funds</a></li>
        <li class="active">Fund Transfer To Store</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>

    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">
        
        <div class="row">
            <div class="col-md-4">
                <div class="panel">

                    @if(Session::has('message')) 
                    <div class="alert alert-{{ Session::get('type') }} alert-dismissible  show" role="alert">
                        <h4 class="alert-heading">{{ Session::get("message") }}</h4>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    @endif

                    <div class="panel-heading">
                        <div class="panel-control">
                            <button class="btn btn-default" data-panel="minmax"><i class="fa fa-arrow-circle-up"></i></button>
                        </div>
                        <h3 class="panel-title">Fund Transfer To Store</h3>
                    </div>

                    <div class="collapse in">
        
                    <form action="{{url('/fund_transfer_store')}}" enctype="multipart/form-data" id="fund_transfer" method="post" accept-charset="utf-8">
                        {{ csrf_field() }} 
                          <div class="panel-body">

								<input type="hidden" name="baltype" id="baltyper" value="1"/> 
								<input type="hidden" name="ladger" id="ladger" value="1"/> 
                                <div class="form-group">
                                    <label class="control-label">Transfer to Store Id</label>  
                                    <input id="txt_referralcode" name="txt_referralcode" type="text" class="form-control" required="required" onBlur="get_store_name()"> 
								</div>     
								
								<div class="form-group">
									<label class="control-label">Transfer Amount</label> 
									<input id="txt_amount" name="txt_amount" type="number" class="form-control" required="required">                 
								</div>
								<div class="form-group">
									<label class="control-label">Enter Remark</label>  
									<input id="txt_remark" name="txt_remark" type="text" class="form-control" required="required">
								</div>
								<div class="clearfix"></div>
								<div class="clearfix"></div>
								
								<div class="form-group">
									<button class="btn btn-success" type="button" onclick="conwv('fund_transfer')">Submit</button>
									<button class="btn btn-primary" type="reset">RESET</button>
								</div>
								
								
							</div>
                       
                    </form>

                </div>

                </div>
            </div>
        

            <div class="col-md-8">
                <div class="row">
                    <div class="panel">

                        <div class="panel-heading">
                            <h3 class="panel-title">Fund Transfer To Store</h3>
                        </div>
                    
                        <div class="panel-body">
                            <div class="text-right">
                                <div class="form-group">
                                    <button class="btn btn-success" id="excel" onclick="EXPORTTOEXCEL('fund_request');">Export To Excel</button>
                                </div>
                            </div>
                            <table id="demo-dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>BANK NAME</th>
                                        <th class="min-tablet">PAYEE NAME</th>
                                        <th class="min-tablet">ACCOUNT NUMBER</th>
                                        <th class="min-tablet">IFSC CODE</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    
                    </div>
                </div>

            </div>
        </div>

    </div>
    <!--===================================================-->
    <!--End page content-->

</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->
<script src="http://code.jquery.com/jquery-2.1.4.min.js"></script>
<script type="text/javascript">
        function get_store_name(){
            var user = $('#txt_referralcode').val();
            
            if(user){
                $.ajax({
                   type:"POST",
                   url:"{{url('/getStoreName')}}",
                   data:{"_token": "{{ csrf_token() }}", "txtintuserid": user},
                   success:function(result)
                   {       
                        if(result)
                        {
                            $("#txt_referralname").empty();
                            $("#txt_referralname").val(result[0].m44_store_name);
                        }else{
                            $("#txt_referralname").empty();
                        }
                   }

                });
            }
        };



</script>
@endsection