@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Cash Collection</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{ url('/admin_dashboard') }}"><i class="fa fa-home"></i></a></li>
        <li><a href="{{ url('/admin_dashboard') }}">Fund</a></li>
        <li class="active">Cash Collection</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>

    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">
        
        <div class="row">
            <div class="col-md-4">
                <div class="panel">

                    @if(Session::has('message')) 
                    <div class="alert alert-{{ Session::get('type') }} alert-dismissible  show" role="alert">
                        <h4 class="alert-heading">{{ Session::get("message") }}</h4>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    @endif

                    <div class="panel-heading">
                        <div class="panel-control">
                            <button class="btn btn-default" data-panel="minmax"><i class="fa fa-arrow-circle-up"></i></button>
                        </div>
                        <h3 class="panel-title">Cash Collection</h3>
                    </div>

                    <div class="collapse in">
        
                    <form action="{{url('/cash_collection')}}" enctype="multipart/form-data" id="fund_transfer" method="post" accept-charset="utf-8">
                        {{ csrf_field() }} 
                          <div class="panel-body">
								<div class="form-group">
									<label class=" control-label">Balance Type <span class="text-danger">*</span></label>
									<div class="" style="margin-top: 5px;">
										<input id="baltyper" class="magic-radio" type="radio" name="baltype" value="1" checked required>
										<label for="baltyper">MAIN</label>
										<input id="baltypeu" class="magic-radio" type="radio" name="baltype" value="2">
										<label for="baltypeu">DMR</label>
									</div>
								</div>
								<div class="form-group">
									<label class=" control-label">ID Type <span class="text-danger">*</span></label>
									<div class="" style="margin-top: 5px;">
										<input id="idype" class="magic-radio" type="radio" onchange="change_id_type(this.id);" name="idstype" value="2" checked required>
										<label for="idype">FROM MOBILE NO</label>
										<input id="idyper" class="magic-radio" type="radio" onchange="change_id_type(this.id);" name="idstype" value="1">
										<label for="idyper">FROM MEMBER ID</label>
									</div>
								</div>
								 <div class="form-group"  id="mobid">
                                    <label class="control-label"> Enter Mobile Number <span class="text-danger">*</span></label>  
                                    <input id="txt_mobileno" name="txt_mobileno" type="text" class="form-control" onBlur="get_member_name2();"> 
								</div> 
								 <div class="form-group" style="display:none" id="memid">
                                    <label class="control-label"> Enter Member Id <span class="text-danger">*</span></label>  
                                    <input id="txt_memberid" name="txt_memberid" type="text" class="form-control"  onBlur="get_member_name3();"> 
								</div> 
                                <div class="form-group">
                                    <label class="control-label">Member Name :- <span id="user_name"></span></label>
								</div>     
								
								<div class="form-group">
									<label class="control-label">Available Balance :- <span id="user_balance"></span></label>
								</div>

								<div class="form-group">
									<label class="control-label">Outstanding Balance :- <span id="user_outstanding"></span></label>
								</div>
								<div class="form-group">
									<label class="control-label">Cash Collected Amount<span class="text-danger">*</span></label>  
									<input id="txt_cashcolledted" name="txt_cashcolledted" type="text" class="form-control" required="required"   oninput="toWords(this.id)"  autocomplete="off"  onKeyPress="if(this.value.length==10) return false;">
								</div>
									<div class="form-group">
										<label class="control-label">Cash Collected Amount in words -:<span style="font-weight: bold;" id="txt_cashcolledted_in_word"></span></label>  
										<span id="divtxt_cashcolledted_in_word" class="text-danger"></span> 
									</div>
								<div class="form-group">
									<label class="control-label">Cash Collection Remark <span class="text-danger">*</span></label>  
									<input id="txt_ccremark" name="txt_ccremark" type="text" class="form-control" required="required">
								</div>

								<div class="clearfix"></div>
								<div class="clearfix"></div>
								
								<div class="form-group">
									<button class="btn btn-success" type="button" onclick="conwv('fund_transfer')">Submit</button>
									<button class="btn btn-primary" type="reset">Reset</button>
								</div>
								
								
							</div>
                       
                    </form>

                </div>

                </div>
            </div>
        

            <div class="col-md-8">
                <div class="row">
                    <div class="panel">

                        <div class="panel-heading">
                            <h3 class="panel-title">CASH COLLECTION <span class="pull-right"><button class="btn btn-success" id="excel" onclick="EXPORTTOEXCEL('fund_request');">Export To Excel</button></span></h3>
                        </div>
                    
                        <div class="panel-body">
                            
                            <table id="demo-dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
                                <thead>
                                    <tr>
                                        <th class="min-tablet">#</th>
                                        <th class="min-tablet">MEMBER ID</th>
										<th class="min-tablet">MEMBER NAME</th>
                                        <th class="min-tablet">TXN ID</th>
										<th class="min-tablet">CREDIT AMOUNT</th>
										<th class="min-tablet">DEBIT AMOUNT</th>
                                        <th>TXN DATE</th>
										<th>REMARK</th>
                                    </tr>
                                </thead>
                                <tbody>
									@foreach($fund_t as $key => $value)
                                    <tr>
                                        <th class="min-tablet">{{ $key+1}}</th>
                                        <th class="min-tablet">{{ $value->user_code}}</th>
										<th class="min-tablet">{{ $value->user_name}}</th>
                                        <th class="min-tablet">{{ $value->cc_transaid}}</th>
                                        <th>{{ $value->debit_amt}}</th>
										<th>{{ $value->credit_amt}}</th>
										<th>{{ $value->fund_date}}</th>
										<th>{{ $value->collected_remrk}}</th>
                                    </tr>
									@endforeach
                                </tbody>
                            </table>
                        </div>
                    
                    </div>
                </div>

            </div>
        </div>

    </div>
    <!--===================================================-->
    <!--End page content-->

</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->
<script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
<script type="text/javascript">
get_member_name2();
function get_member_name2()
{
	var user_contactno = $("input[name='txt_mobileno']").val();
//alert(user_contactno);
	user_contactno = user_contactno.split(' ');
	var txt_contactno=user_contactno[0];
	
	//console.log(user_contactno);
	//var csrf = $("input[name='csrf_token']").val();
	if($("#txt_mobileno").val()!=""	&& txt_contactno.length==10)
	{
		$.ajax({	
			type:"POST",
			url:'get_details',
			dataType: 'json',
			data:{"txt_contactno":txt_contactno,"_token": "{{ csrf_token() }}"},
			beforeSend : function(){
				$('img.loader').show('fadein');
			},
			success:function(msg) 
			{
				console.log(msg);
				$('img.loader').hide('fadeout');
					$('#user_name').html(msg[0].FirstName+' '+msg[0].LastName);
					//alert($("input[name='baltype']").val());
					if($("input[name='baltype']:checked").val()==1)
					{
					$("#user_balance").html(msg[0].RECHARGE_BAL);
				    $('#user_outstanding').html(msg[0].RECHARGE_BAL_OUTSTANDING);
					}
					if($("input[name='baltype']:checked").val()==2)
					{
					$("#user_balance").html(msg[0].UTILITY_BAL);
					$('#user_outstanding').html(msg[0].UTILITY_BAL_OUTSTANDING);
					}
			}
		});
	}
}
 </script>
<script type="text/javascript">
get_member_name3();
function get_member_name3()
{
var user_contactno = $("input[name='txt_memberid']").val();
//alert(user_contactno);
	user_contactno = user_contactno.split(' ');
	var txt_contactno=user_contactno[0];
	
	//console.log(user_contactno, txt_contactno.length);
	//var csrf = $("input[name='csrf_token']").val();
	if($("#txt_memberid").val()!="")
	{
		$.ajax({	
			type:"POST",
			url:'get_mem_details',
			dataType: 'json',
			data:{"txt_contactno":txt_contactno,"_token": "{{ csrf_token() }}"},
			beforeSend : function(){
				$('img.loader').show('fadein');
			},
			success:function(msg) 
			{
				console.log(msg);
				$('img.loader').hide('fadeout');
					$('#user_name').html(msg[0].FirstName+' '+msg[0].LastName);
					//alert($("input[name='baltype']").val());
					if($("input[name='baltype']:checked").val()==1)
					{
					$("#user_balance").html(msg[0].RECHARGE_BAL);
				    $('#user_outstanding').html(msg[0].RECHARGE_BAL_OUTSTANDING);
					}
					if($("input[name='baltype']:checked").val()==2)
					{
					$("#user_balance").html(msg[0].UTILITY_BAL);
					$('#user_outstanding').html(msg[0].UTILITY_BAL_OUTSTANDING);
					}
			}
		});
	}
}
 </script>
<script type="text/javascript">
function change_id_type(id)
{
	if(id == 'idyper')
	{
		$("#mobid").hide();
		$("#memid").show();  
		
		$("#txt_memberid").val('');
		$("#txt_mobileno").val('');
		$("#user_name").val('');
		$("#user_balance").val('');
		$("#user_outstanding").val('');
		$("#txt_amount").val('');
		$("#txt_remark").val('');
		$("#txt_cashcolledted").val('');
		$("#txt_ccremark").val('');
	}
	if(id == 'idype')
	{
		$("#mobid").show();
		$("#memid").hide();

		$("#txt_memberid").val('');
		$("#txt_mobileno").val('');
		$("#user_name").empty();
		$("#user_balance").empty();
		$("#user_outstanding").empty();
		$("#txt_amount").val('');
		$("#txt_remark").val('');
		$("#txt_cashcolledted").val('');
		$("#txt_ccremark").val('');

	  
	}
}
</script>
</script>
<script type="text/javascript">
function toWords(id){
 var price = $('#'+id).val();
var word = price_in_words(price)
	$('#txt_cashcolledted_in_word').html(word);
}
    </script>
@endsection