@extends('Front.app')
@section('content')
@php 
    $image = explode(",",$product->PROD_IMAGE);
    if(isset($image[0])){ $img = $image[0]; }
    else{ $img = ''; }
@endphp
    <!-- ::::::  Start  Breadcrumb Section  ::::::  -->
    <div class="page-breadcrumb">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <ul class="page-breadcrumb__menu">
                        <li class="page-breadcrumb__nav"><a href="{{url('/')}}">Home</a></li>
                        <li class="page-breadcrumb__nav active">{{ucfirst(strtolower($product->CAT_NAME))}}</li>
                    </ul>
                </div>
            </div>
        </div>
    </div> 
    <!-- ::::::  End  Breadcrumb Section  ::::::  -->

    <!-- :::::: Start Main Container Wrapper :::::: -->
    <main id="main-container" class="main-container">

        <!-- Start Product Details Gallery -->
        <div class="product-details">
            <div class="container">
                <div class="row">
                    <div class="col-md-5">
                        <div class="product-gallery-box product-gallery-box--default m-b-60">
                            <div class="product-image--large product-image--large-horizontal">
                                <img class="img-fluid" id="img-zoom" src="{{asset('images/prod_logo/'.$img)}}" data-zoom-image="{{asset('images/prod_logo/'.$img)}}" alt="">
                            </div>
                            <div id="gallery-zoom" class="product-image--thumb product-image--thumb-horizontal pos-relative">
                                @foreach($image as $key => $value)
                                <a @if($key == 0) class="zoom-active" @endif data-image="{{asset('images/prod_logo/'.$value)}}" data-zoom-image="{{asset('images/prod_logo/'.$value)}}">
                                    <img class="img-fluid" src="{{asset('images/prod_logo/'.$value)}}" alt="">
                                </a>
                                @endforeach
                            </div>
                        </div>
                    </div>
                    <div class="col-md-7">
                        <div class="product-details-box m-b-60">
                            <h4 class="font--regular m-b-20">{{ucfirst(strtolower($product->PROD_NAME))}}</h4>
                            <!-- <div class="m-b-15">
                                <span class="text-reference">Reference: Jhon Doe</span> 
                             </div> -->
                    
                            <div class="product__price m-t-5">
                                <span class="product__price product__price--large"><i class="fas fa-rupee-sign"></i>{{number_format($product->PROD_DISCPRICE,2)}} <del>  @if($product->PROD_DISCPRICE != $product->PROD_PRICE) <i class="fas fa-rupee-sign"></i>{{ number_format($product->PROD_PRICE, 2) }} @endif</del></span> &ensp;
                                <span> <i class="fal fa-balance-scale"></i> {{$product->PROD_CAPACITY}} {{$product->UNIT_NAME}}</span>
                                <!--span class="product__tag m-l-15 btn--tiny btn--green">-34%</span -->
                            </div>
                            <!--div class="product__desc m-t-25 m-b-30">
                                <p>At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga.</p>
                            </div -->
                            <div class="product-var p-tb-30">
                                <!-- <div class="product__stock m-b-20">
                                    <span class="product__stock--in"><i class="fas fa-check-circle"></i> {{--$product->PROD_STOCK--}} IN STOCK</span>
                                </div> -->
                                @if($product->IS_VARIATION == "YES")
                                <div class="product-color product-var__item">
                                    <span class="product-var__text">{{ucfirst(strtolower($product->GROUP_NAME))}}</span>
                                    <div class="sidebar__color-filter ">
                                    @if(ucfirst(strtolower($product->GROUP_NAME)) == 'Color')
                                     <label class="product-color"><input name="large-product-color" type="radio" class="product-color-select" value="color-{{strtolower($product->OPT_NAME)}}" checked><span></span></label>
                                    @elseif(ucfirst(strtolower($product->GROUP_NAME)) == 'Weight')
                                        <a href="{{url('product/'.$product->PROD_NAME.'/'.$product->PROD_ID)}}" class="btn btn--small btn--black">{{$product->OPT_NAME}} {{ucfirst(strtolower($product->UNIT_NAME))}}</a>
                                    @else
                                        <a href="{{url('product/'.$product->PROD_NAME.'/'.$product->PROD_ID)}}" class="btn btn--small btn--green">{{$product->OPT_NAME}}</a>
                                    @endif

                                    @if(count($product_varnt) > 0)
                                        @foreach($product_varnt as $vvalue)

                                        @if(ucfirst(strtolower($vvalue->GROUP_NAME)) == 'Color')
                                            <label class="product-color"><input name="large-product-color" type="radio" class="product-color-select" value="color-{{strtolower($vvalue->OPT_NAME)}}"><span></span></label>
                                        @elseif(ucfirst(strtolower($vvalue->GROUP_NAME)) == 'Weight')
                                            <a href="{{url('product/'.$vvalue->PROD_NAME.'/'.$vvalue->PROD_ID.'/'.$vvalue->VARNT_ID)}}" class="btn btn--small btn--green">{{$vvalue->OPT_NAME}} {{ucfirst(strtolower($vvalue->UNIT_NAME))}}</a>
                                        @else
                                           <a href="{{url('product/'.$vvalue->PROD_NAME.'/'.$vvalue->PROD_ID.'/'.$vvalue->VARNT_ID)}}" class="btn btn--small btn--green">{{$vvalue->OPT_NAME}}</a> 
                                        @endif
                                        @endforeach
                                    @endif
                                    </div>
                                </div>
                                @endif
                                <div class="product-quantity product-var__item">
                                    <ul class="product-modal-group">
                                        <li><a href="#modalShippinginfo" data-toggle="modal"  class="link--gray link--icon-left"><i class="fal fa-truck-container"></i>Shipping</a></li>
                                        <li><a href="#modalProductAsk" data-toggle="modal"  class="link--gray link--icon-left"><i class="fal fa-envelope"></i>Ask About This product</a></li>
                                    </ul>
                                </div><!-- 
                                <div class="product-quantity product-var__item d-flex align-items-center">
                                    <span class="product-var__text">Quantity: </span>
                                    <form class="quantity-scale m-l-20">
                                        <div class="value-button" id="decrease" onclick="decreaseValue()">-</div>
                                        <input type="number" id="number" value="0" readonly="readonly" />
                                        <div class="value-button" id="increase" onclick="increaseValue()">+</div>
                                    </form>
                                </div> -->
                                <div class="product-var__item"> <!-- href="#modalAddCart" data-toggle="modal" -->
                                    <a href="javascript:void(0)" onclick="AddCart(this.id)" id="AddToCartPro{{$product->PROD_ID}}" data-proid="{{$product->PROD_ID}}" data-isvariant="NO" class="btn btn--long btn--radius-tiny btn--green btn--green-hover-black btn--uppercase btn--weight m-r-20">Add to cart</a>
                                    <a href="" class="btn btn--round btn--round-size-small btn--green btn--green-hover-black"><i class="fas fa-heart"></i></a>
                                </div>
                                <div class="product-var__item">
                                    <span class="product-var__text">Guaranteed safe checkout </span>
                                    <ul class="payment-icon m-t-5">
                                        <li><img src="{{asset('assets/img/icon/payment/paypal.svg')}}" alt=""></li>
                                        <li><img src="{{asset('assets/img/icon/payment/amex.svg')}}" alt=""></li>
                                        <li><img src="{{asset('assets/img/icon/payment/ipay.svg')}}" alt=""></li>
                                        <li><img src="{{asset('assets/img/icon/payment/visa.svg')}}" alt=""></li>
                                        <li><img src="{{asset('assets/img/icon/payment/shoify.svg')}}" alt=""></li>
                                        <li><img src="{{asset('assets/img/icon/payment/mastercard.svg')}}" alt=""></li>
                                        <li><img src="{{asset('assets/img/icon/payment/gpay.svg')}}" alt=""></li>
                                    </ul>
                                </div>
                               <!--  <div class="product-var__item d-flex align-items-center">
                                    <span class="product-var__text">Share: </span>
                                    <ul class="product-social m-l-20">
                                        <li><a href="#"><i class="fab fa-facebook-f"></i></a></li>
                                        <li><a href="#"><i class="fab fa-twitter"></i></a></li>
                                        <li><a href="#"><i class="fab fa-pinterest-p"></i></a></li>
                                    </ul>
                                </div> -->
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Product Details Gallery -->

        <!-- Start Product Details Tab -->
        <div class="product-details-tab-area">
            <div class="container">
                <div class="row">
                    <div class="col-12">
                        <div class="product-details-content">
                            <ul class="tablist tablist--style-black tablist--style-title tablist--style-gap-30 nav">
                                <li><a class="nav-link active" data-toggle="tab" href="#product-desc">Description</a></li>
                                <li><a class="nav-link" data-toggle="tab" href="#product-dis">Product Details</a></li>
                                <!--li><a class="nav-link" data-toggle="tab" href="#product-review">Reviews</a></li-->
                            </ul>
                            <div class="product-details-tab-box">
                                <div class="tab-content">
                                    <!-- Start Tab - Product Description -->
                                    <div class="tab-pane show active" id="product-desc">
                                        <div class="para__content">
                                        {!! $product->PROD_DESC !!}
                                        </div>    
                                    </div>  
                                    <!-- End Tab - Product Description -->

                                    <!-- Start Tab - Product Details -->
                                    <div class="tab-pane" id="product-dis">
                                        <div class="product-dis__content">
                                            <a href="#" class="product-dis__img m-b-30"><img src="assets/img/logo/another-logo.jpg" alt=""></a>
                                            <div class="table-responsive-md">
                                                <table class="product-dis__list table table-bordered">
                                                    <tbody>
                                                        @if($product->GROUP_NAME != '' && $product->OPT_NAME != '')
                                                        <tr>
                                                            <td class="product-dis__title">{{$product->GROUP_NAME}}</td>
                                                            <td class="product-dis__text">{{$product->OPT_NAME}} @if($product->GROUP_NAME == 'Size') {{$product->UNIT_NAME}} @endif</td>
                                                        </tr>
                                                        @endif
                                                        @if($product->GROUP_NAME1 != '' && $product->OPT_NAME1 != '')
                                                        <tr>
                                                            <td class="product-dis__title">{{$product->GROUP_NAME1}}</td>
                                                            <td class="product-dis__text">{{$product->OPT_NAME1}}  @if($product->GROUP_NAME1 == 'Size') {{$product->UNIT_NAME}} @endif</td>
                                                        </tr>
                                                        @endif
                                                        <tr>
                                                            <td class="product-dis__title">Type</td>
                                                            <td class="product-dis__text">{{$product->CAT_NAME}}</td>
                                                        </tr>
                                                        <tr>
                                                            <td class="product-dis__title">Brand Name</td>
                                                            <td class="product-dis__text">{{$product->PROD_BRAND_NAME}}</td>
                                                        </tr>
                                                        <tr> 
                                                            <td class="product-dis__title">Other Info</td>
                                                            <td class="product-dis__text">{{$product->PROD_NAME}}</td>
                                                        </tr>
                                                        <tr> 
                                                            <td class="product-dis__title">Unit</td>
                                                            <td class="product-dis__text">{{ucfirst(strtolower($product->PROD_CAPACITY))}} {{ucfirst(strtolower($product->UNIT_NAME))}}</td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>  
                                    <!-- End Tab - Product Details -->

                                    <!-- Start Tab - Product Review -->
                                    <div class="tab-pane " id="product-review">
                                        <!-- Start - Review Comment -->
                                        <ul class="comment">
                                            <!-- Start - Review Comment list-->
                                            <li class="comment__list">
                                                <div class="comment__wrapper">
                                                    <div class="comment__img">
                                                        <img src="assets/img/user/image-1.png" alt=""> 
                                                    </div>
                                                    <div class="comment__content">
                                                        <div class="comment__content-top">
                                                            <div class="comment__content-left">
                                                                <h6 class="comment__name">Kaedyn Fraser</h6>
                                                                <ul class="product__review">
                                                                    <li class="product__review--fill"><i class="icon-star"></i></li>
                                                                    <li class="product__review--fill"><i class="icon-star"></i></li>
                                                                    <li class="product__review--fill"><i class="icon-star"></i></li>
                                                                    <li class="product__review--fill"><i class="icon-star"></i></li>
                                                                    <li class="product__review--blank"><i class="icon-star"></i></li>
                                                                </ul>
                                                            </div>   
                                                            <div class="comment__content-right">
                                                                <a href="#" class="link--gray link--icon-left m-b-5"><i class="fas fa-reply"></i>Reply</a>
                                                            </div>
                                                        </div>
                                                        
                                                        <div class="para__content">
                                                            <p class="para__text">Lorem ipsum dolor sit amet, consectetur adipisicing elit. Tempora inventore dolorem a unde modi iste odio amet, fugit fuga aliquam, voluptatem maiores animi dolor nulla magnam ea! Dignissimos aspernatur cumque nam quod sint provident modi alias culpa, inventore deserunt accusantium amet earum soluta consequatur quasi eum eius laboriosam, maiores praesentium explicabo enim dolores quaerat! Voluptas ad ullam quia odio sint sunt. Ipsam officia, saepe repellat. </p>
                                                        </div>
                                                    </div>
                                                </div>
                                                <!-- Start - Review Comment Reply-->
                                                <ul class="comment__reply">
                                                    <li class="comment__reply-list">
                                                        <div class="comment__wrapper">
                                                            <div class="comment__img">
                                                                <img src="assets/img/user/image-2.png" alt=""> 
                                                            </div>
                                                            <div class="comment__content">
                                                                <div class="comment__content-top">
                                                                    <div class="comment__content-left">
                                                                        <h6 class="comment__name">Oaklee Odom</h6>
                                                                    </div>   
                                                                    <div class="comment__content-right">
                                                                        <a href="#" class="link--gray link--icon-left m-b-5"><i class="fas fa-reply"></i>Reply</a>
                                                                    </div>
                                                                </div>
                                                                
                                                                <div class="para__content">
                                                                    <p class="para__text">Lorem ipsum dolor sit amet, consectetur adipisicing elit. Tempora inventore dolorem a unde modi iste odio amet, fugit fuga aliquam, voluptatem maiores animi dolor nulla magnam ea! Dignissimos aspernatur cumque nam quod sint provident modi alias culpa, inventore deserunt accusantium amet earum soluta consequatur quasi eum eius laboriosam, maiores praesentium explicabo enim dolores quaerat! Voluptas ad ullam quia odio sint sunt. Ipsam officia, saepe repellat. </p>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </li>
                                                </ul> <!-- End - Review Comment Reply-->
                                            </li> <!-- End - Review Comment list-->
                                            <!-- Start - Review Comment list-->
                                            <li class="comment__list">
                                                <div class="comment__wrapper">
                                                    <div class="comment__img">
                                                        <img src="assets/img/user/image-3.png" alt=""> 
                                                    </div>
                                                    <div class="comment__content">
                                                        <div class="comment__content-top">
                                                            <div class="comment__content-left">
                                                                <h6 class="comment__name">Jaydin Jones</h6>
                                                                <ul class="product__review">
                                                                <li class="product__review--fill"><i class="icon-star"></i></li>
                                                                <li class="product__review--fill"><i class="icon-star"></i></li>
                                                                <li class="product__review--fill"><i class="icon-star"></i></li>
                                                                <li class="product__review--fill"><i class="icon-star"></i></li>
                                                                <li class="product__review--blank"><i class="icon-star"></i></li>
                                                            </ul>
                                                            </div>   
                                                            <div class="comment__content-right">
                                                                <a href="#" class="link--gray link--icon-left m-b-5"><i class="fas fa-reply"></i>Reply</a>
                                                            </div>
                                                        </div>
                                                        
                                                        <div class="para__content">
                                                            <p class="para__text">Lorem ipsum dolor sit amet, consectetur adipisicing elit. Tempora inventore dolorem a unde modi iste odio amet, fugit fuga aliquam, voluptatem maiores animi dolor nulla magnam ea! Dignissimos aspernatur cumque nam quod sint provident modi alias culpa, inventore deserunt accusantium amet earum soluta consequatur quasi eum eius laboriosam, maiores praesentium explicabo enim dolores quaerat! Voluptas ad ullam quia odio sint sunt. Ipsam officia, saepe repellat. </p>
                                                        </div>
                                                    </div>
                                                </div>
                                            </li> <!-- End - Review Comment list-->
                                        </ul>  <!-- End - Review Comment -->

                                        <!-- Start Add Review Form-->
                                        <div class="review-form m-t-40">
                                            <div class="section-content">
                                                <h6 class="font--bold text-uppercase">ADD A REVIEW</h6>
                                                <p class="section-content__desc">Your email address will not be published. Required fields are marked *</p>
                                            </div>
                                            <form class="form-box" action="#" method="post">
                                                <div class="row">
                                                    <div class="col-12">
                                                        <div class="form-box__single-group">
                                                            <label for="form-name">Your Rating*</label>
                                                            <ul class="product__review">
                                                                <li class="product__review--fill"><i class="icon-star"></i></li>
                                                                <li class="product__review--fill"><i class="icon-star"></i></li>
                                                                <li class="product__review--fill"><i class="icon-star"></i></li>
                                                                <li class="product__review--fill"><i class="icon-star"></i></li>
                                                                <li class="product__review--blank"><i class="icon-star"></i></li>
                                                            </ul>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="form-box__single-group">
                                                            <label for="form-name">Your Name*</label>
                                                            <input type="text" id="form-name" placeholder="Enter your name">
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="form-box__single-group">
                                                            <label for="form-email">Your Email*</label>
                                                            <input type="email" id="form-email" placeholder="Enter your email" required>
                                                        </div>
                                                    </div>
                                                    <div class="col-12">
                                                        <div class="form-box__single-group">
                                                            <label for="form-review">Your review*</label>
                                                            <textarea id="form-review" rows="8" placeholder="Write a review"></textarea>
                                                        </div>
                                                    </div>
                                                    <div class="col-12">
                                                        <button class="btn btn--box btn--small btn--black btn--black-hover-green btn--uppercase font--bold m-t-30" type="submit">Submit</button>
                                                    </div>
                                                </div>
                                            </form>
                                        </div> 
                                        <!-- End Add Review Form- -->
                                    </div>  
                                    <!-- Start Tab - Product Review -->
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>  
        <!-- End Product Details Tab -->

        <!-- ::::::  Start  Product Style - Default Section  ::::::  -->
        <div class="product m-t-100">
            <div class="container">
                <div class="row">
                    <div class="col-12">
                         <!-- Start Section Title -->
                        <div class="section-content section-content--border m-b-35">
                            <h5 class="section-content__title">Related Product
                            </h5>
                            <a href="{{url('products/'.str_replace(' ', '_',$product->CAT_PARENT_NAME).'/'.$product->CAT_PARENT_ID)}}" class="btn btn--icon-left btn--small btn--radius btn--transparent btn--border-green btn--border-green-hover-green font--regular text-capitalize">More Products<i class="fal fa-angle-right"></i></a>
                        </div>  <!-- End Section Title -->
                    </div>
                </div>
                <div class="row">
                    <div class="col-12">
                        <div class="default-slider default-slider--hover-bg-red product-default-slider">
                            <div class="product-default-slider-4grid-1rows gap__col--30 gap__row--40">
                            @foreach($products as $pro_val)
                            @if($product->CAT_PARENT_ID == $pro_val->CAT_PARENT_ID)
                            @php if($pro_val->PROD_IMAGE != ''){ $img = explode(",",$pro_val->PROD_IMAGE); $img = $img[0]; }
                                     else{ $img = '';} 
                                @endphp
                                <!-- Start Single Default Product -->
                                <div class="product__box product__default--single text-center">
                                    <!-- Start Product Image -->
                                    <div class="product__img-box  pos-relative">
                                        <a href="{{url('product/'.str_replace(' ', '_', $pro_val->PROD_NAME).'/'.$pro_val->PROD_ID)}}" class="product__img--link">
                                            <img class="product__img img-fluid" src="{{asset('images/prod_logo/'.$img)}}" alt="">
                                        </a>
                                        <!-- Start Procuct Label -->
                                        <!--  <span class="product__label product__label--sale-dis">-34%</span> -->
                                        <!-- End Procuct Label -->
                                        <!-- Start Product Action Link-->
                                        <ul class="product__action--link pos-absolute">
                                            <li><a href="#modalAddCart" data-toggle="modal"><i class="icon-shopping-cart"></i></a></li>
                                            <li><a href="{{url('product/'.str_replace(' ', '_', $pro_val->PROD_NAME).'/'.$pro_val->PROD_ID)}}"><i class="icon-eye"></i></a>
                                        </ul> 
                                        <!-- End Product Action Link -->
                                    </div> 
                                    <!-- End Product Image -->
                                    <!-- Start Product Content -->
                                    <div class="product__content m-t-20">
                                        <a href="product-single-default.html" class="product__link">{{$pro_val->PROD_NAME}}</a>
                                        <div class="product__price m-t-5">
                                            <span class="product__price">{{number_format($pro_val->PROD_DISCPRICE,2)}} <del>{{$pro_val->PROD_DISCPRICE == $pro_val->PROD_PRICE? '': number_format($pro_val->PROD_PRICE, 2) }}</del></span>
                                        </div>
                                    </div> 
                                    <!-- End Product Content -->
                                </div> 
                                <!-- End Single Default Product -->
                                @endif
                            @endforeach
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div> 
        <!-- ::::::  End  Product Style - Default Section  ::::::  -->  
        
        <!-- ::::::  Start  Company Logo Section  ::::::  -->
        <div class="company-logo m-t-100">
            <div class="container">
                <div class="row">
                    <div class="col-12">
                        <div class="company-logo__area default-slider">
                            <!-- Start Single Company Logo Item -->
                            @foreach($categories as $value)
                            <div class="company-logo__item">
                                <a href="{{url($value->CAT_NAME)}}" class="company-logo__link">
                                    <img src="{{asset('images/cat_logo/'.$value->CAT_IMAGE)}}" alt="{{$value->CAT_NAME}}" class="company-logo__img">
                                </a>
                            </div> 
                            @endforeach
                            <!-- End Single Company Logo Item -->
                        </div>
                    </div>
                </div>
            </div>
        </div> 
        <!-- ::::::  End  Company Logo Section  ::::::  -->

      
    </main>  
    <!-- :::::: End MainContainer Wrapper :::::: -->

    
@endsection
