@extends('Front.app')
@section('content')

    <!-- ::::::  Start  Breadcrumb Section  ::::::  -->
    <div class="page-breadcrumb">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <ul class="page-breadcrumb__menu">
                        <li class="page-breadcrumb__nav"><a href="{{url('/')}}">Home</a></li>
                        <li class="page-breadcrumb__nav active">{{ucfirst(strtolower(str_replace('_', ' ',$name)))}}</li>
                    </ul>
                </div>
            </div>
        </div>
    </div> <!-- ::::::  End  Breadcrumb Section  ::::::  -->

    <!-- :::::: Start Main Container Wrapper :::::: -->
    <main id="main-container" class="main-container">
        <div class="container">
            <div class="row">
                
                <!-- ::::::  Start  Product Style - Catagory Section  ::::::  -->
                <div class="col-12">
                    <div class="product__catagory">

                        <!-- Start Single catagory Product -->

                        @foreach($subcategories as $key => $value)
                        <div class="product__catagory--single">
                            <!-- Start Product Content -->
                            <div class="product__content product__content--catagory">
                                <a href="{{url('productlist/'.str_replace(' ', '_',$value->CAT_NAME).'/'.$value->CAT_ID)}}" class="product__link">{{$value->CAT_NAME}} </a>
                                <span class="product__items--text">Categories</span> {{--$value->PRODUCT_COUNT--}} 
                            </div> <!-- End Product Content -->
                            <!-- Start Product Image -->
                            <div class="product__img-box product__img-box--catagory">
                                <a href="" class="product__img--link">
                                    <img class="product__img img-fluid" src="{{asset('images/cat_logo/'.$value->CAT_IMAGE)}}" alt="">
                                </a>
                            </div> 
                            <!-- End Product Image -->
                        </div> 
                        @endforeach
                        <!-- End Single Default Product -->
                        
                    </div>
                </div>
                <!-- ::::::  End  Product Style - Catagory Section  ::::::  -->

                <!-- Start Rightside - Content -->
                <div class="row">
                       @foreach($catbanner as $keys => $value)
                    <div class="col-md-3 col-12">
                        <div class="banner__box">
                            <!-- Start Single Banner Item -->
                            <div class="banner__box--single banner__box--single-text-style-1 pos-relative">
                                <a href="" class="banner__link">
                                    <img src="{{asset('images/front/'.$value->BANNER_IMG)}}" alt="" class="banner__img">
                                </a>
                            </div> 
                            <!-- End Single Banner Item -->
                        </div>
                    </div>
                    @php if($keys == 3){  break;} @endphp
                    @endforeach
                    <!--div class="col-md-3">
                    <div class="img-responsive">
                        <img src="{{asset('assets/img/banner/size-wide/banner-shop-2-img-2-wide.jpg')}}" alt="">
                    </div>
                    </div>
                    <div class="col-md-3">
                    <div class="img-responsive">
                        <img src="{{asset('assets/img/banner/size-wide/banner-shop-2-img-2-wide.jpg')}}" alt="">
                    </div>
                    </div>
                    <div class="col-md-3">
                    <div class="img-responsive">
                        <img src="{{asset('assets/img/banner/size-wide/banner-shop-2-img-2-wide.jpg')}}" alt="">
                    </div>
                    </div>
                    <div class="col-md-3">
                    <div class="img-responsive">
                        <img src="{{asset('assets/img/banner/size-wide/banner-shop-2-img-2-wide.jpg')}}" alt="">
                    </div>
                    </div-->
                    <!-- ::::::  Start Sort Box Section  ::::::  -->
                    <div class="sort-box m-tb-40">
                        <!-- Start Sort Left Side -->
                        <div class="sort-box-item">
                            <div class="sort-box__tab">
                                <ul class="sort-box__tab-list nav">
                                    <li><a class="sort-nav-link active" data-toggle="tab" href="#sort-grid"><i class="fas fa-th"></i>  </a></li>
                                    <li><a class="sort-nav-link" data-toggle="tab" href="#sort-list"><i class="fas fa-list-ul"></i></a></li>
                                </ul>
                            </div>
                        </div> <!-- Start Sort Left Side -->

                        <div class="sort-box-item d-flex align-items-center flex-warp">
                            <span>Sort By:</span>
                            <div class="sort-box__option">
                                <label class="select-sort__arrow">
                                    <select name="select-sort" class="select-sort" onchange="this.options[this.selectedIndex].value && (window.location = this.options[this.selectedIndex].value);">
                                        <option value="?sort=relevance&page={{request()->page}}" {{request()->sort == 'relevance'? 'selected':''}}>Relevance</option>
                                        <option value="?sort=atoz&page={{request()->page}}" {{request()->sort == 'atoz'? 'selected':''}}>Name, A to Z</option>
                                        <option value="?sort=ztoa&page={{request()->page}}" {{request()->sort == 'ztoa'? 'selected':''}}> Name, Z to A </option>
                                        <option value="?sort=lowtohigh&page={{request()->page}}" {{request()->sort == 'lowtohigh'? 'selected':''}}> Price, low to high</option>
                                        <option value="?sort=hightolow&page={{request()->page}}" {{request()->sort == 'hightolow'? 'selected':''}}>Price, high to low</option>
                                    </select>
                                </label>
                            </div>
                        </div>

                        <div class="sort-box-item">
                            <span>Showing {{ $products->firstItem() }} - {{ $products->lastItem() }} of {{ $products->total() }} result</span>
                        </div>
                    </div> <!-- ::::::  Start Sort Box Section  ::::::  -->

                    <div class="product-tab-area">
                        <div class="tab-content tab-animate-zoom">
                            <div class="tab-pane show active shop-grid" id="sort-grid">
                                <div class="row">
                                @foreach($products as $value)

                                @php 
                                if($value->PROD_IMAGE != ''){ $img = explode(",",$value->PROD_IMAGE); $img = $img[0]; }else{ $img = '';} 
                                @endphp

                                    <div class="col-xl-3 col-lg-4 col-md-4 col-sm-6 col-12">
                                        <!-- Start Single Default Product -->
                                        <div class="product__box product__default--single text-center">
                                            <!-- Start Product Image -->
                                            <div class="product__img-box  pos-relative">
                                                <a href="{{url('product/'.str_replace(' ', '_', $value->PROD_NAME).'/'.$value->PROD_ID)}}" class="product__img--link">
                                                    <img class="product__img img-fluid" src="{{asset('images/prod_logo/'.$img)}}" alt="">
                                                </a>
                                                <!-- Start Procuct Label -->
                                            <!--     <span class="product__label product__label--sale-dis">-10%</span> -->
                                                <!-- End Procuct Label -->
                                                <!-- Start Product Countdown -->
                                                <!-- <div class="product__counter-box">
                                                    <div class="product__counter-item" data-countdown="2023/09/27"></div>
                                                </div>  -->
                                                <!-- End Product Countdown -->
                                                <!-- Start Product Action Link-->
                                                <ul class="product__action--link pos-absolute">
                                                    <li><a href="javascript:void(0)"  onclick="AddCart(this.id)" id="AddToCartProS{{$value->PROD_ID}}" data-proid="{{$value->PROD_ID}}" data-isvariant="NO" ><i class="icon-shopping-cart"></i></a></li>
                                                   <!--  <li><a href="#modalAddCart" data-toggle="modal"><i class="icon-shopping-cart"></i></a></li> -->
                                                    <li><a href="{{url('product/'.str_replace(' ', '_', $value->PROD_NAME).'/'.$value->PROD_ID)}}"><i class="icon-eye"></i></a></li>
                                                </ul> <!-- End Product Action Link -->
                                            </div> <!-- End Product Image -->
                                            <!-- Start Product Content -->
                                            <div class="product__content m-t-20">
                                                <a href="{{url('product/'.str_replace(' ', '_', $value->PROD_NAME).'/'.$value->PROD_ID)}}" class="product__link">{{$value->PROD_NAME}}</a>
                                                <div class="product__price m-t-5">
                                                    <span class="product__price">&#x20B9;{{number_format($value->PROD_DISCPRICE,2)}} <del>@if($value->PROD_DISCPRICE != $value->PROD_PRICE) &#x20B9;{{number_format($value->PROD_PRICE, 2) }} @endif</del></span>
                                                </div>
                                            </div> 
                                            <!-- End Product Content -->
                                        </div> <!-- End Single Default Product -->
                                    </div>
                            @endforeach
                                </div>
                            </div>
                            <div class="tab-pane shop-list" id="sort-list">
                                <div class="row">
                                    <!-- Start Single List Product -->
                                    @foreach($products as $value)

                                    @php 
                                    if($value->PROD_IMAGE != ''){ $img = explode(",",$value->PROD_IMAGE); $img = $img[0]; }else{ $img = '';} 
                                    @endphp
                                        <div class="col-12">
                                            <div class="product__box product__box--list">
                                                <!-- Start Product Image -->
                                                <div class="product__img-box  pos-relative text-center">
                                                    <a href="{{url('product/'.str_replace(' ', '_', $value->PROD_NAME).'/'.$value->PROD_ID)}}" class="product__img--link">
                                                        <img class="product__img img-fluid" src="{{asset('images/prod_logo/'.$img)}}" alt="">
                                                    </a>
                                                    <!-- Start Procuct Label -->
                                                     <!--    <span class="product__label product__label--sale-dis">-31%</span> -->
                                                    <!-- End Procuct Label -->
                                                </div> <!-- End Product Image -->
                                                <!-- Start Product Content -->
                                                <div class="product__content">
                                                    <a href="{{url('product/'.str_replace(' ', '_', $value->PROD_NAME).'/'.$value->PROD_ID)}}" class="product__link"><h5 class="font--regular">{{$value->PROD_NAME}}</h5></a>
                                                    <div class="product__price m-t-5">
                                                        <span class="product__price">&#x20B9;{{number_format($value->PROD_DISCPRICE,2)}} <del>@if($value->PROD_DISCPRICE != $value->PROD_PRICE) &#x20B9;{{number_format($value->PROD_PRICE, 2) }} @endif</del></span>
                                                    </div>
                                                    <div class="product__desc">
                                                        <p>
                                                            {!! $value->PROD_DESC !!}
                                                        </p>
                                                    </div>
                                                    <!-- Start Product Action Link-->
                                                    <ul class="product__action--link-list m-t-30">
                                                        <li><a  class="btn--black btn--black-hover-green">Add to cart</a></li>
                                                    </ul> <!-- End Product Action Link -->
                                                </div> <!-- End Product Content -->
                                            </div> 
                                        </div> 
                                    @endforeach
                                    <!-- End Single List Product -->
                                </div>
                            </div>
                        </div>
                    </div> 
                    <div class="page-pagination">
                            
                        {{ $products->appends(array('sort' => request()->sort))->links()}}
                        <!-- <ul class="page-pagination__list">
                            <li class="page-pagination__item"><a class="page-pagination__link"  href="{{$products->previousPageUrl()}}">Prev</a>
                            <li class="page-pagination__item"><a class="page-pagination__link active"  href="#">1</a></li>
                            <li class="page-pagination__item"><a class="page-pagination__link"  href="#">2</a></li>
                            <li class="page-pagination__item"><a class="page-pagination__link"  href="{{$products->nextPageUrl()}}">Next</a>
                            </li>
                          </ul> -->
                    </div>
                </div>  <!-- Start Rightside - Content -->
            </div>
            @foreach($catbanner_bottom as $keys => $value)
                    <div class="col-md-12 col-12">
                        <div class="banner__box">
                            <!-- Start Single Banner Item -->
                            <div class="banner__box--single banner__box--single-text-style-1 pos-relative">
                                <a href="" class="banner__link">
                                    <img src="{{asset('images/front/'.$value->BANNER_IMG)}}" alt="" class="banner__img">
                                </a>
                            </div> 
                            <!-- End Single Banner Item -->
                        </div>
                    </div>
                    @php if($keys == 1){  break;} @endphp
                    @endforeach
        </div>

        <!-- ::::::  Start  Company Logo Section  ::::::  -->
        <div class="company-logo m-t-100">
            <div class="container">
                <div class="row">
                    <div class="col-12">
                        <div class="company-logo__area default-slider">
                            <!-- Start Single Company Logo Item -->
                            @foreach($categories as $value)
                            <div class="company-logo__item">
                                <a href="{{url($value->CAT_NAME)}}" class="company-logo__link">
                                    <img src="{{asset('images/cat_logo/'.$value->CAT_IMAGE)}}" alt="{{$value->CAT_NAME}}" class="company-logo__img">
                                </a>
                            </div> 
                            @endforeach
                            <!-- End Single Company Logo Item -->
                        </div>
                    </div>
                </div>
            </div>
        </div> 
        <!-- ::::::  End  Company Logo Section  ::::::  -->

    </main> 
    <!-- :::::: End MainContainer Wrapper :::::: -->

@endsection
