@extends('Front.app')
@section('content')
    <!-- ::::::  Start  Breadcrumb Section  ::::::  -->
    <div class="page-breadcrumb">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <ul class="page-breadcrumb__menu">
                        <li class="page-breadcrumb__nav"><a href="{{url('/')}}">Home</a></li>
                        <li class="page-breadcrumb__nav active">My Account</li>
                    </ul>
                </div>
            </div>
        </div>
    </div> 
    <!-- ::::::  End  Breadcrumb Section  ::::::  -->
   <!-- ::::::  Start  Main Container Section  ::::::  -->
    <main id="main-container" class="main-container">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <!-- :::::::::: Start My Account Section :::::::::: -->
                    <div class="my-account-area">
                        <div class="row">
                            <div class="col-xl-3 col-md-4">
                                <div class="my-account-menu">
                                    <ul class="nav account-menu-list flex-column nav-pills" id="pills-tab" role="tablist">
                                        <li>
                                            <a class="link--icon-left" id="pills-dashboard-tab" data-toggle="pill" href="#pills-dashboard"
                                                role="tab" aria-controls="pills-dashboard" aria-selected="true"><i
                                                    class="fas fa-tachometer-alt"></i> Dashboard</a>
                                        </li>
                                        <li>
                                            <a id="pills-order-tab" class="active link--icon-left" data-toggle="pill" href="#pills-order" role="tab"
                                                aria-controls="pills-order" aria-selected="false"><i
                                                    class="fas fa-shopping-cart"></i> Order</a>
                                        </li>
                                        <li>
                                            <a id="pills-address-tab" class="link--icon-left" data-toggle="pill" href="#pills-address" role="tab"
                                                aria-controls="pills-address" aria-selected="false"><i
                                                    class="fas fa-map-marker-alt"></i> Address</a>
                                        </li>
                                      <!--   <li>
                                            <a id="pills-account-tab" class="link--icon-left" data-toggle="pill" href="#pills-account" role="tab"
                                                aria-controls="pills-account" aria-selected="false"><i class="fas fa-user"></i>
                                                Account Details</a>
                                        </li> -->
                                        <li>
                                            <a class="link--icon-left" href="{{url('logout')}}"><i class="fas fa-sign-out-alt"></i> Logout</a>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                            <div class="col-xl-8 col-md-8">
                                <div class="tab-content my-account-tab" id="pills-tabContent">
                                    <div class="tab-pane fade" id="pills-dashboard" role="tabpanel"
                                        aria-labelledby="pills-dashboard-tab">
                                        <div class="my-account-dashboard account-wrapper">
                                            <h4 class="account-title">Dashboard</h4>
                                            <div class="welcome-dashboard m-t-30">
                                                <p>Hello, <strong>{{$user[0]->MemberName}}</strong> </p>
                                            </div>
                                            <p class="m-t-25">From your account dashboard. you can easily check &amp; view your
                                                recent orders, manage your shipping and billing addresses <!-- and edit your password and
                                                account --> details.</p>
                                        </div>
                                    </div>
                                    <div class="tab-pane fade show active" id="pills-order" role="tabpanel" aria-labelledby="pills-order-tab">
                                        <div class="my-account-order account-wrapper">
                                            <h4 class="account-title">Orders</h4>
                                            <div class="account-table text-center m-t-30 table-responsive">
                                                <table class="table">
                                                    <thead>
                                                        <tr>
                                                            <th class="no">No</th>
                                                            <th class="name">Order Id</th>
                                                            <th class="status">Status</th>
                                                            <th class="status">Payment Mode</th>
                                                            <th class="total">Total</th>
                                                            <th class="date">Date</th>
                                                            <th class="action">Action</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                    @foreach($user_cart as $key => $value)
                                                    @php 
                                                        $add = json_decode($value->ADDRESS_DETAILS);
                                                    @endphp
                                                        <tr>
                                                            <td>{{$key+1}}</td>
                                                            <td>{{$value->ORDER_CODE}}</td>
                                                            <td>{{$value->ORDER_STATUS}}</td>
                                                            <td>{{$value->PAYMENT_METHOD}}</td>
                                                            <td>{{number_format($value->FINAL_AMOUNT+$value->DELIVERY_FEE,2)}}</td>
                                                            <td>{{date('d-m-Y', strtotime($value->CREATED_AT))}}</td>
                                                            <td><a href="{{url('view_invoice/'.$value->ORDER_CODE)}}">View</a></td>
                                                        </tr>
                                                    @endforeach
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="tab-pane fade" id="pills-address" role="tabpanel"
                                        aria-labelledby="pills-address-tab">
                                        <div class="my-account-address account-wrapper">
                                            <h4 class="account-title">Address</h4>
                                            @foreach($address as $addvalue)
                                            <div class="account-address m-t-30">
                                                <h6 class="name">{{$addvalue->ADDRESS_TYPE}}</h6>
                                                <p>{{$addvalue->FLAT}} <br> {{$addvalue->LANDMARK}}</p>
                                                <p>City: {{$addvalue->AREA}}, Pincode: {{$addvalue->PINCODE}}</p>
                                                <a class="box-btn m-t-25 " href="#" onclick="update_add(this.id)" id="add{{$addvalue->ADD_ID}}" data-id="{{$addvalue->ADD_ID}}" data-typ="{{$addvalue->ADDRESS_TYPE}}" data-full="{{$addvalue->FLAT}}" data-lan="{{$addvalue->LANDMARK}}" data-area="{{$addvalue->AREA}}" data-pin="{{$addvalue->PINCODE}}"><i class="far fa-edit"></i> Edit Address</a><span style="float: right;"><a href="#AddressmodalQuickView" data-toggle="modal"><i class="fa fa-address-card" aria-hidden="true"></i> Add Address</a></span>
                                            </div>
                                            @endforeach
                                        </div>
                                    </div>
                                   <!--  <div class="tab-pane fade" id="pills-account" role="tabpanel"
                                        aria-labelledby="pills-account-tab">
                                        <div class="my-account-details account-wrapper">
                                            <h4 class="account-title">Account Details</h4>

                                            <div class="account-details">
                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <div class="form-box__single-group">
                                                            <input type="text" placeholder="First Name">
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="form-box__single-group">
                                                            <input type="text" placeholder="Last Name">
                                                        </div>
                                                    </div>
                                                    <div class="col-md-12">
                                                        <div class="form-box__single-group">
                                                            <input type="text" placeholder="Display Name">
                                                        </div>
                                                    </div>
                                                    <div class="col-md-12">
                                                        <div class="form-box__single-group">
                                                            <input type="text" placeholder="Email address">
                                                        </div>
                                                    </div>
                                                    <div class="col-md-12">
                                                        <div class="form-box__single-group">
                                                            <h5 class="title">Password change</h5>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-12">
                                                        <div class="form-box__single-group">
                                                            <input type="password" placeholder="Current Password">
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="form-box__single-group">
                                                            <input type="password" placeholder="New Password">
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="form-box__single-group">
                                                            <input type="password" placeholder="Confirm Password">
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="form-box__single-group">
                                                            <button class="btn btn--box btn--radius btn--small btn--black btn--black-hover-green btn--uppercase font--bold">Save Change</button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div> -->
                                </div>
                            </div>
                        </div>
                    </div><!-- :::::::::: End My Account Section :::::::::: -->
                </div>
            </div>
        </div>
    </main> 
    <!-- ::::::  End  Main Container Section  ::::::  -->

    <!-- Start Modal Quickview cart -->
    <div class="modal fade" id="AddressmodalQuickView" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-body">
                <h4 class="chk-delivery">Delivery Address </h4>
                    <div class="container-fluid">
                        <div class="row">
                            <div class="col text-right">
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true"> <i class="fal fa-times"></i></span>
                                </button>
                            </div>
                            
                            <div class="col-lg-12">                                             
                                    <form id="address" class="" action="{{url('add_user_address')}}" method="POST">
                                    @csrf
                                        <!-- Multiple Radios (inline) -->
                                        
                            <div class="form-group">
                                <div class="add_address_popup">
                                <input  class="radio-none" type="radio" name="txt_address" id="option-1" value="1" checked>
                                <input  class="radio-none" type="radio" name="txt_address" id="option-2" value="2">
                                <input  class="radio-none" type="radio" name="txt_address" id="option-3" value="3">
                                <label for="option-1" class="option option-1">
                                    <div class="dot"></div>
                                    <span>Home</span>
                                    </label>
                                <label for="option-2" class="option option-2">
                                    <div class="dot"></div>
                                     <span>Office</span>
                                </label>
                                <label for="option-3" class="option option-3">
                                    <div class="dot"></div>
                                     <span>Other</span>
                                </label>
                                </div>
                            </div>
                                    <div class="address-fieldset">
                                        <div class="row">
                                            <div class="col-lg-12 col-md-12">
                                                <div class="form-group">
                                                    <label class="control-label">Complete Address *</label>
                                                    <input id="txt_full_address" name="txt_full_address" type="text" placeholder="Complete Address" class="form-control input-md" required="">
                                                </div>
                                            </div>
                                            <div class="col-lg-12 col-md-12">
                                                <div class="form-group">
                                                    <label class="control-label">How to reach *</label>
                                                    <input id="txt_street" name="txt_street" type="text" placeholder="How to reach" class="form-control input-md">
                                                </div>
                                            </div>
                                            <div class="col-lg-6 col-md-12">
                                                <div class="form-group">
                                                    <label class="control-label">Pincode *</label>
                                                    <input id="txt_pincode" name="txt_pincode" type="text" placeholder="Pincode" class="form-control input-md" pattern="^(\d{4}|\d{6})$" title="Please enter valid pincode!" required="">
                                                </div>
                                            </div>
                                            <div class="col-lg-6 col-md-12">
                                                <div class="form-group">
                                                    <label class="control-label">Locality *</label>
                                                    <input id="txt_locality" name="txt_locality" type="text" placeholder="Enter City" class="form-control input-md" pattern="^[a-zA-Z]+(?:[\s-][a-zA-Z]+)*$" title="Please enter valid city name!" required="">
                                                </div>
                                            </div>
                                            <div class="col-lg-12 col-md-12">
                                                <div class="form-group mb-0">
                                                    <div class="address-btns">
                                                       <br> <button type="submit" class="save-btn14 hover-btn btn--small btn--green btn--green-hover-black">Save</button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div> 
    <!-- End Modal Quickview cart -->

        <!-- Start Modal Quickview cart -->
    <div class="modal fade" id="AddressmodalQuickView_1" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-body">
                <h4 class="chk-delivery">Delivery Address </h4>
                    <div class="container-fluid">
                        <div class="row">
                            <div class="col text-right">
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true"> <i class="fal fa-times"></i></span>
                                </button>
                            </div>
                            
                            <div class="col-lg-12">                                             
                                    <form id="update-address" class="" action="{{url('update_user_address')}}" method="POST">
                                    @csrf
                                    <input type="hidden" name="id" id="address_user_id">
                                        <!-- Multiple Radios (inline) -->  
                            <div class="form-group">
                                <div class="add_address_popup">
                                <input  class="radio-none" type="radio" name="txt_address" id="option-4" value="1">
                                <input  class="radio-none" type="radio" name="txt_address" id="option-5" value="2">
                                <input  class="radio-none" type="radio" name="txt_address" id="option-6" value="3">
                                <label for="option-4" class="option option-4">
                                    <div class="dot"></div>
                                    <span>Home</span>
                                    </label>
                                <label for="option-5" class="option option-5">
                                    <div class="dot"></div>
                                     <span>Office</span>
                                </label>
                                <label for="option-6" class="option option-6">
                                    <div class="dot"></div>
                                     <span>Other</span>
                                </label>
                                </div>
                            </div>
                                    <div class="address-fieldset">
                                        <div class="row">
                                            <div class="col-lg-12 col-md-12">
                                                <div class="form-group">
                                                    <label class="control-label">Complete Address *</label>
                                                    <input id="txt_full_address_u" name="txt_full_address" type="text" placeholder="Complete Address" class="form-control input-md" value="" required="">
                                                </div>
                                            </div>
                                            <div class="col-lg-12 col-md-12">
                                                <div class="form-group">
                                                    <label class="control-label">How to reach *</label>
                                                    <input id="txt_street_u" name="txt_street" type="text" value="" placeholder="How to reach" class="form-control input-md">
                                                </div>
                                            </div>
                                            <div class="col-lg-6 col-md-12">
                                                <div class="form-group">
                                                    <label class="control-label">Pincode *</label>
                                                    <input id="txt_pincode_u" name="txt_pincode" type="text" placeholder="Pincode" class="form-control input-md" pattern="^(\d{4}|\d{6})$" value="" title="Please enter valid pincode!" required="">
                                                </div>
                                            </div>
                                            <div class="col-lg-6 col-md-12">
                                                <div class="form-group">
                                                    <label class="control-label">Locality *</label>
                                                    <input id="txt_locality_u" name="txt_locality" type="text" placeholder="Enter City" class="form-control input-md" pattern="^[a-zA-Z]+(?:[\s-][a-zA-Z]+)*$" value="" title="Please enter valid city name!" required="">
                                                </div>
                                            </div>
                                            <div class="col-lg-12 col-md-12">
                                                <div class="form-group mb-0">
                                                    <div class="address-btns">
                                                       <br> <button type="submit" class="save-btn14 hover-btn btn--small btn--green btn--green-hover-black">Update</button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div> 
    <!-- End Modal Quickview cart -->

    <script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
    @if (Session::has('add_success'))
        <script type="text/javascript">
            swal({
              title: "{{ Session::get('add_success') }}",
              icon: "success",
            });
        </script>
    @endif
    @if (Session::has('add_warning'))
        <script type="text/javascript">
            swal({
              title: "{{ Session::get('add_warning') }}",
              icon: "warning",
            });
        </script>
    @endif
    <script type="text/javascript">
        function update_add(id) {
            if($('#'+id).data('typ') == 'HOME')
            { 
                $("#option-4").prop('checked', true);  
                $("#option-5").prop('checked', false);  
                $("#option-6").prop('checked', false);  
               
            }
            if($('#'+id).data('typ') == 'OFFICE')
            { 
                $("#option-4").prop('checked', false);  
                $("#option-5").prop('checked', true);  
                $("#option-6").prop('checked', false); 
             }
            if($('#'+id).data('typ') == 'OTHER')
            { 
                $("#option-4").prop('checked', false);  
                $("#option-5").prop('checked', false);  
                $("#option-6").prop('checked', true); 
            }

            $('#txt_full_address_u').val($('#'+id).data('full'));
            $('#txt_street_u').val($('#'+id).data('lan'));
            $('#txt_locality_u').val($('#'+id).data('area'));
            $('#txt_pincode_u').val($('#'+id).data('pin'));
            $('#address_user_id').val($('#'+id).data('id'));

            $('#AddressmodalQuickView_1').modal('show');
        }
    </script>
    @endsection