@extends('Front.app')
@section('content')

        <!-- ::::::  Start Hero Section  ::::::  -->
        <div class="hero slider-dot-fix slider-dot slider-dot-fix slider-dot--center slider-dot-size--medium slider-dot-circle  slider-dot-style--fill slider-dot-style--fill-white-active-green dot-gap__X--10">
            <!-- Start Single Hero Slide -->
            @foreach($banners as $value)
            <div class="hero-slider">
                <img src="{{asset('/images/front/'.$value->BANNER_IMG)}}" alt="{{$value->BANNER_NAME}}">
            </div> 
            @endforeach
            <!-- End Single Hero Slide -->
        </div>
        <!-- ::::::  End Hero Section  ::::::  -->
          
          <!-- Mobile Recharge
          ============================================= -->
        <div class="pt-4 pb-5 m-t-50">
          <div class="container">
          
          <div class="bg-white  br-11  d-flex">
                <div class="section_title horizontal_title">
			    <div class="h-100">
                    <div class="d-flex align-items-center h-100">
                        <h6>Recharge &amp; Bill Payment</h6>
                    </div>
                </div>
                </div>
                <div class="mr-auto ml-auto">
                <ul class="nav secondary-nav alternate">
              <li class="nav-item"> <a class="nav-link active" href="#"><span><i class="fas fa-mobile-alt"></i></span> Mobile</a> </li>
              <li class="nav-item"> <a class="nav-link" href="#"><span><i class="fas fa-tv"></i></span> DTH</a> </li>
              <li class="nav-item"> <a class="nav-link" href="#"><span><i class="fas fa-credit-card"></i></span> DataCard</a> </li>
              <li class="nav-item"> <a class="nav-link" href="#"><span><i class="fas fa-wifi"></i></span> Broadband</a> </li>
              <li class="nav-item"> <a class="nav-link" href="#"><span><i class="fas fa-phone"></i></span> Landline</a> </li>
              <li class="nav-item"> <a class="nav-link" href="#"><span><i class="fas fa-plug"></i></span> CableTv</a> </li>
              <li class="nav-item"> <a class="nav-link" href="#"><span><i class="fas fa-lightbulb"></i></span> Electricity</a> </li>
              <li class="nav-item"> <a class="nav-link" href="#"><span><i class="fas fa-subway"></i></span> Metro</a> </li>
              <li class="nav-item"> <a class="nav-link" href="#"><span><i class="fas fa-flask"></i></span> Gas</a> </li>
              <li class="nav-item"> <a class="nav-link" href="#"><span><i class="fas fa-tint"></i></span> Water</a> </li>
            </ul>
                <form id="recharge-bill" method="post" class="recharge-form-section">
                  <div class="mb-3 d-flex">
                    <div class="custom-control custom-radio custom-control-inline">
                      <input id="prepaid" name="rechargeBillpayment" class="custom-control-input" checked="" required="" type="radio">
                      <label class="custom-control-label" for="prepaid">Prepaid</label>
                    </div>
                    <div class="custom-control custom-radio custom-control-inline p-l-30" >
                      <input id="postpaid" name="rechargeBillpayment" class="custom-control-input" required="" type="radio">
                      <label class="custom-control-label" for="postpaid">Postpaid</label>
                    </div>
                  </div>
                  <div class="row">
                  <div class="col-md-6 col-lg-3 form-group">
                    <input type="text" class="form-control" data-bv-field="number" id="mobileNumber" required="" placeholder="Enter Mobile Number">
                  </div>
                  <div class="col-md-6 col-lg-3 form-group">
                    <select class="form-control custom-select" id="operator" required="">
                      <option value="">Select Your Operator</option>
                      @foreach($operator as $value)
                      <option value="{{$value->TelecomBrandId}}">{{$value->BrandName}}</option>
                      @endforeach
                    </select>
                  </div>
                  <div class="col-md-6 col-lg-3 form-group">
                    <input class="form-control" id="amount" placeholder="Enter Amount" required="" type="text">
                    <a href="#" data-target="#view-plans" data-toggle="modal" class="view-plans-link">View Plans</a>
                  </div>
                  <div class="col-md-6 col-lg-3 form-group">
                  <a class="btn btn-primary btn-theme btn-block p-tb-10 btn--radius-tiny " href="#">Continue</a>
                  </div>
                  </div>
                </form>
               </div> 
          </div>
        </div>
        </div>
        <!-- Mobile Recharge end -->
        <!-- ::::::  Start  Product Style - Catagory Section  ::::::  -->
        <div class="product m-t-50">
            <div class="container">
                <div class="row">
                    <div class="col-12">
                         <!-- Start Section Title -->
                        <div class="section-content section-content--border m-b-10">
                            <h5 class="section-content__title">Top categories</h5>
                            <a href="{{url('/')}}" class="btn btn--icon-left btn--small btn--radius btn--transparent btn--border-green btn--border-green-hover-green font--regular text-capitalize">More categories <i class="fal fa-angle-right"></i></a>
                        </div>  <!-- End Section Title -->
                    </div>
                </div>
                <div class="row">
                    <div class="col-12">
                        <div class="product__catagory">

                            <!-- Start Single catagory Product -->

                            @foreach($subcategories as $key => $value)
                            <div class="product__catagory--single">
                                <!-- Start Product Content -->
                                <div class="product__content product__content--catagory">
                                    <a href="" class="product__link">{{$value->CAT_NAME}} </a>
                                    <span class="product__items--text">{{$value->PRODUCT_COUNT}} Products</span>
                                </div> <!-- End Product Content -->
                                <!-- Start Product Image -->
                                <div class="product__img-box product__img-box--catagory">
                                    <a href="" class="product__img--link">
                                        <img class="product__img img-fluid" src="{{asset('images/cat_logo/'.$value->CAT_IMAGE)}}" alt="">
                                    </a>
                                </div> 
                                <!-- End Product Image -->
                            </div> 
                            @php if($key == 14){  break;} @endphp
                            @endforeach
                            <!-- End Single Default Product -->
                            
                        </div>
                    </div>
                </div>
            </div>
        </div> <!-- ::::::  End  Product Style - Catagory Section  ::::::  -->
        
        <!-- ::::::  Start banner Section  ::::::  -->
        <div class="banner m-t-30">
            <div class="container-fluid">
                <div class="row">
                    @foreach($catbanner as $keys => $value)
                    <div class="col-md-6 col-12">
                        <div class="banner__box">
                            <!-- Start Single Banner Item -->
                            <div class="banner__box--single banner__box--single-text-style-1 pos-relative">
                                <a href="" class="banner__link">
                                    <img src="{{asset('images/front/'.$value->BANNER_IMG)}}" alt="" class="banner__img">
                                </a>
                            </div> 
                            <!-- End Single Banner Item -->
                        </div>
                    </div>
                    @php if($keys == 1){  break;} @endphp
                    @endforeach
                </div>
            </div>
        </div> <!-- ::::::  End banner Section  ::::::  -->
        <!-- ::::::  Start  Product Style - Default Section  ::::::  -->
        <div class="product m-t-100">
            <div class="container">
                <div class="row">
                    <div class="col-12">
                         <!-- Start Section Title -->
                        <div class="section-content section-content--border m-b-35">
                            <h5 class="section-content__title">Top categories</h5>
                            <ul class="tablist tablist--style-blue tablist--style-gap-20 nav">
                               <!--  <li><a class="nav-link active" data-toggle="tab" href="#fruits">Fruites</a></li> -->
                                @foreach($randcat as $key => $value)
                                <li><a class="nav-link {{$key == 0? 'active':'' }}" data-toggle="tab" href="#CAT_{{$value->CAT_ID}}">{{$value->CAT_NAME}}</a></li>
                                @endforeach
                               <!--  <li><a class="nav-link" data-toggle="tab" href="#fish">Fish</a></li> -->
                            </ul>
                        </div>  <!-- End Section Title -->
                    </div>
                </div>
                <div class="row">
                    <div class="col-12">
                        <div class="tab-content tab-animate-zoom">
                            <!-- Start Single Tab Item -->

                            @foreach($randcat as $key => $value)

                            <div class="tab-pane show {{$key == 0? 'active':'' }}" id="CAT_{{$value->CAT_ID}}">
                                <div class="default-slider default-slider--hover-bg-red product-default-slider">
                                    <div class="product-default-slider-4grid-2rows gap__col--30 gap__row--40">

                                    @foreach($product[$key] as $pvalue)
                                        @php if($pvalue->PROD_IMAGE != ''){ $img = explode(",",$pvalue->PROD_IMAGE); $img = $img[0]; }
                                             else{ $img = '';} 
                                        @endphp
                                        <!-- Start Single Default Product -->
                                        <div class="product__box product__default--single text-center">
                                            <!-- Start Product Image -->
                                            <div class="product__img-box  pos-relative">
                                                <a href="" class="product__img--link">
                                                    <img class="product__img img-fluid" src="{{asset('images/prod_logo/'.$img)}}" alt="{{$pvalue->PROD_NAME}}">
                                                </a>
                                                <!-- Start Procuct Label -->
                                                <!-- <span class="product__label product__label--sale-dis">-34%</span> -->
                                                <!-- End Procuct Label -->
                                                <!-- Start Product Action Link-->
                                                <ul class="product__action--link pos-absolute">
                                                    <li><a href="#modalAddCart" data-toggle="modal"><i class="icon-shopping-cart"></i></a></li>
                                                    <li><a href="wishlist.html"><i class="icon-heart"></i></a></li>
                                                    <li><a href="javascript:void(0)"  data-toggle="modal" data-target="#modalQuickView" data-name="{{$pvalue->PROD_NAME}}" id="QuickView" ><i class="icon-eye"></i></a></li>
                                                    <!-- <li><a href="#modalQuickView" data-toggle="modal"><i class="icon-eye"></i></a></li> -->
                                                </ul> <!-- End Product Action Link -->
                                            </div> <!-- End Product Image -->
                                            <!-- Start Product Content -->
                                            <div class="product__content m-t-20">
                                                
                                                <a href="" class="product__link">{{$pvalue->PROD_NAME}}</a>
                                                <div class="product__price m-t-5">
                                                    <span class="product__price">&#x20B9;{{number_format($pvalue->PROD_DISCPRICE, 2)}} <del>&#x20B9; {{$pvalue->PROD_DISCPRICE == $pvalue->PROD_PRICE? '': number_format($pvalue->PROD_PRICE, 2) }}</del></span>
                                                </div>
                                            </div> <!-- End Product Content -->
                                        </div> 
                                        <!-- End Single Default Product -->
                                        @endforeach
                                              
                                    </div>
                                </div>
                            </div>  
                            @endforeach
                            <!-- End Single Tab Item -->

                        </div>
                    </div>
                </div>
            </div>
        </div> <!-- ::::::  End  Product Style - Default Section  ::::::  -->

         <!-- ::::::  Start banner Section  ::::::  -->
         @foreach($popup as $key => $value)
         <div class="banner m-t-100 pos-relative">
            <div class="banner__bg">
                <img src="{{asset('images/front/'.$value->BANNER_IMG)}}" alt="">
            </div>
            <div class="banner__box banner__box--single-text-style-2">
                <div class="container">
                    <div class="row">
                        <div class="col-12">
                            <div class="banner__content banner__content--center pos-absolute">
                                <h6 class="banner__title  font--medium m-b-10">SPECIAL DISCOUNT</h6>
                                <h1 class="banner__title banner__title--large font--regular text-capitalize">For all Grocery <br>
                                    products</h1>
                                <h6 class="banner__title font--medium m-b-40">Take now 20% off for all grocer product.</h6>
                            </div> 
                        </div>
                    </div>
                </div>
            </div>    
        </div> 
        @php if($keys == 0){  break;} @endphp
        @endforeach
        <!-- ::::::  End banner Section  ::::::  -->

        <!-- ::::::  Start  Product Style - Default Section  ::::::  -->
        <div class="product m-t-100">
            <div class="container">
                <div class="row">
                    <div class="col-12">
                         <!-- Start Section Title -->
                        <div class="section-content section-content--border m-b-35">
                            <h5 class="section-content__title">New Products</h5>
                            <a href="shop-sidebar-grid-left.html" class="btn btn--icon-left btn--small btn--radius btn--transparent btn--border-green btn--border-green-hover-green font--regular text-capitalize">More Products<i class="fal fa-angle-right"></i></a>
                        </div>  <!-- End Section Title -->
                    </div>
                </div>
                <div class="row">
                    <div class="col-12">
                        <div class="default-slider default-slider--hover-bg-red product-default-slider">
                            <div class="product-default-slider-4grid-1rows gap__col--30 gap__row--40">

                                <!-- Start Single Default Product -->
                                @foreach($products as $pro_val)
                                @php if($pro_val->PROD_IMAGE != ''){ $img = explode(",",$pro_val->PROD_IMAGE); $img = $img[0]; }
                                     else{ $img = '';} 
                                @endphp
                                <div class="product__box product__default--single text-center">
                                    <!-- Start Product Image -->
                                    <div class="product__img-box  pos-relative">
                                        <a href="" class="product__img--link">
                                            <img class="product__img img-fluid" src="{{asset('images/prod_logo/'.$img)}}" alt="">
                                        </a>
                                        <!-- Start Procuct Label -->
                                      <!--   <span class="product__label product__label--sale-dis">-34%</span> -->
                                        <!-- End Procuct Label -->
                                        <!-- Start Product Action Link-->
                                        <ul class="product__action--link pos-absolute">
                                            <li><a href="#modalAddCart" data-toggle="modal"><i class="icon-shopping-cart"></i></a></li>
                                            <li><a href="wishlist.html"><i class="icon-heart"></i></a></li>
                                            <li><a href="#modalQuickView" data-toggle="modal"><i class="icon-eye"></i></a></li>
                                        </ul> <!-- End Product Action Link -->
                                    </div> <!-- End Product Image -->
                                    <!-- Start Product Content -->
                                    <div class="product__content m-t-20">
                                        <a href="" class="product__link" style=" overflow: hidden; white-space: nowrap; text-overflow: ellipsis; padding: 0px 24px;">{{$pro_val->PROD_NAME}}</a>
                                        <div class="product__price m-t-5">
                                            <span class="product__price">&#x20B9;{{$pro_val->PROD_DISCPRICE}} <del>&#x20B9;{{$pro_val->PROD_DISCPRICE == $pro_val->PROD_PRICE? '': number_format($pro_val->PROD_PRICE, 2) }}</del></span>
                                        </div>
                                    </div> <!-- End Product Content -->
                                </div> 
                                @endforeach
                                <!-- End Single Default Product -->
                          
                                
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div> <!-- ::::::  End  Product Style - Default Section  ::::::  -->

@endsection