@extends('Front.app')
@section('content')    

    <!-- ::::::  Start  Breadcrumb Section  ::::::  -->
    <div class="page-breadcrumb">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <ul class="page-breadcrumb__menu">
                        <li class="page-breadcrumb__nav"><a href="#">Home</a></li>
                        <li class="page-breadcrumb__nav active">Checkout</li>
                    </ul>
                </div>
            </div>
        </div>
    </div> <!-- ::::::  End  Breadcrumb Section  ::::::  -->

    <!-- ::::::  Start  Main Container Section  ::::::  -->
    <main id="main-container" class="main-container">
        <div class="container">
            @if(count($getdbcart) > 0)
            
		<form method="POST" action="{{url('change_cart_type')}}" id="checkoutesave">
		<div class="row">
			
                
                    @csrf
                <!-- Start Client Shipping Address -->
                <div class="col-lg-5">
                    <div class="section-content">
                        <h5 class="section-content__title">Checkout</h5>
                    </div>
                    <div class="row m-t-40" >
                        <div class="col-12">
                            <div class="">
                                <div >
                                    <h4 class="chk-delivery">Delivery Address <span class="add_address"><a href="#AddressmodalQuickView" data-toggle="modal">Add New Address</a></span></h4>
                                </div>
                                <div class="wrapper1">
                                @foreach($address as $key => $addvalue)
                                <input class="radio-none" value="{{$addvalue->ADD_ID}}" type="radio" name="select" id="option-{{$key+1}}" {{$addvalue->IS_DEFAULT == 'YES'?  'checked':''}} >
                                <label for="option-{{$key+1}}" class="option option-{{$key+1}}">
                                    <div class="row">
										<div class="col-md-2 dot"></div>
										<div class="col-md-10">
                                    <span><b> Full Address </b>: {{$addvalue->FLAT}}<br>
                                        <b> City </b>: {{$addvalue->AREA}}
                                        <b>Pincode </b>: {{$addvalue->PINCODE}}</span>
										</div>
									</div>	
                                </label>
                                @endforeach
                                </div>
                            </div>
                        </div>
                    </div>
                </div> <!-- End Client Shipping Address -->
                    
                <!-- Start Order Wrapper -->
                <div class="col-lg-7">
                    <div class="your-order-section">
                        <div class="section-content">
                            <h5 class="section-content__title">Your order</h5>
                        </div>
                        <div class="your-order-box gray-bg m-t-40 m-b-30">
                            <div class="your-order-product-info">
                                <div class="your-order-top d-flex justify-content-between">
                                    <h6 class="your-order-top-left font--bold">Product</h6>
                                    <h6 class="your-order-top-right font--bold">Total</h6>
                                </div>
                                @php  
                                    $usercart = json_decode($getdbcart[0]->PRODUCT_DETAILS);
                                    $del = (int)($getdbcart[0]->DELIVERY_FEE);
                                @endphp
                                <ul class="your-order-middle">
                                @foreach($usercart as $value)
                                    <li class="d-flex justify-content-between">
                                        <span class="your-order-middle-left font--semi-bold">{{$value->name}} X {{$value->quantity}}</span>
                                        <span class="your-order-middle-right font--semi-bold">&#x20B9;{{number_format($value->disc_price*$value->quantity,2)}}</span>
                                    </li>
                                @endforeach
                                
                                </ul>
                                <div class="your-order-bottom d-flex justify-content-between">
                                    <h6 class="your-order-bottom-left font--bold">Shipping</h6>
                                    <span class="your-order-bottom-right font--semi-bold">@if($del > 0) &#x20B9;{{number_format($getdbcart[0]->DELIVERY_FEE,2)}} @else Free shipping @endif</span>
                                </div>
                                <div class="your-order-total justify-content-between">
                                    @php
                                        if($coupan >= $del+$getdbcart[0]->FINAL_AMOUNT)
                                        {
                                            $coupans = $del+$getdbcart[0]->FINAL_AMOUNT;
                                            $toamt = 0.00;
                                        }
                                        else
                                        {
                                          $coupans = $coupan;
                                          $toamt = ($del+$getdbcart[0]->FINAL_AMOUNT)-$coupan;  
                                        }
                                    @endphp
                                    <div class="d-flex justify-content-between">
                                        <h5 class="your-order-total-left font--bold">Total</h5>
                                        <h5 class="your-order-total-right font--bold">&#x20B9;{{number_format($del+$getdbcart[0]->FINAL_AMOUNT,2)}}</h5>
                                    </div>
                                    <div class="d-flex justify-content-between">
                                        <h5 class="your-order-total-left font--bold">Coupon</h5>
                                        <h5 class="your-order-total-right font--bold">&#x20B9; {{number_format($coupans,2)}}</h5>
                                    </div>
                                    <input type="hidden" name="txt_coupan_amt" value="{{number_format($coupans,2)}}">
                                    <input type="hidden" name="txt_tobepay_amt" value="{{number_format($toamt,2)}}">
                                    <div class="d-flex justify-content-between">
                                        <h5 class="your-order-total-left font--bold">Amount To Be Paid</h5>
                                        <h5 class="your-order-total-right font--bold">&#x20B9;{{number_format($toamt,2)}}</h5>
                                    </div>
                                </div>
                                <input type="hidden" name="text_cart_id" id="text_cart_id" value="{{$getdbcart[0]->ORDER_ID}}">
                                <div class="payment-method">
                                    <h5 class="your-order-total-left font--bold">Payment Mode</h5>
                                   <!--  <input type="radio" name="payment_type" id="payment_type" value="1"> Cash on delivery
                                    &emsp; -->
                                    <input type="radio" name="payment_type" id="payment_type" value="2" onclick="show1()"> Online payments 
                                    &emsp;
                                     <input type="radio" name="payment_type" id="payment_types" value="3"onclick="show2()"> Wallet 
                                    &emsp;
                                </div> 
                                 <div class="payment-method" style="display: none;" id="wallet_types">
                                    <h5 class="your-order-total-left font--bold">Wallet Type</h5>
                                    <input type="radio" name="wallet_type" id="wallet_type" value="1" checked> Main [ Balance : {{$user[0]->RECHARGE_BAL}}]
                                    &emsp;
                                     <input type="radio" name="wallet_type" id="wallet_types" value="2"> Payout [ Balance : {{$user[0]->UTILITY_BAL}}]
                                </div>
                            </div>
                        </div>
                        <div class="text-center">
                            <button class="btn btn--small btn--radius btn--green btn--green-hover-black btn--uppercase font--bold" type="button" onClick="placeorder()">PLACE ORDER</button>
                        </div>
                    </div>
                </div> 
                <!-- End Order Wrapper -->
               
            </div>
			 </form>
            @else
            <div class="row">
                <div class="col-12">
                    <div class="section-content">
                        <h5 class="section-content__title">Your cart item</h5>
                    </div>
                    <div class="empty-cart m-t-40 text-center">
                        <div class="empty-cart-icon title--large"><i class="fal fa-shopping-cart"></i></div>
                        <h3 class="title title--normal title--thin m-tb-30">There are no more items in your cart</h3>
                        <a href="{{url('/')}}" class="btn btn--box btn--large btn--radius btn--green btn--green-hover-black btn--uppercase font--semi-bold m-t-20">CONTINUE SHOPPING</a>
                    </div>
                </div>
            </div>
            @endif
        </div>
    </main> 

    <!-- Start Modal Quickview cart -->
    <div class="modal fade" id="AddressmodalQuickView" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-body">
                <h4 class="chk-delivery">Delivery Address </h4>
                    <div class="container-fluid">
                        <div class="row">
                            <div class="col text-right">
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true"> <i class="fal fa-times"></i></span>
                                </button>
                            </div>
                            
                            <div class="col-lg-12">                                             
                                    <form id="address" class="" action="{{url('add_user_address')}}" method="POST">
                                    @csrf
                                        <!-- Multiple Radios (inline) -->
                                        
                            <div class="form-group">
                                <div class="add_address_popup">
                                <input  class="radio-none" type="radio" name="txt_address" id="option-1-1" value="1" checked>
                                <input  class="radio-none" type="radio" name="txt_address" id="option-1-2" value="2">
                                <input  class="radio-none" type="radio" name="txt_address" id="option-1-3" value="3">
                                <label for="option-1-1" class="option option-1-1">
                                    <div class="dot"></div>
                                    <span>Home</span>
                                    </label>
                                <label for="option-1-2" class="option option-1-2">
                                    <div class="dot"></div>
                                     <span>Office</span>
                                </label>
                                <label for="option-1-3" class="option option-1-3">
                                    <div class="dot"></div>
                                     <span>Other</span>
                                </label>
                                </div>
                            </div>
                                    <div class="address-fieldset">
                                        <div class="row">
                                            <div class="col-lg-12 col-md-12">
                                                <div class="form-group">
                                                    <label class="control-label">Complete Address *</label>
                                                    <input id="txt_full_address" name="txt_full_address" type="text" placeholder="Complete Address" class="form-control input-md" required="">
                                                </div>
                                            </div>
                                            <div class="col-lg-12 col-md-12">
                                                <div class="form-group">
                                                    <label class="control-label">How to reach *</label>
                                                    <input id="txt_street" name="txt_street" type="text" placeholder="How to reach" class="form-control input-md">
                                                </div>
                                            </div>
                                            <div class="col-lg-6 col-md-12">
                                                <div class="form-group">
                                                    <label class="control-label">Pincode *</label>
                                                    <input id="txt_pincode" name="txt_pincode" type="text" placeholder="Pincode" class="form-control input-md" pattern="^(\d{4}|\d{6})$" title="Please enter valid pincode!" required="">
                                                </div>
                                            </div>
                                            <div class="col-lg-6 col-md-12">
                                                <div class="form-group">
                                                    <label class="control-label">Locality *</label>
                                                    <input id="txt_locality" name="txt_locality" type="text" placeholder="Enter City" class="form-control input-md" pattern="^[a-zA-Z]+(?:[\s-][a-zA-Z]+)*$" title="Please enter valid city name!" required="">
                                                </div>
                                            </div>
                                            <div class="col-lg-12 col-md-12">
                                                <div class="form-group mb-0">
                                                    <div class="address-btns">
                                                       <br> <button type="submit" class="save-btn14 hover-btn btn--small btn--green btn--green-hover-black">Save</button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div> 
    <!-- End Modal Quickview cart -->

    <!-- ::::::  End  Main Container Section  ::::::  -->
    <script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
    @if (Session::has('add_success'))
        <script type="text/javascript">
            swal({
              title: "{{ Session::get('add_success') }}",
              icon: "success",
            });
        </script>
    @endif
    @if (Session::has('add_warning'))
        <script type="text/javascript">
            swal({
              title: "{{ Session::get('add_warning') }}",
              icon: "warning",
            });
        </script>
    @endif

<script type="text/javascript">
function show1(){
  document.getElementById('wallet_types').style.display ='none';
}
function show2(){
  document.getElementById('wallet_types').style.display = 'block';
}

    function placeorder() {

        var payment_type = $("input[type='radio'][name='payment_type']:checked").val();
        var address = $("input[type='radio'][name='select']:checked").val();
        var cart_id =  $('#text_cart_id').val();
        if(address === undefined)
        {
            swal({
              title: "Please Select Address!",
              icon: "warning",
            });
        }        
        else if(payment_type === undefined)
        {
            swal({
              title: "Please Select Payment Type!",
              icon: "warning",
            });
        }
        else if(cart_id == '')
        {
            swal({
              title: "Cart Id Not Found!",
              icon: "warning",
            });
        }
        else if(address !== undefined && payment_type !== undefined && cart_id != '')
        { 
            
            //
            if(payment_type == 2)
            {
                $.ajax({
                    type:'POST',
                    url:"{{url('cashfree_payments')}}",
                    data:{"_token": "{{ csrf_token() }}", 'address': address, 'payment_type': payment_type, 'cart_id': cart_id },
                   success:function(result)
                   {
                        if(result['status'] == 'OK')
                        {   
                            window.location.href = result['paymentLink'];
                        }   
                        else
                        {

                        }
                   } 
                });
            }   
            if(payment_type == 3)
            {
                $('form#checkoutesave').submit(); 
            }
        }
    }
</script>
@endsection
