
<!DOCTYPE html>
<html>

<head>
    <meta charset="UTF-8">
    <title>{{config('APP_NAME')}}</title>
    <meta name="description" content="">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- ::::::::::::::Favicon icon::::::::::::::-->
    <link rel="shortcut icon" href="{{asset('assets/img/favicon.png')}}" alt="{{config('APP_NAME')}}" type="image/png">

    <!-- ::::::::::::::All CSS Files here :::::::::::::: -->

    <!-- Vendor CSS Files -->
    <link rel="stylesheet" href="{{asset('assets/css/vendor/jquery-ui.min.css')}}">
    <link rel="stylesheet" href="{{asset('assets/css/vendor/fontawesome.css')}}">
    <link rel="stylesheet" href="{{asset('assets/css/vendor/plaza-icon.css')}}">
    <link rel="stylesheet" href="{{asset('assets/css/vendor/bootstrap.min.css')}}">
    
    <!-- Plugin CSS Files -->
    <link rel="stylesheet" href="{{asset('assets/css/plugin/slick.css')}}">
    <link rel="stylesheet" href="{{asset('assets/css/plugin/material-scrolltop.css')}}">
    <link rel="stylesheet" href="{{asset('assets/css/plugin/price_range_style.css')}}">
    <link rel="stylesheet" href="{{asset('assets/css/plugin/in-number.css')}}">
    <link rel="stylesheet" href="{{asset('assets/css/plugin/venobox.min.css')}}">
    <link rel="stylesheet" href="{{asset('assets/css/plugin/jquery.lineProgressbar.css')}}">

    <!-- Use the minified version files listed below for better performance and remove the files listed above -->
    <!-- <link rel="stylesheet" href="assets/css/vendor/vendor.min.css"/>
    <link rel="stylesheet" href="assets/css/plugin/plugins.min.css"/>
    <link rel="stylesheet" href="assets/css/main.min.css"> -->

    <!-- Main Style CSS File -->
    <link rel="stylesheet" href="{{asset('assets/css/main.css')}}">
</head>

<body>
    <!-- ::::::  Start Header Section  ::::::  -->
    @include('Front.header')
    <!-- :::::: End Header Section ::::::  -->  

    @yield('content')
        


    <!-- ::::::  Start  Footer ::::::  -->
    @include('Front.footer')
    <!-- End Modal Quickview cart -->

    <!-- Vendor JS Files -->
    <script src="{{asset('assets/js/vendor/jquery-3.5.1.min.js')}}"></script>
    <script src="{{asset('assets/js/vendor/modernizr-3.7.1.min.js')}}"></script>
    <script src="{{asset('assets/js/vendor/jquery-ui.min.js')}}"></script>
    <script src="{{asset('assets/js/vendor/bootstrap.bundle.min.js')}}"></script>

    <!-- Plugins JS Files -->
    <script src="{{asset('assets/js/plugin/slick.min.js')}}"></script>
    <script src="{{asset('assets/js/plugin/jquery.countdown.min.js')}}"></script>
    <script src="{{asset('assets/js/plugin/material-scrolltop.js')}}"></script>
    <script src="{{asset('assets/js/plugin/price_range_script.js')}}"></script>
    <script src="{{asset('assets/js/plugin/in-number.js')}}"></script>
    <script src="{{asset('assets/js/plugin/jquery.elevateZoom-3.0.8.min.js')}}"></script>
    <script src="{{asset('assets/js/plugin/venobox.min.js')}}"></script>
    <script src="{{asset('assets/js/plugin/jquery.waypoints.js')}}"></script>
    <script src="{{asset('assets/js/plugin/jquery.lineProgressbar.js')}}"></script>

    <!-- Use the minified version files listed below for better performance and remove the files listed above -->
    <!-- <script src="assets/js/vendor/vendor.min.js"></script>
    <script src="assets/js/plugin/plugins.min.js"></script> -->
    <!-- Main js file that contents all jQuery plugins activation. -->
    <script src="{{asset('assets/js/main.js')}}"></script>
    <script src="{{asset('assets/js/custom.js')}}"></script>

<script type="text/javascript">
  $(function(){
    $('#modalQuickView').modal({
        keyboard: true,
        backdrop: "static",
        show:false,
        
    }).on('show', function(event){
          var name = $(event.relatedTarget).data('name');
        //make your ajax call populate items or what even you need
        $(this).find('#modalname').text(name);
    });

    GetCardData();
});

function AddCart(id) {

    var elem = document.getElementById(id).dataset;
    var op = elem.isvariant;
    var proid = elem.proid;
  
    $.ajax({
        type:"POST",
        url:"{{url('add_to_cart')}}",
        data:{"_token": "{{ csrf_token() }}", "proid" :proid, "isvariant": op},
        success:function(result)
        {
            GetCardData();
            $('#modalAddCart').modal('show');
        }
    });
}

function GetCardData() {

    $('#cart_modal_data').html('');
    $.ajax({
        type:"GET",
        url:"{{url('get_cart_data')}}",
        success:function(result)
        {
            if(parseInt(result['count']) > 0)
            {
                $('#all_pro_count').html('<span class="wishlist-item-count pos-absolute">'+result['count']+'</span>');
                $('#all_pro_counts').html('<span class="wishlist-item-count pos-absolute">'+result['count']+'</span>');
            }
            else
            {
               $('#all_pro_count').html(''); 
               $('#all_pro_counts').html(''); 
            }

            $('#cart_modal_data').html(result['cart']);
        }
    });
}

function RemoveCartProd(id) {
    var prod_id = $('#'+id).data('cpro_id');
    var provar_id = $('#'+id).data('cprovar_id');
    var proisvar = $('#'+id).data('cproisvar_id');
     $.ajax({
        type:'POST',
        url:"{{url('remove_cart_pro')}}",
        data:{"_token": "{{ csrf_token() }}", 'prod_id': prod_id, 'provar_id': provar_id, 'proisvar': proisvar },
       success:function(result)
       {       
            GetCardData();
       }
    });
}


function decreaseValueModal(id) {
    var prod_id = $('#'+id).data('dcpro_id');
    var provar_id = $('#'+id).data('dcprovar_id');
    var proisvar = $('#'+id).data('dcproisvar_id');
    var quantity = $('#'+id).data('dquantity_id');
     $.ajax({
        type:'POST',
        url:"{{url('decrease_value_cart_pro')}}",
        data:{"_token": "{{ csrf_token() }}", 'prod_id': prod_id, 'provar_id': provar_id, 'proisvar': proisvar, 'quantity': quantity },
       success:function(result)
       {       
            GetCardData();
       }
    });
}


function increaseValueModal(id) {
    var prod_id = $('#'+id).data('rcpro_id');
    var provar_id = $('#'+id).data('rcprovar_id');
    var proisvar = $('#'+id).data('rcproisvar_id');
    var rquantity = $('#'+id).data('rquantity_id');
    var quantity = $('#'+id).data('rquantity_id');
     $.ajax({
        type:'POST',
        url:"{{url('increase_value_cart_pro')}}",
        data:{"_token": "{{ csrf_token() }}", 'prod_id': prod_id, 'provar_id': provar_id, 'proisvar': proisvar, 'quantity': quantity },
       success:function(result)
       {       
            GetCardData();
       }
    });
}




</script>
<script type="text/javascript">
    $(window).on('load', function() {
        $('#mymodal').modal('show');
    });
</script>
</body>

</html>
