@extends('Front.FRONT11.common.app')
@section('content')
<style type="text/css">
  
/* Sets the background image for the wheel */
td.the_wheel
{
    background-image: url("{{url('/').'/'.asset('FRONT11/images/Wheel_small.png')}}");
    background-position: center;
    background-repeat: no-repeat;
}

canvas#canvas {
    filter: drop-shadow(1px 15px 11px #a2a2a2);
}

/* Do some css reset on selected elements */
h1, p
{
    margin: 0;
}

div.power_controls
{
    margin-right:70px;
}

div.html5_logo
{
    margin-left:70px;
}

/* Styles for the power selection controls */
table.power
{
    background-color: #cccccc;
    cursor: pointer;
    border:1px solid #333333;
}

table.power th
{
    background-color: white;
    cursor: default;
}

td.pw1
{
    background-color: #6fe8f0;
}

td.pw2
{
    background-color: #86ef6f;
}

td.pw3
{
    background-color: #ef6f6f;
}

/* Style applied to the spin button once a power has been selected */
.clickable
{
    cursor: pointer;
}

/* Other misc styles */
.margin_bottom
{
    margin-bottom: 5px;
}
</style>
<script type="text/javascript" src="{{asset('FRONT11/js/Winwheel.js')}}"></script>
<script src="http://cdnjs.cloudflare.com/ajax/libs/gsap/latest/TweenMax.min.js"></script>
<!-- inner-page-banner start -->
<section class="inner-page-banner has_bg_image" data-background="{{url('/').'/'.asset('FRONT11/images/inner-page-bg.jpeg')}}">
  <div class="container">
    <div class="row">
      <div class="col-lg-12">
        <div class="inner-page-banner-area">
          <h1 class="page-title" style="color: #ffffff;">{{$spin_game_data->NAME}} Spin</h1>
          <nav aria-label="breadcrumb" class="page-header-breadcrumb">
            <ol class="breadcrumb">
              <li class="breadcrumb-item"><a href="{{url('/')}}" style="color: #ffffff;">Home</a></li>
              <li class="breadcrumb-item"><a href="javascript:void(0)" style="color: #ffffff;">Game</a></li>
              <li class="breadcrumb-item active" style="color: #ffffff;">{{$spin_game_data->NAME}} Spin</li>
            </ol>
          </nav>
        </div>
      </div>
    </div>
  </div>
</section>
<!-- inner-page-banner end -->
  <!-- single-categories-play-section start -->
  <section class="single-categories-play-section section-padding">
    <div class="container">
      <div class="row">
        <div class="col-lg-12">
          <div class="single-cat-play-area">
            <div class="single-header d-flex justify-content-between">
              <div class="left d-flex">
                <div class="icon">
                  <img src="{{asset($spin_game_data->IMAGE)}}" alt="{{$spin_game_data->NAME}}" width="50">
                </div>
                <div class="content"><h3 class="title">{{$spin_game_data->NAME}}</h3></div>
              </div>
              <div class="right text-right">
                <span class="amount">Main Wallet Balance : <span class="main-balance" style="color: #c81326"> $ 0.00 </span></span>
              </div>
            </div><!-- single-header end -->
            <div class="single-body">
              <div class="single-body-inner">
                <div class="play-card">
                  <div class="play-card-inner text-center">
                    <div class="play-card-body">
                      <img src="{{url('/').'/'.asset('FRONT11/images/pin.svg')}}" style="position: absolute;left: 29.8rem;top: 5px;rotate: 22%;transform: rotate(12deg);margin-top: -4px;z-index: 1;">
                       <table cellpadding="0" cellspacing="0" border="0">
                          <tr>
                              <td width="438" height="500" class="the_wheel" align="center" valign="center" style="padding-left: 0px;padding-bottom: 13px;">
                                  <canvas id="canvas" width="434" height="434">
                                      <p style="{color: white}" align="center">Sorry, your browser doesn't support canvas. Please try another.</p>
                                  </canvas>
                              </td>
                          </tr>
                      </table>
                      <button onClick="startSpin();" class="cmn-btn" style="background-color: #ffffff;color: var(--main-color);font-weight: 900;border: 2px solid var(--main-color);"> Spin Now! </button>
                    </div>
                    <div class="play-card-footer">
                      <p class="play-card-footer-text">Win Amount : <span class="lottery_no play-card-footer-text"></span></p>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </section>
<!-- single-categories-play-section end -->

<!-- work-steps-section strat -->
<section class="work-steps-section section-padding">
<div class="container">
  <div class="row justify-content-center">
    <div class="col-lg-7">
      <div class="section-header text-center">
        <h2 class="section-title">how it works</h2>
        <p>Sorteo is the best way to play these exciting lotteries from anywhere in the world.</p>
      </div>
    </div>
  </div>
  <div class="row align-items-center">
    <div class="col-lg-6">
      <div class="work-steps-items-part d-flex">
        <div class="line"><img src="{{url('/').'/'.asset('FRONT11/images/elements/line.png')}}" alt="line-image"></div>
        <div class="work-steps-item">
          <div class="work-steps-item-inner">
            <div class="icon">
              <img src="{{url('/').'/'.asset('FRONT11/images/svg-icons/how-work-icons/1.svg')}}" alt="icon">
              <span class="count-num">01</span>
            </div>
            <h4 class="title">choose</h4>
            <p>Choose your lottery & pick your numbers</p>
          </div>
        </div><!-- work-steps-item end -->
        <div class="work-steps-item">
          <div class="work-steps-item-inner">
            <div class="icon">
              <img src="{{url('/').'/'.asset('FRONT11/images/svg-icons/how-work-icons/2.svg')}}" alt="icon">
              <span class="count-num">02</span>
            </div>
            <h4 class="title">buy</h4>
            <p>Complete your purchase</p>
          </div>
        </div><!-- work-steps-item end -->
        <div class="work-steps-item">
          <div class="work-steps-item-inner">
            <div class="icon">
              <img src="{{url('/').'/'.asset('FRONT11/images/svg-icons/how-work-icons/3.svg')}}" alt="icon" class="">
              <span class="count-num">03</span>
            </div>
            <h4 class="title">win</h4>
            <p>Start dreaming, you're almost there</p>
          </div>
        </div><!-- work-steps-item end -->
      </div>
    </div>
    <div class="col-lg-6">
      <div class="work-steps-thumb-part">
        <img src="{{url('/').'/'.asset('FRONT11/images/elements/step.png')}}" alt="work-step-image">
        <a href="#" class="play-btn"><i class="fa fa-play"></i></a>
      </div>
    </div>
  </div>
</div>
</section>
<!-- work-steps-section strat -->

<!-- reward-section start -->
<section class="reward-section section-padding border-top has_bg_image" data-background="{{url('/').'/'.asset('FRONT11/images/bg-five.jpg')}}">
<div class="container">
  <div class="row justify-content-center">
    <div class="col-lg-7">
      <div class="section-header text-center">
        <h2 class="section-title">Lucky-Rewards</h2>
        <p>We at Sorteo offer you the most generous and innovative lotto bonuses. How would you feel with an attractive deposit bonus, a risk free lottery ticket</p>
      </div>
    </div>
  </div>
  <div class="row m-bottom-not-30">
    <div class="col-lg-4 col-md-6">
      <div class="reward-item text-center">
        <div class="icon">
          <img src="{{url('/').'/'.asset('FRONT11/images/svg-icons/reward/1.svg')}}" alt="image">
        </div>
        <div class="content">
          <h3 class="title">Collect Points</h3>
          <p>After playing your ticket, win or not, enter the code from your ticket to collect Lucke-Rewards points.</p>
        </div>
      </div>
    </div><!-- reward-item end-->
    <div class="col-lg-4 col-md-6">
      <div class="reward-item text-center">
        <div class="icon">
          <img src="{{url('/').'/'.asset('FRONT11/images/svg-icons/reward/2.svg')}}" alt="image">
        </div>
        <div class="content">
          <h3 class="title">Enter Drawings</h3>
          <p>Use your Lucke-Rewards points to enter drawings for a second chance to win.So why are you waiting for?</p>
        </div>
      </div>
    </div><!-- reward-item end-->
    <div class="col-lg-4 col-md-6">
      <div class="reward-item text-center">
        <div class="icon">
          <img src="{{url('/').'/'.asset('FRONT11/images/svg-icons/reward/3.svg')}}" alt="image">
        </div>
        <div class="content">
          <h3 class="title">Promotions & Drawings</h3>
          <p>You’ve earned your points and are ready to play again. Check out the latest Lucke-Rewards drawings</p>
        </div>
      </div>
    </div><!-- reward-item end-->
  </div>
</div>
</section>
<!-- reward-section end -->

<!-- question-section start -->
<section class="question-section border-top section-padding section-bg">
<div class="container">
  <div class="row justify-content-between">
    <div class="col-lg-4">
      <div class="thumb text-lg-right text-center">
        <img src="{{url('/').'/'.asset('FRONT11/images/elements/faq.png')}}" alt="image">
      </div>
    </div>
    <div class="col-lg-7">
      <div class="content">
        <h2 class="title">If you have any questions</h2>
        <p>Our top priorities are to protect your privacy, provide secure transactions, and safeguard your data. When you're ready to play, registering an account is required so we know you're of legal age and so no one else can use your account.We answer the most commonly asked lotto questions..</p>
        <a href="{{url('frequently_asked_questions')}}" class="cmn-btn">Check FAQs</a>
      </div>
    </div>
  </div>
</div>
</section>
<!-- question-section end -->
<script>

            var segments_data = JSON.stringify('{{$all_spin_data}}'); 
                segments_data = JSON.parse(segments_data);
            var all_segments_data = JSON.parse(segments_data.replace(/&quot;/g,'"')); 
            var spin_count = parseInt('{{$spin_count}}');

            // Create new wheel object specifying the parameters at creation time.
            let theWheel = new Winwheel({
                'outerRadius'     : 212,        
                'innerRadius'     : 75,         
                'textFontSize'    : 16,         
                'textOrientation' : 'vertical', 
                'textAlignment'   : 'outer',
                'numSegments'     : spin_count,
                'lineWidth'       : 0,  
                'strokeStyle'     : '#ffffff',       
                'textFillStyle'   : '#ffffff',
                'segments'        : all_segments_data,            
                // [                               
                //   {'fillStyle' : '#6c1ae6', 'text' : '300'},
                //   {'fillStyle' : '#bd19e6', 'text' : '450'},
                //   {'fillStyle' : '#e619e6', 'text' : '600'},
                //   {'fillStyle' : '#e619bd', 'text' : '750'},
                //   {'fillStyle' : '#e61994', 'text' : '500'},
                //   {'fillStyle' : '#e6196b', 'text' : 'BANKRUPT'},
                //   {'fillStyle' : '#e61942', 'text' : '3000'},
                //   {'fillStyle' : '#e61919', 'text' : '600'},
                //   {'fillStyle' : '#e6431b', 'text' : '700'},
                //   {'fillStyle' : '#ee1c24', 'text' : '350'},
                //   {'fillStyle' : '#e66b19', 'text' : '500'},
                //   {'fillStyle' : '#e69419', 'text' : '800'},
                //   {'fillStyle' : '#e6bd19', 'text' : '300'},
                //   {'fillStyle' : '#e6e619', 'text' : '400'},
                //   {'fillStyle' : '#bde619', 'text' : '650'},
                //   {'fillStyle' : '#98e722', 'text' : '1000'},
                //   {'fillStyle' : '#6be619', 'text' : '500'},
                //   {'fillStyle' : '#42e619', 'text' : '400'},
                //   {'fillStyle' : '#1ae61a', 'text' : '900'},
                //   {'fillStyle' : '#19e642', 'text' : 'BANKRUPT'},
                //   {'fillStyle' : '#19e694', 'text' : '600'},
                //   {'fillStyle' : '#19e6bd', 'text' : '700'},
                //   {'fillStyle' : '#19e6e6', 'text' : '800'},
                //   {'fillStyle' : '#19bde6', 'text' : 'LOOSE TURN', 'textFontSize' : 12},
                //   {'fillStyle' : '#1a94e6', 'text' : '300'},
                //   {'fillStyle' : '#196be6', 'text' : '450'},
                //   {'fillStyle' : '#1942e6', 'text' : '600'},
                //   {'fillStyle' : '#1919e6', 'text' : '750'},
                //   {'fillStyle' : '#4219e6', 'text' : '500'},
                //   {'fillStyle' : '#6b19e6', 'text' : 'BANKRUPT'},
                //   {'fillStyle' : '#6b19e6', 'text' : '3000'},
                // ],
                'animation' :           // Specify the animation to use.
                {
                    'type'     : 'spinToStop',
                    'duration' : 30,    // Duration in seconds.
                    'spins'    : 10,     // Default number of complete spins.
                    'callbackFinished' : alertPrize,
                    'callbackSound'    : playSound,   // Function to call when the tick sound is to be triggered.
                    'soundTrigger'     : 'pin'        // Specify pins are to trigger the sound, the other option is 'segment'.
                },
                // 'pins' :        // Turn pins on.
                // {
                //     'number'     : 31,
                //     'fillStyle'  : 'silver',
                //     'outerRadius': 4,
                // }
            });

            // Loads the tick audio sound in to an audio object.
            let audio = new Audio("{{url('/').'/'.asset('FRONT11/tick.mp3')}}");

            // This function is called when the sound is to be played.
            function playSound()
            {
                // Stop and rewind the sound if it already happens to be playing.
                audio.pause();
                audio.currentTime = 0;

                // Play the sound.
                audio.play();
            }

            // Vars used by the code in this page to do power controls.
            let wheelPower    = 3;
            let wheelSpinning = false;

            // -------------------------------------------------------
            // Click handler for spin button.
            // -------------------------------------------------------
            function startSpin()
            {
                // Ensure that spinning can't be clicked again while already running.
                if (wheelSpinning == false) {
                    // Based on the power level selected adjust the number of spins for the wheel, the more times is has
                    // to rotate with the duration of the animation the quicker the wheel spins.
                    if (wheelPower == 1) {
                        theWheel.animation.spins = 3;
                    } else if (wheelPower == 2) {
                        theWheel.animation.spins = 6;
                    } else if (wheelPower == 3) {
                        theWheel.animation.spins = 10;
                    }

                    // Begin the spin animation by calling startAnimation on the wheel object.
                    theWheel.startAnimation();

                    // Set to true so that power can't be changed and spin button re-enabled during
                    // the current animation. The user will have to reset before spinning again.
                    wheelSpinning = true;
                }
            }

            // -------------------------------------------------------
            // Function for reset button.
            // -------------------------------------------------------

            function resetWheel()
            {
                theWheel.stopAnimation(false);  // Stop the animation, false as param so does not call callback function.
                theWheel.rotationAngle = 0;     // Re-set the wheel angle to 0 degrees.
                theWheel.draw();                // Call draw to render changes to the wheel.

                wheelSpinning = false;          // Reset to false to power buttons and spin can be clicked again.
            }

            // -------------------------------------------------------
            // Called when the spin animation has finished by the callback feature of the wheel because I specified callback in the parameters.
            // -------------------------------------------------------
            function alertPrize(indicatedSegment)
            {
                // Just alert to the user what happened.
                // In a real project probably want to do something more interesting than this with the result.
                if (indicatedSegment.text == 'LOOSE TURN') {
                    alert('Sorry but you loose a turn.');
                } else if (indicatedSegment.text == 'BANKRUPT') {
                    alert('Oh no, you have gone BANKRUPT!');
                } else {
                    alert("You have won " + indicatedSegment.text);
                }
            }

        </script>
@endsection