@extends('Front.FRONT10.main-layout')
@section('content')  
  	<!-- Page Header
    ============================================= -->
    <section class="page-header page-header-text-light bg-secondary">
      <div class="container">
        <div class="row align-items-center">
          <div class="col-md-8">
            <h1>Browse Plans</h1>
          </div>
          <div class="col-md-4">
            <ul class="breadcrumb justify-content-start justify-content-md-end mb-0">
              <li><a href="index.html">Home</a></li>
              <li class="active">Plans</li>
            </ul>
          </div>
        </div>
      </div>
    </section><!-- Page Header end -->
    
  <!-- Content
  ============================================= -->
  <div id="content">
    <div class="container">
      <div class="bg-light shadow-md rounded p-4">
        <form id="recharge-history" class="form-row mb-4 mb-sm-2" method="post">
          @csrf
          <div class="col-12 col-sm-6 col-md-2">
            <div class="form-group">
              <label for="birthDate">From Date</label>
              <input id="txt_birthDate" name="txt_fromdate" value="{{$start}}" type="date" class="form-control" required placeholder="Form Date">
            </div>
          </div>          
          <div class="col-12 col-sm-6 col-md-2">
            <div class="form-group">
              <label for="birthDate">To Date</label>
              <input id="txt_birthDate" name="txt_todate" value="{{$end}}" type="date" class="form-control" required placeholder="To Date">
            </div>
          </div>
          <div class="col-12 col-sm-6 col-md-3">
            <div class="form-group">
              <label for="operator">Operators</label>
              <select class="custom-select" id="operator" name="dd_operator" required="">
                <option value="-1">Select Your Operator</option>
                @foreach($OPERATOR as $op)
                <option value="{{ $op->TelecomBrandId }}" {{$dd_operator == $op->TelecomBrandId? 'selected':''}}>{{ $op->BrandName }}</option>
                @endforeach
              </select>
            </div>
          </div>
          <div class="col-12 col-sm-6 col-md-3">
            <div class="form-group">
              <label for="records">Number Of Records</label>
              <select class="custom-select" id="records" name="txt_noofrecords" required="">
                <option value="20" {{$txt_noofrecords == '20'? 'selected':''}}>20 Records</option>
                <option value="50" {{$txt_noofrecords == '50'? 'selected':''}}>50 Records</option>
                <option value="100" {{$txt_noofrecords == '100'? 'selected':''}}>100 Records</option>
                <option value="200" {{$txt_noofrecords == '200'? 'selected':''}}>200 Records</option>
                <option value="500" {{$txt_noofrecords == '500'? 'selected':''}}>500 Records</option>
                <option value="1000" {{$txt_noofrecords == '1000'? 'selected':''}}>1000 Records</option>
              </select>
            </div>
          </div>
          <div class="col-12 col-sm-6 col-md-2">

              <label for="records" style="color: #ffffff;">Filter Button</label>
            <button class="btn btn-primary btn-block" type="submit">Filter</button>
          </div>
        </form>
        <div class="plans page">
          <div class="table-responsive-md">
            <table class="table table-hover border">
              <tbody>
                @foreach($rec_report as $key => $value)
                <tr>
                  <td class="text-5 text-primary text-center align-middle"><i class="fas fa-rupee-sign"></i>{{$value->Amount}} <span class="text-1 text-muted d-block">Amount</span></td>
                  <td class="text-3 text-center align-middle">{{$value->Account}} <span class="text-1 text-muted d-block">Phone Number</span></td>
                  <td class="text-1 text-muted align-middle">Service Type : {{$value->ServiceType}}, Circle : {{$value->CircleName}}, Operator : {{$value->ServiceProvider}},  Transaction Number : {{$value->Transactionid}}, Recharge Date :  {{$value->RequestDate}}</td>
                  <td class="align-middle"><button class="btn btn-sm @if($value->Status == 'SUCCESS') btn-outline-success @elseif($value->Status == 'PENDING') btn-outline-warning @elseif($value->Status == 'FAILED') btn-outline-primary @else btn-outline-danger @endif shadow-none text-nowrap" type="submit" style="width: 130px;">{{$value->Status}}</button></td>
                  <td class="align-middle">
				@if($value->Status == 'SUCCESS')
                    <a class="btn btn-sm btn-outline-info shadow-none text-nowrap"  href="{{url('bill-receipt/'.$value->Transactionid)}}" target="_blank"><i class="fas fa-print"></i></a>
				@endif                  
</td>
                </tr>
                @endforeach
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
  </div><!-- Content end -->

@endsection