@extends('Front.FRONT10.main-layout')
@section('content')

    <section class="page-content container section bg-light shadow-md rounded px-5">
      <div>
        <div class="row">
        
          <!-- Electricity Bill
          ============================================= -->
          <div class="col-lg-4 mb-4 mb-lg-0">
            <h2 class="text-4 mb-3">Pay your Electricity Bill</h2>
            <form id="electricityBill" method="post">
              <div class="form-group">
                  <select class="custom-select" id="dd_brand"  name="dd_brand" required="" onchange="checkuserlogin()">
                  <option value="">Select Your Operator</option>
				@foreach($OPERATOR as $value)
                  <option  value="{{$value->BrandCode}}" data-account="{{$value->Account}}" data-hint="{{$value->AcDesc}}">{{$value->BrandName}}</option>
				@endforeach
                  </select>
				<span id="divdd_brand" style="color:red;"></span>
                </div>
              <!-- div class="form-group">
                <select class="custom-select" id="yourState" required="">
                  <option value="">Select Your State</option>
                </select>
              </div -->
              <div class="form-group">
                <input type="text" class="form-control" data-bv-field="number" id="txt_number"  name="txt_number"  required placeholder="Enter Number" onclick="checkuserlogin()">
				<span id="divtxt_account" style="color:red;"></span> 
              </div>
			<div class="form-group"  id="account"> 
                <input type="text" class="form-control" data-bv-field="number" id="txt_account"  name="txt_account"  required placeholder="Enter Account Number">
				<span id="divtxt_account" style="color:red;"></span> 
			</div>
			<div class="form-group">
				<button  onClick="find_bijlibill()" class="btn btn-sm btn-success btn-block" type="button">View Bill Amount</button>
			</div>  
			<div class="form-group" id="btntxt_desc"  style="display:none">
				<button class="btn btn-block" type="button"> <span id="divtxt_desc" style="color:red;"></span> </button>
            </div>  
			<div class="form-group input-group">
                <div class="input-group-prepend"> <span class="input-group-text">&#x20B9;</span> </div>
                <input class="form-control" id="amount" placeholder="Enter Amount" required type="text">
              </div>
              <button class="btn btn-primary btn-block" type="submit">Continue</button>
            </form>
          </div><!-- Electricity Bill end -->
          
          <!-- Slideshow
          ============================================= -->
          <div class="col-lg-8">
            <div class="owl-carousel owl-theme slideshow single-slider">
			@foreach($banners as $value)
              <div class="item"><a href="#"><img class="img-fluid" src="{{asset('images/front/'. $value->BANNER_IMG)}}" alt="{{ $value->BANNER_DESC}}" /></a></div>
			@endforeach
            </div>
          </div><!-- Slideshow end -->
          
        </div>
      </div>
    </section>
    
    
    <!-- Refer & Earn
    ============================================= -->
    
      <section  class="page-content container section bg-light shadow-md rounded px-5">
       
      </section>
<!-- Refer & Earn end -->
    

<!-- Back to Top
============================================= -->
<a id="back-to-top" data-toggle="tooltip" title="Back to Top" href="javascript:void(0)"><i class="fa fa-chevron-up"></i></a>

<!-- Modal Dialog - View Plans
============================================= -->
<script>
    function checkuserlogin() {
    $.ajax({
     type:"POST",
     url:"{{ url('/check_user_login')}}",
     data:{"_token": "{{ csrf_token() }}"},
     success:function(result)
     { 
      if(result == 'false')
      {
        swal({
          title: "Please login after use service!",
          //text: "Once deleted, you will not be able to recover this imaginary file!",
          //icon: "warning",
          buttons: true,
          dangerMode: true,
        })
        .then((willDelete) => {
          if (willDelete) {
            location.href = "sign-in";
          }
        });
      }
     }  
    });
  }

	function find_bijlibill()
	{
		var dd_brand =$('#dd_brand').val();
		var txt_account =$("input[name='txt_account']").val();
		var txt_number =$("input[name='txt_number']").val();
		$.ajax({	
			type:"POST",
			url:"{{ url('/front_fetch_bill')}}",
			dataType: 'json',
			data:{"dd_brand":dd_brand,"txt_account":txt_account,"txt_number":txt_number,_token:'{{csrf_token()}}'},
			beforeSend : function(){
				$('img.loader').show('fadein');
			},
			success:function(msg) 
			{
				console.log(msg.MSG); 
				$('img.loader').hide('fadeout');
				if(msg.STATUS==1){
				$('#txt_amount').val(msg.BILL_AMOUNT);
					$('#btntxt_desc').show();
				$('#divtxt_desc').html('<span> CUSTOMER NAME:- '+msg.NUMBER+'</br>  BILL DUE DATE:- '+msg.DUEDATE+'</br> BILLNO:- '+msg.BILLNO+'</span>');
				}
				else
				{
					$('#txt_amount').val('');
					$('#btntxt_desc').show();
					$('#divtxt_desc').html(msg.DESC);
				}
			}
		});
	}
	function confirm_details_bbbill(get_id)
	{
	
		var dd_brand =$('#dd_brand').val();
		var txt_account =$("input[name='txt_account']").val();
		var txt_number =$("input[name='txt_number']").val();
		var txt_amount=$('#txt_bijlibamount').val();
		bootbox.confirm('Are you sure to Pay Bill this Number -'+txt_number+' with amount of '+txt_amount+'.Please Confirm.', function(result){
			if(result==true)
			{
				alert("You pressed OK!");
				document.getElementById(get_id).submit();
			}
			else {
				alert("You pressed Cancel!");
			}
		});
	}
</script>
<script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
<script type="text/javascript">
$(document).ready(function(){

	$('#hide').hide();
	$('#account').hide();
	$('#dd_brand').change(function(){
		var value =	$('#dd_brand option:selected').val();
		//var value =	$('#dd_brand option:selected').val();
		var account =	$(this).find(':selected').data('account');
		var hint =	$(this).find(':selected').data('hint');
		if(value!="-1"){
			$('#hide').show();
			if(account=='1'){
				$('#account').show();
				$('#account_text').text("Enter "+hint);
			}
			else{
				$('#account').hide();
			}
		}
		else{
			$('#hide').hide();
		}
	});
	
});
</script>
@endsection