@extends('Front.FRONT10.main-layout')
@section('content')
    
    <section class="page-content container section bg-light shadow-md rounded px-5">
      <div class="">
        <div class="row">
        
          <!-- DTH Recharge
          ============================================= -->
          <div class="col-lg-4 mb-4 mb-lg-0">
            <h2 class="text-4 mb-3">DTH Recharge</h2>
            <form id="dthRechargeBill" method="post" action="{{url('dth-recharge')}}">
					@csrf
              <div class="form-group">
                  <select class="custom-select"name="dd_dthbrand" id="dd_dthbrand" required="" >
                  <option value="">Select Your Operator</option>
				@foreach($OPERATOR as $value)
                  <option value="{{$value->TelecomBrandId}}"  {{Session()->get('dd_dthbrand') == $value->TelecomBrandId? 'Selected':''}}>{{$value->BrandName}}</option>
				@endforeach
                  </select>
                </div>
              <div class="form-group">
                <input type="text" class="form-control" data-bv-field="number" id="txt_cardno" name="txt_cardno"  value="{{Session()->get('txt_cardno')}}"  required placeholder="Enter Your Card Number" >
              </div>
			<div class="form-group">
				<button class="btn btn-sm btn-success btn-block"  type="button" onclick="get_dthplan_and_last_rech('dd_dthbrand')">View Plans</button>
			</div>  
			<div class="form-group" id="btntxt_desc"  style="display:none">
				<button class="btn btn-block" type="button"> <span id="plans" style="color:red;"></span> </button>
            </div>  
              <div class="form-group input-group">
                <div class="input-group-prepend"> <span class="input-group-text">&#x20B9;</span> </div>
                <input class="form-control" id="txt_amount" name="txt_amount" placeholder="Enter Amount"  value="{{Session()->get('txt_amount')}}" required type="text">
              </div>

			@if(Session::get('B2C_USER_ID') != '' && Session::get('B2C_USER_ROLE') == 'B2CUSER')
              <div class="mb-3">
                <div class="custom-control custom-radio custom-control-inline">
                  <input id="prepaid" name="payment_type" value="1" class="custom-control-input" {{Session()->get('payment_type') == 1? 'checked':''}} {{Session()->get('payment_type') == 2? '':'checked'}} required type="radio">
                  <label class="custom-control-label" for="prepaid">Pay Wallet</label>
                </div>
                <div class="custom-control custom-radio custom-control-inline">
                  <input id="postpaid" name="payment_type" value="2" class="custom-control-input" {{Session()->get('payment_type') == 2? 'checked':''}}  required type="radio">
                  <label class="custom-control-label" for="postpaid">Pay Credit/Debit Card</label>
                </div>
              </div>
			@else
			<input id="prepaid" name="payment_type" value="1" class="custom-control-input" checked required type="hidden">
			@endif

              <button class="btn btn-primary btn-block" type="button" onclick="conformsubmit('dthRechargeBill')">Continue to Recharge</button>
            </form>
          </div><!-- DTH Recharge end -->
          
          <!-- Slideshow
          ============================================= -->
          <div class="col-lg-8">
            <div class="owl-carousel owl-theme slideshow single-slider">
			@foreach($banners as $value)
              <div class="item"><a href="#"><img class="img-fluid" src="{{asset('images/front/'. $value->BANNER_IMG)}}" alt="{{ $value->BANNER_DESC}}" /></a></div>
			@endforeach
            </div>
          </div><!-- Slideshow end -->
          
        </div>
      </div>
    </section>
    <section class="page-content container section shadow-md rounded px-5" style="background-image: url(/public/FRONT9/images/42.png);
    height: 445px;background-color: #fbe5cd;">
        
    </section>
    


<!-- Back to Top
============================================= -->
<a id="back-to-top" data-toggle="tooltip" title="Back to Top" href="javascript:void(0)"><i class="fa fa-chevron-up"></i></a>

<!-- Modal Dialog - View Plans
============================================= -->
<div id="view-info" class="modal fade" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">DTH Recharge Info</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"> <span aria-hidden="true"></span> </button>
      </div>
          <div class="modal-body">
            <h5>Card Number :  <span id="ph"></span></h5>
            <h5>Operator : <span id="op"></span></h5>
            <h5>Amount : <span id="am"></span></h5>
            <h5>Payment Type : <span id="pt"></span></h5>
			<h5><span id="plansd"></span></h5>

          </div>
        <div class="modal-footer">
          <button class='btn btn-sm btn-outline-primary shadow-none text-nowrap' type='button'  data-dismiss="modal" aria-label="Close">Cancel</button>
          <button class='btn btn-sm btn-outline-success shadow-none text-nowrap' type='button' onclick="recharge_now('dthRechargeBill')">Recharge Now</button>
        </div>
      </div>
    </div>
  </div>
<!-- Modal Dialog - View Plans end -->
@if(Session::has('message'))
<script type="text/javascript">
      swal({
        title: "{{Session::get('message')}}",
        //icon: "{{Session::get('type')}} ",
        button: "OK",
      });
</script>
@endif

<!-- This form is hidden -->
<form action="{{url('/payment-completebtocdth')}}" method="POST" hidden>
        <input type="hidden" value="{{csrf_token()}}" name="_token" /> 
        <input type="text" class="form-control" id="rzp_paymentid"  name="rzp_paymentid">
        <input type="text" class="form-control" id="rzp_orderid" name="rzp_orderid">
        <input type="text" class="form-control" id="rzp_signature" name="rzp_signature">
        <input type="text" class="form-control" id="user_code" name="user_code">
        <input type="text" class="form-control" id="txt_amounts" name="txt_amount">
        <input type="text" class="form-control" id="txt_cardnos" name="txt_cardno">
        <input type="text" class="form-control" id="dd_dthbrands" name="dd_dthbrand">
        <input type="text" class="form-control" id="payment_types" name="payment_type">
		<input type="text" class="form-control" id="receiptId" name="receiptId">
    
    <button type="submit" id="rzp-paymentresponse" class="btn btn-primary">Submit</button>
</form>

<form action="{{url('/payment-failedbtoc-addmoneywall')}}" method="POST" hidden>
        <input type="hidden" value="{{csrf_token()}}" name="_token" /> 
        <input type="text" class="form-control" id="rzp_paymentid"  name="rzp_paymentid">
        <input type="text" class="form-control" id="rzp_orderid" name="rzp_orderid">
        <input type="text" class="form-control" id="rzp_signature" name="rzp_signature">
        <input type="text" class="form-control" id="user_code" name="user_code">
        <input type="text" class="form-control" id="txt_amounts" name="txt_amounts">
        <input type="text" class="form-control" id="receiptId" name="receiptId">
        
    <button type="submit" id="rzp-paymentresponse" class="btn btn-primary">Submit</button>
</form>

<script src="https://checkout.razorpay.com/v1/checkout.js"></script>

<script>
  function recharge_now(form_id) {

	var check	= "{{Session::get('B2C_USER_ID')}}";
	if(check)
	{
     var txt_cardno = $("#txt_cardno").val();
     var txt_amount = $("#txt_amount").val();
     var payment_type = $("input[name='payment_type']:checked").val();
     var operator=$('#dd_dthbrand').val();

				$.ajax({
				   type:"POST",
				   url:"{{ url('b2crazorpay')}}",
				   data:{"_token": "{{ csrf_token() }}", "txt_amount":txt_amount },
				   success:function(result)
				   {   	
							console.log(result);

						var options = {
										"key": result[1].razorpayId, // Enter the Key ID generated from the Dashboard
										"amount":result[1].amount, // Amount is in currency subunits. Default currency is INR. Hence, 50000 refers to 50000 paise
										"currency": result[1].currency,
										"name": result[1].name,
										"description": result[1].description,
										"user_code":result[1].user_code,
										"image": "{{asset('/images/config/logo/'.config('SITE_LOGO') ) }}", // You can give your logo url 
										"order_id": result[1].orderId, //This is a sample Order ID. Pass the `id` obtained in the response of Step 1
										"handler": function (response){
											// After payment successfully made response will come here
											// send this response to Controller for update the payment response
											// Create a form for send this data
											// Set the data in form
											document.getElementById('rzp_paymentid').value = response.razorpay_payment_id;
											document.getElementById('rzp_orderid').value = response.razorpay_order_id;
											document.getElementById('rzp_signature').value = response.razorpay_signature;
											document.getElementById('user_code').value = result[1].user_code;
											document.getElementById('txt_amounts').value = result[2].txt_amount;
											document.getElementById('receiptId').value = result[1].receiptId;		
											document.getElementById('txt_cardnos').value = txt_cardno;
											document.getElementById('dd_dthbrands').value = operator;
											document.getElementById('payment_types').value = payment_type;

											document.getElementById('rzp-paymentresponse').click();
										},
										"prefill": {
											"name": result[1].name,
											"email": result[1].email,
											"contact": result[1].contactNumber
										},
										"notes": {
											"address": result[1].address
										},
										"theme": {
											"color": "{{config('SITE_BTN_BG')}}"
										}
									};
									var rzp1 = new Razorpay(options);
									rzp1.on('payment.failed', function (response){
											document.getElementById('rzp_paymentid').value = response.error.metadata.payment_id;
											document.getElementById('rzp_orderid').value = response.error.metadata.order_id;
											document.getElementById('rzp_signature').value = response.error.description+' ['+ response.error.code +' ] '+' [ '+ response.error.reason +' ]';
											document.getElementById('user_code').value = result[1].user_code;
											document.getElementById('txt_amounts').value = result[2].txt_amount;
											document.getElementById('receiptId').value = result[1].receiptId;
									});
									
									$('#view-info').modal('hide');
									rzp1.open();
									e.preventDefault();
				   }
					});
		}
		else
		{
			document.getElementById(form_id).submit();
		}
  }


  function conformsubmit(id) {
     var txt_cardno = $("#txt_cardno").val();
     var txt_amount = $("#txt_amount").val();
     var payment_type = $("input[name='payment_type']:checked").val();
     var dd_brand_name = $("#dd_dthbrand option:selected").text();

    if(txt_cardno == '')
    {
      swal({
        title: "Enter Card Number!",
        button: "OK",
      });
    }
    else if(txt_cardno.length > 15)
    {
      swal({
        title: "Enter valid Card Number!",
        button: "OK",
      });
    }
    else if(txt_cardno.length < 4)
    {
      swal({
        title: "Enter valid Card Number!",
        button: "OK",
      });
	}
    else if(txt_amount == '')
    {
      swal({
        title: "Enter Amount!",
        button: "OK",
      });
    }
    else if(txt_amount < 10)
    {
      swal({
        title: "Min Amount Rs 10 !",
        button: "OK",
      });
    }
    else if(txt_amount > 10000)
    {
      swal({
        title: "Max Amount Rs 10000 !",
        button: "OK",
      });
    }
    else if(dd_brand_name == '')
    {
      swal({
        title: "Select Operator!",
        button: "OK",
      });
    }
    else
    {

      if(payment_type == 1)
      {
        var pt_name = 'Pay Wallet';
      }     
      if(payment_type == 2)
      {
        var pt_name = 'Pay Credit/Debit Card';
      }

      $('#ph').html(txt_cardno);
      $('#op').html(dd_brand_name);
      $('#am').html(txt_amount);
      $('#pt').html(pt_name);
      $('#view-info').modal('show');
    }
  }




	function confirm_details_dth(get_id) {
		var txt;
		var operator=$('#dd_dthbrand').val();
		var txt_cardno=$('#txt_cardno').val();
		var txt_amount=$('#txt_dthamount').val();
		var result =false;
		bootbox.confirm('Are you sure to Recharge this DTH -'+txt_cardno+' with amount of '+txt_amount+'.Please Confirm.', function(result){
			if(result==true)
			{
				alert("You pressed OK!");
				document.getElementById(get_id).submit();
			}
			else {
				alert("You pressed Cancel!");
			}
		});
	}
</script>
 <script>
 function get_dthplan_and_last_rech(id) {
        var opcode = $("#"+id).val();
		var number = $("#txt_cardno").val();
		var operator=$('#dd_dthbrand').val();

        if(number == '')
        {
          swal({
			title: "Enter Card Number!",
			button: "OK",
		  });
        }
       else if(operator == '')
        {
          swal({
			title: "Select Operator!",
			button: "OK",
		  });
        }
		else
		{  
			$.ajax({
               type:"POST",
               url:"{{ url('/front_get_dth_roffer')}}",
               data:{"_token": "{{ csrf_token() }}", "cardnumber":number , "opt":opcode },
               success:function(result)
               {   
                    if(result == 'DATA NOT FOUND')
                    {
                        alert(result);
                    }
                    else
                    {
						$('#dd_brand').val(result['brand_id']);
                        $('#plans').empty();
					console.log(result['MSG']);
						if(result['MSG'] == 'DTH INFO FETCH SUCCESSFULLY')
						{
							$('#btntxt_desc').show();
							$('#plans').html('<span> Customer Name:- '+result['DTHINFO'][0].customerName+'</br> Balance:- '+result['DTHINFO'][0].Balance+'</br> Planname :- '+result['DTHINFO'][0].planname+'</br> Next Recharge Date:- '+result['DTHINFO'][0].NextRechargeDate+'</span>'); 
							$('#plansd').html('<span> Customer Name:- '+result['DTHINFO'][0].customerName+'</br> Balance:- '+result['DTHINFO'][0].Balance+'</br> Planname :- '+result['DTHINFO'][0].planname+'</br> Next Recharge Date:- '+result['DTHINFO'][0].NextRechargeDate+'</span>'); 
							$('#txt_amount').val(result['DTHINFO'][0].MonthlyRecharge);
						}
						else
						{
							$('#btntxt_desc').show();
							$('#plans').html('<span> '+result['MSG']+' </span>'); 
							$('#txt_amount').val('');
						}
                    }    
               }
            });
		}
}

 function select_plan_amo(prs) {
 $('#txt_amount').empty();
 $('#txt_amount').val(prs);
}
 </script>
@endsection