@extends('Front.FRONT10.main-layout')
@section('content')
  	<!-- Page Header
    ============================================= -->
    <section class="page-header page-header-text-light bg-secondary">
      <div class="container">
        <div class="row align-items-center">
          <div class="col-md-8">
            <h1>My Profile</h1>
          </div>
          <div class="col-md-4">
            <ul class="breadcrumb justify-content-start justify-content-md-end mb-0">
              <li><a href="index.html">Home</a></li>
              <li class="active">My Profile</li>
            </ul>
          </div>
        </div>
      </div>
    </section><!-- Page Header end -->

    
  <!-- Content
  ============================================= -->
  <div id="content">
    <div class="container">
      <div class="bg-light shadow-md rounded p-4">
        <div class="row">
          <div class="col-md-3">
            <ul class="nav nav-tabs flex-column" id="myTab" role="tablist">
              <li class="nav-item"> <a id="first-tab" data-toggle="tab" href="#firstTab" role="tab" aria-controls="firstTab" @if(collect(request()->segments())->last() == 'password' || collect(request()->segments())->last() == 'add-money-wallet') class="nav-link" aria-selected="false" @else class="nav-link active" aria-selected="true"  @endif>Personal Information</a> </li>
              <li class="nav-item"> <a id="second-tab" data-toggle="tab" href="#secondTab" role="tab" aria-controls="secondTab" @if(collect(request()->segments())->last() == 'password') aria-selected="true"class="nav-link active" @else aria-selected="false" class="nav-link" @endif>Change Password</a> </li>
<!--          <li class="nav-item"> <a class="nav-link" id="third-tab" data-toggle="tab" href="#thirdTab" role="tab" aria-controls="thirdTab" aria-selected="false">Favourites</a> </li> -->
              <li class="nav-item"> <a id="fourth-tab" data-toggle="tab" href="#fourthTab" role="tab" aria-controls="fourthTab"  @if(collect(request()->segments())->last() == 'add-money-wallet') aria-selected="true"class="nav-link active" @else aria-selected="false" class="nav-link" @endif>Add Money</a> </li>
            </ul>
          </div>
          <div class="col-md-9">
            <div class="tab-content my-3" id="myTabContentVertical">
              <div class="tab-pane fade @if(collect(request()->segments())->last() == 'password' || collect(request()->segments())->last() == 'add-money-wallet') @else show active  @endif " id="firstTab" role="tabpanel" aria-labelledby="first-tab">
                <div class="row">
                  <div class="col-lg-8">
      @if(Session::has('success')) 
        <div class="alert alert-success alert-dismissible  show" role="alert">
          <h4 class="alert-heading">{{ Session::get("success") }}</h4>
          <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
      @endif
      @if(Session::has('error')) 
        <div class="alert alert-danger alert-dismissible  show" role="alert">
          <h4 class="alert-heading">{{ Session::get("error") }}</h4>
          <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
      @endif
                    <h4 class="mb-4">Personal Information</h4>
                    <form id="personalInformation" method="post" action="{{url('update-user-info')}}">
                      @csrf
                      <div class="mb-3">
                        <div class="custom-control custom-radio custom-control-inline">
                          <input id="male" name="txt_profile" value="1" class="custom-control-input" required type="radio" {{$user[0]->MemberGender == 'Male'? 'checked':'' }}>
                          <label class="custom-control-label" for="male">Male</label>
                        </div>
                        <div class="custom-control custom-radio custom-control-inline">
                          <input id="female" name="txt_profile" value="2" class="custom-control-input" type="radio" {{$user[0]->MemberGender == 'Female'? 'checked':'' }}>
                          <label class="custom-control-label" for="female">Female</label>
                        </div>
                      </div>
                      <div class="form-group">
                        <label for="fullName">Full Name</label> 
                        <input type="text" name="txt_txt_fullName" value="{{$user[0]->MemberName}}" class="form-control" data-bv-field="txt_fullName" id="txt_fullName" required placeholder="Full Name">
                      </div>
                      <div class="form-group">
                        <label for="mobileNumber">Mobile Number</label>
                        <input type="text" name="txt_mobileNumber" value="{{$user[0]->MemberContactNo}}" class="form-control" data-bv-field="txt_mobilenumber" id="txt_mobileNumber" readonly>
                      </div>
                      <div class="form-group">
                        <label for="emailID">Email ID</label>
                        <input type="text" value="{{$user[0]->MemberEmail}}" name="txt_emailID" class="form-control" data-bv-field="txt_emailid" id="txt_emailID" readonly>
                      </div>
                      <div class="form-group">
                        <label for="birthDate">Date of Birth</label>
                        <input id="txt_birthDate" name="txt_birthDate" value="{{$user[0]->MemberDOB}}" type="text" class="form-control" required placeholder="Date of Birth">
                      </div>
                      <div class="form-group">
                        <label for="inputCountry">State</label>
                        <select class="custom-select" id="dd_state" name="dd_state" onchange="get_city_name()">
                          <option value=""> --- Please Select State--- </option>
                          @foreach($state as $key => $value)
                          <option value="{{$value->LOC_ID}}" {{$user[0]->MemberStateID == $value->LOC_ID? 'selected':''}}>{{$value->LOC_NAME}}</option>
                          @endforeach
                        </select>
                      </div>
                      <div class="form-group">
                        <label for="inputCountry">City</label>
                        <select class="custom-select" id="dd_city" name="dd_city">
                          @if($user[0]->MemberCityID != '') 
                          <option value="{{$user[0]->MemberCityID}}">{{$user[0]->MemberCity}}</option>
                          @else
                          <option value=""> --- Please Select State--- </option>
                          @endif
                        </select>
                      </div>
                      <button class="btn btn-primary" type="button" onclick="update_pro('personalInformation')">Update Now</button>
                    </form>
                  </div>
                  <div class="col-lg-4 mt-4 mt-lg-0 ">
                    <div class="card bg-light-3 p-3">
                      <p class="mb-2">We value your Privacy.</p>
                      <p class="text-1 mb-0">We will not sell or distribute your contact information. Read our <a href="{{url('privacy_policy')}}">Privacy Policy</a>.</p>
                   <!--    <hr>
                      <p class="mb-2">Billing Enquiries</p>
                      <p class="text-1 mb-0">Do not hesitate to reach our <a href="#">support team</a> if you have any queries.</p>
                     --></div>
                  </div>
                </div>
              </div>
              <div class="tab-pane fade  @if(collect(request()->segments())->last() == 'password')  show active @else  @endif " id="secondTab" role="tabpanel" aria-labelledby="second-tab">
                <div class="row">
                  <div class="col-lg-8">
      @if(Session::has('success')) 
        <div class="alert alert-success alert-dismissible  show" role="alert">
          <h4 class="alert-heading">{{ Session::get("success") }}</h4>
          <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
      @endif
      @if(Session::has('error')) 
        <div class="alert alert-danger alert-dismissible  show" role="alert">
          <h4 class="alert-heading">{{ Session::get("error") }}</h4>
          <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
      @endif
                    <h4 class="mb-4">Change Password</h4>
                    <form id="changePassword" method="post" action="{{url('user-change-password')}}">
                       @csrf
                      <div class="form-group">
                        <input type="password" name="txt_oldpassword" class="form-control" data-bv-field="existingpassword" id="txt_oldpassword" required placeholder="Existing Password">
                      </div>
                      <div class="form-group">
                        <input type="password" name="txt_newpassword" class="form-control" data-bv-field="newpassword" id="txt_newpassword" required placeholder="New Password">
                      </div>
                      <div class="form-group">
                        <input type="password" name="txt_newcpassword" class="form-control" data-bv-field="confirmgpassword" id="txt_newcpassword" required placeholder="Confirm Password">
                      </div>
                      <button class="btn btn-primary" type="submit">Update Password</button>
                    </form>
                  </div>
                  <div class="col-lg-4 mt-4 mt-lg-0 ">
                    <div class="card bg-light-3 p-3">
                      <p class="mb-2">We value your Privacy.</p>
                      <p class="text-1 mb-0">We will not sell or distribute your contact information. Read our <a href="{{url('privacy_policy')}}">Privacy Policy</a>.</p>
                      <hr>
                  <!--     <p class="mb-2">Billing Enquiries</p>
                      <p class="text-1 mb-0">Do not hesitate to reach our <a href="#">support team</a> if you have any queries.</p> -->
                    </div>
                  </div>
                </div>
              </div>
              <div class="tab-pane fade" id="thirdTab" role="tabpanel" aria-labelledby="third-tab">
                <h4 class="mb-4">Your Saved Connections</h4>
                <div class="table-responsive-lg">
                  <table class="table table-hover border">
                    <tbody>
                      <tr>
                        <td class="text-center align-middle"><img class="border p-1 rounded bg-light" src="images/brands/operator/vodafone.jpg" alt=""></td>
                        <td class="text-center align-middle">9898989898</td>
                        <td class="text-center align-middle">Vodafone</td>
                        <td class="align-middle">
                        <div class="d-flex justify-content-end">
                        <button class="btn btn-sm btn-outline-primary shadow-none text-nowrap" type="submit">Recharge Now</button>
                          <button class="btn btn-sm btn-outline-secondary shadow-none ml-1" type="submit" data-toggle="tooltip" data-original-title="Edit"><i class="fas fa-edit"></i></button></div></td>
                      </tr>
                      <tr>
                        <td class="text-center align-middle"><img class="border p-1 rounded bg-light" alt="" src="images/brands/operator/vodafone.jpg"></td>
                        <td class="text-center align-middle">9696969696</td>
                        <td class="text-center align-middle">Vodafone</td>
                        <td class="align-middle">
                        <div class="d-flex justify-content-end">
                        <button class="btn btn-sm btn-outline-primary shadow-none text-nowrap" type="submit">Recharge Now</button>
                          <button class="btn btn-sm btn-outline-secondary shadow-none ml-1" type="submit" data-toggle="tooltip" data-original-title="Edit"><i class="fas fa-edit"></i></button></div></td>
                      </tr>
                    </tbody>
                  </table>
                </div>
              </div>
              <div class="tab-pane fade @if(collect(request()->segments())->last() == 'add-money-wallet')  show active @else  @endif" id="fourthTab" role="tabpanel" aria-labelledby="fourth-tab">
                <div class="row">
                  <div class="col-lg-10">
      @if(Session::has('success')) 
        <div class="alert alert-success alert-dismissible  show" role="alert">
          <h4 class="alert-heading">{{ Session::get("success") }}</h4>
          <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
      @endif
      @if(Session::has('error')) 
        <div class="alert alert-danger alert-dismissible  show" role="alert">
          <h4 class="alert-heading">{{ Session::get("error") }}</h4>
          <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
      @endif
                    <h4>Add Money in {{ config('SITE_NAME') }} Wallet</h4>
					<p>Select Amount</p>
                    <form id="payment" method="post" action="{{url('add-money-wallet')}}">
						@csrf
                      <div class="form-group">
                        <input type="text" class="form-control" data-bv-field="cardnumber" name="txt_amount" id="txt_amount" required placeholder="0" readonly>
                      </div>
                      <div class="form-row">
                        <div class="col-lg-12">
                          <div class="form-group">
							<button class="btn btn-sm btn-outline-primary shadow-none text-nowrap" type="button" style="margin: 5px;" onclick="AddAmWall('1')">+1</button >
							<button class="btn btn-sm btn-outline-primary shadow-none text-nowrap" type="button" style="margin: 5px;" onclick="AddAmWall('100')">+100</button>
							<button class="btn btn-sm btn-outline-primary shadow-none text-nowrap" type="button" style="margin: 5px;" onclick="AddAmWall('200')">+200</button>
							<button class="btn btn-sm btn-outline-primary shadow-none text-nowrap" type="button" style="margin: 5px;" onclick="AddAmWall('500')">+500</button>
							<button class="btn btn-sm btn-outline-primary shadow-none text-nowrap" type="button" style="margin: 5px;" onclick="AddAmWall('1000')">+1000</button>
							<button class="btn btn-sm btn-outline-primary shadow-none text-nowrap" type="button" style="margin: 5px;" onclick="AddAmWall('2000')">+2000</button>
                          </div>
                        </div>
                      </div>
                      <button class="btn btn-primary" type="button"  onclick="payment_wall('payment')">Continue</button>
                    </form>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
<!-- Content end -->  

<form action="{{url('/payment-completebtoc-addmoneywall')}}" method="POST" hidden>
        <input type="hidden" value="{{csrf_token()}}" name="_token" /> 
        <input type="text" class="form-control" id="rzp_paymentid"  name="rzp_paymentid">
        <input type="text" class="form-control" id="rzp_orderid" name="rzp_orderid">
        <input type="text" class="form-control" id="rzp_signature" name="rzp_signature">
        <input type="text" class="form-control" id="user_code" name="user_code">
        <input type="text" class="form-control" id="txt_amounts" name="txt_amounts">
        <input type="text" class="form-control" id="receiptId" name="receiptId">
        
    <button type="submit" id="rzp-paymentresponse" class="btn btn-primary">Submit</button>
</form>

<form action="{{url('/payment-failedbtoc-addmoneywall')}}" method="POST" hidden>
        <input type="hidden" value="{{csrf_token()}}" name="_token" /> 
        <input type="text" class="form-control" id="rzp_paymentid"  name="rzp_paymentid">
        <input type="text" class="form-control" id="rzp_orderid" name="rzp_orderid">
        <input type="text" class="form-control" id="rzp_signature" name="rzp_signature">
        <input type="text" class="form-control" id="user_code" name="user_code">
        <input type="text" class="form-control" id="txt_amounts" name="txt_amounts">
        <input type="text" class="form-control" id="receiptId" name="receiptId">
        
    <button type="submit" id="rzp-paymentresponse" class="btn btn-primary">Submit</button>
</form>

<script src="https://checkout.razorpay.com/v1/checkout.js"></script>
<button id="rzp-button1" hidden>Pay</button> 

<script>
function AddAmWall(id){
	$('#txt_amount').val(id);
}

$(function() {
 'use strict';
  // Depart Date
  $('#birthDate').daterangepicker({
	singleDatePicker: true,
	"showDropdowns": true,
	autoUpdateInput: false,
	maxDate: moment().add(0, 'days'),
	}, function(chosen_date) {
  $('#birthDate').val(chosen_date.format('MM-DD-YYYY'));
  });
 });


        function get_city_name() {
        var id = $('#dd_state').val();
        if(id > 0)
        {
            $.ajax({
               type:"POST",
               url:"{{ url('/get-city')}}",
               data:{"_token": "{{ csrf_token() }}", "id":id },
               success:function(result)
               {   
                    if(result == 'DATA NOT FOUND')
                    {
                        alert(result);
                    }
                    else
                    {
                      console.log(result);
                        $('#dd_city').empty();
                        $("#dd_city").append('<option value=""> --- Please Select State--- </option>');
                        $.each(result,function(key,value){
                            $("#dd_city").append('<option value="'+result[key].LOC_ID+'">'+result[key].LOC_NAME+'</option>');
                        });
                        $('.selectpicker').selectpicker('refresh');
                    }    
               }
            });
        }
        } 



function payment_wall(id) {
	var txt_amount = $('#txt_amount').val();
	if(txt_amount < 1)
	{
		swal({
			title: "Select Any one option!",
			buttons: true,
			dangerMode: true,
		  })
	}
	else if(txt_amount > 2000)
	{
		swal({
			title: "maximum limit Rs 2000 !",
			buttons: true,
			dangerMode: true,
		  })
	}
	else
	{
	   swal({
			title: "Rs "+txt_amount+".00",
			text: "Are you sure Add Money in Wallet?",
			buttons: true,
			dangerMode: true,
		  })
		  .then((willDelete) => {
			if (willDelete) {
					
				$.ajax({
				   type:"POST",
				   url:"{{ url('b2crazorpay')}}",
				   data:{"_token": "{{ csrf_token() }}", "txt_amount":txt_amount },
				   success:function(result)
				   {   	

				var options = {
					"key": result[1].razorpayId, // Enter the Key ID generated from the Dashboard
					"amount":result[1].amount, // Amount is in currency subunits. Default currency is INR. Hence, 50000 refers to 50000 paise
					"currency": result[1].currency,
					"name": result[1].name,
					"description": result[1].description,
					"user_code":result[1].user_code,
					"image": "{{asset('/images/config/logo/'.config('SITE_LOGO') ) }}", // You can give your logo url 
					"order_id": result[1].orderId, //This is a sample Order ID. Pass the `id` obtained in the response of Step 1
					"handler": function (response){
						// After payment successfully made response will come here
						// send this response to Controller for update the payment response
						// Create a form for send this data
						// Set the data in form
						document.getElementById('rzp_paymentid').value = response.razorpay_payment_id;
						document.getElementById('rzp_orderid').value = response.razorpay_order_id;
						document.getElementById('rzp_signature').value = response.razorpay_signature;
						document.getElementById('user_code').value = result[1].user_code;
						document.getElementById('txt_amounts').value = result[2].txt_amount;
						document.getElementById('receiptId').value = result[1].receiptId;

						document.getElementById('rzp-paymentresponse').click();
					},
					"prefill": {
						"name": result[1].name,
						"email": result[1].email,
						"contact": result[1].contactNumber
					},
					"notes": {
						"address": result[1].address
					},
					"theme": {
						"color": "{{config('SITE_BTN_BG')}}"
					}
				};
				var rzp1 = new Razorpay(options);
				rzp1.on('payment.failed', function (response){
						document.getElementById('rzp_paymentid').value = response.error.metadata.payment_id;
						document.getElementById('rzp_orderid').value = response.error.metadata.order_id;
						document.getElementById('rzp_signature').value = response.error.description+' ['+ response.error.code +' ] '+' [ '+ response.error.reason +' ]';
						document.getElementById('user_code').value = result[1].user_code;
						document.getElementById('txt_amounts').value = result[2].txt_amount;
						document.getElementById('receiptId').value = result[1].receiptId;
				});

				rzp1.open();
				e.preventDefault();
						
				   }
				});
			}
		  }); 
	  }
 }


function update_pro(id) {
   swal({
        title: "Are you sure update Profile?",
        //text: "Once deleted, you will not be able to recover this imaginary file!",
        //icon: "warning",
        buttons: true,
        dangerMode: true,
      })
      .then((willDelete) => {
        if (willDelete) {
         document.getElementById(id).submit();
        }
      });
 }


</script>
@endsection