@extends('Front.FRONT10.main-layout')
@section('content')

<section class="page-content container section bg-light shadow-md rounded px-5">
        <div class="row">
          
          <!-- Mobile Recharge
          ============================================= -->
          <div class="col-lg-4 mb-4 mb-lg-0">
            <h2 class="text-4 mb-3">Mobile Recharge or Bill Payment</h2>
            <form id="recharge-bill" action="{{url('do-recharge')}}" method="post">
              @csrf
              <div class="form-group">
                <input type="text" class="form-control" data-bv-field="number" id="txt_mobileno"  name="txt_mobileno"   oninput="get_plan_and_last_rech(this.id)" required placeholder="Enter Mobile Number" value="{{Session()->get('txt_mobileno')}}">
              </div>
              <div class="form-group">
                <select class="custom-select" id="dd_brand" name="dd_brand" required="">
                  <option value="">Select Your Operator</option>
            				@foreach($OPERATOR as $value)
                              <option value="{{$value->TelecomBrandId}}" {{Session()->get('dd_brand') == $value->TelecomBrandId? 'Selected':''}}>{{$value->BrandName}}</option>
            				@endforeach
                </select>
				<input type="hidden" id="txt_circleid" name="txt_circleid" class="form-control" required="required">
				<input type="hidden" id="txt_circlecode" name="txt_circlecode" class="form-control" required="required">
              </div>
              <div class="form-group input-group">
                <div class="input-group-prepend"> <span class="input-group-text">&#x20B9;</span> </div>
                <a href="#" class="view-plans-link" onclick="show_plans_fun()">View Plans</a>
                <input class="form-control" id="txt_amount" name="txt_amount" placeholder="Enter Amount"  value="{{Session()->get('txt_amount')}}" required type="text">
              </div>
			@if(Session::get('B2C_USER_ID') != '' && Session::get('B2C_USER_ROLE') == 'B2CUSER')
              <div class="mb-3">
                <div class="custom-control custom-radio custom-control-inline">
                  <input id="prepaid" name="payment_type" value="1" class="custom-control-input" {{Session()->get('txt_amount') == 1? 'checked':''}} {{Session()->get('txt_amount') == 2? '':'checked'}} required type="radio">
                  <label class="custom-control-label" for="prepaid">Pay Wallet</label>
                </div>
                <div class="custom-control custom-radio custom-control-inline">
                  <input id="postpaid" name="payment_type" value="2" class="custom-control-input" {{Session()->get('txt_amount') == 2? 'checked':''}}  required type="radio">
                  <label class="custom-control-label" for="postpaid">Pay Credit/Debit Card</label>
                </div>
              </div>
			@else
			<input id="prepaid" name="payment_type" value="1" class="custom-control-input" checked required type="hidden">
			@endif
              <button class="btn btn-primary btn-block" type="button" onclick="conformsubmit('recharge-bill')">Continue to Recharge</button>
            </form>
          </div><!-- Mobile Recharge end -->
          
          <!-- Slideshow
          ============================================= -->
          <div class="col-lg-8">
            <div class="owl-carousel owl-theme slideshow single-slider">
			@foreach($banners as $value)
              <div class="item"><a href="#"><img class="img-fluid" src="{{asset('images/front/'. $value->BANNER_IMG)}}" alt="{{ $value->BANNER_DESC}}" /></a></div>
			@endforeach
            </div>
          </div><!-- Slideshow end -->
          
        </div>
    
    </section>
    <!--div class="page-content container section bg-light shadow-md rounded px-5">
      <section class="">
	
        <h2 class="text-9 font-weight-500 text-center">Featured Offers</h2>
        <p class="lead text-center mb-4">Get Best Offers &amp; Discounts</p>
        <div class="row banner">
          <div class="col-md-6">
            <div class="item rounded"> <a href="#">
              <div class="caption">
                <h2>Save 20% on Recharge &amp; Bill</h2>
                <p>Use Code: Recharge20</p>
              </div>
              <div class="banner-mask"></div>
              <img class="img-fluid" src="{{asset('FRONT9/images/slider/small-banner-11-600x220.jpg')}}" alt="banner"> </a> </div>
          </div>
          <div class="col-md-6">
            <div class="item rounded"> <a href="#">
              <div class="caption">
                <h2>5% OFF on Bill Payment</h2>
                <p>Use Code: Bill5</p>
              </div>
              <div class="banner-mask"></div>
              <img class="img-fluid" src="{{asset('FRONT9/images/slider/small-banner-12-600x220.jpg')}}" alt="banner"> </a> </div>
          </div>
        </div>
        <div class="row banner mt-4 mb-2">
          <div class="col-md-4">
            <div class="item rounded"> <a href="#">
              <div class="caption">
                <h2>10% OFF</h2>
                <p>On Metro Booking</p>
              </div>
              <div class="banner-mask"></div>
              <img class="img-fluid" src="{{asset('FRONT9/images/slider/small-banner-13-600x320.jpg')}}" alt="banner"> </a> </div>
          </div>
          <div class="col-md-4 mt-4 mt-md-0">
            <div class="item rounded"> <a href="#">
              <div class="caption">
                <h2>15% OFF</h2>
                <p>On electricity Bill Payment</p>
              </div>
              <div class="banner-mask"></div>
              <img class="img-fluid" src="{{asset('FRONT9/images/slider/small-banner-14-600x320.jpg')}}" alt="banner"> </a> </div>
          </div>
          <div class="col-md-4 mt-4 mt-md-0">
            <div class="item rounded"> <a href="#">
              <div class="caption">
                <h2>10% OFF</h2>
                <p>On DTH Recharge</p>
              </div>
              <div class="banner-mask"></div>
              <img class="img-fluid" src="{{asset('FRONT9/images/slider/small-banner-15-600x320.jpg')}}" alt="banner"> </a> </div>
          </div>
        </div>
     
      </section>
    </div-->
  
      <section class="page-content container section shadow-md rounded px-5" style="background-image: url(/public/FRONT9/images/42.png);
    height: 445px;background-color: #fbe5cd;">
        
      </section>


<!-- Back to Top
============================================= -->
<a id="back-to-top" data-toggle="tooltip" title="Back to Top" href="javascript:void(0)"><i class="fa fa-chevron-up"></i></a>
<!-- Modal Dialog - View Plans
============================================= -->
<div id="view-plans" class="modal fade" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Plans</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"> <span aria-hidden="true">×</span> </button>
      </div>
          <div class="modal-body">
            <button class="btn btn-primary btn-block" type="submit">View Plans</button>
          </div>
        <div class="plans">
          <div class="table-responsive-md">
            <table class="table table-hover border" id="plans">
              <tbody>
                <tr><td class='text-5 text-primary text-center align-middle'>&#x20B9; NA <span class='text-1 text-muted d-block'>Amount</span></td><td class='text-1 text-muted align-middle'>Talktime &#x20B9; NA</td><td class='align-middle'><button class='btn btn-sm btn-outline-primary shadow-none text-nowrap' type='button'>Recharge Now</button></td></tr>
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
  </div>
<!-- Modal Dialog - View Plans end -->



<!-- Modal Dialog - View Plans
============================================= -->
<div id="view-info" class="modal fade" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Recharge Info</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"> <span aria-hidden="true">×</span> </button>
      </div>
          <div class="modal-body">
            <h5>Phone Number :  <span id="ph"></span></h5>
            <h5>Operator : <span id="op"></span></h5>
            <h5>Amount : <span id="am"></span></h5>
            <h5>Payment Type : <span id="pt"></span></h5>
          </div>
        <div class="modal-footer">
          <button class='btn btn-sm btn-outline-primary shadow-none text-nowrap' type='button'  data-dismiss="modal" aria-label="Close">Cancel</button>
          <button class='btn btn-sm btn-outline-success shadow-none text-nowrap' type='button' onclick="recharge_now('recharge-bill')">Recharge Now</button>
        </div>
      </div>
    </div>
  </div>
<!-- Modal Dialog - View Plans end -->
@if(Session::has('message'))
<script type="text/javascript">
      swal({
        title: "{{Session::get('message')}}",
        //icon: "{{Session::get('type')}} ",
        button: "OK",
      });
</script>
@endif


<!-- This form is hidden -->
<form action="{{url('/payment-completebtoc')}}" method="POST" hidden>
        <input type="hidden" value="{{csrf_token()}}" name="_token" /> 
        <input type="text" class="form-control" id="rzp_paymentid"  name="rzp_paymentid">
        <input type="text" class="form-control" id="rzp_orderid" name="rzp_orderid">
        <input type="text" class="form-control" id="rzp_signature" name="rzp_signature">
        <input type="text" class="form-control" id="user_code" name="user_code">
        <input type="text" class="form-control" id="txt_amounts" name="txt_amount">
        <input type="text" class="form-control" id="txt_mobilenos" name="txt_mobileno">
        <input type="text" class="form-control" id="dd_brands" name="dd_brand">
        <input type="text" class="form-control" id="txt_circleids" name="txt_circleid">
        <input type="text" class="form-control" id="txt_circlecodes" name="txt_circlecode">
        <input type="text" class="form-control" id="payment_types" name="payment_type">
		<input type="text" class="form-control" id="receiptId" name="receiptId">
        
    <button type="submit" id="rzp-paymentresponse" class="btn btn-primary">Submit</button>
</form>

<form action="{{url('/payment-failedbtoc-addmoneywall')}}" method="POST" hidden>
        <input type="hidden" value="{{csrf_token()}}" name="_token" /> 
        <input type="text" class="form-control" id="rzp_paymentid"  name="rzp_paymentid">
        <input type="text" class="form-control" id="rzp_orderid" name="rzp_orderid">
        <input type="text" class="form-control" id="rzp_signature" name="rzp_signature">
        <input type="text" class="form-control" id="user_code" name="user_code">
        <input type="text" class="form-control" id="txt_amounts" name="txt_amounts">
        <input type="text" class="form-control" id="receiptId" name="receiptId">
        
    <button type="submit" id="rzp-paymentresponse" class="btn btn-primary">Submit</button>
</form>

<script src="https://checkout.razorpay.com/v1/checkout.js"></script>
 <script>
  function recharge_now(form_id) {
	var check	= "{{Session::get('B2C_USER_ID')}}";
	if(check)
	{
			 var txt_mobileno = $("#txt_mobileno").val();
			 var dd_brand = $("#dd_brand").val();
			 var txt_amount = $("#txt_amount").val();
			 var payment_type = $("input[name='payment_type']:checked").val()
			 var txt_circleid = $("#txt_circleid").val();
			 var txt_circlecode = $("#txt_circlecode").val();

				$.ajax({
				   type:"POST",
				   url:"{{ url('b2crazorpay')}}",
				   data:{"_token": "{{ csrf_token() }}", "txt_amount":txt_amount },
				   success:function(result)
				   {   	

						var options = {
										"key": result[1].razorpayId, // Enter the Key ID generated from the Dashboard
										"amount":result[1].amount, // Amount is in currency subunits. Default currency is INR. Hence, 50000 refers to 50000 paise
										"currency": result[1].currency,
										"name": result[1].name,
										"description": result[1].description,
										"user_code":result[1].user_code,
										"image": "{{asset('/images/config/logo/'.config('SITE_LOGO') ) }}", // You can give your logo url 
										"order_id": result[1].orderId, //This is a sample Order ID. Pass the `id` obtained in the response of Step 1
										"handler": function (response){
											// After payment successfully made response will come here
											// send this response to Controller for update the payment response
											// Create a form for send this data
											// Set the data in form
											document.getElementById('rzp_paymentid').value = response.razorpay_payment_id;
											document.getElementById('rzp_orderid').value = response.razorpay_order_id;
											document.getElementById('rzp_signature').value = response.razorpay_signature;
											document.getElementById('user_code').value = result[1].user_code;
											document.getElementById('txt_amounts').value = result[2].txt_amount;
											document.getElementById('receiptId').value = result[1].receiptId;
											document.getElementById('txt_mobilenos').value = txt_mobileno;
											document.getElementById('dd_brands').value = dd_brand;
											document.getElementById('txt_circleids').value = txt_circleid;
											document.getElementById('txt_circlecodes').value = txt_circlecode;
											document.getElementById('payment_types').value = payment_type;

											document.getElementById('rzp-paymentresponse').click();
										},
										"prefill": {
											"name": result[1].name,
											"email": result[1].email,
											"contact": result[1].contactNumber
										},
										"notes": {
											"address": result[1].address
										},
										"theme": {
											"color": "{{config('SITE_BTN_BG')}}"
										}
									};
									var rzp1 = new Razorpay(options);
									rzp1.on('payment.failed', function (response){
											document.getElementById('rzp_paymentid').value = response.error.metadata.payment_id;
											document.getElementById('rzp_orderid').value = response.error.metadata.order_id;
											document.getElementById('rzp_signature').value = response.error.description+' ['+ response.error.code +' ] '+' [ '+ response.error.reason +' ]';
											document.getElementById('user_code').value = result[1].user_code;
											document.getElementById('txt_amounts').value = result[2].txt_amount;
											document.getElementById('receiptId').value = result[1].receiptId;
									});
									
									
									$('#view-info').modal('hide');
									rzp1.open();
									e.preventDefault();
					}
				});
		}
		else
		{
			document.getElementById(form_id).submit();
		}
  }


  function conformsubmit(id) {
     var txt_mobileno = $("#txt_mobileno").val();
     var dd_brand = $("#dd_brand").val();
     var txt_amount = $("#txt_amount").val();
     var payment_type = $("input[name='payment_type']:checked").val()
     var dd_brand_name = $("#dd_brand option:selected").text();

    if(txt_mobileno == '')
    {
      swal({
        title: "Enter Phone Number!",
        button: "OK",
      });
    }
    else if(txt_mobileno.length != 10)
    {
      swal({
        title: "Enter valid Phone Number!",
        button: "OK",
      });
    }
    else if(dd_brand == '')
    {
      swal({
        title: "Select Operator!",
        button: "OK",
      });
    }
    else if(txt_amount == '')
    {
      swal({
        title: "Enter Amount!",
        button: "OK",
      });
    }
    else
    {

      if(payment_type == 1)
      {
        var pt_name = 'Pay Wallet';
      }     
      if(payment_type == 2)
      {
        var pt_name = 'Pay Credit/Debit Card';
      }

      $('#ph').html(txt_mobileno);
      $('#op').html(dd_brand_name);
      $('#am').html(txt_amount);
      $('#pt').html(pt_name);
      $('#view-info').modal('show');
    }
  }



 function get_plan_and_last_rech(id) {
        var phone = $("#"+id).val();
        if(phone.length == 10)
        {
            $.ajax({
               type:"POST",
               url:"{{ url('/front_check_mobile_roffer')}}",
               data:{"_token": "{{ csrf_token() }}", "mobile":phone },
               success:function(result)
               {   
                    if(result == 'DATA NOT FOUND')
                    {
                        alert(result);
                    }
                    else
                    {
						$('#dd_brand').val(result['brand_id']);
						$('#txt_circleid').val(result['circle_id']);
						$('#txt_circlecode').val(result['circle_code']);
                        $('#plans').empty();
						if(result['ROFFER'][0].desc != 'Unable to Plans')
						{
                        $.each(result['ROFFER'],function(key,value){
                            $("#plans").append("<tr><td class='text-5 text-primary text-center align-middle'>&#x20B9; "+result['ROFFER'][key].rs+" <span class='text-1 text-muted d-block'>Amount</span></td><td class='text-1 text-muted align-middle'>Talktime &#x20B9; "+result['ROFFER'][key].desc+"</td><td class='align-middle'><button class='btn btn-sm btn-outline-primary shadow-none text-nowrap' type='button'  onclick='select_plan_amo("+result['ROFFER'][key].rs+")'>Recharge Now</button></td></tr>");
                        });
						}
						else
						{
								$("#plans").append("  <tr><td class='text-5 text-primary text-center align-middle'>&#x20B9; NA <span class='text-1 text-muted d-block'>Amount</span></td><td class='text-1 text-muted align-middle'>Talktime &#x20B9; NA</td><td class='align-middle'><button class='btn btn-sm btn-outline-primary shadow-none text-nowrap' type='button'  onclick='select_plan_amo(0)'>Recharge Now</button></td></tr>");
						}
					$("#plans").append("</tbody>");
                       
                    }    
               }

            });
        }
        }

 function select_plan_amo(prs) {
 $('#txt_amount').empty();
 $('#txt_amount').val(prs);
}

function show_plans_fun()
{
	var phone = $("#txt_mobileno").val();
	var op = $("#dd_brand").val();
	if($("#txt_mobileno").val() == '')
		{
			swal({
			  title: "Please Enter Phone Number!",
			  icon: "warning",
			  button: "OK",
			});
		}
		else if($("#dd_brand").val() == '')
		{
				swal({
				  title: "Please Select Operator!",
				  icon: "warning",
				  button: "OK",
				});
		}
		else
		{
			$('#view-plans').modal('show');
		}
}

 function select_plan_amo(prs) {
 $('#txt_amount').empty();
 $('#txt_amount').val(prs);
 $('#view-plans').modal('hide');
}
 </script>

@endsection