@extends('Front.FRONT10.main-layout')
@section('content')  
  	<!-- Page Header
    ============================================= -->
    <section class="page-header page-header-text-light bg-secondary">
      <div class="container">
        <div class="row align-items-center">
          <div class="col-md-8">
            <h1>Account Statement</h1>
          </div>
          <div class="col-md-4">
            <ul class="breadcrumb justify-content-start justify-content-md-end mb-0">
              <li><a href="index.html">Home</a></li>
              <li class="active">Account</li>
            </ul>
          </div>
        </div>
      </div>
    </section><!-- Page Header end -->
    
  <!-- Content
  ============================================= -->
  <div id="content">
    <div class="container">
      <div class="bg-light shadow-md rounded p-4">
        <form id="recharge-history" action="{{url('account-statement')}}" class="form-row mb-4 mb-sm-2" method="post">
          @csrf
          <div class="col-12 col-sm-6 col-md-3">
            <div class="form-group">
              <label for="birthDate">From Date</label>
              <input id="txt_birthDate" name="txt_fromdate" value="{{$start}}" type="date" class="form-control" required placeholder="Form Date">
            </div>
          </div>          
          <div class="col-12 col-sm-6 col-md-3">
            <div class="form-group">
              <label for="birthDate">To Date</label>
              <input id="txt_birthDate" name="txt_todate" value="{{$end}}" type="date" class="form-control" required placeholder="To Date">
            </div>
          </div>
          <div class="col-12 col-sm-6 col-md-4">
            <div class="form-group">
              <label for="records">Number Of Records</label>
              <select class="custom-select" id="records" name="txt_noofrecords" required="">
                <option value="20" {{$txt_noofrecords == '20'? 'selected':''}}>20 Records</option>
                <option value="50" {{$txt_noofrecords == '50'? 'selected':''}}>50 Records</option>
                <option value="100" {{$txt_noofrecords == '100'? 'selected':''}}>100 Records</option>
                <option value="200" {{$txt_noofrecords == '200'? 'selected':''}}>200 Records</option>
                <option value="500" {{$txt_noofrecords == '500'? 'selected':''}}>500 Records</option>
                <option value="1000" {{$txt_noofrecords == '1000'? 'selected':''}}>1000 Records</option>
              </select>
            </div>
          </div>
          <div class="col-12 col-sm-6 col-md-2">

              <label for="records" style="color: #ffffff;">Filter Button</label>
            <button class="btn btn-primary btn-block" type="submit">Filter</button>
          </div>
        </form>
        <div class="plans page">
          <div class="table-responsive-md">
            <table class="table table-hover border">
              <tbody>
                @foreach($ledger_report as $key => $value)
                <tr>
                  <td class="text-5 text-primary text-center align-middle">{{$value->Transactionid}} <span class="text-1 text-muted d-block">Transaction Number</span></td>
                  <td class="text-3 text-center align-middle"><i class="fas fa-rupee-sign"></i>{{substr($value->AmountCredited, 0, -2)}} <span class="text-1 text-muted d-block">Credit</span></td>
                  <td class="text-3 text-center align-middle"><i class="fas fa-rupee-sign"></i>{{substr($value->AmountDedited, 0, -2)}} <span class="text-1 text-muted d-block">Debit</span></td>
                  <td class="text-1 text-muted align-middle">{{$value->Description}}, Transaction Date :  {{$value->TransactionDate}}</td>
                </tr>
                @endforeach
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
  </div><!-- Content end -->

@endsection