@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Master Panel</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{ url('/') }}"><i class="demo-pli-home"></i></a></li>
        <li><a href="{{ url('/') }}">Dashboard</a></li>
        <li class="active">INVOICE ENTRY LISTING</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>

    @if ($errors->any())
    <div class="alert alert-danger">
        <ul>
            @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
    @endif

    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">

        <div class="row">
            
                <div class="panel">

                    <div class="panel-heading">
                        <div class="panel-control">
                            <button class="btn btn-default" data-panel="minmax"><i class="demo-psi-chevron-up"></i></button>
                        </div>
                        <h3 class="panel-title">Invoice Entry Search</h3>
                    </div>

                    <div class="collapse in">
        
                        <form action="" method="POST">
                            {{ csrf_field() }}
                            <div class="panel-body">
                                <div class="row">
                                    <div class="col-sm-2">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_fromdate">From</label>
                                            <div id="demo-dp-txtinput">
                                                <input type="text" name="txt_fromdate" id="txt_fromdate" class="form-control" placeholder="dd/mm/yyyy" autocomplete="off" required>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-sm-2">   
                                        <div class="form-group">
                                            <label class="control-label" for="txt_todate">To</label>
                                            <div id="demo-dp-txtinput">
                                                <input type="text" name="txt_todate" id="txt_todate" class="form-control" placeholder="dd/mm/yyyy" autocomplete="off" required>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-sm-2">   
                                        <div class="form-group">
                                            <label class="control-label">&nbsp;</label>
                                            <div>
                                                <button class="btn btn-success" type="submit">Search</button>
                                            </div>
                                        </div>
                                    </div>

                                </div>    
                            </div>
                        </form>
                    </div>
        
                </div>
            
        </div>

        <div class="row">
            <div class="panel">
                
                <div class="panel-body">
                    <table id="demo-dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
                        <thead>
                            <tr>
                                <th>S.NO.</th>
                                <th>User Name</th>
                                <th class="min-tablet">Invoice Number</th>
                                <th class="min-tablet">Package</th>
                                <th class="min-tablet">PAN No.</th>
                                <th class="min-tablet">Net Amount</th>
                                <th class="min-tablet">Created On</th>
                                <th class="min-tablet">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($invoice as $value)
                            <tr>
                                <td>#</td>
                                <td>{{$value->m45_buy_user_name}}</td>
                                <td>{{$value->m45_buy_invoiceid}}</td>
                                <td>{{$value->m45_buy_package}}</td>
                                <td>{{$value->m45_buy_panno}}</td>
                                <td>{{$value->m45_buy_net_amt}}</td>
                                <td>{{$value->m45_buy_prod_date}}</td>
                                <td><a class="btn btn-success btn-xs" href="">EDIT</a></td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
        
            </div>
        </div>


        
            
    </div>
    <!--===================================================-->
    <!--End page content-->

</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->
@endsection

