@extends('mainlayout')
@section('content')
<style type="text/css">
ul.dropdown {
    position: absolute !important;
    z-index: 1 !important;
    top: 44% !important;
    left: 9% !important;
    display: block !important;
}
</style>
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">User Panel</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{ url('/') }}"><i class="demo-pli-home"></i></a></li>
        <li><a href="{{ url('/') }}">Dashboard</a></li>
        <li class="active">INVOICE ENTRY</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>

    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">

        @if ($errors->any())
        <div class="alert alert-danger">
            <ul>
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
        @endif

        <div class="row">
            
            <div class="panel">
                <div class="panel-heading">
                    <div class="panel-control">
                        <button class="btn btn-default" data-panel="minmax"><i class="demo-psi-chevron-up"></i></button>
                    </div>
                    <h3 class="panel-title">INVOICE ENTRY</h3>
                </div>

                <div class="collapse in">
                    <form class="form-horizontal" action="{{url('finvoice_entry')}}" method="POST">
                        {{ csrf_field() }}
                        <div class="panel-body">
                            <div class="row">  

                                <div class="col-md-6 col-xs-12">
                                    <div class="form-group">
                                      <label class="control-label col-md-4 col-xs-12">User ID *</label>
                                      <div class="col-md-8 col-xs-12">
                                        <input type="text" id="txt_userid" name="txt_userid" class="form-control" placeholder="Enter User ID." onkeyup="getuser();" required>
                                        <input type="hidden" id="txt_uid" name="txt_uid">
                                        <input type="hidden" id="txt_mobileno" name="txt_mobileno">
                                      </div>
                                    </div>
                                </div>

                                <div class="col-md-6 col-xs-12">
                                    <div class="form-group">
                                      <label class="control-label col-md-4 col-xs-12">Name</label>
                                      <div class="col-md-8 col-xs-12">
                                        <input type="text" id="txt_name" name="txt_name" class="form-control" required>
                                      </div>
                                    </div>
                                </div>

                                <div class="col-md-6 col-xs-12">
                                    <div class="form-group">
                                      <label class="control-label col-md-4 col-xs-12">Package *</label>
                                      <div class="col-md-8 col-xs-12">
                                        <select class="form-control" name="dd_package" id="dd_package" onchange="get_packamt(this.id);" required>
                                            <option value="-1">SELECT PACKAGE</option>
                                            @foreach($package as $pckg)
                                            <option value="{{$pckg->PACKAGE_ID}}">{{$pckg->PACKAGE_NAME}}</option>
                                            @endforeach
                                        </select>
                                      </div>
                                    </div>
                                </div>

                                <div class="col-md-6 col-xs-12">
                                    <div class="form-group">
                                      <label class="control-label col-md-4 col-xs-12">Package Amount</label>
                                      <div class="col-md-8 col-xs-12">
                                        <input type="text" id="txt_walletbal" name="txt_walletbal" class="form-control" placeholder="Enter Package Amount.">
                                      </div>
                                    </div>
                                </div>

                                <div class="col-md-6 col-xs-12">
                                    <div class="form-group">
                                      <label class="control-label col-md-4 col-xs-12">PAN No. *</label>
                                      <div class="col-md-8 col-xs-12">
                                        <input type="text" id="txt_panno" name="txt_panno" class="form-control" placeholder="Enter PAN No." required>
                                      </div>
                                    </div>
                                </div>

                                <div class="col-md-6 col-xs-12">
                                    <div class="form-group">
                                      <label class="control-label col-md-4 col-xs-12">Billing Address *</label>
                                      <div class="col-md-8 col-xs-12">
                                        <textarea id="txt_biiladd" name="txt_biiladd" rows="3" col="9" placeholder="Enter Billing Address." class="form-control" ></textarea>
                                      </div>
                                    </div>
                                </div>

                                <div class="col-md-6 col-xs-12">
                                    <div class="form-group">
                                      <label class="control-label col-md-4 col-xs-12">Shipping Address *</label>
                                      <div class="col-md-8 col-xs-12">
                                        <textarea id="txt_shipadd" name="txt_shipadd" rows="3" col="9" placeholder="Enter Shipping Address." class="form-control"></textarea>
                                      </div>
                                    </div>
                                </div>
                                 
                                

                            </div>
                        </div>
                    
                        <div class="panel-body">        

                            <table class="table table-striped table-bordered" cellspacing="0" width="100%">
                                <thead>
                                    <tr>
                                        <th>S.No</th>
                                        <th>Item</th>
                                        <th>Qty</th>
                                        <th>Grams(gm)</th>
                                        <th>Purity</th>
                                        <th>Price per gm</th>
                                        <th>Amount</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td></td>
                                        <td>
                                            <input type="text" id="txt_item" name="txt_item[]" class="form-control txt_item" placeholder="Enter Item." onblur="getProd(this.id)" autocomplete="off" required>
                                        </td>
                                        <td><input type="text" id="txt_qty" name="txt_qty[]" class="form-control" placeholder="Enter Qty." onchange="calcAmt(this.id);" required></td>
                                        <td><input type="text" id="txt_grams" name="txt_grams[]" class="form-control" placeholder="Enter Grams." onchange="calcAmt(this.id);" required></td>
                                        <td><select id="txt_purity" name="txt_purity[]" class="form-control" placeholder="Enter Purity." onchange="calcAmt(this.id);" required><option value="75.50%">18 Caret (75.50%)</option><option value="91.60%">22 Caret (91.60%)</option></select></td>
                                        <td><input type="text" id="txt_price" name="txt_price[]" class="form-control" placeholder="Enter Price." onchange="calcAmt(this.id);" required></td>
                                        <td><input type="text" id="txt_amt" name="txt_amt[]" class="form-control txt_amt" onchange="calcSum();" value="" required></td>
                                        <td>
                                          <button type="button" id="add-btn" class="btn btn-success btn-xs add-btn"
                                          onclick="addRow()">ADD ROW</button>
                                        </td>
                                    </tr>       
                                </tbody>
                                <thead>
                                    <tr>
                                        <th>Total</th>
                                        <th></th>
                                        <th></th>
                                        <th></th>
                                        <th></th>
                                        <th></th>
                                        <th><input type="text" id="txt_total" name="txt_total" onblur="on_total(this.id);" readonly=""></th>
                                        <th></th>
                                    </tr>
                                </thead>
                            </table>
                        </div>
                    
                        <div class="panel-body">

                            <div class="row">  

                                <div class="col-md-6 col-xs-6">
                                    <p>
                                    <br>1) 3 Days Return Policy<br>
                                    2) Subject to Lucknow Uttar Pradesh Jurisdiction exclusively only in any case<br> 
                                    3) Golden Verse reserves the right to modify/change all or any terms applicable to the program without assigning any reasons or withoutout any prior intimation whatsoever.<br>
                                    4) Cash back / promotional income or any offer is applicable when company (Golden Verse) in profit.<br>
                                    5) Cash back or any offer in not a guaranteed offer.<br>
                                    6) Company can stop or start any offer without any prior notice.<br>
                                    7) For any offer kindly refer to company's office or franchise's office. <br>*Terms and conditions apply<br><br></p>
                                </div>

                                <div class="col-md-6 col-xs-6">
                                   <div class="form-group">
                                      <label class="control-label col-md-3">[Hall Mark]</label>
                                      <div class="col-md-9">
                                        <input type="text" id="txt_hallmark" name="txt_hallmark" class="form-control" onblur="add();" required>
                                      </div>
                                    </div>

                                    <div class="form-group">
                                      <label class="control-label col-md-3">[Machinary Polishing Charge]</label>
                                      <div class="col-md-9">
                                        <input type="text" id="txt_machpol" name="txt_machpol" class="form-control" onblur="add();" required>
                                      </div>
                                    </div>

                                    <div class="form-group">
                                      <label class="control-label col-md-3">[Labour/Making]</label>
                                      <div class="col-md-9">
                                        <input type="text" id="txt_making" name="txt_making" class="form-control" onblur="add();" required>
                                      </div>
                                    </div>
                                </div>

                                <!-- <div class="col-md-12 col-xs-12">
                                    
                                </div>

                                <div class="col-md-12 col-xs-12">
                                    
                                </div> -->

                            </div>
                        </div>

                        <div class="panel-body">

                            <div class="row">  

                                <div class="col-md-12 col-xs-12 justify-content-right">
                                    <div class="col-md-6 col-md-offset-6 col-xs-12">
                                        <div class="form-group">
                                          <label class="control-label col-md-3 col-xs-12">Total Amount</label>
                                          <div class="col-md-9 col-xs-12">
                                            <input type="text" id="txt_totalamt" name="txt_totalamt" class="form-control" placeholder="Total Amount" required>
                                          </div>
                                        </div>
                                    </div>

                                    <div class="col-md-6 col-md-offset-6 col-xs-12">
                                        <div class="form-group">
                                          <label class="control-label col-md-3 col-xs-12">GST 3%</label>
                                          <div class="col-md-9 col-xs-12">
                                            <input type="text" id="txt_gst" name="txt_gst" class="form-control" placeholder="GST" required>
                                          </div>
                                        </div>
                                    </div>

                                    <div class="col-md-6 col-md-offset-6 col-xs-12">
                                        <div class="form-group">
                                          <label class="control-label col-md-3 col-xs-12">Net Amount</label>
                                          <div class="col-md-9 col-xs-12">
                                            <input type="text" id="txt_netamt" name="txt_netamt" class="form-control" placeholder="Net Amount" required>
                                          </div>
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>
                   

                        <div class="panel-footer text-center">
                            <button type="submit" class="btn btn-success">Submit</button>
                            <button class="btn btn-primary" type="reset">Cancel</button>                           
                        </div>
                    </form>
                    
                    
                </div>
    
            </div>

        </div>  
            
    </div>
    <!--===================================================-->
    <!--End page content-->

</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->
@endsection

<script src="http://code.jquery.com/jquery-2.1.4.min.js"></script>
<script type="text/javascript">
    $(document).ready(function(){
        $('.txt_item').keyup(function(){
            var item = $(this).val();
            var id = $(this).attr('id');
            var no = id.replace(/[^0-9]/g,'');
            if(item){
                $.ajax({
                   type:"POST",
                   url:"{{url('/prod_autocomplete')}}",
                   data:{"_token": "{{ csrf_token() }}", "item": item},
                   success:function(result)
                   {       
                        if(result)
                        {
                            console.log(result);
                            $('#prodlist'+no).find('.dropdown-menu'+no).empty();
                            $.each(result,function(key,value){

                              $('#prodlist'+no).find('.dropdown-menu'+no).append('<li>'+result[key].m41_product_name+'</li>');
                            });
                        }else{
                            $("#prodlist"+no).empty();
                        }
                   }

                });
            }
        });

        $(document).on('click', 'li', function(){
            var value = $(this).text();
            $('#txt_item').val(value);
            $('#prodlist').html("");
        });

    });
</script>
<script type="text/javascript">

        function get_packamt(id){
            var pack_id = $('#'+id).val();
            if(pack_id){
                $.ajax({
                   type:"POST",
                   url:"{{url('/get_packamt')}}",
                   data:{"_token": "{{ csrf_token() }}", "pack_id": pack_id},
                   success:function(result)
                   {       
                        if(result)
                        {
                            $("#txt_walletbal").val(result[0].PACKAGE_FEE);
                        }else{
                            $("#txt_walletbal").empty(); 
                        }
                   }

                });
            }
        }

        var id = 0;

        function addRow(){
        
            var markup = '';
            id += 1; 
            markup += '<tr id="row' +id+ '">';
            markup += '<td></td>';
            markup += '<td>';
            markup += '<input type="text" id="txt_item' +id+ '" name="txt_item[]" class="form-control';
            markup += ' txt_item" placeholder="Enter Item." onblur="getProd(this.id)" autocomplete="off" required>';
            markup += '</td>';
            markup += '<td><input type="text" id="txt_qty' +id+ '" name="txt_qty[]" class="form-control" placeholder="Enter Qty." onchange="calcAmt(this.id);" required></td>';
            markup += '<td><input type="text" id="txt_grams' +id+ '" name="txt_grams[]" class="form-control" placeholder="Enter Grams." onchange="calcAmt(this.id);"></td>';
            markup += '<td><select id="txt_purity" name="txt_purity[]" class="form-control" placeholder="Enter Purity." onchange="calcAmt(this.id);" required><option value="75.50%">18 Caret (75.50%)</option><option value="91.60%">22 Caret (91.60%)</option></select></td>';
            markup += '<td><input type="text" id="txt_price' +id+ '" name="txt_price[]" class="form-control" placeholder="Enter Price." onchange="calcAmt(this.id);" required></td>';
            markup += '<td><input type="text" id="txt_amt' +id+ '" name="txt_amt[]" class="form-control txt_amt" placeholder="Enter Amount." onchange="calcSum();" required></td>';
            markup += '<td>';             
            markup += '<button type="button" id="add-btn' +id+ '" class="btn btn-success btn-xs add-btn" onclick="addRow()">ADD ROW</button>';
            markup += '<button type="button" id="del-btn' +id+ '" class="btn btn-success btn-xs del-btn" onclick="$(this).parent().parent().remove()">DELETE ROW</button>';
            markup += '</td>';
            markup += '</tr>';
            $('table tbody').append(markup);       

        };

        function getProd(id){
            var attrid = id;
            var no = attrid.replace(/[^0-9]/g,'');
            var value = $('#'+attrid).val();
            
            if(value){
                $.ajax({
                   type:"POST",
                   url:"{{url('/get_prod')}}",
                   data:{"_token": "{{ csrf_token() }}", "prod_name": value},
                   success:function(result)
                   {       
                        if(result)
                        {
                            $("#txt_prodid"+no).val(result[0].m41_product_id);
                            $("#txt_prodprice"+no).val(result[0].m41_product_price);
                            $("#txt_proddp"+no).val(result[0].m41_product_dp);
                            $("#txt_prodstore"+no).val(result[0].m41_product_store);
                            $("#txt_prodbvol"+no).val(result[0].m41_product_bussn_volume);
                        }else{
                            $("#txt_prodid"+no).empty(); 
                        }
                   }

                });
            }
            else{
                if($("#txt_prodid"+no).val() == ""){
                    alert("Please select product.");
                }
                
            }
        };

        function getuser(){
            var user = $('#txt_userid').val();
            
            if(user){
                $.ajax({
                   type:"POST",
                   url:"{{url('/getuser_details')}}",
                   data:{"_token": "{{ csrf_token() }}", "userid": user},
                   success:function(result)
                   {       
                        if(result)
                        {
                            $("#txt_uid").empty();
                            $("#txt_name").empty(); 
                            $("#txt_biiladd").empty();
                            $("#txt_shipadd").empty();
                            $("#txt_walletbal").empty();
                            $("#txt_uid").val(result[0].RegId);
                            $("#txt_name").val(result[0].MemberName);
                            $("#txt_mobileno").val(result[0].MemberContactNo);
                            $("#txt_biiladd").val(result[0].MemberLocation);
                            $("#txt_shipadd").val(result[0].MemberLocation);
                        }else{
                            $("#txt_uid").empty();
                            $("#txt_name").empty(); 
                            $("#txt_name").empty(); 
                            $("#txt_mobileno").empty();
                            $("#txt_shipadd").empty();
                            $("#txt_walletbal").empty();
                        }
                   }

                });
            }
        };

        function calcAmt(id){
            var id = id;
            var id_no = id.replace(/[^0-9]/g,'');
            var amt = 0;
            var total_amt = 0;
            var qty = 0;
            var grams = 0;
            var price = 0;

            qty = $('#txt_qty'+id_no).val();
            grams = $('#txt_grams'+id_no).val();
            price = $('#txt_price'+id_no).val();

            if(qty != "" && grams != "" && price != ""){
                amt = parseFloat(grams) * parseFloat(price);
                total_amt = parseFloat(amt) * parseFloat(qty);
            }
            $('#txt_amt'+id_no).val(total_amt);
            calcSum();
        };

        function calcSum(){
            var amt = 0;

            $('.txt_amt').each(function(){
                amt += Number($(this).val());
            });
            $('#txt_total').val(amt);
        };
    
        function on_total(id){
            var tamt = $('#txt_total').val();
            var machinery_cg = '';
            var polishing_cg = '';
            var hall_mark = '';
            machinery_cg = parseFloat(tamt/100) * parseFloat(15).toFixed(2);
            polishing_cg = parseFloat(tamt/100) * parseFloat(10).toFixed(2);
            hall_mark = parseFloat(tamt/100) * parseFloat(10).toFixed(2);
            $('#txt_hallmark').val(hall_mark);
            $('#txt_machpol').val(polishing_cg);
            $('#txt_making').val(machinery_cg);
        };

        function add(){
            var amt = $('#txt_total').val();
            var hallmark = $('#txt_hallmark').val();
            var machpol = $('#txt_machpol').val();
            var making = $('#txt_making').val();
            var sum = '';
            var gst = "";
            var gst_amt = "";
            var net_amt = "";

            if(amt != "" && hallmark != "" && machpol != "" && making != ""){
                sum = parseFloat(amt) + parseFloat((amt*hallmark)/100) + parseFloat((amt*machpol)/100)+ parseFloat((amt*making)/100);
                gst = parseInt(sum) / parseInt(100);
                gst_amt = parseFloat(gst * 3).toFixed(2);
                net_amt = parseFloat(gst_amt) + parseFloat(sum);
            }
            $('#txt_totalamt').val(sum);
            $('#txt_gst').val(gst_amt);
            $('#txt_netamt').val(net_amt);
        };
</script>