@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Shopping Product</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->
        
        
        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
            <li><a href="#"><i class="fa fa-home"></i></a></li>
            <li><a href="#">Shopping Product</a></li>
            <li class="active">VIEW ORDER</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->
        
    </div>
    
    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">
        
        <div class="row">
            <div class="col-lg-offset-3 col-lg-6">
                <div class="panel">

                    @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                    @endif

                    @if(Session::has('message')) 
                    <div class="alert alert-{{ Session::get('type') }} alert-dismissible show" role="alert">
                        <h4 class="alert-heading">{{ Session::get('message') }}</h4>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    @endif
                    
                    <div class="panel-heading">
                        <div class="panel-control">
                            <button class="btn btn-default" data-panel="minmax"><i class="fa fa-arrow-circle-up"></i></button>
                        </div>
                        <h3 class="panel-title">VIEW ORDER</h3>
                    </div>
                    
                    <div class="collapse in">   
                        
                        <form action="{{url('emp_view_order')}}" id="profile_edit" method="post" accept-charset="utf-8">
                            {{ csrf_field() }} 
                            <div class="panel-body">
                                <div class="row">
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_orderid">Order Id *</label>
                                            <input type="text" id="txt_orderid" name="txt_orderid" class="form-control" placeholder="Enter Order Id." autocomplete="off">
                                        </div>
                                    </div>    
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label class="control-label" style="display:block;">&nbsp;</label>
                                            <button class="btn btn-success" type="submit">Find</button>
                                        </div>
                                    </div>
                                </div>
                            </div>    
                        </form>
                    </div>
                    
                </div>
            </div>
            
        </div>
        @if($single_order != '')
        <div class="row">

            <div class="col-sm-6">
                <div class="panel panel-bordered panel-success">
                    <div class="panel-heading">
                        <h3 class="panel-title text-light">Order Detail</h3>
                    </div>
                        
                    <!-- Striped Table -->
                    <!--===================================================-->
                    <div class="panel-body">
                        <div class="table-responsive">
                            <table class="table table-striped mb-0">
                                <tbody>
                                    <tr>
                                        <td class="border-top-none">Order Id.</td>
                                        <td class="border-top-none"><strong>{{$single_order[0]->ORDER_CODE}}</strong></td>
                                    </tr>
                                    <tr>    
                                        <td class="border-top-none">User Code </td>
                                        <td class="border-top-none"><strong>{{$single_order[0]->USER_CODE}}</strong></td>
                                    </tr>
                                    <tr>    
                                        <td class="border-top-none">User Name </td>
                                        <td class="border-top-none"><strong>{{$single_order[0]->USER_NAME}}</strong></td>
                                    </tr>
                                    <tr>
                                        <td class="border-top-none">Address</td>
                                        <td class="border-top-none"><strong>{{$single_order[0]->FLAT, $single_order[0]->AREA, $single_order[0]->LANDMARK, $single_order[0]->PINCODE, $single_order[0]->ADDRESS_TYPE}}</strong></td>
                                    </tr>
                                    <tr>
                                        <td class="border-top-none">Amount</td>
                                        <td class="border-top-none"><strong><i class="fa fa-inr" aria-hidden="true"></i> {{number_format($single_order[0]->FINAL_AMOUNT,2)}}</strong></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <!--===================================================-->
                    <!-- End Striped Table -->
                        
                </div>
            </div>

            <div class="col-sm-6">
                <div class="panel panel-bordered panel-success">
                    <div class="panel-heading">
                        <h3 class="panel-title text-light">Order Status</h3>
                    </div>
                        
                    <!-- Striped Table -->
                    <!--===================================================-->
                    <div class="panel-body">
                        <div class="table-responsive">
                            <table class="table table-striped mb-0">
                                <tbody>
                                    <tr>
                                        <td class="border-top-none">Order Status</td>
                                        <td class="border-top-none"><strong>{{$single_order[0]->ORDER_STATUS}}</strong></td>
                                    </tr>
                                    <tr>
                                        <td class="border-top-none">Payment Status</td>
                                        <td class="border-top-none"><strong>{{$single_order[0]->PAYMENT_STATUS}}</strong></td>
                                    </tr>
                                    <tr>
                                        <td class="border-top-none">Payment Method</td>
                                        <td class="border-top-none"><strong>{{$single_order[0]->PAYMENT_METHOD}}</strong></td>
                                    </tr>
                                    <tr>
                                        <td class="border-top-none">Created At</td>
                                        <td class="border-top-none"><strong>{{$single_order[0]->CREATED_AT}}</strong></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <!--===================================================-->
                    <!-- End Striped Table -->
                        
                </div>
            </div>
            
            <div class="col-sm-12">
                <div class="panel panel-bordered panel-success">
                    <div class="panel-heading">
                        <h3 class="panel-title text-light">Products</h3>
                    </div>
                        
                    <!-- Striped Table -->
                    <!--===================================================-->
                    <div class="panel-body">
                        <div class="table-responsive">
                            <table class="table table-striped mb-0">
                                <tbody>
                                    <th>
                                        <td class="border-top-none"><strong>Name</strong></td>
                                        <td class="border-top-none"><strong>Image</strong></td>
                                        <td class="border-top-none"><strong>Unit</strong></td>
                                        <td class="border-top-none"><strong>Variant</strong></td>
                                        <td class="border-top-none"><strong>Type </strong></td>
                                        <td class="border-top-none"><strong>Qty</strong></td>
                                        <td class="border-top-none"><strong>Price </strong></td>
                                        <td class="border-top-none"><strong>Disc Price </strong></td>
                                        <td class="border-top-none"><strong>Total </strong></td>
                                    </th>
                                    @foreach(json_decode($single_order[0]->PRODUCT_DETAILS) as $kye => $provalue)
                                    @php  $image = explode(",",$provalue->image); if(count($image) > 0){ $img = $image[0]; }else{ $img = ''; } @endphp
                                    <tr>
                                        <td class="border-top-none">{{$kye+1}}</td>
                                        <td class="border-top-none">{{$provalue->name}}</td>
                                        <td class="border-top-none"><img src="{{asset('images/prod_logo/'.$img)}}" width="50"></td>
                                        <td class="border-top-none">{{$provalue->capacity}} {{$provalue->unit_name}}</td>
                                        <td class="border-top-none">{{$provalue->is_variant}}</td>
                                        <td class="border-top-none">@if($provalue->is_variant == 'YES'){{$provalue->group_name}}{{$provalue->option_name}} @endif</td>
                                        <td class="border-top-none">{{$provalue->quantity}}</td>
                                        <td class="border-top-none"><i class="fa fa-inr"></i> {{number_format($provalue->price,2)}}</td>
                                        <td class="border-top-none"><i class="fa fa-inr"></i>  {{number_format($provalue->disc_price,2)}}</td>
                                        <td class="border-top-none"><i class="fa fa-inr"></i>  {{number_format($provalue->quantity*$provalue->disc_price,2)}}</td>
                                    </tr>
                                    @endforeach
                                    <th>
                                        <td class="border-top-none"></td>
                                        <td class="border-top-none"></td>
                                        <td class="border-top-none"></td>
                                        <td class="border-top-none"></td>
                                        <td class="border-top-none"></td>
                                        <td class="border-top-none"></td>
                                        <td class="border-top-none"></td>
                                        <td class="border-top-none"><strong>SubTotal </strong></td>
                                        <td class="border-top-none"><strong><i class="fa fa-inr" aria-hidden="true"></i> {{number_format($single_order[0]->FINAL_AMOUNT,2)}} </strong></td>
                                    </th>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <!--===================================================-->
                    <!-- End Striped Table -->
                        
                </div>
            </div>     
        </div>  
        @endif
    </div>
    <!--===================================================-->
    <!--End page content-->
        
</div>
@endsection
    