@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Master Panel</h1>
		</div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->
		
		
        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
			<li><a href="{{url('/'.Session::get("dash_url"))}}"><i class="fa fa-home"></i></a></li>
			<li><a href="{{url('/'.Session::get("dash_url"))}}">Dashboard</a></li>
			<li class="active">View Employee Profile</li>
		</ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->
		
	</div>
	
    @if ($errors->any())
    <div class="alert alert-danger">
        <ul>
            @foreach ($errors->all() as $error)
			<li>{{ $error }}</li>
            @endforeach
		</ul>
	</div>
    @endif
	
    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">
		
        <div class="row">
            <div class="col-lg-offset-3 col-lg-6">
                <div class="panel">
					
                    <div class="panel-heading">
                        <div class="panel-control">
                            <button class="btn btn-default" data-panel="minmax"><i class="fa fa-arrow-circle-up"></i></button>
						</div>
                        <h3 class="panel-title">View Employee Profile</h3>
					</div>
                    
                    <div class="collapse in">	
						@if(Session::has('message')) 
						<div class="alert alert-{{ Session::get('type') }} alert-dismissible show" role="alert">
							<h4 class="alert-heading">{{ Session::get('message') }}</h4>
							<button type="button" class="close" data-dismiss="alert" aria-label="Close">
								<span aria-hidden="true">&times;</span>
							</button>
						</div>
						@endif
						<form action="{{url('view_employee')}}" id="profile_edit" method="post" accept-charset="utf-8">
							{{ csrf_field() }} 
                            <div class="panel-body">
                                <div class="row">
                                    <div class="col-sm-10">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_memberid">Employee Id *</label>
                                            <input type="text" id="txt_memberid" name="txt_memberid" class="form-control" placeholder="Enter Member Id." required value={{$USERID}}>
										</div>
									</div>    
                                    <div class="col-sm-2">
                                        <div class="form-group">
                                            <label class="control-label" style="display:block;">&nbsp;</label>
                                            <button class="btn btn-success" type="submit">Find</button>
										</div>
									</div>
								</div>
							</div>    
						</form>
					</div>
					
				</div>
			</div>
            
		</div>
		@if($user != '')
		<div class="row">
            <div class="col-sm-3">
                <div class="panel">
                    <div class="panel-heading">
                        <h3 class="panel-title">Employee Profile</h3>
					</div>
					
                    <!-- Striped Table -->
                    <!--===================================================-->
                    <div class="panel-body">
                        <div class="table-responsive">
							<center>
								<!-- Current avatar -->
								@if($user[0]->MemberImage!='')
								<img src="{{ asset('images/USER_PHOTO/' .$user[0]->MemberImage) }}" alt="WELCOME "  title="" class="img-circle profile_img" style="height:200px;width:200px;">
								@else
								<img src="{{ asset('images/user.png') }}" alt="WELCOME" title="" class="img-circle profile_img">
								@endif
								<h3>{{ $user[0]->FirstName}} {{ $user[0]->LastName}}</h3>
							</center>
                            <table class="table table-striped">
                                <tbody>
                                    <tr>
                                        <td>Name</td>
                                        <td>{{ $user[0]->FirstName}} {{ $user[0]->LastName}}</td>
									</tr>
                                    <tr>
                                        <td>Join At</td>
                                        <td>{{ $user[0]->CreatedDate}}</td>
										<tr>
											<td>Email Id</td>
											<td>{{ $user[0]->MemberEmail}}</td>
										</tr>
										<tr>
											<td>Mobile No</td>
											<td>{{ $user[0]->MemberContactNo}}</td>
										</tr>
										<tr>
											<td>Address</td>
											<td>{{ $user[0]->MemberLocation}}</td>
										</tr>
										<tr>
											<td>Postal Code</td>
											<td>{{ $user[0]->MemberPostalCode}}</td>
										</tr>
									</tbody>
								</table>
							</div>
						</div>
						<!--===================================================-->
						<!-- End Striped Table -->
						
					</div>
				</div>
					@if($get_useralldetail != '')
						@foreach( $get_useralldetail as $con)
						@endforeach
					@endif
				<div class="col-sm-3">
					<div class="panel">
						<div class="panel-heading">
							<h3 class="panel-title">Account Detail</h3>
						</div>
						
						<!-- Striped Table -->
						<!--===================================================-->
						<div class="panel-body">
							<div class="table-responsive">
								<table class="table table-striped">
									<tbody>
										<tr>
											<td>A/c No.</td>
											<td>{{ $con->CBSACno}}</td>
										</tr>
										<tr>
											<td>A/c Holder Name </td>
											<td>{{ $con->NAMEatBANK}}</td>
										</tr>
										<tr>
											<td>Bank Name</td>
											<td>{{ $con->BANKNo}}</td>
										</tr>
										<tr>
											<td>Bank Branch</td>
											<td>{{$con->Branch}}</td>
										</tr>
										<tr>
											<td>IFSC Code</td>
											<td>{{$con->IFSCode}}</td>
										</tr>
									</tbody>
								</table>
							</div>
						</div>
						<!--===================================================-->
						<!-- End Striped Table -->
						
					</div>
				</div>
				<div class="col-sm-3">
					<div class="panel">
						<div class="panel-heading">
							<h3 class="panel-title">Sponsor Detail</h3>
						</div>
						
						<!-- Striped Table -->
						<!--===================================================-->
						<div class="panel-body">
							<div class="table-responsive">
								<table class="table table-striped">
									<tbody>
										<tr>
											<td>Sponsor</td>
											<td>{{ $con->ReferralMobileNo}}</td>
										</tr>
										<tr>
											<td>Parent</td>
											<td>{{ $con->ParentMobileNo}}</td>
										</tr>
									</tbody>
								</table>
							</div>
						</div>
						<!--===================================================-->
						<!-- End Striped Table -->
						
					</div>
				</div>
				
			</div>	
			@endif
		</div>
		<!--===================================================-->
		<!--End page content-->
		
	</div>
	
	@endsection
	