@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Master Panel</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{ url('/admin_dashboard') }}"><i class="demo-pli-home"></i></a></li>
        <li><a href="{{ url('/admin_dashboard') }}">Dashboard</a></li>
        <li class="active">Config Settings</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>

    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">

        <div class="row">
            <div class="col-lg-12">
        
        
                <!-- FORM VALIDATION ON TABS -->
                <!--===================================================-->
                <div class="tab-base">
                    
                    <!-- Nav tabs -->
                    <ul class="nav nav-tabs">
                        <li
						@if(!empty($singleconfig))
						@if($singleconfig[0]->SC_NAME != "SITE_LOGO" && $singleconfig[0]->SC_NAME != "SITE_BG_IMAGE") 
						class="active"
						@endif
						@endif
						><a href="#demo-bsc-tab-1" data-toggle="tab">General Settings</a></li>
						@if(!empty($singleconfig))
                        <li
						@if($singleconfig[0]->SC_NAME == "SITE_LOGO") 
						class="active"
						@endif
						><a href="#demo-bsc-tab-2" data-toggle="tab">Site Logo</a></li>
                        <li 
						@if($singleconfig[0]->SC_NAME == 'SITE_BG_IMAGE') 
						class="active"
						@endif
						><a href="#demo-bsc-tab-3" data-toggle="tab">Site Background Image</a></li>
						@endif	
                    </ul>

                    @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                    @endif

                    @if(Session::has('config_msg')) 
                    <div class="alert alert-{{ Session::get('type') }} alert-dismissible  show" role="alert">
                        <h4 class="alert-heading">{{ Session::get("config_msg") }}</h4>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    @endif
        
                    <!-- Tabs Content -->
                        <div class="tab-content">
					@if(!empty($singleconfig))	
                            <div class="tab-pane fade
								@if($singleconfig[0]->SC_NAME != "SITE_LOGO" && $singleconfig[0]->SC_NAME != "SITE_BG_IMAGE") 
								in active
								@endif
							" id="demo-bsc-tab-1">
                                <p class="text-main text-bold">HOME</p>
                                <hr>

                               
                                <form id="edit-mainconfig" action="{{url('/update_siteconfig_employee/'.$singleconfig[0]->SC_ID)}}" method="POST" enctype="multipart/form-data">
                                    {{ csrf_field() }}
                                    <div class="row">

                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label class="control-label">Config Variable</label>
                                                <input type="text" class="form-control" name="txt_name" id="txt_name" value="{{$singleconfig[0]->SC_NAME}}">
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label class="control-label">Config Value</label>
                                                <input type="text" class="form-control" name="txt_value" id="txt_value" value="{{$singleconfig[0]->SC_VALUE}}">
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label class="control-label">Config Description</label>
                                                <input type="text" class="form-control" name="txt_desc" id="txt_desc" value="{{$singleconfig[0]->SC_DESC}}">
                                            </div>
                                        </div> 
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label class="control-label" for="dd_affiliate">Affiliate</label>
                                            <select class="form-control" id="dd_affiliate" name="dd_affiliate">
                                                <option value="">Select Affiliate</option>
												@foreach($affi as $value)
												@if($value->AFFI_ID != 1)
                                                <option value="{{$value->AFFI_ID}}" {{$value->AFFI_ID == $singleconfig[0]->SC_AFFID ? 'selected':'' }}>{{$value->AFFI_NAME}}</option>
												@endif
												@endforeach
                                            </select>
                                        </div>
                                    </div>

                                    </div>

                                    <div class="tab-footer clearfix">
                                        <button type="button" class="btn btn-primary" onclick="conwv('edit-mainconfig')">Update Configuration</button>
                                        <button type="reset" class="btn btn-primary">Reset</button>
                                    </div>

                                </form>
									</div>
								<div class="tab-pane fade 
								@if($singleconfig[0]->SC_NAME == "SITE_LOGO") 
								in active
								@endif
								" id="demo-bsc-tab-2">
                                <p class="text-main text-bold">Logo</p>
                                <hr>

                                
                                <form id="edit-sitelogo" action="{{url('/update_siteimage_employee/SITE_LOGO/'.$singleconfig[0]->SC_ID)}}" method="POST" enctype="multipart/form-data">
                                    {{ csrf_field() }}
                                    <div class="row">

                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label class="control-label">Site Logo Name</label>
                                                <input type="text" class="form-control" name="txt_site_logo" value="SITE_LOGO">
                                            </div>
                                        </div>    
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label class="control-label">Upload Logo Image</label>
                                                <input type="file" class="form-control" name="txt_value">
                                            </div>
                                        </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label class="control-label" for="dd_affiliate">Affiliate</label>
                                            <select class="form-control" id="dd_affiliate" name="dd_affiliate">
                                                <option value="">Select Affiliate</option>
												@foreach($affi as $value)
												@if($value->AFFI_ID != 1)
                                                <option value="{{$value->AFFI_ID}}"  {{$value->AFFI_ID == $singleconfig[0]->SC_AFFID ? 'selected':'' }}>{{$value->AFFI_NAME}}</option>
												@endif
												@endforeach
                                            </select>
                                        </div>
                                    </div>

                                    </div>

                                    <div class="tab-footer clearfix">
                                        <button type="button" class="btn btn-primary" onclick="conwv('edit-sitelogo')">Update Configuration</button>
                                        <button type="reset" class="btn btn-primary">Reset</button>
                                    </div>

                                </form>  
                            </div>
                            <div class="tab-pane fade 
							@if($singleconfig[0]->SC_NAME == "SITE_BG_IMAGE") 
								in active
								@endif
								" id="demo-bsc-tab-3">
                                <p class="text-main text-bold">Background Image</p>
                                <hr>
                                <form id="edit-bgimage" action="{{url('/update_siteimage_employee/SITE_BG_IMAGE/'.$singleconfig[0]->SC_ID)}}" method="POST" enctype="multipart/form-data">
                                    {{ csrf_field() }}
                                    <div class="row">

                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label class="control-label">Site Background Name</label>
                                                <input type="text" class="form-control" name="txt_bg_image" value="SITE_BG_IMAGE">
                                            </div>
                                        </div> 

                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label class="control-label">Upload Background Image</label>
                                                <input type="file" class="form-control" name="txt_value">
                                            </div>
                                        </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label class="control-label" for="dd_affiliate">Affiliate</label>
                                            <select class="form-control" id="dd_affiliate" name="dd_affiliate">
                                                <option value="">Select Affiliate</option>
												@foreach($affi as $value)
												@if($value->AFFI_ID != 1)
                                                <option value="{{$value->AFFI_ID}}"  {{$value->AFFI_ID == $singleconfig[0]->SC_AFFID ? 'selected':'' }}>{{$value->AFFI_NAME}}</option>
												@endif
												@endforeach
                                            </select>
                                        </div>
                                    </div>

                                    </div>

                                    <div class="tab-footer clearfix">
                                        <button type="button" class="btn btn-primary" onclick="conwv('edit-bgimage')">Update Configuration</button>
                                        <button type="reset" class="btn btn-primary">Reset</button>
                                    </div>
                                </form>
                            </div>
                                @else
                                <form id="add-mainconfig" action="{{url('/add_mainconfig_employee')}}" method="POST">
                                    {{ csrf_field() }}
                                    <div class="row">

                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label class="control-label">Config Variable</label>
                                                <input type="text" class="form-control" name="txt_name" id="txt_name" placeholder="Enter Config Variable">
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label class="control-label">Config Value</label>
                                                <input type="text" class="form-control" name="txt_value" id="txt_value" placeholder="Enter Config Value">
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label class="control-label">Config Description</label>
                                                <input type="text" class="form-control" name="txt_desc" id="txt_desc" placeholder="Enter Config Description">
                                            </div>
                                        </div> 
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label class="control-label" for="dd_affiliate">Affiliate</label>
                                            <select class="form-control" id="dd_affiliate" name="dd_affiliate">
                                                <option value="">Select Affiliate</option>
												@foreach($affi as $value)
												@if($value->AFFI_ID != 1)
                                                <option value="{{$value->AFFI_ID}}">{{$value->AFFI_NAME}}</option>
												@endif
												@endforeach
                                            </select>
                                        </div>
                                    </div>

                                    </div>

                                    <div class="tab-footer clearfix">
                                        <button type="button" class="btn btn-primary" onclick="conwv('add-mainconfig')">Update Configuration</button>
                                        <button type="reset" class="btn btn-primary">Reset</button>
                                    </div>

                                </form>
								</div>
                                @endif
                        </div>
                </div>
                <!--===================================================-->
                <!-- END FORM VALIDATION ON TABS -->
        
            </div>
        

        <div class="row">
            <div class="panel">
            
                <div class="panel-body">
                    <table id="demo-dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
                        <thead>
                            <tr>
                                <th>S.No</th>
                                <th>Config Variable</th>
                                <th class="min-tablet">Config Value</th>
								<th class="min-tablet" style="width: 150px;">Affiliate</th>
                                <th>Description</th>
                                <th class="min-tablet">Edit</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $i=1;?>
                            @foreach($config as $value)
                            <tr>
                                <td>{{$i++}}</td>
                                <td>{{$value->SC_NAME}}</td>
                                <td>{{$value->SC_VALUE}}</td>
								<td>{{$value->SC_AFFNAME}}</td>
                                <td>{{$value->SC_DESC}}</td>
                                <td><a class="btn btn-success btn-xs" href="{{url('/view_config_employee/'.$value->SC_ID)}}">EDIT</a></td>
                            </tr>
                            @endforeach

                        </tbody>
                    </table>
                </div>
            
            </div>
        </div>

            
    </div>
    <!--===================================================-->
    <!--End page content-->

</div>


<!--===================================================-->
<!--END CONTENT CONTAINER-->

<script src="http://ajax.googleapis.com/ajax/libs/jquery/2.0.0/jquery.min.js"></script>
<script type="text/javascript">
$(document).ready(function(){
    $(".val").on("click", function(e) {
        var id = $(this).data('id');
        var packname = $(this).data('packname');
        $('#txt_statusregid').val(id);
        $('#packname').text(packname);
    });
});
</script>
@endsection