@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Employee Panel</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{url('/'.Session::get("dash_url"))}}"><i class="demo-pli-home"></i></a></li>
        <li><a href="{{url('/'.Session::get("dash_url"))}}">Dashboard</a></li>
        <li class="active">TopUp Report</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>

    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">
        
        <div class="row">
            <div class="panel">

                <div class="panel-heading">
                    <div class="panel-control">
                        <button class="btn btn-default" data-panel="minmax"><i class="demo-psi-chevron-up"></i></button>
                    </div>
                    <h3 class="panel-title">TopUp Report</h3>
                </div>

                <div class="collapse in">
						<form action="{{url('/emp_topup_report')}}" method="POST">
                        {{ csrf_field() }}
                        <div class="panel-body">  
                          <div class="col-sm-2">
                                <div class="form-group">
                                    <label class="control-label" for="txt_fromdate">From Date</label>
                                    <div id="demo-dp-txtinput">
                                        <input type="text" name="txt_fromdate" id="txt_fromdate" value="{{$start}}" class="form-control" placeholder="dd/mm/yyyy" autocomplete="off">
                                    </div>
                                </div>                                
                            </div>
                        
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label class="control-label" for="txttodate">To Date</label>
                                    <div id="demo-dp-txtinput">
                                        <input type="text" name="txt_todate" id="txt_todate" value="{{$end}}"  class="form-control" placeholder="dd/mm/yyyy" autocomplete="off" >
                                    </div>
                                </div>
                            </div>

                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label class="control-label" for="txt_userid">Member Id</label>
                                    <input type="text" id="txt_userid" name="txt_userid"  value="{{$maemberid}}"  class="form-control" placeholder="Enter User Id.">
                                </div>
                            </div>
                            
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label class="control-label">Position</label>
                                     <select name="dd_pos" id="dd_pos" class="form-control">
                                        <option value="-1" >Select</option>
                                        <option value="LEFT" {{$pos =='LEFT'? 'selected':'' }}>LEFT</option>
                                        <option VALUE="RIGHT"  {{$pos =='RIGHT'? 'selected':'' }}>RIGHT</option>
                                    </select>
                                </div>
                            </div>

                        </div>
                       
                        <div class="panel-footer text-center">
                            <button class="btn btn-success" type="submit">Search</button>
                            <button class="btn btn-info" type="button">Reset</button>
                        </div>
                    </form>
                </div>
    
            </div>
        </div> 

        <div class="row">
            <div class="panel">
            
                <div class="panel-body">
  
                    <table id="demo-dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
						<thead>
							<tr>
								<th>S.NO.</th>
								<th>MEMBER NAME</th>
								<th>MEMBER CODE</th>
								<th>SPONSOR ID</th>
								<th>PARENT ID</th>
								<th>POSITION</th>
								<th>JOINING DATE</th>
								<th>TOPUPDATE</th>
								<th>PACKAGE</th>
							    <th>PV</th>
								
							</tr>
						</thead>
						<tbody>
							<?php $sn = 1;$lvl_no="1"; $totalpv=0.00;$totalretopup_pv=0.00;?>
												@if( !empty($user_rec))
													@foreach( $user_rec as $con)
										
															<?php 
																$totalpv=$totalpv+$con->TOPUP_BV;
																$totalretopup_pv=$totalretopup_pv+$con->RETOPUP_BV;
													
																?>
							<tr>
								<td>{{ '#' }}</td>
								<td>{{$con->MemberName}}</td>
								<td>{{ $con->RegCode }}</td>
								<td>{{ $con->ReferralMobileNo }}</td>
								<td>{{ $con->ParentMobileNo }}</td>
								<td>{{ $con->Position}}</td>
								<td>{{ $con->JOINING_DATE  }}</td>
								<td>{{ $con->TOPUP_DATE  }}</td>
								<td>{{ $con->PACKAGE_NAME }}</td>
								<td>{{ $con->TOPUP_BV }}</td>
                            </tr>
							 @endforeach
							@endif
						</tbody>
					    <tr>
								<th></th>
								<th></th>
								<th></th>
								<th></th>
								<th></th>
								<th></th>
								<th></th>
								<th></th>
								<th>TOTAL</th>
							    <th>{{$totalpv}}</th>
							
								
							</tr>
					</table>
                    </table>
                </div>
            
            </div>
        </div>     
            
    </div>
    <!--===================================================-->
    <!--End page content-->

</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->
@endsection