@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Ticket Reply</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{url('/'.Session::get("dash_url"))}}"><i class="fa fa-home"></i></a></li>
        <li><a href="{{url('/'.Session::get("dash_url"))}}">Support</a></li>
        <li class="active">Ticket Reply</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>

    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">
		 <div class="row">
            
                <div class="panel">
                    
                    <div class="panel-heading">
                        <div class="panel-control">
                            <button class="btn btn-default" data-panel="minmax"><i class=" fa fa-arrow-circle-up"></i></button>
                        </div>
                        <h3 class="panel-title">Ticket Reply Filter</h3>
                    </div>

                    <div class="collapse in">
        
                        <form action="{{url('/filter_ticket_reply')}}" method="POST">
							{{ csrf_field() }}
                            <div class="panel-body">
                                <div class="row">
                                    <div class="col-sm-2">
                                        <div class="form-group">
                                            <label class="control-label" for="txtfromdate">From Date</label>
                                            <div id="demo-dp-txtinput">
                                                <input type="text" name="txtfromdate" id="txtfromdate" class="form-control input-inline input-medium" placeholder="dd/mm/yyyy" autocomplete="off" >
                                            </div>
                                        </div>
                                    </div>    
                                    <div class="col-sm-2">
                                        <div class="form-group">
                                            <label class="control-label" for="txttodate">To Date</label>
                                            <div id="demo-dp-txtinput">
                                                <input type="text" name="txttodate" id="txttodate" class="form-control input-inline input-medium" placeholder="dd/mm/yyyy" autocomplete="off" >
                                            </div>
                                        </div>
                                    </div>
                                <div class="col-sm-2">
                                        <div class="form-group">
                                            <label class="control-label" for="txtuserid">Ticket No</label>
                                            <input type="text" id="txt_ticket" name="txt_ticket" class="form-control input-inline input-medium" placeholder="Enter Ticket  No." >
                                        </div>
                                    </div> 
									<div class="col-sm-2">
                                        <div class="form-group">
                                            <label class="control-label" for="txtuserid">Ticket Type</label>
                                            <select name="dd_ticket" id="dd_ticket"  class="form-control empty selectpicker" data-live-search="true" data-width="100%">
										<option value="">SELECT STATUS</option>
										<option value="1">SUPPORT</option>
										<option value="2">ACCOUNT</option>
										<option value="3">SALES</option>
									</select>
                                        </div>
                                    </div> 
                                    <div class="col-sm-2">
                                        <div class="form-group">
                                            <label class="control-label" for="txtuserid">User Id</label>
                                            <input type="text" id="txt_transid" name="txt_transid" class="form-control input-inline input-medium" placeholder="Enter User ID." >
											@if(count($tickets) > 0) <input type="hidden" id="txt_status" name="txt_status" value="{{$tickets[0]->STATUS}}"> @endif
                                        </div>
                                    </div>  
									<div class="col-sm-2">
                                        <div class="form-group">
                                            <label class="control-label" for="txtuserid">Urgency</label>
                                            <select name="dd_urgency" id="dd_urgency"  class="form-control empty selectpicker" data-live-search="true" data-width="100%">
										<option value="">SELECT STATUS</option>
										<option value="1">HIGH</option>
										<option value="3">LOW</option>
										<option value="2">MEDIUM</option>
									</select>
                                        </div>
                                    </div> 
                                </div>
                            </div>
                            <div class="panel-footer text-center">
                                <button class="btn btn-success" type="submit">Search</button>
                            </div>
                        </form>
                        
                    </div>
        
                </div>
            
        </div>
        <div class="row">
            <div class="panel">
            
                <div class="panel-body">
                    <table id="demo-dt-addrow" class="table table-striped table-bordered" cellspacing="0" width="100%">
                        <thead>
                            <tr>
                                <th>S.No</th>
                                <th>Ticket No.</th>
                                <th class="min-tablet">Ticket Type </th>
								<th class="min-tablet">Urgency</th>
                                <th class="min-tablet">Full Name</th>
                                <th class="min-tablet">Title</th>
                                <th class="min-tablet">Status</th>
                                <th class="min-tablet">Date</th>
                            </tr>
                        </thead>
                        <tbody>
							@php $sn=0; @endphp
                            @foreach($tickets as $tk)
                            <tr>
                                <td>{{++$sn}}</td> 
                                <td><a class="btn-link" href="{{url('employee_ticket_reply/'.$tk->TICKET_ID)}}"> {{$tk->TICKET_NO}} </a></td>
                                <td>{{$tk->TICKET_FOR}}</td>
								 <td>{{$tk->URGENCY}}</td>
                                <td>
                                    @foreach($users as $u)
                                    @if($u->RegId == $tk->USER_ID)
                                    {{$u->MemberName}} <br><b>{{$u->RegCode}}</b>
                                    @endif
                                    @endforeach
                                </td>
                                <td>{{$tk->SUBJECT}}</td>
                                <td>{{$tk->STATUS}}</td>
                                <td>{{$tk->CREATED_AT}}</td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            
            </div>
        </div>
        </div>

            
    </div>
    <!--===================================================-->
    <!--End page content-->

</div>


<!--===================================================-->
<!--END CONTENT CONTAINER-->

<script src="http://ajax.googleapis.com/ajax/libs/jquery/2.0.0/jquery.min.js"></script>
@endsection