@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Employee Panel</h1>
		</div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->
		
		
        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
			<li><a href="{{url('/'.Session::get("dash_url"))}}"><i class="demo-pli-home"></i></a></li>
			<li><a href="{{url('/'.Session::get("dash_url"))}}">Dashboard</a></li>
			<li class="active">Search By Number</li>
		</ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->
		
	</div>
	
    @if ($errors->any())
    <div class="alert alert-danger">
        <ul>
            @foreach ($errors->all() as $error)
			<li>{{ $error }}</li>
            @endforeach
		</ul>
	</div>
    @endif
	
    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">
		
        <div class="row">
            <div class="col-lg-offset-3 col-lg-6">
                <div class="panel">
					
                    <div class="panel-heading">
                        <div class="panel-control">
                            <button class="btn btn-default" data-panel="minmax"><i class="demo-psi-chevron-up"></i></button>
						</div>
                        <h3 class="panel-title">Search By Number</h3>
					</div>
                    
                    <div class="collapse in">	
					@if(Session::has('message')) 
							<div class="alert alert-{{ Session::get('type') }} alert-dismissible show" role="alert">
								<h4 class="alert-heading">{{ Session::get('message') }}</h4>
								<button type="button" class="close" data-dismiss="alert" aria-label="Close">
									<span aria-hidden="true">&times;</span>
								</button>
							</div>
						@endif
						<form action="{{url('search_recharge')}}" method="post" accept-charset="utf-8">
							{{ csrf_field() }} 
                            <div class="panel-body">
                                <div class="row">
                                    <div class="col-sm-4">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_contactno">Phone Number</label>
                                            <input type="text" id="txt_contactno" name="txt_contactno" class="form-control" placeholder="Enter Phone Number.">
										</div>
									</div>    
                                    <div class="col-sm-4">
                                        <div class="form-group">
                                            <label class="control-label" style="display:block;">&nbsp;</label>
                                            <button class="btn btn-success" type="submit">Find</button>
										</div>
									</div>
								</div>
							</div>    
						</form>  
						
						
						
					</div>
					
				</div>
			</div>
            
		</div>

		<div class="row">
            <div class="panel">
            
                <div class="panel-body">
  
                    <table id="demo-dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
						<thead>
							<tr>
								<th>S.NO.</th>
								<th>TXN DATE</th>
								<th>MEMBERID/NAME</th>
								<th>CONSUMERNO</th>
								<th>OPERATOR</th>
								<th>STATUS</th>
								<th>TXN ID</th>
								<th>OP.BAL</th>
								<th>AMOUNT</th>
								<th>COMMI</th>
								<th>CL.BAL</th>
								<th>VIA</th>
								<td>ACTION</td>
								
							</tr>
						</thead>
						<tbody>
							@foreach( $rec_report as $con)
							<tr>
								<td>{{ '#' }}</td>
								<td>{{ $con->RequestDate }}</td>
								<td>{{ $con->RegCode }}/ {{ $con->MemberFirstName  }}</td>
								<td>{{ $con->Account }}</td>
								<td>{{ $con->ServiceProvider }}</td>
								<td>
									@if( $con->Status == 'SUCCESS') 
									<button type="button" class="btn btn-success btn-xs">{{ $con->Status }}</button>
									@elseif( $con->Status == 'PENDING') 
									<button type="button" class="btn btn-warning btn-xs">{{ $con->Status }}</button>
									@else
									<button type="button" class="btn btn-danger btn-xs">{{ $con->Status }}</button>
									@endif
								</td>
								<td>{{ $con->LiveId }}</td>
								
								<td>{{ $con->PreBal }}</td>
								<td>{{ $con->Amount }}</td>
								<td>{{ $con->Commision }}</td>
								<td>{{ $con->PostBal }}</td>
								<td>{{ $con->RequestType }}</td>
								@if( $con->Status == 'PENDING') 
									<td>
										<button type="button" class="btn btn-warning btn-xs" data-toggle="modal" 
										data-account="{{$con->Account}}" data-recstatus="{{$con->Status}}" data-recopertid="{{$con->LiveId}}"
										data-amount="{{$con->Amount}}" data-rechid="{{$con->RechargeID}}" data-transid="{{$con->Transactionid}}" 
										data-target="#status_modal" title="ACTION" onClick="show_rechdetails2(this)">ACTION</button>
									</td>
								@else
									<td></td>
								@endif
							</tr>
							@endforeach
						</tbody>

					</table>
                    </table>
                </div>
            
            </div>
        </div>
        
		
	</div>
    <!--===================================================-->
    <!--End page content-->
	
</div>

@endsection

