@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Employee Panel</h1>
		</div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->
		
		
        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
			<li><a href="{{url('/'.Session::get("dash_url"))}}"><i class="demo-pli-home"></i></a></li>
			<li><a href="{{url('/'.Session::get("dash_url"))}}">Dashboard</a></li>
			<li class="active">Search By Number</li>
		</ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->
		
	</div>
	
    @if ($errors->any())
    <div class="alert alert-danger">
        <ul>
            @foreach ($errors->all() as $error)
			<li>{{ $error }}</li>
            @endforeach
		</ul>
	</div>
    @endif
	
    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">
		
        <div class="row">
            <div class="col-lg-offset-3 col-lg-6">
                <div class="panel">
					
                    <div class="panel-heading">
                        <div class="panel-control">
                            <button class="btn btn-default" data-panel="minmax"><i class="demo-psi-chevron-up"></i></button>
						</div>
                        <h3 class="panel-title">Search By Number</h3>
					</div>
                    
                    <div class="collapse in">	
					@if(Session::has('message')) 
							<div class="alert alert-{{ Session::get('type') }} alert-dismissible show" role="alert">
								<h4 class="alert-heading">{{ Session::get('message') }}</h4>
								<button type="button" class="close" data-dismiss="alert" aria-label="Close">
									<span aria-hidden="true">&times;</span>
								</button>
							</div>
						@endif
						<form action="" method="post" accept-charset="utf-8">
							{{ csrf_field() }} 
                            <div class="panel-body">
                                <div class="row">
                                    <div class="col-sm-4">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_contactno">Phone Number</label>
                                            <input type="text" id="txt_contactno" name="txt_contactno" class="form-control" placeholder="Enter Phone Number.">
										</div>
									</div>    
                                    <div class="col-sm-4">
                                        <div class="form-group">
                                            <label class="control-label" style="display:block;">&nbsp;</label>
                                            <button class="btn btn-success" type="submit">Find</button>
										</div>
									</div>
								</div>
							</div>    
						</form>  
						
						
						
					</div>
					
				</div>
			</div>
            
		</div>

		<div class="row">
            <div class="panel">
            
                <div class="panel-body">
  
                    <table id="demo-dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
						<thead>
							<tr>
								<th>S.NO.</th>
								<th>TXN DATE</th>
								<th>MEMBERID/NAME</th>
								<th>REMITTER</th>
								<th>BENE NAME</th>
								<th>BENE A/cNO</th>
								<th>BENE IFSCODE</th>
								<th>AMOUNT</th>
								<th>CCF</th>
								<th>BANK REF NO</th>
								<th>STATUS</th>						
								<th>ACTION</th>
								<th>PRINT</th>
								
							</tr>
						</thead>
						<tbody>
		                   @foreach( $dmt_report as $con)
							<tr>
								<td>{{ '#' }}</td>
								<td>{{ $con->Date_createdat }}</td>
								<td>{{ $con->RegCode }}-</br>[{{ $con->MemberFirstName}} {{ $con->MemberLastName}} ]</td>
								<td>{{ $con->Mobile_no}}</td>
								<td>{{ $con->Beneficiary_name }}</td>
								<td>{{ $con->Account_number }}</td>
								<td>{{ $con->IFSCode }}</td>
								<td>{{ $con->Amount }}</td>
								<td>{{ $con->Topup_charge }}</td>
								<td>{{ $con->Impsrefno }}</td>
								<td>
								@if( $con->Transfer_status == 'SUCCESS' || $con->Transfer_status == 'REJECT' || $con->Transfer_status == 'RSUCCESS') 
								<button type="button" class="btn btn-success btn-xs">{{ $con->Transfer_status }}</button>
								@elseif( $con->Transfer_status == 'PENDING') 
								<button type="button" class="btn btn-warning btn-xs">{{ $con->Transfer_status }}</button>
								@elseif( $con->Transfer_status == 'FAILED'|| $con->Transfer_status == 'REFUNDED'|| $con->Transfer_status == 'RFAILED') 
								<button type="button" class="btn btn-danger btn-xs">{{ $con->Transfer_status }}</button>
								@else
								<button type="button" class="btn btn-info btn-xs">{{ $con->Transfer_status }}</button>
								@endif
								</td>
								@if( Session::get('USER_ID') ==-1 )
								
										@if( $con->Transfer_status == 'SUCCESS' || $con->Transfer_status == 'FOR REFUND' || $con->Transfer_status == 'REJECT') 
										<td>
											<button type="button" class="btn btn-warning btn-xs" data-toggle="modal" 
											 data-recopertid="{{$con->Impsrefno}}" data-account="{{$con->Account_number}}" data-recstatus="{{$con->Transfer_status}}"
											data-amount="{{$con->Amount}}" data-rechid="{{$con->Dmr_id}}" data-transid="{{$con->Transactionid}}" 
											data-target="#tid_modal" title="ACTION" onClick="show_dmtdetails(this)">ACTION</button></td>
										@elseif( $con->Transfer_status == 'PENDING') 
										<td>
											<button type="button" class="btn btn-warning btn-xs" data-toggle="modal" 
											data-recopertid="{{$con->Impsrefno}}" data-account="{{$con->Account_number}}" data-recstatus="{{$con->Transfer_status}}"
									data-amount="{{$con->Amount}}" data-rechid="{{$con->Dmr_id}}" data-transid="{{$con->Transactionid}}" 
											data-target="#status_modal" title="ACTION" onClick="show_rechdetails2(this)">ACTION</button></td>
										@elseif( $con->Transfer_status == 'FAILED' || $con->Transfer_status == 'REFUNDED') 
										<td>
											<button type="button" class="btn btn-warning btn-xs" data-toggle="modal" 
										 data-recopertid="{{$con->Impsrefno}}" data-account="{{$con->Account_number}}" data-recstatus="{{$con->Transfer_status}}"
									data-amount="{{$con->Amount}}" data-rechid="{{$con->Dmr_id}}" data-transid="{{$con->Transactionid}}" 
											data-target="#failed_refunded_modal" title="ACTION" onClick="show_rechdetails1(this)">ACTION</button></td>
										@else
										<td></td>
										@endif
											<td>
											<button type="button" class="btn btn-info btn-xs" data-toggle="modal" data-target="#response_modal" title="VIEW RESPONSE"  data-response="{{$con->Remarks}}" 
												data-rechresponse="{{$con->Remarks}}" onClick="show_response(this)">VIEW RESPONSE</button>
											</td>
									@else
									<td>
										@if( $con->Transfer_status == 'SUCCESS') 
										<button type="button" class="btn btn-warning btn-xs" data-toggle="modal" 
										data-account="{{$con->Account_number}}" data-recstatus="{{$con->Transfer_status}}"
										data-amount="{{$con->Amount}}" data-rechid="{{$con->Dmr_id}}" data-transid="{{$con->Transactionid}}" 
										data-target="#complaint_modal" title="COMPLAINT" onClick="raise_dispute(this)">COMPLAINT</button>
										@endif
									</td>
								@endif
							
								<td></td>
							</tr>
	                        @endforeach
						</tbody>

					</table>
                    </table>
                </div>
            
            </div>
        </div>
        
		
	</div>
    <!--===================================================-->
    <!--End page content-->
	
</div>

@endsection

