@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Employee Panel</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{url('/'.Session::get("dash_url"))}}"><i class="demo-pli-home"></i></a></li>
        <li><a href="{{url('/'.Session::get("dash_url"))}}">Dashboard</a></li>
        <li class="active">REFFERAL BONUS POINT DETAILS</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>

    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">

        <div class="row">
            <div class="col-lg-offset-3 col-lg-6">
            
                <div class="panel">
                    <div class="panel-heading">
                        <div class="panel-control">
                            <button class="btn btn-default" data-panel="minmax"><i class="demo-psi-chevron-up"></i></button>
                        </div>
                        <h3 class="panel-title">REFFERAL BONUS POINT DETAILS</h3>
                    </div>

                    <div class="collapse in">
        
                        <form action="{{ url('emp_refferal_bonus_report') }}" class="cmxform form-horizontal" id="signupForm" method="post" accept-charset="utf-8">
    									{{ csrf_field() }}
                            <div class="panel-body">
                                <div class="row">
                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="col-md-3 control-label" for="txt_from">From Date</label>
                                            <div class="col-md-9">
                                                <div id="demo-dp-txtinput">
                                                    <input type="text" name="txt_from" id="txt_from" value="{{$start}}" class="form-control input-inline input-medium" placeholder="dd/mm/yyyy" autocomplete="off" >
                                                </div>
                                            </div>
                                        </div>
                                    </div>    
                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="col-md-3 control-label" for="txtto">To Date</label>
                                            <div class="col-md-9">
                                                <div id="demo-dp-txtinput">
                                                    <input type="text" name="txt_to" id="txt_to" value="{{$end}}"  class="form-control input-inline input-medium" placeholder="dd/mm/yyyy" autocomplete="off" >
                                                </div>
                                            </div>
                                        </div>
                                    </div> 

                                </div>
                            </div>
                            <div class="panel-footer text-center">
                                <button class="btn btn-success" type="submit">Search</button>
                            </div>
                        </form>
                        
                    </div>
        
                </div>
            </div>
        </div>

        <div class="row">
            <div class="panel">
            
                <div class="panel-body">
                    <table id="demo-dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
                        <thead>
                            <tr>
                                <th>SNO.</th>
                                <th>TRANSACTION DATE</th>
                                <th>MEMBER </th>
                                <th>REFERRAL BY</th>
                                <th class="min-tablet">DESCRIPTION</th>
                                <th class="min-tablet">AMOUNT</th>
                                <th class="min-tablet">DEDUCTION</th>
								<th class="min-tablet">STATUS</th>
                            </tr>
                        </thead>
                        <tbody>
                           <?php $sn = 1;?>
								@foreach( $direct_report as $con)
								<tr>
									<td>{{ $sn++ }}</td>
									<td>{{ $con->DIRECT_ENTRYDATE}}</td>
									<td>{{ $con->REFERRAL_ID }}</td>
									<td>{{ $con->DIRECT_USERID }}</td>
								   
									<td>{{'REFFERAL BONUS POINT'}}</td>
									<td>{{ $con->DIRECT_AMOUNT}}</td>
									<td>{{ $con->DIRECT_TDSCHARGE}}</td>
									<td><span class="label label-table label-success">{{ $con->DIRECT_ISPUBLISH }}</span></td>
								</tr>
								@endforeach
                        </tbody>
                    </table>
                </div>
            
            </div>
        </div>
        
            
    </div>
    <!--===================================================-->
    <!--End page content-->

</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->
@endsection
