@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Master Panel</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{url('/'.Session::get("dash_url"))}}"><i class="demo-pli-home"></i></a></li>
        <li><a href="{{url('/'.Session::get("dash_url"))}}">Dashboard</a></li>
        <li class="active">PREPAID API SEQUENCE SLAB WISE</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>

    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">

        <div class="row">

            <div class="col-lg-offset-4 col-lg-4">
            
                <div class="panel">

                    <div class="panel-heading">
                        <div class="panel-control">
                            <button class="btn btn-default" data-panel="minmax"><i class="demo-psi-chevron-up"></i></button>
                        </div>
                        <h3 class="panel-title">PREPAID API SEQUENCE SLAB WISE</h3>
                    </div>

                    <div class="collapse in">
                        
                        <form action="{{url('/emp_prepaidapi_sequences')}}" method="POST">
                            {{ csrf_field() }}
                            <div class="panel-body">
                                <div class="row">

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="dd_group">Group</label>
                                            <select class="form-control" name="dd_group" id="dd_group" required>
                                                <option value="-1">SELECT GROUP</option>
                                                @foreach($slab as $sb)
                                                <option value="{{ $sb->GROUP_ID }}">{{$sb->GROUP_NAME}}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>

                                </div>

                            </div>
                            <div class="panel-footer text-center">
                                <button class="btn btn-success" type="submit">Save</button>
                                <button class="btn btn-default" type="button">Close</button>
                            </div>
                        </form>

                        
                    </div>
        
                </div>

            </div>
            
        </div>

        <div class="row">

            <div class="panel">

                <div class="panel-heading">
                    <h3 class="panel-title">PREPAID API SEQUENCE SLAB WISE</h3>
                </div>
            
                <div class="panel-body">
                    <table id="demo-dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
                        <thead>
                            <tr>
                                <th>S. NO.</th>
                                <th>SERVICE TYPE</th>
                                <th class="min-tablet">TELECOM OPERATOR</th>
                                <th class="min-tablet">API1</th>
                                <th class="min-tablet">API2</th>
                                <th class="min-tablet">API3</th>
                                <th class="min-tablet">API4</th>
                                <th class="min-tablet">API5</th>
                                <th class="min-tablet">API6</th>
                                <th class="min-tablet">STOP RECHARGE</th>
                                <th class="min-tablet">ACTION</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($margin as $mr)
                            <tr>
                                <td>{{$mr->SN}}</td>
                                <td>{{$mr->ServiceName}}</td>
                                <td>{{$mr->BrandName}}</td>
                                <td>
                                    <select class="form-control" name="dd_api1" id="dd_api1">
                                        <option value="-1">SELECT API</option>
                                        @foreach($api as $ap)
                                        <option value="{{ $ap->API_ID }}">{{$ap->API_NAME}}</option>
                                        @endforeach
                                    </select>
                                </td>
                                <td>
                                    <select class="form-control" name="dd_api2" id="dd_api2">
                                        <option value="-1">SELECT API</option>
                                        @foreach($api as $ap)
                                        <option value="{{ $ap->API_ID }}">{{$ap->API_NAME}}</option>
                                        @endforeach
                                    </select>
                                </td>
                                <td>
                                    <select class="form-control" name="dd_api3" id="dd_api3">
                                        <option value="-1">SELECT API</option>
                                        @foreach($api as $ap)
                                        <option value="{{ $ap->API_ID }}">{{$ap->API_NAME}}</option>
                                        @endforeach
                                    </select>
                                </td>
                                <td>
                                     <select class="form-control" name="dd_api4" id="dd_api4">
                                        <option value="-1">SELECT API</option>
                                        @foreach($api as $ap)
                                        <option value="{{ $ap->API_ID }}">{{$ap->API_NAME}}</option>
                                        @endforeach
                                    </select>
                                </td>
                                <td>
                                    <select class="form-control" name="dd_api5" id="dd_api5">
                                        <option value="-1">SELECT API</option>
                                        @foreach($api as $ap)
                                        <option value="{{ $ap->API_ID }}">{{$ap->API_NAME}}</option>
                                        @endforeach
                                    </select>
                                </td>
                                <td>
                                     <select class="form-control" name="dd_api6" id="dd_api6">
                                        <option value="-1">SELECT API</option>
                                        @foreach($api as $ap)
                                        <option value="{{ $ap->API_ID }}">{{$ap->API_NAME}}</option>
                                        @endforeach
                                    </select>
                                </td>
                                <td>
                                    <select class="form-control" name="dd_status" id="dd_status">
                                        <option value="-1">ACTIVE</option>
                                        <option value="-1">STOP</option>
                                    </select>
                                </td>
                                <td>
                                    <button type="submit" class="btn btn-primary btn-md val">UPDATE</button>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            
            </div>
        </div>
            
    </div>
    <!--===================================================-->
    <!--End page content-->

</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->
@endsection
