@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Master Panel</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{url('/'.Session::get("dash_url"))}}"><i class="demo-pli-home"></i></a></li>
        <li><a href="{{url('/'.Session::get("dash_url"))}}">Dashboard</a></li>
        <li class="active">PREPAID MARGIN SLAB WISE</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>

    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">

        <div class="row">

            <div class="col-lg-offset-4 col-lg-4">
            
                <div class="panel">

                    <div class="panel-heading">
                        <div class="panel-control">
                            <button class="btn btn-default" data-panel="minmax"><i class="demo-psi-chevron-up"></i></button>
                        </div>
                        <h3 class="panel-title">PREPAID MARGIN SLAB WISE</h3>
                    </div>

                    <div class="collapse in">
                        
                        <form action="{{url('emp_prepaid_margin')}}" method="POST">
                            {{ csrf_field() }}
                            <div class="panel-body">
                                <div class="row">

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="dd_group">Group</label>
                                            <select class="form-control" name="dd_group" id="dd_group" required>
                                                <option value="-1">SELECT GROUP</option>
                                                @foreach($slab as $sb)
                                                <option value="{{ $sb->GROUP_ID }}">{{$sb->GROUP_NAME}}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="dd_operator">Operator</label>
                                            <select class="form-control" name="dd_operator" id="dd_operator" required>
                                                <option value="-1">SELECT OPERATOR</option>
                                                @foreach($OPERATOR as $op)
                                                <option value="{{ $op->TelecomBrandId }}">{{ $op->BrandName }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>

                                </div>

                            </div>
                            <div class="panel-footer text-center">
                                <button class="btn btn-success" type="submit">Save</button>
                                <button class="btn btn-default" type="button">Close</button>
                            </div>
                        </form>

                        
                    </div>
        
                </div>

            </div>
        </div>    
            
        

        <div class="row">
            <div class="panel">

                <div class="panel-heading">
                    <h3 class="panel-title">PREPAID MARGIN SLAB WISE</h3>
                </div>
            
                <div class="panel-body">
                    <table id="demo-dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
                        <thead>
                            <tr>
                                <th>S NO.</th>
                                <th>SERVICE TYPE</th>
                                <th class="min-tablet">TELECOM OPERATOR</th>
                                <th class="min-tablet">VALUE</th>
                                <th class="min-tablet">METHOD</th>
                                <th class="min-tablet">TYPE</th>
                                <th class="min-tablet">ACTION</th>
                            </tr>
                        </thead>
                        <tbody>
                            <button class="btn btn-success pull-left" id="btn_check_all">UPDATE ALL</button>
                            @foreach($margin as $mr)
                            <form action="" method="post">
                                <tr>
                                    <td><input type="checkbox" id="txt_check{{$mr->MarginId}}" class="txt_check" name="txt_check" value="{{$mr->MarginId}}"></td>
                                    <td>{{$mr->SN}}</td>
                                    <td>{{$mr->ServiceType}}</td>
                                    <td>{{$mr->BrandName}}</td>
                                    <td><input class="form-control" type="number" id="txt_margin{{$mr->MarginId}}" name="txt_margin" value="{{$mr->Margin}}"></td>
                                    <td>
                                        <select class="form-control" name="dd_distribution" id="dd_distribution{{$mr->MarginId}}">
                                            <option value="1" {{$mr->METHOD == 1 ? 'selected' : ''}}>MARGIN</option>
                                            <option value="2" {{$mr->METHOD == 2 ? 'selected' : ''}}>SURCHARGE</option>
                                        </select>
                                    </td>
                                    <td>
                                        <select class="form-control" name="dd_margintype" id="dd_margintype{{$mr->MarginId}}">
                                            <option value="1" {{$mr->TYPE == 1 ? 'selected' : ''}}>PERCENTAGE</option>
                                            <option value="2" {{$mr->TYPE == 2 ? 'selected' : ''}}>FIX</option>
                                        </select>
                                    </td>
                                    <td>
                                        <button type="submit" class="btn btn-primary btn-md val">UPDATE</button>
                                    </td>
                                </tr>
                            </form>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            
            </div>
        </div>
            
    </div>
    <!--===================================================-->
    <!--End page content-->

</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->
<script src="http://ajax.googleapis.com/ajax/libs/jquery/2.0.0/jquery.min.js"></script>
<script type="text/javascript">
$(document).ready(function() {
    $("#btn_check_all").click(function(){
        var clicked = false;
        var id = [];
        var check_id = '';
        var value = [];
        var method = [];
        var type = [];
        $(".txt_check").prop("checked", !clicked);
        $.each($("input[name='txt_check']:checked"), function(){
            check_id = $(this).val();
            id.push($(this).val());
            value.push($("#txt_margin" + check_id).val());
            method.push($("#dd_distribution" + check_id).val());            
            type.push($("#dd_margintype" + check_id).val());
        });

        if(id){
            $.ajax({
               type:"POST",
               url:"{{url('/update_margin')}}",
               data:{"_token": "{{ csrf_token() }}", "ids": id, "values": value, "methods": method, "types": type},
               success:function(result)
               {   
                    if(result){
                        window.location.href = "/prepaid_margin";
                    }
               } 
            });
        }
        
    });

    $("input[name='txt_check']").click(function(){
        var clicked = false;
        var id = [];
        var check_id = '';
        var value = [];
        var method = [];
        var type = [];
        $(this).prop("checked", !clicked);
        $.each($("input[name='txt_check']:checked"), function(){
            check_id = $(this).val();
            alert(check_id);
            id.push($(this).val());
            value.push($("#txt_margin" + check_id).val());
            method.push($("#dd_distribution" + check_id).val());            
            type.push($("#dd_margintype" + check_id).val());
        });

        if(id){
            $.ajax({
               type:"POST",
               url:"{{url('/update_margin')}}",
               data:{"_token": "{{ csrf_token() }}", "ids": id, "values": value, "methods": method, "types": type},
               success:function(result)
               {   
                    if(result == 1){
                        window.location.href = "/prepaid_margin";
                    }
               } 
            });
        }
        
    });
});

</script>
@endsection
