@extends('mainlayout')
@section('content')
<?php $folder = ''; ?>
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Pending Recharge</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->
        
        
        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
            <li><a href="{{url('/'.Session::get("dash_url"))}}"><i class="demo-pli-home"></i></a></li>
            <li><a href="{{url('/'.Session::get("dash_url"))}}">Recharge Report</a></li>
            <li class="active">Pending Recharge</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->
        
    </div>
    
    
    <!--Page content-->
    <!--===================================================-->


    <div id="page-content">
         <div class="row">
            
                <div class="panel">
                    
                    <div class="panel-heading">
                        <div class="panel-control">
                            <button class="btn btn-default" data-panel="minmax"><i class="fa fa-arrow-circle-up"></i></button>
                        </div>
                        <h3 class="panel-title">Pending Recharge Report</h3>
                    </div>

                    <div class="collapse out">
        
                        <form action="{{url('/emp_pendingrecharge_report')}}" method="POST">
                            {{ csrf_field() }}
                            <div class="panel-body">
                                <div class="row">
                                    <div class="col-sm-2">
                                        <div class="form-group">
                                            <label class="control-label" for="txtfromdate">From Date</label>
                                            <div id="demo-dp-txtinput">
                                                <input type="text" name="txtfromdate" id="txtfromdate" class="form-control input-inline input-medium" placeholder="YYYY-MM-DD" autocomplete="off" >
                                            </div>
                                        </div>
                                    </div>    
                                    <div class="col-sm-2">
                                        <div class="form-group">
                                            <label class="control-label" for="txttodate">To Date</label>
                                            <div id="demo-dp-txtinput">
                                                <input type="text" name="txttodate" id="txttodate" class="form-control input-inline input-medium" placeholder="YYYY-MM-DD" autocomplete="off" >
                                            </div>
                                        </div>
                                    </div>
                                <div class="col-sm-2">
                                        <div class="form-group">
                                            <label class="control-label" for="txtuserid">Consumer No</label>
                                            <input type="text" id="txt_account" name="txt_account" class="form-control input-inline input-medium" placeholder="Enter Consumer No." >
                                        </div>
                                    </div> 
								<div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="txt_memberid">Member Id</label>
                                        <input type="text" id="txt_memberid" name="txt_memberid" class="form-control" placeholder="Enter Member Id." >
                                    </div>
                                </div>
                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="txtuserid">Trnx ID</label>
                                        <input type="text" id="txt_transid" name="txt_transid" class="form-control input-inline input-medium" placeholder="Enter User ID." >
                                    </div>
                                </div>  

								<div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label">Api</label>
                                        <select name="dd_api" id="dd_api" class="form-control selectpicker" data-live-search="true" data-width="100%">
                                            <option value="-1">Select Api</option>
                                            @foreach($API as $api)
                                            <option value="{{ $api->API_ID }}">{{$api->API_NAME}}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label">Operator</label>
                                        <select name="dd_operator" id="dd_operator" class="form-control selectpicker" data-live-search="true" data-width="100%">
                                            <option value="-1">Select Operator</option>
                                            @foreach($OPERATOR as $op)
                                            <option value="{{ $op->TelecomBrandId }}">{{ $op->BrandName }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                    
                                </div>
                            </div>
                            <div class="panel-footer text-center">
                                <button class="btn btn-success" type="submit">Search</button>
								<button class="btn btn-primary" type="reset">Reset</button>
                            </div>
                        </form>
                        
                    </div>
        
                </div>
            
        </div>

         <div class="row">
            <div class="panel">
            <div class="col-md-12 mb-10 mt-10">
						<button type="button" id="all_success" class="btn btn-success pull-left mr-5" data-toggle="tooltip" data-placement="bottom" title="ALL SUCCESS" data-original-title="ALL SUCCESS">ALL SUCCESS</button>
						<button type="button" id="all_failed" class="btn btn-danger pull-left mr-5" data-toggle="tooltip" data-placement="bottom" title="ALL REFUND" data-original-title="ALL REFUND">ALL REFUND</button>
				</div>
                <div class="panel-body">
 <div class="mb-10 text-right"><button class="btn btn-success " type="button" onclick="EXPORTTOEXCEL('pendingrecharge_report');"><i class="fa fa-file-excel-o" aria-hidden="true"></i> Export To Excel</button></div>
                    <table id="demo-dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
                        <thead>
                            <tr>
								<th><input type="checkbox" name="all_check" id="all_check" value="-1"/></th>
                                <th>S.NO.</th>
                                <th>TXN_DATE</th>
                                <th>MEMBERID/NAME</th>
                                <th>CONSUMERNO</th>
                                <th>OPERATOR</th>
                                <th>CIRCLE</th>
                                <th>STATUS</th>
                                <th>TXN_ID</th>
                                <th>OP.BAL</th>
                                <th>AMOUNT</th>
                                <th>COMMI</th>
                                <th>CL.BAL</th>
                                <th>VIA</th>
								<th>API</th>
                                <th>ACTION</th>
								<th>VIEW_RESPONSE</th>
								<th>RECEIPT</th>
								<th>HIT CALLBACK</th>
                            </tr>
                        </thead>
                        <tbody>
							@php 
							$PreBal =0;
							$Amount =0;
							$Commision =0;
							$PostBal =0;
							@endphp
                            @foreach( $rec_report as $no => $con)
                            <tr>
                                <td><input type="checkbox" name="pending" value="{{$con->Transactionid}}" /></td>
								<td>{{ $no+1}}</td>
                                <td>{{ $con->RequestDate }}</td>
                                <td>{{ $con->RegCode }}-</br>[{{ $con->MemberFirstName}} {{ $con->MemberLastName}}]</br>[{{ $con->MemberAffiliate}}]</br>[{{ $con->MemberRole}}]</td>
                                <td>{{ $con->Account }}</td>
                                <td>{{ $con->ServiceProvider }}</td>
                                <td>{{ $con->CircleName }}</td>
                                <td>
                                    @if( $con->Status == 'SUCCESS') 
                                    <button type="button" class="btn btn-success btn-xs">{{ $con->Status }}</button>
                                    @elseif( $con->Status == 'PENDING') 
                                    <button type="button" class="btn btn-warning btn-xs">{{ $con->Status }}</button>
                                    @else
                                    <button type="button" class="btn btn-danger btn-xs">{{ $con->Status }}</button>
                                    @endif
                                </td>
                                <td>{{ $con->LiveId }}</td>
                                <td>{{ $con->PreBal }}</td>
                                <td>{{ $con->Amount }}</td>
                                <td>{{ $con->Commision }}</td>
                                <td>{{ $con->PostBal }}</td>
                                <td>{{ $con->RequestType }}</td>
								<td>{{ $con->ApiName }}</td>
								@if( $con->Status == 'SUCCESS' || $con->Status == 'FOR REFUND' || $con->Status == 'REJECT') 
								<td>
									<button type="button" class="btn btn-warning btn-xs" data-toggle="modal" 
									data-account="{{$con->Account}}" data-recstatus="{{$con->Status}}" data-recopertid="{{$con->LiveId}}"
									data-amount="{{$con->Amount}}" data-rechid="{{$con->RechargeID}}" data-transid="{{$con->Transactionid}}" 
									data-target="#tid_modal" title="ACTION" onClick="show_rechdetails(this)">ACTION</button></td>
								@elseif( $con->Status == 'PENDING') 
								<td>
									<button type="button" class="btn btn-warning btn-xs" data-toggle="modal" 
									data-account="{{$con->Account}}" data-recstatus="{{$con->Status}}" data-recopertid="{{$con->LiveId}}"
									data-amount="{{$con->Amount}}" data-rechid="{{$con->RechargeID}}" data-transid="{{$con->Transactionid}}" 
									data-target="#status_modal" title="ACTION" onClick="show_rechdetails2(this)">ACTION</button></td>
								@elseif( $con->Status == 'FAILED' || $con->Status == 'REFUNDED') 
								<td>
									<button type="button" class="btn btn-warning btn-xs" data-toggle="modal" 
									data-account="{{$con->Account}}" data-recstatus="{{$con->Status}}" data-recopertid="{{$con->LiveId}}"
									data-amount="{{$con->Amount}}" data-rechid="{{$con->RechargeID}}" data-transid="{{$con->Transactionid}}" 
									data-target="#failed_refunded_modal" title="ACTION" onClick="show_rechdetails1(this)">ACTION</button></td>
								@else
								<td></td>
								@endif
								<td><button type="button" class="btn btn-info btn-xs" data-toggle="modal" data-target="#response_modal" title="VIEW RESPONSE" 
									data-rechresponse="{{$con->Remarks}}"  data-response="{{$con->Remarks}}"onClick="show_response(this)">VIEW RESPONSE</button>
								</td>
								@if( $con->Status == 'SUCCESS')
								<td><a class="btn btn-warning btn-xs" href="{{url('bill_receipt/'.$con->Transactionid)}}" target="_blank">PRINT RECEIPT</a></td>
								@else
								<td></td>
								@endif
				    	<td><input type="hidden" id="txt_rechtxnid" name="txt_rechtxnid" value="{{$con->Transactionid}}"/><button type="button" class="btn btn-success btn-xs" title="HIT CALLBACK" onClick="hit_callback({{$con->Transactionid}})">HIT CALLBACK</button></td>
						</tr>

							@php 
							$PreBal =$con->PreBal + $PreBal;
							$Amount =$con->Amount + $Amount;
							$Commision =$con->Commision+ $Commision;
							$PostBal =$con->PostBal+$PostBal;
							@endphp

                       @endforeach
						</tbody>
                        <tfoot>
                            <tr>
                                <th>#</th>
                                <th></th>
   <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th>Total</th>
                                <th>{{number_format($Amount, 2)}}</th>
                                <th>{{number_format($Commision, 2)}}</th>
                                <th></th>
                                <th></th>
								<th></th>
                                <th></th>
								<th></th>
								<th></th>
								<th></th>
                            </tr>
                        </tfoot>
					</table>
                </div>
            
            </div>
        </div>
        
    </div>
    <!--===================================================-->
    <!--End page content-->
    <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
<script>
 $('#all_check').change(function(){
    if($(this).prop('checked')){
        $('tbody tr td input[type="checkbox"]').each(function(){
            $(this).prop('checked', true);
        });
    }else{
        $('tbody tr td input[type="checkbox"]').each(function(){
            $(this).prop('checked', false);
        });
    }
});
</script>
<script>
$('#all_success').click(function(){
	var myCheckboxes = new Array();
	$("input[name='pending']:checked").each(function(){
	if($(this).val()>0)
	myCheckboxes.push($(this).val());
	});
	console.log(myCheckboxes);
	if(myCheckboxes.length > 0)
	{
	$.ajax({	
		type:"POST",
		url:"{{ url('/update_rechargestatus') }}",
		dataType: 'json',
		data:{"txt_transid":myCheckboxes,"txt_operid":'N/A',"status":"SUCCESS",_token: '{{csrf_token()}}',_method: "PATCH"},
		success: function(response){
				alert("Recharge Success Update Successfully!");
				console.log(response);
				//window.location.reload(); 
        },
        error: function( req, status, err ) {
           console.log( 'something went wrong', status, err );
			alert(err);
        }
		}); 
	}
	else
	{
		alert("Please select recharge for change the status.");
	}
	});
$('#all_failed').click(function(){
	var myCheckboxes = new Array();
	$("input[name='pending']:checked").each(function(){
	if($(this).val()>0)
	myCheckboxes.push($(this).val());
	});
	console.log(myCheckboxes);
	if(myCheckboxes.length > 0)
	{
		$.ajax({	
			type:"POST",
			url:"{{ url('update_rechargestatus') }}",
			dataType: 'json',
			data:{"txt_transid":myCheckboxes, "txt_operid":'N/A',"status":"FAILURE",_token: '{{csrf_token()}}',_method: "PATCH"},
			success: function(response){
					alert("Recharge Refund Update Successfully!");
					console.log(response);
					//window.location.reload(); 
			},
			error: function( req, status, err ) {
				console.log( 'something went wrong', status, err );
				alert(err);
			}
		}); 
	}
	else
	{
		alert("Please select user for change the status.");
	}
});
</script>
</div>

 <!-- Modal content-->
<div class="modal fade" id="response_modal" role="dialog">
		<div class="modal-dialog">
		  <!-- Modal content-->
			<div class="modal-content">
				<div class="modal-header">
					<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
					<h4 class="modal-title" id="status_modallabel"><center>RECHARGE RESPONSE</center></h4>
				</div>
				<div class="modal-body fs-12">
					<div class="col-md-12 col-sm-12 col-xs-12" >
						<div class="form-group mb-0">
						<label class="control-label"> <span id="rech_response" style="overflow-wrap: break-word;"></span></label>
						</div>
					</div>	
					<center>RESPONSE AFTER API HIT</center>
				</div>
			</div>
			<script type="text/javascript">
				function show_response(obj)
				{
				//$('#rech_response').text($(obj).data('rechresponse'));
				var myJSON = JSON.stringify($(obj).data('response'));
				document.getElementById("rech_response").innerHTML = myJSON;
				} 
			</script>
		</div>
	</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->
@endsection