@extends('mainlayout')
@section('content')
<style>
table.dataTable thead .sorting:after, 
table.dataTable thead .sorting_asc:after, 
table.dataTable thead .sorting_desc:after, 
table.dataTable thead .sorting_asc_disabled:after, 
table.dataTable thead .sorting_desc_disabled:after {
    position: absolute;
    bottom: 8px;
    right: 8px;
    display: none;
    font-family: 'Glyphicons Halflings';
    opacity: 0.5;
}
</style>
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Employee Panel</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{url('/'.Session::get("dash_url"))}}"><i class="demo-pli-home"></i></a></li>
        <li><a href="{{url('/'.Session::get("dash_url"))}}">Dashboard</a></li>
        <li class="active">PAYMENT RELEASE REPORT</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>

    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">

        <div class="row">
            
            <div class="panel">
                <div class="panel-heading">
                    <div class="panel-control">
                        <button class="btn btn-default" data-panel="minmax"><i class="demo-psi-chevron-up"></i></button>
                    </div>
                    <h3 class="panel-title">PAYMENT RELEASE REPORT</h3>
                </div>

                <div class="collapse in">
    
                     <form action="{{ url('/emp_payment_release_report') }}" method="post">
                    {{ csrf_field() }}
                       <div class="panel-body">  
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label class="control-label" for="txt_fromdate">From Date</label>
                                    <div id="demo-dp-txtinput">
                                        <input type="text" name="txt_fromdate" id="txt_fromdate" class="form-control" placeholder="dd/mm/yyyy" autocomplete="off" >
                                    </div>
                                </div>                                
                            </div>
                        
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label class="control-label" for="txt_todate">To Date</label>
                                    <div id="demo-dp-txtinput">
                                        <input type="text" name="txt_todate" id="txt_todate" class="form-control" placeholder="dd/mm/yyyy" autocomplete="off" >
                                    </div>
                                </div>
                            </div>

                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label class="control-label" for="txt_memberid">User Id*</label>
                                    <input type="text" name="txt_memberid" id="txt_memberid" class="form-control input-inline input-medium">

                                </div>
                            </div>
                           

                        </div>
                       
                        <div class="panel-footer text-center">
                            <button class="btn btn-success" type="submit">Search</button>
                        </div>
                    </form>
                    
                </div>
    
            </div>
            
        </div>

        <div class="row">
            <div class="panel">
            
                <div class="panel-body">
                   <table id="demo-dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
                       <thead>
							<tr>
                                <th>SNo.</th>
                                <th>PAY DATE</th>
								<th>USER ID</th>
								<th class="min-tablet">USER NAME</th>
								<th class="min-tablet">AMOUNT </th>
								<th class="min-tablet">PAY MODE</th>
								<th class="min-tablet">REMARK</th>
								<th class="min-tablet">DESCRIPTION</th>
							</tr>
                        </thead>
                        <tbody>
                            <?php $sn = 1;?>
                                @foreach( $ledger_report as $con)
                                <tr>
                                    <td>{{ $sn}}</td>
                                    <td>{{ $con->TransactionDate}}</td>
                                    <td>{{ $con->MemberID }}</td>
                                    <td>{{ $con->MemberFirstName }} {{ $con->MemberLastName }}</td>
                                    <td>{{$con->AmountDedited}}</td>
                                    <td>{{ $con->TransFrom }}</td>
                                    <td>{{ $con->Description}}</td>
                                    <td>Payment disbursed.</td>
                                    
                                </tr>
                                <?php $sn=$sn+1;?>
                                @endforeach
                        </tbody>
                    </table>
                </div>
            
            </div>
        </div>
        
            
    </div>
    <!--===================================================-->
    <!--End page content-->

</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->
@endsection

