@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Employee Panel</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{url('/'.Session::get("dash_url"))}}"><i class="demo-pli-home"></i></a></li>
        <li><a href="{{url('/'.Session::get("dash_url"))}}">Dashboard</a></li>
        <li class="active">Admin Ledger</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>

    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">

        <div class="row">
            
            <div class="panel">
                <div class="panel-heading">
                    <div class="panel-control">
                        <button class="btn btn-default" data-panel="minmax"><i class="demo-psi-chevron-up"></i></button>
                    </div>
                    <h3 class="panel-title">Admin Ledger</h3>
                </div>

                <div class="collapse in">
    
                   <form action="{{url('/emp_main_ledger')}}" enctype="multipart/form-data" id="fund_transfer" method="post" accept-charset="utf-8">
                        {{ csrf_field() }} 
                            <div class="panel-body">
                                <div class="row">    

                                    <div class="col-sm-2">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_datefrom">From Date</label>
                                            <div id="demo-dp-txtinput">
                                                <input type="text" name="txt_datefrom" id="txt_datefrom"  value="{{$start}}"  class="form-control input-inline input-medium" placeholder="dd/mm/yyyy" autocomplete="off" >
                                            </div>
                                        </div>
                                    </div>    

                                    <div class="col-sm-2">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_dateto">To Date</label>
                                            <div id="demo-dp-txtinput">
                                                <input type="text" name="txt_dateto" id="txt_dateto"  value="{{$end}}" class="form-control input-inline input-medium" placeholder="dd/mm/yyyy" autocomplete="off" >
                                            </div>    
                                        </div>
                                    </div> 
                           
                                
                                    <div class="col-sm-2">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_transid">Transaction Id</label>
                                            <input type="text" name="txt_transid" id="txt_transid" value="{{$txt_transid}}"  class="form-control" placeholder="Enter Transaction Id.">
                                        </div>
                                    </div>

                                    <div class="col-sm-2">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_records">No. Of Records</label>
                                            <input type="text" name="txt_records" id="txt_records"  value="{{$txt_noofrecords}}" class="form-control" placeholder="Enter No. Of Records" >
                                        </div>
                                    </div>

                                    <div class="col-sm-2">
                                        <div class="form-group">
                                            <label class="control-label">Ledger Status</label>
                                            <select name="dd_ledgertype"  class="form-control">
                                                <option value="-1">Select Ledger</option>
                                                <option value="1" {{$dd_ledgertype == 1? 'Selected':''}}>Fund Credit</option>
                                            </select>
                                        </div>
                                    </div>

                                </div>
                            </div>
                            <div class="panel-footer text-center">
                                <input type="submit" id="btnsubmit" class="btn btn-success" >
                                <input type="reset" id="btnsreset" class="btn btn-primary" >                            
                            </div>
                        </form>
                    
                </div>
    
            </div>
            
        </div>

        <div class="row">
            <div class="panel">
            
                <div class="panel-body">
                    <div class="text-right">
                        <div class="form-group">
                            <button class="btn btn-success" id="excel" onclick="EXPORTTOEXCEL('fund_wallet_transfer');">Export To Excel</button>
                        </div>
                    </div>
                    <table id="demo-dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
                        <thead>
                            <tr>
                                <th>SNO.</th>
                                <th>MEMBERID/NAME</th>
                                <th class="min-tablet">TRANSACTION ID</th>
                                <th class="min-tablet">TRANSACTION DATE</th>
                                <th class="min-tablet">DESCRIPTION</th>
                                <th class="min-tablet">CR. AMOUNT</th>
                                <th class="min-tablet">DR. AMOUNT</th>
                                <th class="min-tablet">BALANCE FOR</th>
                                <th class="min-tablet">MAINBAL</th>
                                <th class="min-tablet">PAYOUTBAL</th>
                                <th class="min-tablet">REWARDBAL</th>
                            </tr>
                        </thead>
                        <tbody>
							@foreach( $ledger_report as $con)
							 <tr>
							 <td >{{'#'}}</td >
            <td>{{$con->MemberID}}<span style="color:red;">/</span>{{$con->MemberFirstName}} {{$con->MemberLastName}}</td>
			<td>{{$con->Transactionid}}</td>
			<td>{{$con->TransactionDate}}</td>
			<td>{{$con->Description}}</td>
			<td>{{$con->AmountCredited}}</td>
			<td>{{$con->AmountDedited}}</td>
			<td>{{$con->BalanceType}}</td>
			<td>{{$con->CurrentBalance}}</td>
			<td>{{$con->UtilityBalance}}</td>
			<td>{{$con->RemittanceBalance}}</td>
			</tr>
			 @endforeach
						</tbody>
                    </table>
                </div>
            
            </div>
        </div>
            
    </div>
    <!--===================================================-->
    <!--End page content-->

</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->
@endsection
