@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Employee Panel</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{url('/'.Session::get("dash_url"))}}"><i class="demo-pli-home"></i></a></li>
        <li><a href="{{url('/'.Session::get("dash_url"))}}">Dashboard</a></li>
        <li class="active">KYC REPORT</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>

    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">
        
        <div class="row">
            <div class="panel">

                <div class="panel-heading">
                    <div class="panel-control">
                        <button class="btn btn-default" data-panel="minmax"><i class="demo-psi-chevron-up"></i></button>
                    </div>
                    <h3 class="panel-title">ALL MEMBER KYC DETAILS</h3>
                </div>

                <div class="collapse in">
    
                    <form action="{{url('/emp_kyc')}}" method="POST">
                        {{ csrf_field() }}
                        <div class="panel-body">

                            <div class="col-sm-4">
                                <div class="form-group">
                                    <label class="control-label">Members</label>
                                    <div class="radio">
                                        <input id="rballmembers" class="magic-radio" type="radio" name="rb_kycst" value="0" 
                                               <?php echo ($kycst=='ALL')?'checked':''?>>
                                        <label for="rballmembers">All Members</label>

                                        <input id="rbjoinmember" class="magic-radio" type="radio" name="rb_kycst" value="2"
                                               <?php echo ($kycst=='PENDING')?'checked':''?>>
                                        <label for="rbjoinmember">Pending KYC</label>

                                        <input id="rbtopupmember" class="magic-radio" type="radio" name="rb_kycst" value="1"
                                               <?php echo ($kycst=='APPROVED')?'checked':''?>>
                                        <label for="rbtopupmember">Approved KYC</label>
                                    </div>
                                </div>
                            </div>    

                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label class="control-label" for="txtfromdate">From Date</label>
                                    <div id="demo-dp-txtinput">
                                        <input type="text" name="txt_fromdate" id="txt_fromdate" value="{{$start}}" class="form-control" placeholder="YYYY-mm-dd" autocomplete="off" >
                                    </div>
                                </div>                                
                            </div>
                        
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label class="control-label" for="txttodate">To Date</label>
                                    <div id="demo-dp-txtinput">
                                        <input type="text" name="txt_todate" id="txt_todate" value="{{$end}}" class="form-control" placeholder="YYYY-mm-dd" autocomplete="off" >
                                    </div>
                                </div>
                            </div>

                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label class="control-label" for="txtuserid">Member Id</label>
                                    <input type="text" id="txt_userid" name="txt_userid"  value="{{$txt_memberids}}" class="form-control" placeholder="Enter User Id.">
                                </div>
                            </div>
                            
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label class="control-label">Position</label>
                                    <select class="form-control" id="dd_pos" name="dd_pos">
                                       <option value="-1">Select</option>
                                            <option value="LEFT" {{$pos == 'LEFT'? 'selected':''}}>Left</option>
                                            <option value="RIGHT" {{$pos == 'RIGHT'? 'selected':''}}>Right</option>
                                    </select>
                                </div>
                            </div>

                        </div>
                       
                        <div class="panel-footer text-center">
                            <button class="btn btn-success" type="submit">Search</button>
                            <button class="btn btn-success" type="button">Export To Excel</button>
                        </div>
                    </form>
                </div>
    
            </div>
        </div> 

        <div class="row">
            <div class="panel">
            
                <div class="panel-body">
                    <div class="table-responsive">
                 <table id="demo-dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
						<thead>
							<tr>
								<th>STATUS</th>
								<th>SPONSOR ID</th>
								<th>MEMBERID/ NAME</th>
								<th>CONTACTNO</th>
								<th>QUALIFICATION</th>
								<th>PANCARD</th>
								<th>AADHAR</th>
								<th>IDPROOFTYPE</th>
								<th>IDPROOF</th>
								<th>ADDRESS</th>
								<th>ADDRESSPROOF</th>
								
								<th>ACTION</th>				
							</tr>
						</thead>
						<tbody>
							@foreach( $userkyc_report as $con)
							<tr>
								<td>{{ $kycst }}</td>
								<td>{{ $con->ReferralMobileNo }}</td>
								<td>{{ $con->MemberCode }}/{{$con->FirstName.' '.$con->LastName}}</td>
								<td>{{ $con->MemberContactNo }}</td>
								<td>{{ $con->Qualification }}</td>
								<td>{{ $con->Pancarno }}</td>
								<td>{{ $con->AadharCard }}</td>
								<td>{{ $con->IDProofType }}</td>
								<td><img src="{{ asset('/images/USER_IDPROOF/'.$con->IDProof) }}" height="100" /></td>
								<td>{{ $con->Address }}</td>
								<td><img src="{{ asset('/images/USER_ADDRESSPROOF/'.$con->AddressProof) }}" height="100" /> </td>
								<td><button type="button" class="btn {{($con->KYCStatus=='APPROVED')?'btn-success':'btn-danger'}} btn-xs" data-toggle="modal" data-target="#kycstatus_modal" title="CHANGE KYC STATUS" onclick="get_user_details(this,'{{ $con->RegId }}');" data-mobileno="{{ $con->MemberContactNo}}" data-fname="{{$con->FirstName}}" data-lname="{{$con->LastName}}" ><i class="fa fa-{{($con->KYCStatus=='APPROVED')?'check':'close'}}"></i>
								</button></td>
                            </tr>
							@endforeach
						</tbody>
					   
							</table>
                </div>
            </div>
            </div>
        </div>     
            
    </div>
    <!--===================================================-->
    <!--End page content-->

</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->
<div class="modal fade" id="kycstatus_modal" role="dialog">

		<div class="modal-dialog">
		  <!-- Modal content-->
		  <div class="modal-content">
		  <form action="{{'user_kycstatus'}}" class="cmxform form-horizontal" method="post" >
		  	{{ csrf_field() }}
			 <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true"></span></button>
                <h4 class="modal-title" id="status_modallabel"><center>CHANGE USER KYC STATUS</center></h4>
             </div>
			<div class="modal-body">
			
				<div class="col-md-12 col-sm-12 col-xs-12" >
					<div class="form-group">
					<label class="control-label">USER NAME :- <span id="statususer_mobileno"></span> [<span id="user_fname"></span> <span id="user_lname"></span>]</label>
					<input id="txt_statusmobileno" name="txt_statusmobileno" type="hidden" class="form-control" required="required">
					<input id="txt_statusregid" name="txt_statusregid" type="hidden" class="form-control" required="required">
					</div>
				</div>	
				<center>Would you like to change the status of user kyc ?</center>
			
			</div>
			<div class="modal-footer">
				<button type="button" class="btn btn-default" data-dismiss="modal" onclick="javascript:window.location.reload()">NO</button>
				<button type="submit" class="btn btn-primary">YES</button>
			</div>
			</form>
		  </div>
		</div>
	</div>
	
			
		
			<script>
				$('.loader').hide();
				function get_img(obj)
				{
				$('#put_img').attr('src', '');
				var key = '{{ asset("/images/")}}/' + $(obj).data('img');
				$('#put_img').attr('src', key);
				}
				function get_user_details(obj,id)
				{

					$('#txt_statusmobileno').val($(obj).data('mobileno'));
					$('#txt_statusregid').val(id);
					$('#statususer_mobileno').html($(obj).data('mobileno'));
					$('#user_fname').html($(obj).data('fname'));
					$('#user_lname').html($(obj).data('lname'));
					
				
				} 
			</script>
@endsection