@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Employee Panel</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{url('/'.Session::get("dash_url"))}}"><i class="demo-pli-home"></i></a></li>
        <li><a href="{{url('/'.Session::get("dash_url"))}}">Dashboard</a></li>
        <li class="active">Fund Request</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>

    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">
        
        <!--div class="row">
            <div class="col-lg-offset-3 col-lg-6">
              <div class="panel">

                  <div class="panel-heading">
                      <div class="panel-control">
                          <button class="btn btn-default" data-panel="minmax"><i class="demo-psi-chevron-up"></i></button>
                      </div>
                      <h3 class="panel-title">Fund Request</h3>
                  </div>

                  <div class="collapse in">
      
                      <form action="{{url('/emp_fund_request')}}" method="POST">
                        {{csrf_field()}}
                          <div class="panel-body form-horizontal form-padding">

                              <div class="row">

                                  <div class="col-sm-12">
                                      <div class="form-group">
                                          <label class="col-md-3 control-label" for="txt_memberid">Member Id</label>
                                          <div class="col-md-9">
                                              <input type="text" name="txt_memberid" id="txt_memberid" class="form-control" placeholder="Enter Member Id." required>
                                          </div>
                                      </div>
                                  </div>

                                  <div class="col-sm-12">
                                      <div class="form-group">
                                          <label class="col-md-3 control-label" for="txt_datefrom">From Date</label>
                                          <div class="col-md-9">
                                              <div id="demo-dp-txtinput">
                                                  <input type="text" name="txt_datefrom" id="txt_datefrom" class="form-control input-inline input-medium" placeholder="dd/mm/yyyy" autocomplete="off" >
                                              </div>
                                          </div>    
                                      </div>
                                  </div>   

                                  <div class="col-sm-12">
                                      <div class="form-group">
                                          <label class="col-md-3 control-label" for="txt_dateto">To Date</label>
                                          <div class="col-md-9">
                                              <div id="demo-dp-txtinput">
                                                  <input type="text" name="txt_dateto" id="txt_dateto" class="form-control input-inline input-medium" placeholder="dd/mm/yyyy" autocomplete="off" >
                                              </div>
                                          </div>    
                                      </div>
                                  </div>                                   

                              </div>

                          </div>
                         
                          <div class="panel-footer text-center">
                              <button class="btn btn-success" type="submit">Search</button>
                              <button class="btn btn-success" type="reset">Cancel</button>                            

                          </div>
                      </form>
                  </div>
      
              </div>
            </div>
        </div --> 

        <div class="row">
            <div class="panel">

                <div class="panel-heading">
                    <h3 class="panel-title">Fund Request</h3>
                </div>
            
                <div class="panel-body">
                    <div class="text-right">
                        <div class="form-group">
                            <button class="btn btn-success" id="excel" onclick="EXPORTTOEXCEL('fund_req_status');">Export To Excel</button>
                        </div>
                    </div>
                    <table id="demo-dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
                        <thead>
               	<tr>
								<th>#</th>
								<th>STATUS</th>
								<th>MEMBER ID</th>
								<th>MEMBER NAME</th>
								<th>PAYEE NAME</th>
								<th>ACCOUNT NO</th>
								<th>BANK NAME</th>
								<th>PAYMENT MODE</th>
								<th>WALLET TYPE</th>
								<th>AMOUNT</th>
								<th>UTR/BANK REFRENCE</th>
								<th>REMARK</th>
								<th>ADMIN REPLY</th>
								<th>TRANSACTION ID</th>
								<th>REQUEST DATE</th>						
								<th>UPDATED DATE</th>
								<th>ACTION</th>
							</tr>
              </thead>
              <tbody>
             <?php $sn =  1; ?>
			  @foreach( $fund_req_toadmin as $ba)
             <tr>
			 <td>{{$sn}}</td>
			 <td>@if($ba->FUNDREQ_STATUS == 'APPROVED') 
						<button type="button" class="btn btn-success btn-xs">{{strtoupper($ba->FUNDREQ_STATUS)}}</button>
						@elseif( $ba->FUNDREQ_STATUS  == 'PENDING') 
						<button type="button" class="btn btn-warning btn-xs">{{strtoupper($ba->FUNDREQ_STATUS)}}</button>
						@elseif( $ba->FUNDREQ_STATUS  == 'CANCELED') 
						<button type="button" class="btn btn-danger btn-xs">{{strtoupper($ba->FUNDREQ_STATUS)}}</button>
						@else
						<button type="button" class="btn btn-info btn-xs">{{strtoupper($ba->FUNDREQ_STATUS)}}</button>
						@endif
</td>
			 <td>{{$ba->MEMBER_CONTACT}}</td>
			 <td>{{$ba->MEMBER_FIRSTNAME}} {{$ba->MEMBER_LASTNAME}}</td>
			
			 <td>{{$ba->FUNDREQ_PAYEE}}</td>
			 <td>{{$ba->FUNDREQ_ACCOUNTNO}}</td>
		     <td>{{$ba->BANK_NAME}}</td>
			 <td>{{$ba->FUNDREQ_MODE}}</td>
			 <td>{{$ba->FUNDREQ_TOWALLET}}</td>
			 <td>{{strtoupper($ba->FUNDREQ_AMOUNT)}}</td>
			 <td>{{strtoupper($ba->FUNDREQ_UTRNO)}}</td>
			 <td>{{strtoupper($ba->FUNDREQ_DESCRIPTION)}}</td>
			 <td>{{strtoupper($ba->FUNDREQ_ADMINRES)}}</td>
			 <td>{{$ba->FUNDREQ_TRANID}}</td>
			 <td>{{strtoupper($ba->FUNDREQ_CREATEDAT)}}</td>
			 <td>{{strtoupper($ba->FUNDREQ_UPDATEAT)}}</td>
			 <td>@if($ba->FUNDREQ_STATUS=="PENDING")
                  <button type="button" class="btn btn-success btn-xs" data-toggle="modal" data-target="#status_modal" title="{{$ba->FUNDREQ_STATUS}}" onclick="get_status_details(this,'{{ $ba->FUNDREQ_ID }}');" data-status="APPROVED" data-trasnid="{{$ba->FUNDREQ_TRANID}}" data-amount="{{$ba->FUNDREQ_AMOUNT}}" data-mobieno="{{$ba->MEMBER_CONTACT}}" >
                  ACCEPT</button>
				  <button type="button" class="btn btn-danger btn-xs" data-toggle="modal" data-target="#status_modal" title="{{$ba->FUNDREQ_STATUS}}" onclick="get_status_details(this,'{{ $ba->FUNDREQ_ID }}');" data-status="CANCELED" data-trasnid="{{$ba->FUNDREQ_TRANID}}" data-amount="{{$ba->FUNDREQ_AMOUNT}}" data-mobieno="{{$ba->MEMBER_CONTACT}}" >
                  REJECT</button>
				  @endif
				  </td>
			 </tr>
			 <?php $sn =  $sn+1; ?>
			 @endforeach
              </tbody>
                    </table>
                </div>
            
            </div>
        </div>   
            
    </div>
    <!--===================================================-->
    <!--End page content-->

</div>
	<div class="modal fade" id="status_modal" role="dialog">
    <div class="modal-dialog">
      <!-- Modal content-->
      <div class="modal-content">
      <form action="{{url('emp_fundrequest_status')}}" class="cmxform form-horizontal" enctype="multipart/form-data" method="post" >
        {{ csrf_field() }}
       <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
                <h4 class="modal-title" id="status_modallabel"><center>CHANGE FUND REQUEST STATUS</center></h4>
             </div>
      <div class="modal-body">
        <div class="col-md-12 col-sm-12 col-xs-12" >
          <div class="form-group">
          <label class="control-label">REQUEST TRANSACTION ID :-  <span id="request_trasnid"></span></label>
		  <label class="control-label">REQUEST AMOUNT :-  <span id="request_amount"></span></label>
          <input id="txt_mobileno" name="txt_mobileno" type="hidden" class="form-control" required="required">
          <input id="txt_amount" name="txt_amount" type="hidden" class="form-control" required="required">
          <input id="txt_status" name="txt_status" type="hidden" class="form-control" required="required">
          <input id="txt_fundrequestid" name="txt_fundrequestid" type="hidden" class="form-control" required="required">
          </div>
        </div>  
		<div class="col-md-12 col-sm-12 col-xs-12" >
          <div class="form-group">
		  <label class="control-label">WOULD YOU LIKE TO -  <span id="request_status" style="color:red; "></span> THIS FUND REQUEST.</label>
          </div>
        </div>
		<div class="col-md-12 col-sm-12 col-xs-12" >
          <div class="form-group">
		  <label class="control-label">ADMIN REPLY</label>
		  <input id="txt_adminreply" name="txt_adminreply" type="text" class="form-control" required="required">
          </div>
        </div>
        <center>Would you like to change the status of fund request.?</center>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal" onclick="javascript:window.location.reload()">NO</button>
        <button type="submit" class="btn btn-primary">YES</button>
      </div>
      </form>
      </div>
    </div>
  </div>
  <script>
    $('.loader').hide();
    function get_status_details(obj,id)
    {
      $('#txt_fundrequestid').val(id);
      $('#txt_status').val($(obj).data('status'));
      $('#request_status').html($(obj).data('status'));
      $('#request_trasnid').html($(obj).data('trasnid'));
      $('#request_amount').html($(obj).data('amount'));
      $('#txt_amount').val($(obj).data('amount'));
      $('#txt_mobileno').val($(obj).data('mobieno'));
    } 
  </script>
<!--===================================================-->
<!--END CONTENT CONTAINER-->
@endsection
