@extends('mainlayout')
@section('content')
<style>
.error {
    border-color: red;
}
</style>
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Employee Panel</h1>
		</div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->
        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
			<li><a href="{{url('/'.Session::get("dash_url"))}}"><i class="fa fa-home"></i></a></li>
			<li><a href="{{url('/'.Session::get("dash_url"))}}">Employee</a></li>
			<li class="active">Employee Registration</li>
		</ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->
	</div>
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">
        <div class="row">
			<div class="col-lg-offset-3 col-lg-6">
				
                <div class="panel">

                	@if(Session::has('message')) 
					<div class="alert alert-{{ Session::get('type') }} alert-dismissible  show" role="alert">
						<h4 class="alert-heading">{{ Session::get("message") }}</h4>
						<button type="button" class="close" data-dismiss="alert" aria-label="Close">
							<span aria-hidden="true">&times;</span>
						</button>
					</div>
					@endif
					
                    <div class="panel-heading">
						
                        <div class="panel-control">
                            <button class="btn btn-default" data-panel="minmax"><i class="demo-psi-chevron-up"></i></button>
						</div>
                        <h3 class="panel-title">Employee Registration</h3>
					</div>
                    <div class="collapse in">
                        <form action="{{ url('employee_signup') }}" enctype="multipart/form-data"  id="empForm" method="post" accept-charset="utf-8">
							{{ csrf_field() }} 
                            <div class="panel-body">
                                <div class="row">
                                    <div class="col-sm-4">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_referralcode">Referral User Id *</label>
                                            <input type="text" id="txt_referralcode" name="txt_referralcode" class="form-control empty" placeholder="Enter Referral User Id." required  onfocusout="get_employee_name();" onfocusin="get_employee_name();" >
										</div>
									</div>    
                                    <div class="col-sm-4">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_username">Name</label>
                                            <input type="text" class="form-control empty" placeholder="Referral Name" name="txt_referralname" id="txt_referralname" required autocomplete="off">
										</div>
									</div>
                                    <div class="col-sm-4">
                                        <div class="form-group">
                                            <label class=" control-label">Position</label>
                                            <div class="" style="margin-top: 5px;">
                                                <input id="demo-inline-form-radio-2" class="magic-radio" type="radio" name="position" value="JUNIOR" required>
                                                <label for="demo-inline-form-radio-2">JUNIOR</label>
                                                <input id="demo-inline-form-radio-3" class="magic-radio" type="radio" name="position" value="SENIOR">
                                                <label for="demo-inline-form-radio-3">SENIOR</label>
											</div>
										</div>
									</div>
								</div>
                                <div class="row">
                                    <legend>Profile</legend>
									<div class="col-sm-6">
										<div class="form-group">
											<label class="control-label" for="txt_username">Name</label>
											<input type="text" class="form-control" placeholder="Full Name" name="txt_username" id="txt_username" required>
										</div>
									</div>
									<div class="col-sm-6">
										<div class="form-group">
											<label class="control-label" for="txt_email">Email Id</label>
											<input type="email" class="form-control" placeholder="Your E-mail" name="txt_email" id="txt_email" required>
										</div>
									</div>
									
								</div>
                                <div class="row">
									<div class="col-sm-6">
										<div class="form-group">
											<label class="control-label" for="txt_mobileno">Mobile No.</label>
											<input type="number" class="form-control" placeholder="Mobile No." name="txt_mobileno" id="txt_mobileno" required>
										</div>
									</div>
									<div class="col-sm-6">    
										<div class="form-group">
											<label class="control-label" for="txt_dob">Date Of Birth</label>
											<div id="demo-dp-txtinput">
												<input name="txt_dob" id="txt_dob" type="text" class="form-control" date_format="YYYY-mm-dd" placeholder="dd/mm/yyyy" autocomplete="off" required>
											</div>
										</div>
									</div>
								</div>
                                <div class="row">
									<div class="col-sm-6">
										<div class="form-group">
											<label class="control-label" for="txt_address">Address</label>
											<textarea class="form-control" name="txt_address" id="txt_address" rows="5" style="height:;"required ></textarea>
										</div>
									</div>

									<div class="col-sm-12">
										<div class="form-group">
											<label class="control-label" for="dd_role">Role</label>
											<select class="form-control selectpikcer" name="dd_role" id="dd_role" data-live-search="true" data-width="100%" required>
												<option value="2">SALES</option>
												<option value="3">SUPPORT</option>
												<option value="4">ACCOUNT</option>
												<option value="5">TECHNICAL</option>
												<option value="7">BACKOFFICE</option>
											</select>
										</div>
									</div>
                                    <div class="col-sm-6">
										<div class="form-group">
											<label class="control-label" for="txt_aadhar">Aadhar Number <span style="color: #e30808;font-size: 10px;">(eg. 1234 5678 9876)</span></label>
											<input type="text" id="txt_aadhar" name="txt_aadhar" class="form-control" placeholder="Enter Aadhar Number." onchange="aadharValidate();" required>
											<span id="txt_aad_err" style="color:red;"></span>
										</div>
                                    </div>
                                    <div class="col-sm-6">
										<div class="form-group">
											<label class="control-label" for="txt_panno">PAN Card Number <span style="color: #e30808;font-size: 10px;">(eg. ALMPJ4444J)</span></label>
											<input type="text" id="txt_panno" name="txt_panno" class="form-control" placeholder="Enter PAN Card Number." onchange="panValidate();" required>
											<span id="txt_pan_err" style="color:red;"></span>
										</div>
										<span class="error"></span>
                                    </div>
									<div class="col-sm-6">
										<div class="form-group">
											<label class="control-label" for="txt_accno">Account Number <span style="color: #e30808;font-size: 10px;">(eg. 1233455345345)</span></label>
											<input type="text" id="txt_accno" name="txt_accno" class="form-control" placeholder="Enter Account Number." onchange="accnoValidate();" required>
											<span id="txt_acc_err" style="color:red;"></span>
										</div>
                                    </div>
                                    <div class="col-sm-6">
										<div class="form-group">
											<label class="control-label" for="txt_ifsccode">IFSC Code <span style="color: #e30808;font-size: 10px;">(eg. ASDF1234567)</span></label>
											<input type="text" id="txt_ifsccode" name="txt_ifsccode" class="form-control" placeholder="Enter IFSC Code." onchange="ifscValidate();" required>
											<span id="txt_ifsc_err" style="color:red;"></span>
										</div>
                                    </div>
                                    <div class="col-sm-6">
										<div class="form-group">
											<label class="control-label" for="dd_bank">Bank Name</label>
											<select class="form-control selectpicker" name="dd_bank" id="dd_bank" data-live-search="true" data-width="100%">
												@foreach($banks as $b)
												<option value="{{$b->BANK_ID}}">{{$b->BANK_NAME}}</option>
												@endforeach
											</select>
										</div>
                                    </div>
                                    <div class="col-sm-6">
										<div class="form-group">
											<label class="control-label" for="txt_branchname">Branch Name</label>
											<input type="text" id="txt_branchname" name="txt_branchname" class="form-control" placeholder="Enter Branch Name." required>
										</div>
                                    </div>
									
									<input type="hidden" name="dd_status" value="1">
									<input type="hidden" name="txt_shopname" value="sads">
									<input type="hidden" name="txt_gstno" value="sdfs">
								</div>  
								
                                <div class="row">
                                    <legend>Login Details</legend>
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_password">Password</label>
                                            <input type="password" class="form-control" placeholder="Password" name="txt_password" id="txt_password" required>
										</div>
									</div>    
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_confpassword">Confirm Password</label>
                                            <input type="password" class="form-control" placeholder="Password" name="txt_confpassword" id="txt_confpassword" required>
										</div>
									</div>
								</div>
                               
		

                                <div class="row">
								<div class="col-sm-offset-4 col-sm-4 text-center">
									<div class="checkbox" style="margin-top: 28px;">
										<input id="terms" class="magic-checkbox" type="checkbox" name="ckbterms" value="0" required>
									<label for="terms">I Accept Terms & Condition</label>
									</div>
								</div>
								</div>
							</div>
                            <div class="panel-footer text-center">
                                <button id="regbtn" class="btn btn-success" type="button" onclick="conwv1('empForm')">Register</button>
							</div>
						</form>
					</div>
				</div>
			</div>
		</div>
	</div>
    <!--===================================================-->
    <!--End page content-->
</div>
<!--===================================================-->

<!--END CONTENT CONTAINER-->
@endsection