@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Update Profile</h1>
		</div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->
		
		
        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
			<li><a href="{{url('/'.Session::get("dash_url"))}}"><i class="fa fa-home"></i></a></li>
			<li><a href="{{url('/'.Session::get("dash_url"))}}">Profile</a></li>
			<li class="active">Update Profile</li>
		</ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->
		
	</div>
	
    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">
		
        <div class="row">
            <div class="col-lg-offset-3 col-lg-6">
				
				<div class="panel">
				@if(Session::has('message')) 
				<div class="alert alert-{{ Session::get('type') }} alert-dismissible  show" role="alert">
					<h4 class="alert-heading">{{ Session::get("message") }}</h4>
					<button type="button" class="close" data-dismiss="alert" aria-label="Close">
						<span aria-hidden="true">&times;</span>
					</button>
				</div>
				@endif
					
					<div class="panel-heading">
						<div class="panel-control">
							<button class="btn btn-default" data-panel="minmax"><i class=" fa fa-arrow-circle-up"></i></button>
						</div>
						<h3 class="panel-title">Edit Your Profile</h3>
					</div>
					
					<div class="collapse in">
						@if($get_useralldetail != '')
						@foreach( $get_useralldetail as $con)
						@endforeach
						<form id="profile_update" action="{{ url('emp_updateprofile') }}" enctype="multipart/form-data" method="post" accept-charset="utf-8">      
							{{ csrf_field() }}
							<div class="panel-body">
								
								<div class="row">
									<div class="col-sm-6">
										<div class="form-group">
											<label class="control-label" for="txt_username">Name <span style="color:red">(eg.First Name {SPACE} Last Name)</span></label>
											<input type="text" id="txt_username" name="txt_username" class="form-control" value="{{$con->FirstName}} {{ $con->LastName}}" required>
										</div>
									</div>
									
									<div class="col-sm-6">
										<div class="form-group">
											<label class="control-label" for="txt_email">Email Id</label>
											<input type="text" id="txt_email" name="txt_email" class="form-control" value="{{$con->MemberEmail}}" required>
										</div>
									</div>
								</div>
								<div class="row">	
									<div class="col-sm-6">
										<div class="form-group">
											<label class="control-label" for="txt_mobileno">Mobile No.</label>
											<input type="text" id="txt_mobileno" name="txt_mobileno" class="form-control" value="{{$con->MemberContactNo}}" required>
										</div>
									</div>
									<div class="col-sm-6">    
										<div class="form-group">
											<label class="control-label" for="txt_dob">Date Of Birth</label>
											<div id="demo-dp-txtinput">
												<input id="txt_dob" name="txt_dob" type="text" class="form-control" value="{{$con->MemberDOB}}" autocomplete="off" required >
											</div>
										</div>
									</div>
								</div>
								<div class="row">
									<div class="col-sm-6">
										<div class="form-group">
											<label class="control-label" for="txt_address">Address</label>
											<textarea class="form-control" id="txt_address" name="txt_address" rows="1" required>{{$con->MemberLocation}}</textarea>
										</div>
									</div>
									
									
									
									<div class="col-sm-6">   
										<div class="form-group">
											<label class="control-label" for="txt_pin">Postal Code</label>
											<input type="text" id="txt_postalcode" name="txt_postalcode" class="form-control" placeholder="Enter Pin Code." required value="{{$con->MemberPostalCode}}">
										</div>
									</div>
								</div>
								<div class="row">
									<div class="col-sm-6">
										<div class="form-group">
											<label class="control-label" for="txt_yourphoto">Your Photo Upload</label><br>
											@if($con->MemberImage!='')
											<img src="{{ asset('/images/USER_PHOTO/'.$con->MemberImage) }}" height="100" />
											@else
											<img src="{{ asset('images/user.png') }}" height="100" />
											@endif
											
											<input type="hidden" name="txt_yourphotohd" id="txt_yourphotohd" value="{{$con->MemberImage}}"> 
											<input type="file" name="txt_yourphoto" id="txt_yourphoto" class="form-control" required>
										</div>
									</div>
								
									
								</div> 
								
							</div>
							<div class="panel-footer text-center">
								<button class="btn btn-success" type="button" onclick="conwv('profile_update')">UPDATE</button>
								<button type="reset" class="btn btn-primary">RESET</button>	
							</div>
						</form>
						@endif
					</div>
					
				</div>
				
			</div>
		</div>
		
	</div>
	<!--===================================================-->
	<!--End page content-->
	
</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->
@endsection