@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">View Profile</h1>
		</div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->
		
		
        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
			<li><a href="{{url('/'.Session::get("dash_url"))}}"><i class="fa fa-home"></i></a></li>
			<li><a href="{{url('/'.Session::get("dash_url"))}}">Profile</a></li>
			<li class="active">View Profile</li>
		</ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->
		
	</div>
	
    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">
		
        <div class="row">
            <div class="col-sm-3">
                <div class="panel">
                    <div class="panel-heading">
                        <h3 class="panel-title">User Profile</h3>
					</div>
					
                    <!-- Striped Table -->
                    <!--===================================================-->
                    <div class="panel-body">
                        <div class="table-responsive">
							<center>
								<!-- Current avatar -->
								@if($user[0]->MemberImage!='')
								<img src="{{ asset('images/USER_PHOTO/' .$user[0]->MemberImage) }}" alt="WELCOME "  title="" class="img-circle profile_img" style="height:200px;width:200px;">
								@else
								<img src="{{ asset('images/user.png') }}" alt="WELCOME" title="" class="img-circle profile_img">
								@endif
								<h3>{{ $user[0]->FirstName}} {{ $user[0]->LastName}}</h3>
							</center>
                            <table class="table table-striped">
                                <tbody>
                                    <tr>
                                        <td>Name</td>
                                        <td>{{ $user[0]->FirstName}} {{ $user[0]->LastName}}</td>
									</tr>
                                    <tr>
                                    	<tr>
											<td>Role</td>
											<td>{{ $user[0]->MemberRole}}</td>
										</tr>
                                        <td>Join At</td>
                                        <td>{{ $user[0]->CreatedDate}}</td>
										<tr>
											<td>Email Id</td>
											<td>{{ $user[0]->MemberEmail}}</td>
										</tr>
										<tr>
											<td>Mobile No</td>
											<td>{{ $user[0]->MemberContactNo}}</td>
										</tr>
										<tr>
											<td>Address</td>
											<td>{{ $user[0]->MemberLocation}}</td>
										</tr>
										<tr>
											<td>Postal Code</td>
											<td>{{ $user[0]->MemberPostalCode}}</td>
										</tr>

									</tbody>
								</table>
							</div>
						</div>
						<!--===================================================-->
						<!-- End Striped Table -->
						
					</div>
				</div>
				@if($get_useralldetail != '')
				@foreach( $get_useralldetail as $con)
				@endforeach
				@endif
				<div class="col-sm-3">
					<div class="panel">
						<div class="panel-heading">
							<h3 class="panel-title">Account Detail</h3>
						</div>
						
						<!-- Striped Table -->
						<!--===================================================-->
						<div class="panel-body">
							<div class="table-responsive">
								<table class="table table-striped">
									<tbody>
										<tr>
											<td>A/c No.</td>
											<td>{{ $con->CBSACno}}</td>
										</tr>
										<tr>
											<td>A/c Holder Name </td>
											<td>{{ $con->NAMEatBANK}}</td>
										</tr>
										<tr>
											<td>Bank Name</td>
											<td>{{ $con->BANKNo}}</td>
										</tr>
										<tr>
											<td>Bank Branch</td>
											<td>{{$con->Branch}}</td>
										</tr>
										<tr>
											<td>IFSC Code</td>
											<td>{{$con->IFSCode}}</td>
										</tr>
									</tbody>
								</table>
							</div>
						</div>
						<!--===================================================-->
						<!-- End Striped Table -->
						
					</div>
				</div>

				<div class="col-sm-3">
					<div class="panel">
						<div class="panel-heading">
							<h3 class="panel-title">Sponsor Detail</h3>
						</div>
						
						<!-- Striped Table -->
						<!--===================================================-->
						<div class="panel-body">
							<div class="table-responsive">
								<table class="table table-striped">
									<tbody>
										<tr>
											<td>Sponsor</td>
											<td>{{ $user[0]->ReferralMobileNo}}</td>
										</tr>
										<tr>
											<td>Parent</td>
											<td>{{ $user[0]->ParentMobileNo}}</td>
										</tr>
									</tbody>
								</table>
							</div>
						</div>
						<!--===================================================-->
						<!-- End Striped Table -->
						
					</div>
				</div></div>
				
			</div>
			<!--===================================================-->
			<!--End page content-->
			
		</div>
		<!--===================================================-->
		<!--END CONTENT CONTAINER-->
		@endsection
		
		