@extends('mainlayout')
@section('content')
<style>
.error {
    border-color: red;
}
</style>
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Master Panel</h1>
		</div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->
		
		
        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
			<li><a href="{{url('/'.Session::get("dash_url"))}}"><i class="demo-pli-home"></i></a></li>
			<li><a href="{{url('/'.Session::get("dash_url"))}}">Dashboard</a></li>
			<li class="active">Edit Employee KYC Details</li>
		</ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->
		
	</div>
	

	
    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">
		
        <div class="row">
            <div class="col-lg-offset-3 col-lg-6">
                <div class="panel">

            	    @if ($errors->any())
				    <div class="alert alert-danger">
				        <ul>
				            @foreach ($errors->all() as $error)
							<li>{{ $error }}</li>
				            @endforeach
						</ul>
					</div>
				    @endif

					@if(Session::has('message')) 
					<div class="alert alert-{{ Session::get('type') }} alert-dismissible show" role="alert">
						<h4 class="alert-heading">{{ Session::get('message') }}</h4>
						<button type="button" class="close" data-dismiss="alert" aria-label="Close">
							<span aria-hidden="true">&times;</span>
						</button>
					</div>
					@endif
					
                    <div class="panel-heading">
                        <div class="panel-control">
                            <button class="btn btn-default" data-panel="minmax"><i class="demo-psi-chevron-up"></i></button>
						</div>
                        <h3 class="panel-title">Edit Employee KYC Details</h3>
					</div>
                    
                    <div class="collapse in">	

                       <form action="{{'edit_empkycdetails'}}" id="profile_edit" method="post" accept-charset="utf-8">
					   {{ csrf_field() }} 
                            <div class="panel-body">
                                <div class="row">
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_memberid">Member Id *</label>
                                            <input type="text" id="txt_memberid" name="txt_memberid" class="form-control" placeholder="Enter Member Id." required value={{$USERID}}>
										</div>
									</div>    
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label class="control-label" style="display:block;">&nbsp;</label>
                                            <button class="btn btn-success" type="submit">Find</button>
										</div>
									</div>
								</div>
							</div>    
						</form>  
						@if($get_useralldetail != '')
						@foreach( $get_useralldetail as $con)
						@endforeach
						<form action="{{ url('update_empkyc')}}" enctype="multipart/form-data" id="kyc_update" 
						method="post" accept-charset="utf-8">
						{{ csrf_field() }}
                            <div class="panel-body">
							<input id="txt_membercode" name="txt_membercode" type="hidden" required value="{{$con->RegCode}}" readonly>
						<input id="txt_userid" name="txt_userid" type="hidden" required="required" value="{{$con->RegId}}" readonly>
							<div class="row">
						
									<div class="col-sm-6">
										<div class="form-group">
											<label class="control-label" for="txt_yourphoto">Your Photo Upload</label>
											<input type="hidden" name="txt_yourphotohd" id="txt_yourphotohd" value="{{$con->MemberImage}}"> 
											<input type="file" name="txt_yourphoto" id="txt_yourphoto" class="form-control" required>
										</div>
									</div>
									<div class="col-md-6 text-center" style="margin-top:10%;">
										@if($con->MemberImage!='')
										<img src="{{ asset('/images/USER_PHOTO/'.$con->MemberImage) }}" height="100" />
										@else
										<img src="{{ asset('images/user.png') }}" height="100" />
										@endif
									</div>
								</div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="control-label" for="ddidproof">Id Proof</label>
                                            <select class="form-control" name="dd_idprooftype" id="dd_idprooftype" required="required">
												<option value="-1">SELECT ID PROOF</option>
												<option value="1" {{($con->IDProofType1==1)?'selected':''}}>ADHAR CARD</option>
												<option value="2" {{($con->IDProofType1==2)?'selected':''}}>DRIVING LICENSE</option>
												<option value="3" {{($con->IDProofType1==3)?'selected':''}}>GOVT.ISSUED IDENTITY CARD</option>
												<option value="4" {{($con->IDProofType1==4)?'selected':''}}>PASSPORT</option>
											</select>
										</div>

									</div>	
									<div class="col-md-6">
										<div class="form-group">
                                            <label class="control-label" for="txt_aadharcard">Aadhar No <span style="color:red">(eg. 1234 5678 9876)</span></label>
                                            <input type="text" name="txt_aadharcard" id="txt_aadharcard" class="form-control" placeholder="Enter Aadhar Number." required value="{{$con->AadharCard}}" onchange="aadharValidate2();">
                                            <span id="txt_aad_err" style="color:red;"></span>
										</div>
									</div>
									<div class="col-md-6">	
										<div class="form-group">
                                            <label class="control-label" for="txt_aadharfront">Aadhar Front</label>
											<input type="hidden" name="txt_aadharfronthd" id="txt_aadharfronthd" value="{{$con->AadharFront}}">
                                            <input type="file" name="txt_aadharfront" id="txt_aadharfront" class="form-control" >
										</div>
									</div>

									<div class="col-md-6 text-center" style="margin-top:10%;">
										@if($con->AadharFront!='')
                                        <img src="{{ asset('/images/USER_IDPROOF/'.$con->AadharFront) }}" height="100" />
										@else
										<img src="{{ asset('images/aadhar.jpg') }}" height="100" />
										@endif
									</div>

									<div class="col-md-6">
										<div class="form-group">
                                            <label class="control-label" for="txt_aadharback">Aadhar Back</label>
											<input type="hidden" name="txt_aadharbackhd" id="txt_aadharbackhd" value="{{$con->AadharBack}}">
                                            <input type="file" name="txt_aadharback" id="txt_aadharback" class="form-control" >
										</div>
									</div>

									<div class="col-md-6 text-center" style="margin-top:10%;">
										@if($con->AadharBack!='')
                                        <img src="{{ asset('/images/USER_IDPROOF/'.$con->AadharBack) }}" height="100" />
										@else
										<img src="{{ asset('images/aadhar.jpg') }}" height="100" />
										@endif
									</div>
										
									<div class="col-md-6">	
                                        <div class="form-group">
                                            <label class="control-label" for="txt_pancard">Pancard Number <span style="color:red">(eg. ALMPJ4444J)</span></label>
                                            <input type="text" name="txt_pancard" id="txt_pancard" class="form-control" placeholder="Enter Id Number." required value="{{$con->Pancarno}}" onchange="panValidate2();">
											<span id="txt_pan_err" style="color:red;"></span>
										</div>
										
                                        <div class="form-group">
                                            <label class="control-label" for="txt_idproof">Upload Pancard</label>
											<input type="hidden" name="txt_idproofhd" id="txt_idproofhd" value="{{$con->IDProof}}">
                                            <input type="file" name="txt_idproof" id="txt_idproof" class="form-control" required>
										</div>
									</div>
									
                                    <div class="col-md-6 text-center" style="margin-top:10%;">
										@if($con->IDProof!='')
                                        <img src="{{ asset('/images/USER_IDPROOF/'.$con->IDProof) }}" height="100" />
										@else
										<img src="{{ asset('images/pan_card.jpg') }}" height="100" />
										@endif
									</div>
									
								</div>
								
                                <div class="row">
									
									
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="control-label" for="ddaddproof">Address Proof</label>
                                            <select class="form-control" id="ddaddproof" name="ddaddproof" required>
                                               <option value="1" {{($con->AddProofType1==1)?'selected':''}}>ADHAR CARD</option>
												<option value="2" {{($con->AddProofType1==2)?'selected':''}}>DRIVING LICENSE</option>
												<option value="3" {{($con->AddProofType1==3)?'selected':''}}>GOVT.ISSUED IDENTITY CARD</option>
												<option value="4" {{($con->AddProofType1==4)?'selected':''}}>PASSPORT</option>
												
											</select>
										</div>
										
                                        <div class="form-group">
                                            <label class="control-label" for="txt_address">Address</label>
											<textarea class="form-control" id="txt_address" name="txt_address" rows="5" required>{{$con->Address}}</textarea>
										
										</div>
										
                                        <div class="form-group">
                                            <label class="control-label" for="txt_addressproof">Address Proof</label>
											<input type="hidden" name="txt_addressproofhd" id="txt_addressproofhd" value="{{$con->AddressProof}}"> 
                                            <input type="file" name="txt_addressproof" id="txt_addressproof" class="form-control" required value="{{$con->AddressProof}}">
										</div>
									</div>
                                    
                                    <div class="col-md-6 text-center" style="margin-top:10%;">
										@if($con->AddressProof!='')
										<img src="{{ asset('/images/USER_ADDRESSPROOF/'.$con->AddressProof) }}" height="100" />
										@else
										<img src="{{ asset('images/aadhar.jpg') }}" height="100" />
										@endif
									</div>
									
								</div>
								
							</div>
                            <div class="panel-footer text-center">
                                <button class="btn btn-success" type="button" onclick="conwv3('kyc_update')">UPDATE</button>
								<button type="reset" class="btn btn-primary">RESET</button>	
							</div>
						</form>
						@endif
					</div>
					
				</div>
			</div>
            
		</div>
        
		
	</div>
    <!--===================================================-->
    <!--End page content-->
	
</div>

@endsection