@extends('mainlayout')
@section('content')
<style>
.error {
    border-color: red;
}
</style>
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Master Panel</h1>
		</div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->
		
		
        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
			<li><a href="{{url('/'.Session::get("dash_url"))}}"><i class="demo-pli-home"></i></a></li>
			<li><a href="{{url('/'.Session::get("dash_url"))}}">Dashboard</a></li>
			<li class="active">Edit Employee Bank</li>
		</ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->
		
	</div>
	
    @if ($errors->any())
    <div class="alert alert-danger">
        <ul>
            @foreach ($errors->all() as $error)
			<li>{{ $error }}</li>
            @endforeach
		</ul>
	</div>
    @endif
	
    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">
		
        <div class="row">
            <div class="col-lg-offset-3 col-lg-6">
                <div class="panel">
					
                    <div class="panel-heading">
                        <div class="panel-control">
                            <button class="btn btn-default" data-panel="minmax"><i class="demo-psi-chevron-up"></i></button>
						</div>
                        <h3 class="panel-title">Edit Employee Bank Details</h3>
					</div>
                    
                    <div class="collapse in">
					@if(Session::has('message')) 
							<div class="alert alert-{{ Session::get('type') }} alert-dismissible show" role="alert">
								<h4 class="alert-heading">{{ Session::get('message') }}</h4>
								<button type="button" class="close" data-dismiss="alert" aria-label="Close">
									<span aria-hidden="true">&times;</span>
								</button>
							</div>
						@endif
						<form action="{{'edit_empbankdetails'}}" id="bank_edit" method="post" accept-charset="utf-8">
							{{ csrf_field() }} 
                            <div class="panel-body">
                                <div class="row">
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_memberid">Employee Id *</label>
                                            <input type="text" id="txt_memberid" name="txt_memberid" class="form-control" placeholder="Enter Member Id." required value={{$USERID}}>
										</div>
									</div>    
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label class="control-label" style="display:block;">&nbsp;</label>
                                            <button class="btn btn-success" type="submit">Find</button>
										</div>
									</div>
								</div>
							</div>    
						</form>  
						@if($get_useralldetail != '')
						@foreach( $get_useralldetail as $con)
						@endforeach
						<form id="bankdetails_update" action="{{ url('update_empbankdetails') }}" enctype="multipart/form-data" method="post" accept-charset="utf-8">      
							{{ csrf_field() }}
                            <div class="panel-body">
							<input id="txt_membercode" name="txt_membercode" type="hidden" required value="{{$con->RegCode}}" readonly>
						<input id="txt_userid" name="txt_userid" type="hidden" required="required" value="{{$con->RegId}}" readonly>
                                <div class="row">
                                    
									
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_nameatbank">A/C Holder Name</label>
                                            <input type="text" id="txt_nameatbank" name="txt_nameatbank" class="form-control" placeholder="Enter A/C Holder Name." value="{{$con->NAMEatBANK}}" required>
										</div>
									</div>
                                    
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_cbsacno">CBS A/C Number  <span style="color:red">(eg. 1233455345345)</span></label>
                                            <input type="text" id="txt_cbsacno" name="txt_cbsacno" class="form-control" placeholder="Enter CBS A/C Number." value="{{$con->CBSACno}}" onchange="accnoValidate2();" required>
											<span id="txt_acc_err" style="color:red;"></span>
										</div>
									</div>
                                    
                                    <div class="col-sm-6">
										<div class="form-group">
											<label class="control-label" for="dd_bank">Bank Name</label>
											<select class="form-control" name="dd_bank" id="dd_bank">
												@foreach($banks as $b)
												<option value="{{$b->BANK_ID}}" {{$b->BANK_ID == $con->BANKNo ? 'selected' : ''}}>{{$b->BANK_NAME}}</option>
												@endforeach
											</select>
										</div>
                                    </div>
									
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_bankifsccode">IFSC Code <span style="color:red">(eg. ASDF1234567)</span></label>
                                            <input type="text" id="txt_bankifsccode" name="txt_bankifsccode" class="form-control" placeholder="Enter IFSC Code." value="{{$con->IFSCode}}" onchange="ifscValidate2();" required>
											<span id="txt_ifsc_err" style="color:red;"></span>
										</div>
									</div>
                                    
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_bankbranch">Bank Branch</label>
                                            <input type="text" id="txt_bankbranch" name="txt_bankbranch" class="form-control" placeholder="Enter Bank Branch."  value="{{$con->Branch}}" required>
										</div>
									</div>
									
                                    <div class="col-md-6">
										<div class="form-group">
                                            <label class="control-label" for="txt_cancelchq">Account Proof</label>
											<input type="hidden" name="txt_cancelchqhd" id="txt_cancelchqhd" value="{{$con->CancelCheque}}"> 
                                            <input type="file" name="txt_cancelchq" id="txt_cancelchq" class="form-control" required>
										</div>
										
									</div>
									<div class="col-md-6">
										@if($con->CancelCheque == '')
									<img src="{{ asset('/images/check_image.jpg') }}" width="580" /> 
									@elseif($con->CancelCheque != '')
									<img src="{{ asset('/images/CANCEL_CHEQUE/'.$con->CancelCheque) }}" width="580" /> 
									@endif
									</div>


								</div>    
							</div>
                            <div class="panel-footer text-center">
                                <button class="btn btn-success"  type="button" onclick="conwv2('bankdetails_update')">Update</button>
								<button type="reset" class="btn btn-primary">RESET</button>	
							</div>
						</form>
                        @endif
						
					</div>
					
				</div>
			</div>
            
		</div>
        
		
	</div>
    <!--===================================================-->
    <!--End page content-->
	
</div>

@endsection