@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Employee Panel</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{url('/'.Session::get("dash_url"))}}"><i class="demo-pli-home"></i></a></li>
        <li><a href="{{url('/'.Session::get("dash_url"))}}">Dashboard</a></li>
        <li class="active">Total Downline</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>

    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">
        
        <div class="row">
            <div class="panel">

                <div class="panel-heading">
                    <div class="panel-control">
                        <button class="btn btn-default" data-panel="minmax"><i class="demo-psi-chevron-up"></i></button>
                    </div>
                    <h3 class="panel-title">Total Downline</h3>
                </div>

                <div class="collapse in">
    
                    <form action="{{url('/emp_downline')}}" method="POST">
                        {{ csrf_field() }}
                        <div class="panel-body">

                            <div class="row">

                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <label class="control-label">Members</label>
                                        <div class="radio">
                                            <input id="rballmembers" class="magic-radio" type="radio" name="rbmembers" value="0">
                                            <label for="rballmembers">All Members</label>

                                            <input id="rbjoinmember" class="magic-radio" type="radio" name="rbmembers" value="1">
                                            <label for="rbjoinmember">Join Member</label>

                                            <input id="rbtopupmember" class="magic-radio" type="radio" name="rbmembers" value="2">
                                            <label for="rbtopupmember">Topup Member</label>
                                        </div>
                                    </div>
                                </div>    

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="txt_fromdate">From Date</label>
                                        <div id="demo-dp-txtinput">
                                            <input type="text" name="txt_fromdate" id="txt_fromdate" value="{{$start}}" class="form-control" placeholder="dd/mm/yyyy" autocomplete="off" >
                                        </div>
                                    </div>                                
                                </div>
                            
                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="txt_todate">To Date</label>
                                        <div id="demo-dp-txtinput">
                                            <input type="text" name="txt_todate" id="txt_todate"  value="{{$end}}" class="form-control" placeholder="dd/mm/yyyy" autocomplete="off" >
                                        </div>
                                    </div>
                                </div>

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="txt_memberid">Member Id</label>
                                        <input type="text" id="txt_memberid" name="txt_memberid"  value="{{$memberid}}" class="form-control" placeholder="Enter User Id." required>
                                    </div>
                                </div>
                                
                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label">Position</label>
                                        <select name="dd_pos" id="dd_pos" class="form-control">
                                            <option value="-1">Select</option>
                                            <option value="LEFT" {{$pos =='LEFT'? 'selected':''}}>LEFT</option>
                                            <option VALUE="RIGHT"  {{$pos =='RIGHT'? 'selected':''}}>RIGHT</option>
                                        </select>
                                    </div>
                                </div>
                            </div>

                        </div>
                       
                        <div class="panel-footer text-center">
                            <button class="btn btn-success" type="submit">Search</button>
                        </div>
                    </form>
                </div>
        
            </div>
        </div> 

        <div class="row">
            <div class="panel">
            
                <div class="panel-body">
                    <table id="demo-dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
                        <thead>
							<tr>
								<th>S.NO.</th>
								<th>MEMBER NAME</th>
								<th>CONTACTNO</th>
								<th>SPONSOR ID</th>
								<th>PARENT ID</th>
								<th>POSITION</th>
								<th>JOINING DATE</th>
								<th>TOPUPDATE</th>
								<th>RETOPUPDATE</th>
								<th>PACKAGE</th>
							    <th>AMOUNT</th>
								<th>RETOPUP PACKAGE</th>
								<th>RETOPUP AMOUNT</th>
							</tr>
						</thead>
						<tbody>
						@if(!empty($user_rec))
							@foreach( $user_rec as $con)
												
							<tr>
								<td>{{ '#' }}</td>
								<td>{{$con->MemberName}}</td>
								<td>{{ $con->MemberContactNo }}</td>
								<td>{{ $con->ReferralMobileNo }}</td>
								<td>{{ $con->ParentMobileNo }}</td>
								<td>{{ $con->Position}}</td>
								<td>{{ $con->JOINING_DATE  }}</td>
								<td>{{ $con->TOPUP_DATE  }}</td>
								<td>{{ $con->RETOPUP_DATE}}</td>
								<td>{{ $con->PACKAGE_NAME }}</td>
								<td>{{ $con->TOPUP_BV}}</td>
								<td>{{ $con->REPACKAGE_NAME  }}</td>
								<td>{{ $con->RETOPUP_BV }}</td>
                            </tr>
							 @endforeach
							@endif
						</tbody>
					   
                    </table>
                </div>
            
            </div>
        </div>     
            
    </div>
    <!--===================================================-->
    <!--End page content-->

</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->
@endsection