@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Master Panel</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{url('/'.Session::get("dash_url"))}}"><i class="demo-pli-home"></i></a></li>
        <li><a href="{{url('/'.Session::get("dash_url"))}}">Dashboard</a></li>
        <li class="active">Datewise Business</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>

    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">
        
        <div class="row">
            <div class="panel">

                <div class="panel-heading">
                    <div class="panel-control">
                        <button class="btn btn-default" data-panel="minmax"><i class="demo-psi-chevron-up"></i></button>
                    </div>
                    <h3 class="panel-title">Datewise Business</h3>
                </div>

                <div class="collapse in">
						<form action="{{url('/emp_datewise_business_detail')}}" method="POST">
                        {{ csrf_field() }}
                        <div class="panel-body">  
                          <div class="col-sm-4">
                                <div class="form-group">
                                    <label class="control-label" for="txt_fromdate">From Date</label>
                                    <div id="demo-dp-txtinput">
                                        <input type="text" name="txt_fromdate" id="txt_fromdate" value="{{$start}}" class="form-control" placeholder="dd/mm/yyyy" autocomplete="off">
                                    </div>
                                </div>                                
                            </div>
                        
                            <div class="col-sm-4">
                                <div class="form-group">
                                    <label class="control-label" for="txt_todate">To Date</label>
                                    <div id="demo-dp-txtinput">
                                        <input type="text" name="txt_todate" id="txt_todate" value="{{$end}}"  class="form-control" placeholder="dd/mm/yyyy" autocomplete="off" >
                                    </div>
                                </div>
                            </div>

                            <div class="col-sm-4">
                                <div class="form-group">
                                    <label class="control-label" for="txt_userid">User Id</label>
                                    <input type="text" id="txt_userid"  value="{{$memberid}}" name="txt_userid" class="form-control" placeholder="Enter User Id.">
                                </div>
                            </div>

                        </div>
                       
                        <div class="panel-footer text-center">
                            <button class="btn btn-success" type="submit">Search</button>
                            <button class="btn btn-info" type="button">Reset</button>
                        </div>
                    </form>
                </div>
    
            </div>
        </div> 

        <div class="row">
            <div class="panel">
            
                <div class="panel-body">
  
                    <table id="demo-dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
						<thead>
							<tr>
								<th>S.NO.</th>
								<th>MEMBER ID</th>
								<th>MEMBER NAME</th>
								<th>TOTAL LEFT</th>
								<th>TOTAL RIGHT</th>
								<th>TOTAL TOPUP LEFT</th>
								<th>TOTAL TOPUP RIGHT</th>
								<th>TOTAL LEFT PV</th>
								<th>TOTAL RIGHT PV</th>
							    <th>TOPUP DATE</th>
							</tr>
						</thead>
						<tbody>
							<?php $sn = 1;?>
							@if( !empty($user_rec))
								@foreach( $user_rec as $con)
							<tr>
								<td>{{ $sn++ }}</td>
								<td>{{ $con->LOGINID }}</td>
								<td>{{ $con->USERNAME }}</td>
								<td>{{ $con->TOTAL_LEFT }}</td>
								<td>{{ $con->TOTAL_RIGHT}}</td>
								<td>{{ $con->TOTAL_TOPUPLEFT  }}</td>
								<td>{{ $con->TOTAL_TOPUPRIGHT  }}</td>
								<td>{{ $con->TOTAL_LEFTPV }}</td>
								<td>{{ $con->TOTAL_RIGHTPV }}</td>
                                <td>{{ $con->TOPUP_DATE }}</td>
                            </tr>
							 @endforeach
							@endif
						</tbody>
                    </table>
                </div>
            
            </div>
        </div>     
            
    </div>
    <!--===================================================-->
    <!--End page content-->

</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->
@endsection