@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Master Panel</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{url('/'.Session::get("dash_url"))}}"><i class="demo-pli-home"></i></a></li>
        <li><a href="{{url('/'.Session::get("dash_url"))}}">Dashboard</a></li>
        <li class="active">NEW SLAB</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>

    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">

        <div class="row">

            <div class="col-md-4">
            
                <div class="panel">

                    <div class="panel-heading">
                        <div class="panel-control">
                            <button class="btn btn-default" data-panel="minmax"><i class="demo-psi-chevron-up"></i></button>
                        </div>
                        <h3 class="panel-title">NEW SLAB</h3>
                    </div>

                    <div class="collapse in">
                        @if(!isset($single_slab[0]->GROUP_ID))
                        <form action="{{url('/emp_add_slab')}}" method="POST">
                            {{ csrf_field() }}
                            <div class="panel-body">
                                <div class="row">

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_group_name">Enter Group/Slab Name</label>
                                            <input type="text" name="txt_group_name" id="txt_group_name" class="form-control" placeholder="Enter Group/Slab Name.">
                                        </div>
                                    </div>

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="dd_type">Group Type</label>
                                            <select class="form-control" name="dd_type" id="dd_type" required>
                                                <option value="2">SELF RETAIL</option>
                                                <option value="1">WHITE LABEL</option>
                                                <option value="3">API USER</option>
                                            </select>
                                        </div>
                                    </div>

                                </div>

                            </div>
                            <div class="panel-footer text-center">
                                <button class="btn btn-success" type="submit" onclick="return confirm('Are you sure you want to submit?');">Save</button>
                                <button class="btn btn-default" type="button">Close</button>
                            </div>
                        </form>
                        @elseif(isset($single_slab[0]->GROUP_ID))
                        <form action="{{url('/emp_update_slab/'.$single_slab[0]->GROUP_ID)}}" method="POST">
                            {{ csrf_field() }}
                            <div class="panel-body">
                                <div class="row">

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_group_name">Enter Group/Slab Name</label>
                                            <input type="text" name="txt_group_name" id="txt_group_name" class="form-control" value="{{$single_slab[0]->GROUP_NAME}}">
                                        </div>
                                    </div>

                                </div>

                            </div>
                            <div class="panel-footer text-center">
                                <button class="btn btn-success" type="submit" onclick="return confirm('Are you sure you want to submit?');">Save</button>
                                <button class="btn btn-default" type="button">Close</button>
                            </div>
                        </form>
                        @endif
                        
                    </div>
        
                </div>

            </div>
            
        

            <div class="col-md-8">
                <div class="panel">
                
                    <div class="panel-body">
                        <table id="demo-dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
                            <thead>
                                <tr>
                                    <th>GROUP NAME</th>
                                    <th>USER</th>
                                    <th class="min-tablet">GROUP TYPE</th>
                                    <th class="min-tablet">DATE</th>
                                    <th class="min-tablet">ACTION</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($slab as $sb)
                                <tr>
                                    <td>{{$sb->GROUP_NAME}}</td>
                                    <td>{{$sb->USER_ID}}</td>
                                    <td>{{$sb->GROUP_TYPE}}</td>
                                    <td>{{$sb->GROUP_CREATEDAT}}</td>
                                    <td>
                                        <a class="btn btn-success btn-xs" href="{{url('emp_view_slab/'.$sb->GROUP_ID)}}">EDIT</a>
                                        <button data-id="{{$sb->GROUP_ID}}" data-slabname="{{$sb->GROUP_NAME}}" data-target="#demo-default-modal" data-toggle="modal" class="btn btn-primary btn-xs val">{{$sb->GROUP_STATUS == 'ACTIVE' ? 'ACTIVE' : 'INACTIVE'}}</button>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                
                </div>
            </div>

            <div class="modal fade" id="demo-default-modal" role="dialog" tabindex="-1" aria-labelledby="demo-default-modal" aria-hidden="true">
                <div class="modal-dialog">
                    <div class="modal-content">

                    <form action="{{url('emp_slab_status')}}" method="POST"> 
                        {{ csrf_field() }}

                        <!--Modal header-->
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal"><i class="pci-cross pci-circle"></i></button>
                            <h4 class="modal-title">CHANGE SLAB STATUS</h4>
                        </div>

                        <!--Modal body-->
                        <div class="modal-body">
                            <div class="form-group">
                                <input id="txt_slab_id" name="txt_slab_id" type="hidden" class="form-control" required="required">
                            </div>
                            <p class="text-semibold text-main">SLAB NAME :-<span id="slab_name"></span></p>
                            <br>
                            <p class="text-semibold text-main">Would you like to change the status of slab ?</p>

                        </div>

                        <!--Modal footer-->
                        <div class="modal-footer">
                            <button data-dismiss="modal" class="btn btn-default" type="button">NO</button>
                            <button class="btn btn-primary" type="submit">Yes</button>
                        </div>

                    </form>
                    </div>
                </div>
            </div>

        </div>
            
    </div>
    <!--===================================================-->
    <!--End page content-->

</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->
<script src="http://ajax.googleapis.com/ajax/libs/jquery/2.0.0/jquery.min.js"></script>
<script type="text/javascript">
$(document).ready(function(){
    $(".val").on("click", function(e) {
        var id = $(this).data('id');
        var slabname = $(this).data('slabname');
        $('#txt_slab_id').val(id);
        $('#slab_name').text(slabname);
    });
});
</script>
@endsection
