@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Employee Panel</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{url('/'.Session::get("dash_url"))}}"><i class="demo-pli-home"></i></a></li>
        <li><a href="{{url('/'.Session::get("dash_url"))}}">Dashboard</a></li>
        <li class="active">Change Member Status</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>

    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">
        
        <div class="row">
            <div class="panel">

                <div class="panel-heading">
                    <div class="panel-control">
                        <button class="btn btn-default" data-panel="minmax"><i class="demo-psi-chevron-up"></i></button>
                    </div>
                    <h3 class="panel-title">Change Member Status</h3>
                </div>

                <div class="collapse in">
    
                    <form action="{{url('emp_change_status')}}" method="POST">
                        {{ csrf_field() }} 
                        <div class="panel-body">

                            <div class="col-sm-4">
                                <div class="form-group">
                                    <label class="control-label">Members</label>
                                    <div class="radio">
                                        <input id="rballmembers" class="magic-radio" type="radio" name="rbmembers" value="0" >
                                        <label for="rballmembers">All Members</label>

                                        <input id="rbjoinmember" class="magic-radio" type="radio" name="rbmembers" value="1">
                                        <label for="rbjoinmember">Join Member</label>

                                        <input id="rbtopupmember" class="magic-radio" type="radio" name="rbmembers" value="2">
                                        <label for="rbtopupmember">Topup Member</label>
                                    </div>
                                </div>
                            </div>    

                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label class="control-label" for="txtfromdate">From Date</label>
                                    <div id="demo-dp-txtinput">
                                        <input type="text" name="txtfromdate" id="txtfromdate" class="form-control" placeholder="dd/mm/yyyy" autocomplete="off" >
                                    </div>
                                </div>                                
                            </div>
                        
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label class="control-label" for="txttodate">To Date</label>
                                    <div id="demo-dp-txtinput">
                                        <input type="text" name="txttodate" id="txttodate" class="form-control" placeholder="dd/mm/yyyy" autocomplete="off" >
                                    </div>
                                </div>
                            </div>

                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label class="control-label" for="txtuserid">User Id</label>
                                    <input type="text" id="txtuserid" name="txtuserid" class="form-control" placeholder="Enter User Id." >
                                </div>
                            </div>
                            
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label class="control-label">Position</label>
                                    <select class="form-control">
                                        <option>Select</option>
                                        <option>Left</option>
                                        <option>Right</option>
                                    </select>
                                </div>
                            </div>

                        </div>
                       
                        <div class="panel-footer text-center">
                            <button class="btn btn-success" type="submit">Search</button>
                            <button class="btn btn-success" type="button">Export To Excel</button>
                        </div>
                    </form>
                </div>
    
            </div>
        </div> 

        <div class="row">
            <div class="panel">
                <div class="panel-body">
			<table id="demo-dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
						<thead>
							<tr>
								<th><input type="checkbox" name="all_check" id="all_check" value="-1"/></th>
								<th>MEMBER NAME</th>
								<th>CONTACTNO</th>
								<th>SPONSOR ID</th>
								<th>PARENT ID</th>
								<th>POSITION</th>
								<th>JOINING DATE</th>
								<th>TOPUPDATE</th>
								<th>RETOPUPDATE</th>
								<th>PACKAGE</th>
							    <th>PV</th>
								<th>RETOPUP PACKAGE</th>
								<th>RETOPUP PV</th>			
							</tr>
						</thead>
						<tbody>
							<?php $sn = 1;$lvl_no="1"; $totalpv=0.00;$totalretopup_pv=0.00;?>
								@if( !empty($user_report))
									@foreach( $user_report as $con)
										<?php 
											$totalpv=$totalpv+$con->TOPUP_BV;
											$totalretopup_pv=$totalretopup_pv+$con->RETOPUP_BV;
										?>
							<tr>
								<td><input type="checkbox" name="activate" value="{{$con->RegId}}" /></td>
								<td>{{$con->MemberName}}</td>
								<td>{{ $con->MemberContactNo }}</td>
								<td>{{ $con->ReferralMobileNo }}</td>
								<td>{{ $con->ParentMobileNo }}</td>
								<td>{{ $con->Position}}</td>
								<td>{{ $con->JOINING_DATE  }}</td>
								<td>{{ $con->TOPUP_DATE  }}</td>
								<td>{{ $con->RETOPUP_DATE }}</td>
								<td>{{ $con->PACKAGE_NAME }}</td>
								<td>{{ $con->TOPUP_BV }}</td>
								<td>{{ $con->REPACKAGE_NAME  }}</td>
								<td>{{ $con->RETOPUP_BV }}</td>
								
								</tr>
							 @endforeach
							@endif
						</tbody>
					    <tr>
								<th></th>
								<th></th>
								<th></th>
								<th></th>
								<th></th>
								<th></th>
								<th></th>
								<th></th>
								<th></th>
								<th>TOTAL</th>
							    <th>{{$totalpv}}</th>
								<th></th>
								<th>{{$totalretopup_pv}}</th>
								
							</tr>
							</table>
                </div>
            
            </div>
        </div>     
            
    </div>
    <!--===================================================-->
    <!--End page content-->

</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->
@endsection